/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.snight;

import java.io.FileNotFoundException;
import java.io.FileReader;
import java.util.Hashtable;
import org.rhwlab.snight.Config;
import qdxml.DocHandler;
import qdxml.QDParser;

public class XMLConfig
implements DocHandler {
    static Config iConfig;
    static String iConfigFileName;
    String iZipFile;
    String iImageFile;
    String iEndIndex;
    public static final String CS = ", ";

    public static Config createConfigFromXMLFile(String fileName) {
        iConfigFileName = fileName;
        new XMLConfig(fileName, null);
        return iConfig;
    }

    public XMLConfig(String fileName) {
        try {
            FileReader fr = new FileReader(fileName);
            QDParser.parse(this, fr);
        }
        catch (FileNotFoundException fnfe) {
            fnfe.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public XMLConfig(String fileName, Config config) {
        iConfig = config;
        try {
            FileReader fr = new FileReader(fileName);
            QDParser.parse(this, fr);
        }
        catch (FileNotFoundException fnfe) {
            fnfe.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
    }

    @Override
    public void startElement(String tag, Hashtable h) throws Exception {
        if (tag.equals("embryo")) {
            if (iConfig == null) {
                iConfig = new Config(iConfigFileName, true);
            }
            XMLConfig.iConfig.iConfigHash = new Hashtable();
            int i = 0;
            while (true) {
                if (i < Config.configParams.length) {
                    XMLConfig.iConfig.iConfigHash.put(Config.configParams[i], "");
                    ++i;
                    continue;
                }
                break;
            }
        } else if (tag.equals("nuclei")) {
            String file = (String)h.get("file");
            XMLConfig.iConfig.iConfigHash.put("zipFileName", file);
        } else if (tag.equals("image")) {
            String typical = (String)h.get("file");
            XMLConfig.iConfig.iConfigHash.put("typical image", typical);
        } else if (tag.equals("start")) {
            String startIndex = (String)h.get("index");
            XMLConfig.iConfig.iConfigHash.put("starting index", startIndex);
        } else if (tag.equals("end")) {
            String endIndex = (String)h.get("index");
            XMLConfig.iConfig.iConfigHash.put("ending index", endIndex);
        } else if (tag.equals("naming")) {
            String method = (String)h.get("method");
            XMLConfig.iConfig.iConfigHash.put("namingMethod", method);
        } else if (tag.equals("axis")) {
            String axis = (String)h.get("axis");
            XMLConfig.iConfig.iConfigHash.put("axis", axis);
        } else if (tag.equals("polar")) {
            String size = (String)h.get("size");
            XMLConfig.iConfig.iConfigHash.put("polarSize", size);
            XMLConfig.println("startElement: " + size);
        } else if (tag.equals("resolution")) {
            String xyRes = (String)h.get("xyRes");
            XMLConfig.iConfig.iConfigHash.put("xyRes", xyRes);
            String zRes = (String)h.get("zRes");
            XMLConfig.iConfig.iConfigHash.put("zRes", zRes);
            String planeEnd = (String)h.get("planeEnd");
            XMLConfig.iConfig.iConfigHash.put("planeEnd", planeEnd);
        } else if (tag.equals("exprCorr")) {
            String exprCorr = (String)h.get("type");
            XMLConfig.iConfig.iConfigHash.put("exprCorr", exprCorr);
        } else if (tag.equals("useZip")) {
            String useZip = (String)h.get("type");
            XMLConfig.iConfig.iConfigHash.put("use zip", useZip);
        } else if (tag.equals("useStack")) {
            String useStack = (String)h.get("type");
            XMLConfig.iConfig.iConfigHash.put("use stack", useStack);
        } else if (tag.equals("angle")) {
            String degrees = (String)h.get("degrees");
            XMLConfig.iConfig.iConfigHash.put("angle", degrees);
        } else if (tag.equals("center")) {
            String x = (String)h.get("x");
            String y = (String)h.get("y");
            XMLConfig.iConfig.iConfigHash.put("x", x);
            XMLConfig.iConfig.iConfigHash.put("y", y);
        }
    }

    @Override
    public void endElement(String tag) throws Exception {
    }

    @Override
    public void startDocument() throws Exception {
    }

    @Override
    public void endDocument() throws Exception {
        iConfig.setStartingParms();
    }

    @Override
    public void text(String str) throws Exception {
    }

    public static void println(String s) {
        System.out.println(s);
    }
}

