/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.snight;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;

public class ZipNuclei {
    String iZipName;
    String iEntryName;
    ZipFile iZipFile;
    InputStream iInputStream;
    BufferedReader iBufferedReader;
    public static final String CS = ", ";

    public ZipNuclei(String zipName) {
        this.iZipName = zipName;
        this.iInputStream = null;
        File zipFile = new File(zipName);
        try {
            this.iZipFile = new ZipFile(zipFile);
        }
        catch (IOException ioe) {
            if (ioe instanceof ZipException) {
                System.out.println("got ZipException: " + ioe);
                System.out.println("looking for: " + this.iZipName);
                ioe.printStackTrace();
            }
            ioe.printStackTrace();
        }
    }

    public ZipEntry getZipEntry(String entryName) {
        ZipEntry ze = null;
        Enumeration<? extends ZipEntry> entries = this.iZipFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry e = entries.nextElement();
            if (!e.getName().equals(entryName)) continue;
            ze = e;
            break;
        }
        return ze;
    }

    public String readLine(ZipEntry entry) {
        String s = null;
        try {
            if (this.iInputStream == null) {
                this.iInputStream = this.iZipFile.getInputStream(entry);
                this.iBufferedReader = new BufferedReader(new InputStreamReader(this.iInputStream));
            }
            if ((s = this.iBufferedReader.readLine()) == null) {
                this.closeEntry();
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            System.exit(1);
        }
        return s;
    }

    public void closeEntry() {
        if (this.iInputStream == null) {
            return;
        }
        try {
            this.iBufferedReader.close();
            this.iInputStream.close();
            this.iInputStream = null;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public void close() {
        try {
            this.iZipFile.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public static void main(String[] args) {
        ZipNuclei zn = new ZipNuclei("/home/biowolp/data/081505/081505-edit.zip");
        Enumeration<? extends ZipEntry> e = zn.iZipFile.entries();
        while (e.hasMoreElements()) {
            ZipEntry ze = e.nextElement();
            String[] sa = zn.parseZipEntry(ze);
            if (!sa[0].equals("nuclei")) continue;
            String s = zn.readLine(ze);
            zn.closeEntry();
        }
    }

    public String[] parseZipEntry(ZipEntry ze) {
        String[] sa = ze.getName().split("/");
        return sa;
    }

    public int parseZipEntryName(String s) {
        int m = s.indexOf("-");
        if (m < 0) {
            return m;
        }
        s = s.substring(1, m);
        return Integer.parseInt(s);
    }

    private static void println(String s) {
        System.out.println(s);
    }
}

