/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.tree;

import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.tree.TreeNode;
import org.rhwlab.snight.NucleiMgr;
import org.rhwlab.snight.Nucleus;
import org.rhwlab.tree.Cell;

public class AncesTree
implements Comparator {
    private Cell iRoot;
    private String iSplitTime;
    private String iNucleiPrefix;
    private int iStartingIndex;
    private int iEndingIndex;
    private Vector iTempV;
    private boolean iRootEstablished;
    private Hashtable iCells;
    private Hashtable iCellsByName;
    private NucleiMgr iNucleiMgr;
    private Vector iNucleiRecord;
    private int iPolarCount;
    private boolean iShowDeathsAndDivisions;
    private int[] iCellCounts;
    private Vector iRootCells;
    private static final String[] fgo = new String[]{"P0", "AB", "P1", "ABa", "ABp", "EMS", "P2"};
    private static final String POLAR = "polar";
    private static final String CS = ", ";
    private static final String DIVISIONTEMPLATE = "  Division:                 ->                ";
    private static final String DEATHTEMPLATE = "  Death:                ";
    private static final String ROOTNAME = "P";
    private static final int DEAD = -1;
    private static final int PARLOC = 12;
    private static final int DAULOC = 31;
    private static final int DEATHLOC = 9;

    public AncesTree(Cell root, NucleiMgr nucleiMgr, int startingIndex, int endingIndex) {
        this.iRoot = new Cell(ROOTNAME, endingIndex, startingIndex);
        this.iRoot.setEndTime(1);
        this.iNucleiMgr = nucleiMgr;
        this.iStartingIndex = startingIndex;
        this.iEndingIndex = endingIndex;
        this.iRootEstablished = false;
        this.iTempV = new Vector();
        this.iCells = new Hashtable();
        this.iPolarCount = 1;
        this.iShowDeathsAndDivisions = false;
        this.iCellCounts = new int[endingIndex + 1];
        Vector nv = nucleiMgr.getNuclei(1);
        Boolean sulstonmode = false;
        Iterator it = nv.iterator();
        while (it.hasNext()) {
            String s = ((Nucleus)it.next()).identity;
            if (s.isEmpty() || s.startsWith("N", 0)) continue;
            sulstonmode = true;
        }
        if (sulstonmode.booleanValue()) {
            this.iRoot.add(this.createDummyNodes());
        }
        this.processEntries();
        this.adjustEarlyStartTimes();
        this.extractRootCells();
        Cell PP = (Cell)this.iCellsByName.get(ROOTNAME);
        int kk = PP.getChildCount();
    }

    public AncesTree(Cell root, NucleiMgr nucleiMgr, int startingIndex, int endingIndex, boolean test) {
        this.iRoot = new Cell(ROOTNAME, endingIndex, startingIndex);
        this.iRoot.setEndTime(1);
        this.iNucleiMgr = nucleiMgr;
        this.iStartingIndex = startingIndex;
        this.iEndingIndex = endingIndex;
        this.iRootEstablished = false;
        this.iTempV = new Vector();
        this.iCells = new Hashtable();
        this.iPolarCount = 1;
        this.iShowDeathsAndDivisions = false;
        this.iCellCounts = new int[endingIndex + 1];
        this.processEntries();
        this.extractRootCells();
        Cell PP = (Cell)this.iCellsByName.get(ROOTNAME);
        int kk = PP.getChildCount();
    }

    private void adjustEarlyStartTimes() {
        int tEnd = 0;
        Cell x = (Cell)this.iCellsByName.get("ABal");
        if (x != null) {
            int t_MS;
            int t_P0;
            int t_AB;
            int t_ABal = x.getTime();
            if (t_ABal < 1) {
                return;
            }
            x = (Cell)this.iCellsByName.get("ABa");
            int t_ABa = x.getTime();
            if (t_ABa < 0) {
                t_ABa = t_ABal - 14;
                x.setTime(t_ABal - 14);
                x.setEndTime(t_ABal - 1);
                x = (Cell)this.iCellsByName.get("ABp");
                x.setTime(t_ABal - 14);
                x.setEndTime(t_ABal - 1);
            }
            if ((t_AB = (x = (Cell)this.iCellsByName.get("AB")).getTime()) < 0) {
                t_AB = t_ABal - 28;
                x.setTime(t_AB);
                tEnd = t_ABa - 1;
                x.setEndTime(tEnd);
                x = (Cell)this.iCellsByName.get("P1");
                x.setTime(t_AB);
                x.setEndTime(tEnd);
            }
            if ((t_P0 = (x = (Cell)this.iCellsByName.get("P0")).getTime()) < 0) {
                t_P0 = t_ABal - 42;
                x.setTime(t_ABal - 42);
                tEnd = t_AB - 1;
                x.setEndTime(tEnd);
            }
            if ((t_MS = (x = (Cell)this.iCellsByName.get("MS")).getTime()) < 1) {
                return;
            }
            x = (Cell)this.iCellsByName.get("EMS");
            int t_EMS = x.getTime();
            if (t_EMS < 0) {
                t_EMS = t_MS - 17;
                x.setTime(t_EMS);
                tEnd = t_MS - 1;
                x.setEndTime(tEnd);
                x = (Cell)this.iCellsByName.get("P2");
                x.setTime(t_EMS);
                x.setEndTime(tEnd);
            }
        }
    }

    private Cell createDummyNodes() {
        System.out.println("creating dummy nodes");
        Cell c0 = new Cell("P0", 500, -120);
        this.iCells.put("P0", c0);
        Cell d1 = this.addDaughter(c0, "AB", -100);
        Cell d2 = this.addDaughter(c0, "P1", -100);
        Cell c1 = d1;
        Cell c2 = d2;
        d1 = this.addDaughter(c1, "ABa", -86);
        d2 = this.addDaughter(c1, "ABp", -86);
        this.addDaughter(d1, "ABal", -73);
        this.addDaughter(d1, "ABar", -73);
        this.addDaughter(d2, "ABpl", -71);
        this.addDaughter(d2, "ABpr", -71);
        d1 = this.addDaughter(c2, "EMS", -84);
        d2 = this.addDaughter(c2, "P2", -84);
        this.addDaughter(d1, "MS", -68);
        this.addDaughter(d1, "E", -68);
        this.addDaughter(d2, "C", -65);
        this.addDaughter(d2, "P3", -65);
        return c0;
    }

    private Cell addDaughter(Cell parent, String dName, int startTime) {
        Cell d = new Cell(dName, 500, startTime);
        this.iCells.put(dName, d);
        parent.add(d);
        parent.setEndTime(startTime);
        return d;
    }

    private void extractRootCells() {
        this.iRootCells = new Vector();
        int k = this.iRoot.getChildCount();
        for (int i = 0; i < k; ++i) {
            Cell x = (Cell)this.iRoot.getChildAt(i);
        }
        Enumeration<TreeNode> e = this.iRoot.children();
        while (e.hasMoreElements()) {
            Cell c = (Cell)e.nextElement();
            this.iRootCells.add(c);
            Collections.sort(this.iRootCells, this);
        }
    }

    public int compare(Object o1, Object o2) {
        Cell c1 = (Cell)o1;
        Cell c2 = (Cell)o2;
        String s1 = c1.getName();
        String s2 = c2.getName();
        if (s1.indexOf("Nuc") == 0 && s2.indexOf("Nuc") == 0) {
            int n2;
            String ss1 = s1.substring(3);
            String ss2 = s2.substring(3);
            int k1 = this.numberEnd(ss1);
            int k2 = this.numberEnd(ss2);
            int n1 = Integer.parseInt(ss1.substring(0, k1));
            if (n1 < (n2 = Integer.parseInt(ss2.substring(0, k2)))) {
                return -1;
            }
            if (n1 > n2) {
                return 1;
            }
        }
        return 0;
    }

    private int numberEnd(String s) {
        int k = 0;
        for (int i = 0; i < s.length() && Character.isDigit(s.charAt(i)); ++i) {
            ++k;
        }
        return k;
    }

    public Vector getRootCells() {
        return this.iRootCells;
    }

    private void processEntries() {
        int r;
        int count = 0;
        for (int i = this.iStartingIndex; i <= this.iEndingIndex && (r = this.processEntry(i)) == 0 && (r = (this.iCellCounts[i] = this.countAliveCellsAtIndex(i))) >= 0; ++i) {
            count = r;
        }
        this.makeCellsByNameHash();
    }

    private int countAliveCellsAtIndex(int k) {
        Vector nuclei;
        try {
            nuclei = (Vector)this.iNucleiMgr.getNucleiRecord().elementAt(k - 1);
        }
        catch (ArrayIndexOutOfBoundsException oob) {
            return -1;
        }
        Nucleus n = null;
        int count = 0;
        for (int j = 0; j < nuclei.size(); ++j) {
            n = (Nucleus)nuclei.elementAt(j);
            if (n.status == -1) continue;
            ++count;
        }
        return count;
    }

    private int processEntry(int i) {
        Vector nuclei;
        int index = i;
        if (this.iShowDeathsAndDivisions) {
            System.out.println("processEntry: " + i + " ************");
        }
        --i;
        Vector nuclei_record = this.iNucleiMgr.getNucleiRecord();
        try {
            nuclei = (Vector)nuclei_record.elementAt(i);
        }
        catch (ArrayIndexOutOfBoundsException oob) {
            System.out.println("***** processEntry: " + i);
            return 1;
        }
        this.iNucleiMgr.setSuccessors(i);
        if (index == this.iStartingIndex) {
            for (int j = 0; j < nuclei.size(); ++j) {
                Nucleus n = (Nucleus)nuclei.elementAt(j);
                this.processRootCell(i, n);
            }
        } else {
            Vector prev = (Vector)this.iNucleiMgr.getNucleiRecord().elementAt(i - 1);
            for (int j = 0; j < nuclei.size(); ++j) {
                Cell parent;
                String parentName;
                Nucleus n = (Nucleus)nuclei.elementAt(j);
                if (n.status == -1) continue;
                if (n.predecessor == -1) {
                    this.processRootCell(i, n);
                    continue;
                }
                int k = n.predecessor - 1;
                Nucleus prevn = null;
                if (k >= 0) {
                    try {
                        prevn = (Nucleus)prev.elementAt(k);
                    }
                    catch (Exception e) {
                        return 1;
                    }
                }
                if (prevn.status == -1) {
                    n.predecessor = -1;
                    this.processRootCell(i, n);
                    continue;
                }
                String hashKey = prevn.getHashKey();
                n.setHashKey(hashKey);
                if ((n.successor1 == -1 || n.successor1 == 0) && index < this.iEndingIndex) {
                    if (this.iShowDeathsAndDivisions) {
                        System.out.println(this.death(n.identity));
                    }
                    Cell c = null;
                    if (hashKey != null) {
                        c = (Cell)this.iCells.get(hashKey);
                    }
                    if (c != null) {
                        c.setEndTime(index);
                        c.setEndFate(2);
                    } else {
                        System.out.println("DYING CELL NOT IN HASH TABLE");
                        continue;
                    }
                }
                if ((parentName = prevn.identity).equals("Nuc199") && i == 179) {
                    int lll = 9;
                }
                if (hashKey == null) {
                    System.out.println("null hashkey");
                    System.out.println("***** processEntry2: " + i + CS + this.iCells);
                }
                if ((parent = (Cell)this.iCells.get(hashKey)) == null) {
                    System.out.println("null parent: " + parentName);
                    System.out.println("i=" + (i + 1) + ", j=" + (j + 1));
                    System.out.println(prevn.toString());
                    System.out.println(n.toString());
                }
                if (prevn.successor2 == -1) {
                    parent.updateCellData(n);
                    continue;
                }
                String daughterName = n.identity;
                if (daughterName == null) {
                    System.out.println("null daughterName: " + i + CS + j);
                    System.out.println(n);
                }
                Cell daughter = new Cell(daughterName);
                daughter.setParameters(index, this.iEndingIndex, n);
                if (n.successor1 == -1 && index < this.iEndingIndex) {
                    daughter.setEndTime(index);
                    daughter.setEndFate(2);
                }
                hashKey = this.makeHashKey(index, n);
                n.setHashKey(hashKey);
                daughter.setHashKey(hashKey);
                Cell x = (Cell)this.iCells.get(n.identity);
                if (x != null) {
                    Cell p = (Cell)x.getParent();
                    x.removeFromParent();
                    this.iCells.remove(n.identity);
                }
                if (parent == null) {
                    System.out.println("null parent, i = " + (i + 1) + "j = " + (j + 1));
                    System.out.println("FORCED CONTINUE");
                    continue;
                }
                parent.add(daughter);
                parent.setEndTime(index - 1);
                parent.setEndFate(1);
                if (daughterName.equals(POLAR)) {
                    n.identity = daughterName;
                    daughter.setName(daughterName);
                }
                if (this.iShowDeathsAndDivisions) {
                    System.out.println(this.division(parent.getName(), daughter.getName()));
                }
                this.iCells.put(daughter.getHashKey(), daughter);
                this.checkDaughters(parent);
            }
        }
        return 0;
    }

    public String division(String par, String dau) {
        StringBuffer sb = new StringBuffer(DIVISIONTEMPLATE);
        sb.replace(12, 12 + par.length(), par);
        sb.replace(31, 31 + dau.length(), dau);
        return sb.toString();
    }

    private String death(String cellName) {
        StringBuffer sb = new StringBuffer(DEATHTEMPLATE);
        sb.replace(9, 9 + cellName.length(), cellName);
        return sb.toString();
    }

    private void setSuccessors(int i) {
        Vector nuclei_record = this.iNucleiMgr.getNucleiRecord();
        Vector now = (Vector)nuclei_record.elementAt(i);
        Nucleus n = null;
        int m1 = -1;
        for (int j = 0; j < now.size(); ++j) {
            n = (Nucleus)now.elementAt(j);
            n.successor1 = m1;
            n.successor2 = m1;
        }
        if (i == nuclei_record.size() - 1) {
            return;
        }
        Vector next = (Vector)nuclei_record.elementAt(i + 1);
        for (int j = 0; j < next.size(); ++j) {
            int pred;
            n = (Nucleus)next.elementAt(j);
            if (n.status == -1 || (pred = n.predecessor) == -1) continue;
            Nucleus p = (Nucleus)now.elementAt(pred - 1);
            if (p.successor1 == m1) {
                p.successor1 = j + 1;
                continue;
            }
            if (p.successor2 == m1) {
                p.successor2 = j + 1;
                continue;
            }
            System.out.println("error: MORE THAN 2 SUCCESSORS");
        }
    }

    private void makeCellsByNameHash() {
        int pct = 0;
        String key = null;
        this.iCellsByName = new Hashtable();
        String rname = this.iRoot.getName();
        this.iCellsByName.put(this.iRoot.getName(), this.iRoot);
        int namingMethod = this.iNucleiMgr.getConfig().iNamingMethod;
        boolean b = namingMethod == 2;
        Enumeration e = this.iCells.keys();
        while (e.hasMoreElements()) {
            String hashKey = (String)e.nextElement();
            Cell c = (Cell)this.iCells.get(hashKey);
            key = c.getName();
            if (key.equals(POLAR) && !b) {
                key = POLAR + ++pct;
            }
            this.iCellsByName.put(key, c);
        }
        Cell PP = (Cell)this.iCellsByName.get(ROOTNAME);
        int kk = PP.getChildCount();
    }

    public Hashtable getCellsByName() {
        return this.iCellsByName;
    }

    private void checkDaughters(Cell parent) {
        if (parent.getChildCount() < 2) {
            return;
        }
        if (parent == this.iRoot) {
            this.checkFirstGeneration();
            return;
        }
        String pn = parent.getName();
        Cell d1 = (Cell)parent.getChildAt(0);
        Cell d2 = (Cell)parent.getChildAt(1);
        String n1 = d1.getName();
        String n2 = d2.getName();
        char c1 = ' ';
        int c2 = 32;
        try {
            c1 = n1.charAt(n1.length() - 1);
            c2 = n2.charAt(n2.length() - 1);
        }
        catch (Exception ioe) {
            System.out.println("checkDaughters: " + parent);
            System.out.println("checkDaughters: " + d1);
            System.out.println("checkDaughters: " + d2);
            new Throwable().printStackTrace();
        }
        if (!Character.isLowerCase(c1)) {
            parent.removeAllChildren();
            if (pn.equals("P0")) {
                this.add(parent, d1, d2, n1.equals("AB"));
            } else if (pn.equals("P1")) {
                this.add(parent, d1, d2, n1.equals("EMS"));
            } else if (pn.equals("P2")) {
                this.add(parent, d1, d2, n1.equals("C"));
            } else if (pn.equals("P3")) {
                this.add(parent, d1, d2, n1.equals("D"));
            } else if (pn.equals("EMS")) {
                this.add(parent, d1, d2, n1.equals("MS"));
            } else if (pn.equals("P4")) {
                this.add(parent, d1, d2, n1.equals("Z2"));
            }
            return;
        }
        if (c1 < c2) {
            return;
        }
        parent.removeAllChildren();
        parent.add(d2);
        parent.add(d1);
    }

    private void add(Cell parent, Cell d1, Cell d2, boolean sense) {
        if (sense) {
            parent.add(d1);
            parent.add(d2);
        } else {
            parent.add(d2);
            parent.add(d1);
        }
    }

    private void checkFirstGeneration() {
        Cell c;
        int i;
        int cc = this.iRoot.getChildCount();
        Hashtable<String, Cell> ch = new Hashtable<String, Cell>();
        for (i = 0; i < cc; ++i) {
            Cell x = (Cell)this.iRoot.getChildAt(i);
            String xn = x.getName();
            if (ch.containsKey(xn)) {
                xn = xn + (int)(100.0 * Math.random());
            }
            ch.put(xn, x);
        }
        this.iRoot.removeAllChildren();
        for (i = 0; i < fgo.length; ++i) {
            if (!ch.containsKey(fgo[i])) continue;
            c = (Cell)ch.remove(fgo[i]);
            this.iRoot.add(c);
        }
        Enumeration e = ch.elements();
        while (e.hasMoreElements()) {
            c = (Cell)e.nextElement();
            this.iRoot.add(c);
        }
    }

    private void processRootCell(int i, Nucleus n) {
        if (n.status == -1) {
            return;
        }
        Cell c = new Cell(n.identity);
        c.setParameters(i + 1, this.iEndingIndex, n);
        String hashKey = this.makeHashKey(i + 1, n);
        n.setHashKey(hashKey);
        c.setHashKey(hashKey);
        Cell x = (Cell)this.iCells.get(n.identity);
        if (x != null) {
            Cell parent = (Cell)x.getParent();
            x.removeFromParent();
            this.iCells.remove(n.identity);
            parent.add(c);
            this.checkDaughters(parent);
        } else {
            this.iRoot.add(c);
        }
        this.iCells.put(hashKey, c);
        this.checkForCellDeath(n, i + 1, hashKey);
        this.checkFirstGeneration();
    }

    private void checkForCellDeath(Nucleus n, int index, String hashKey) {
        if (n.successor1 == -1 && index < this.iEndingIndex) {
            if (this.iShowDeathsAndDivisions) {
                System.out.println(this.death(n.identity));
            }
            Cell c = null;
            if (hashKey != null) {
                c = (Cell)this.iCells.get(hashKey);
            }
            if (c != null) {
                c.setEndTime(index);
                c.setEndFate(2);
            } else {
                System.out.println("DYING CELL NOT IN HASH TABLE");
            }
        }
    }

    private String makeHashKey(int index, Nucleus n) {
        return String.valueOf(index * 100000 + n.index);
    }

    public Cell getRoot() {
        return this.iRoot;
    }

    public int getCellCount(int time) {
        return this.iCellCounts[time];
    }

    public Hashtable getCells() {
        return this.iCells;
    }

    public static void main(String[] args) {
    }

    private static void println(String s) {
        System.out.println(s);
    }
}

