/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.tree;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.text.DecimalFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import org.rhwlab.snight.Nucleus;
import org.rhwlab.tree.CellData;

public class Cell
extends DefaultMutableTreeNode {
    private String iName;
    private int iTimeIndex;
    private int iPlane;
    private int iX;
    private int iY;
    private double iDia;
    private int iEndTime;
    private int iEndFate;
    private String iHashKey;
    private Hashtable iCellXHash;
    public int iEndingIndex;
    private int iLateTime;
    private Vector iCellData;
    public double ysc;
    public int yStartUse;
    public int xUse;
    private int iXmax;
    private Vector iCellsDrawn;
    public static int cMin = 25000;
    public static int cMax = 35000;
    private static double cScale;
    private static double cHeight;
    private static int iEndingIndexS;
    public static int xsc;
    private String blank9 = "         ";
    private String blank7 = "       ";
    private String[] blanks = new String[]{"", " ", "  ", "   ", "    ", "     ", "      ", "       ", "        ", "         ", "          "};
    private static final String[] SEPARATORS;
    private static final int COMMASPACE = 0;
    private static final int TAB = 1;
    private StringBuffer iRedHeader;
    private static final DecimalFormat NODEC;
    private static final DecimalFormat ONEDEC;
    private static final Color GRAYCOLOR;
    private static final Color[] CMAP;
    private static final Color[] CMAP3;
    private static final Color[] CMAP2;
    public static final int NAME = 4;
    public static final int TIME = 0;
    public static final int PLANE = 3;
    public static final int X = 1;
    public static final int Y = 2;
    public static final int DIA = 5;
    public static final int PREV = 12;
    public static final int START0 = 10;
    public static final int START1 = 20;
    public static final int BORDERS = 90;
    public static final int LINEWIDTH = 5;
    public static final int ALIVE = 0;
    public static final int DIVIDED = 1;
    public static final int DIED = 2;
    public static final int LARGEENDTIME = 500;
    public static final String[] fates;
    private static final String CS = ", ";

    public static void setEndingIndexS(int endingIndex) {
        iEndingIndexS = endingIndex;
    }

    public static int getEndingIndex() {
        return iEndingIndexS;
    }

    public static void setXScale(int xScale) {
        xsc = xScale;
    }

    public void setLateTime(int time) {
        this.iLateTime = time;
    }

    public static void setMinRed(int min) {
        cMin = min;
        Cell.setRedScale();
    }

    public static void setMaxRed(int max) {
        cMax = max;
        Cell.setRedScale();
    }

    private static void setRedScale() {
        cScale = (double)CMAP.length / (double)(cMax - cMin);
    }

    public static void setHeight(double height) {
        cHeight = height;
    }

    public Cell(String name) {
        super(name);
        this.iName = (String)this.userObject;
        this.iLateTime = this.iEndingIndex = iEndingIndexS;
        this.iCellData = new Vector();
        cScale = (double)CMAP.length / (double)(cMax - cMin);
    }

    public Cell(Cell c) {
        this.iName = c.iName;
        this.iEndingIndex = c.iEndingIndex;
        this.iLateTime = c.iLateTime;
        this.iCellData = c.iCellData;
        this.iTimeIndex = c.iTimeIndex;
        this.iPlane = c.iPlane;
        this.iX = c.iX;
        this.iY = c.iY;
        this.iDia = c.iDia;
        this.iEndTime = c.iEndTime;
        this.iEndFate = c.iEndFate;
        this.iHashKey = c.iHashKey;
        this.iCellXHash = c.iCellXHash;
        Cell p = (Cell)c.getParent();
        this.setParent(p);
        Cell d1 = (Cell)c.getChildAt(0);
        this.insert(d1, 0);
        Cell.println("Cell, " + this);
    }

    public Cell(String name, int endingIndex) {
        this(name);
        this.iEndingIndex = endingIndex;
    }

    public Cell(String name, int endingIndex, int startTime) {
        this(name, endingIndex);
        this.iTimeIndex = startTime;
    }

    public Color getColor(int i) {
        CellData cd = (CellData)this.iCellData.elementAt(i);
        int red = cd.iNucleus.rweight;
        return Cell.getTheColor(Cell.getDiscrete(red));
    }

    public Color getLastColor() {
        CellData cd = (CellData)this.iCellData.lastElement();
        int red = cd.iNucleus.rweight;
        return Cell.getTheColor(Cell.getDiscrete(red));
    }

    private Color getColor(int i, Vector v) {
        if (v.size() == 0) {
            return Cell.getTheColor(Cell.getDiscrete(0));
        }
        CellData cd = (CellData)v.elementAt(i);
        int red = cd.iNucleus.rweight;
        return Cell.getTheColor(Cell.getDiscrete(red));
    }

    public void paintLine(Graphics g, int x1, int y1, int x2, int y2) {
        Graphics2D g2d = (Graphics2D)g;
        int width = 5;
        g2d.setStroke(new BasicStroke(width));
        g2d.drawLine(x1, y1, x2, y2);
    }

    private void drawColoredLine(Graphics g, Cell c, int x1, int y1, int x2, int y2) {
        Vector use = !this.iName.equals(c.getName()) ? c.iCellData : this.iCellData;
        int useSize = use.size();
        if (x1 != x2) {
            Cell parent = (Cell)c.getParent();
            Color color = this.getColor(use.size() - 1, use);
            g.setColor(color);
            g.drawLine(x1, y1, x2, y2);
        } else {
            int range = (int)Math.round((double)(y2 - y1) / this.ysc);
            int k = Math.min(range, useSize);
            if (k == 0) {
                useSize = k = range;
            }
            if (k > 0) {
                int y2i = y1;
                int y10 = y1;
                for (int i = 0; i < k; ++i) {
                    Color color = c.getColor(i, use);
                    g.setColor(color);
                    y2i = y10 + (y2 - y10) * (i + 1) / k;
                    this.paintLine(g, x1, y1, x2, y2);
                    y1 = y2i;
                }
            }
        }
        g.setColor(Color.black);
    }

    public void draw(Graphics g, int w, int h, int frameWidth, Hashtable cHash) {
        this.iCellsDrawn = new Vector();
        this.iCellXHash = cHash;
        int rootStart = this.iTimeIndex;
        double height = this.iLateTime - this.iTimeIndex;
        this.ysc = (double)(h - 20 - 90) / height;
        this.iXmax = xsc;
        this.yStartUse = 20;
        this.xUse = this.draw(g, h, xsc + 20, this.yStartUse, this, cHash, rootStart);
        g.fillOval(this.xUse - 2, 18, 4, 4);
        g.drawString(this.toString(), this.xUse + 5, 20);
        this.fillInHash(this, cHash);
        g.setColor(Color.yellow);
        g.drawLine(this.xUse, 10, this.xUse, 20);
        g.setColor(Color.black);
        this.showScale(g, h - 20 - 90, frameWidth);
        this.drawCellNames(g);
        this.iLateTime = this.iEndingIndex;
    }

    private void drawCellNames(Graphics g) {
        g.setColor(Color.BLACK);
        Enumeration e = this.iCellsDrawn.elements();
        while (e.hasMoreElements()) {
            Cell c = (Cell)e.nextElement();
            boolean b = this.isLeaf(c);
            if (!b && c == this) continue;
        }
    }

    private boolean isLeaf(Cell c) {
        boolean rtn = false;
        if (c.isLeaf()) {
            rtn = true;
        } else if (c.getEndTime() > this.iLateTime) {
            rtn = true;
        }
        return rtn;
    }

    private int draw(Graphics g, int h, int x, int ystart, Cell c, Hashtable cHash, int rootStart) {
        int x2;
        int x1;
        this.iCellsDrawn.add(c);
        boolean done = false;
        int lastTime = c.iEndTime;
        int lateTime = this.iLateTime;
        if (c.iEndTime > lateTime) {
            done = true;
            lastTime = lateTime;
        }
        int length = (int)((double)(lastTime - c.iTimeIndex) * this.ysc + 0.5);
        c.yStartUse = (int)((double)(c.iTimeIndex - this.iTimeIndex) * this.ysc) + 20;
        if (c.getChildCount() == 0 || done) {
            if (x < this.iXmax) {
                x = this.iXmax + xsc;
            }
            this.drawColoredLine(g, c, x, c.yStartUse, x, c.yStartUse + length);
            g.setColor(Color.black);
            this.drawRotatedText(g, c.getName(), x, c.yStartUse + length + 5, 1.5707963267948966);
            if (x > this.iXmax) {
                this.iXmax = x;
            }
            c.xUse = x;
            this.fillInHash(c, cHash);
            g.fillOval(c.xUse - 2, c.yStartUse - 2, 4, 4);
            return x;
        }
        Cell cLeft = (Cell)c.getChildAt(0);
        Cell cRite = (Cell)c.getChildAt(1);
        int nl = cLeft.getChildCount() / 2;
        if (nl == 0) {
            nl = 1;
        }
        int nr = cRite.getChildCount() + 1;
        cLeft.xUse = x1 = this.draw(g, h, x, this.yStartUse + length, cLeft, cHash, rootStart);
        if (!this.isLeaf(cLeft)) {
            g.fillOval(cLeft.xUse - 2, cLeft.yStartUse - 2, 4, 4);
            this.fillInHash(cLeft, cHash);
            this.drawRotatedText(g, cLeft.getName(), cLeft.xUse, cLeft.yStartUse - 5, -0.39269908169872414);
        }
        int xx = x1 + xsc * nl;
        cRite.xUse = x2 = this.draw(g, h, xx, this.yStartUse + length, cRite, cHash, rootStart);
        if (!this.isLeaf(cRite)) {
            g.fillOval(cRite.xUse - 2, cRite.yStartUse - 2, 4, 4);
            this.fillInHash(cRite, cHash);
            this.drawRotatedText(g, cRite.getName(), cRite.xUse, cRite.yStartUse - 5, -0.39269908169872414);
        }
        this.drawColoredLine(g, c, cLeft.xUse, cLeft.yStartUse, cRite.xUse, cRite.yStartUse);
        x = (x1 + x2) / 2;
        this.drawColoredLine(g, c, x, c.yStartUse, x, cLeft.yStartUse);
        return x;
    }

    private void fillInHash(Cell c, Hashtable cHash) {
        int k = c.xUse * 10000 + c.yStartUse;
        cHash.put(new Integer(k), c);
    }

    private void showScale(Graphics g, int y, int frameWidth) {
        int lateTime = this.iLateTime;
        int dy = (int)((double)(y - 20 - 90) * this.ysc);
        int x = 5;
        Color colorNow = g.getColor();
        g.setColor(Color.blue);
        g.drawLine(x, 20, x, y + 20);
        int k = this.iLateTime - this.iTimeIndex;
        double fy = y;
        double fk = k;
        double incOne = fy / fk;
        double incTen = 10.0 * incOne;
        k = (k - k % 10) / 10;
        int inc = 5;
        for (int i = 0; i <= k; ++i) {
            int y0 = 20 + (int)Math.round(incTen * (double)i);
            g.drawLine(x, y0, x + inc, y0);
        }
        g.drawString(String.valueOf(this.iTimeIndex), x + inc, 20);
        g.drawString(String.valueOf(lateTime), x + inc, 20 + y + 15);
        g.setColor(colorNow);
    }

    private void drawRotatedText(Graphics g, String s, int x, int y, double angle) {
        Point p;
        Point p1 = new Point(x, y);
        Graphics2D g2d = (Graphics2D)g;
        g2d.rotate(angle);
        try {
            g2d.getTransform().inverseTransform(p1, p1);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (angle > 1.5) {
            g2d.drawString(s, y, -x);
        } else {
            p = this.myRotate(x, y);
            g2d.drawString(s, (int)p.getX(), (int)p.getY());
        }
        p = this.myRotate(x, y);
        g2d.rotate(-angle);
    }

    private Point myRotate(int x, int y) {
        double h = Math.sqrt(x * x + y * y);
        double a = Math.atan((double)y / (double)x);
        double b = 1.1780972450961724 - a;
        int yy = (int)Math.round(h * Math.cos(b));
        int xx = (int)Math.round(h * Math.sin(b));
        return new Point(xx, yy);
    }

    public void updateCellData(Nucleus n) {
        this.iCellData.add(new CellData(n));
    }

    public Vector getCellData() {
        return this.iCellData;
    }

    public void setCellData(Vector cd) {
        this.iCellData = cd;
    }

    public Vector getCellData(int start, int end) {
        if (start <= this.iTimeIndex && end > this.iEndTime) {
            return this.iCellData;
        }
        if (start > this.iEndTime) {
            return null;
        }
        Vector v = new Vector();
        start = Math.max(this.iTimeIndex, start);
        int last = this.iTimeIndex + this.iCellData.size() - 1;
        end = Math.min(last, end);
        for (int i = start; i <= end; ++i) {
            v.add(this.iCellData.elementAt(i - this.iTimeIndex));
        }
        return v;
    }

    public Vector getAllCellData(int start, int end) {
        Vector parentCellData;
        Vector rtn = new Vector();
        for (Cell p = (Cell)this.getParent(); p != null && (parentCellData = p.getCellData(start, end)) != null; p = (Cell)p.getParent()) {
            rtn.addAll(0, parentCellData);
        }
        Vector v = this.getCellData(start, end);
        if (v != null) {
            rtn.addAll(v);
        }
        return rtn;
    }

    public String getRedDataString(int first, int last, int separator, int[] count) {
        int time;
        int k = 0;
        String sep = SEPARATORS[separator];
        String s = "";
        Enumeration e = this.iCellData.elements();
        int i = 0;
        for (i = 0; i < this.iCellData.size() && (time = i + this.iTimeIndex) >= first; ++i) {
            if (time > last) continue;
            CellData cd = (CellData)this.iCellData.elementAt(i);
            double d = cd.iNucleus.rweight - 35000;
            s = k == 0 ? s + sep + ONEDEC.format(d + 0.1) : s + sep + NODEC.format(d);
            ++k;
        }
        System.out.println("Cell " + this.iName + CS + k + CS + i);
        count[0] = k;
        return s;
    }

    public String getReverseRedDataString(int first, int last, int separator, int[] count) {
        int time;
        String sep = SEPARATORS[separator];
        int k = 0;
        String s = "";
        String s1 = "";
        StringBuffer sb = new StringBuffer();
        for (int i = this.iCellData.size() - 1; i >= 0 && (time = i + this.iTimeIndex) >= first; --i) {
            if (time > last) continue;
            CellData cd = (CellData)this.iCellData.elementAt(i);
            double d = cd.iNucleus.rweight - 35000;
            if (k == 0) {
                s1 = ONEDEC.format(d + 0.1);
                s = s + sep + s1;
                sb.append(this.makeHeaderName(s1));
            } else {
                s1 = NODEC.format(d);
                s = s + sep + s1;
                sb.append(this.makeHeaderName(s1));
            }
            ++k;
        }
        System.out.println("Cell: " + this.iName + CS + k);
        this.iRedHeader = sb;
        count[0] = k;
        return s;
    }

    private String makeHeaderName(String num) {
        int m;
        String s = "";
        int n = num.length();
        if (n > (m = this.iName.length())) {
            s = this.iName + this.blanks[n - m];
        } else {
            int k = m - n;
            s = this.iName.substring(k);
        }
        return CS + s;
    }

    public String getReverseRedDataHeaderString() {
        return this.iRedHeader.toString();
    }

    public void setParameters(int time, int endTime, Nucleus n) {
        this.iTimeIndex = time;
        this.iPlane = (int)(n.z + 0.5f);
        this.iX = n.x;
        this.iY = n.y;
        this.iDia = n.size;
        this.iEndTime = endTime;
        this.iEndFate = 0;
        this.iCellData.add(new CellData(n));
    }

    public void setStartTime(int time) {
        this.iTimeIndex = time;
        this.iEndTime = 0;
        this.iEndFate = 0;
    }

    public void setTime(int time) {
        this.iTimeIndex = time;
    }

    public String getName() {
        return this.iName;
    }

    public void setName(String newName) {
        this.iName = newName;
    }

    public String getHashKey() {
        return this.iHashKey;
    }

    public void setHashKey(String hashKey) {
        this.iHashKey = hashKey;
    }

    public int getTime() {
        return this.iTimeIndex;
    }

    public int getEndTime() {
        return this.iEndTime;
    }

    public int getEnd() {
        return this.iEndTime;
    }

    public String getFate() {
        return fates[this.iEndFate];
    }

    public int getFateInt() {
        return this.iEndFate;
    }

    public int getPlane() {
        return this.iPlane;
    }

    public int getX() {
        return this.iX;
    }

    public int getY() {
        return this.iY;
    }

    public double getDiam() {
        return this.iDia;
    }

    @Override
    public String toString() {
        return this.iName;
    }

    public String toString(int x) {
        StringBuffer sb = new StringBuffer(this.iName);
        sb.append(CS + this.iTimeIndex);
        sb.append(CS + this.iPlane);
        return sb.toString();
    }

    public void setEndTime(int time) {
        this.iEndTime = time;
    }

    public void setEndingIndex(int time) {
        this.iEndingIndex = time;
    }

    public void setEndFate(int fate) {
        this.iEndFate = fate;
    }

    public int getLifeTime() {
        return this.iEndTime - this.iTimeIndex + 1;
    }

    public boolean isAnterior() {
        Cell x = (Cell)this.getParent().getChildAt(0);
        return x == this;
    }

    public void showParameters() {
    }

    public String showStuff() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.iName + CS);
        sb.append(this.iTimeIndex + CS);
        sb.append(this.iEndTime + CS);
        sb.append(this.iEndingIndex);
        return sb.toString();
    }

    public static int getDiscrete(int r) {
        int k = 0;
        k = (int)((double)(r - cMin) * cScale);
        return k;
    }

    public static Color getTheColor(int index) {
        if (index < 0) {
            index = 0;
            return GRAYCOLOR;
        }
        if (index >= CMAP2.length) {
            index = CMAP2.length - 1;
        }
        return CMAP2[index];
    }

    private static void println(String s) {
        System.out.println(s);
    }

    static {
        cHeight = 400.0;
        SEPARATORS = new String[]{CS, "\t"};
        NODEC = new DecimalFormat("#######");
        ONEDEC = new DecimalFormat("#######.#");
        GRAYCOLOR = new Color(128, 128, 128);
        CMAP = new Color[]{new Color(0, 30, 255), new Color(0, 55, 230), new Color(0, 80, 205), new Color(0, 105, 180), new Color(0, 130, 155), new Color(0, 155, 130), new Color(0, 180, 105), new Color(0, 205, 80), new Color(0, 230, 55), new Color(0, 255, 30), new Color(30, 230, 0), new Color(55, 205, 0), new Color(85, 180, 0), new Color(105, 155, 0), new Color(130, 130, 0), new Color(155, 105, 0), new Color(180, 80, 0), new Color(205, 55, 0), new Color(230, 30, 0), new Color(255, 0, 0)};
        CMAP3 = new Color[]{new Color(0, 0, 255), new Color(0, 41, 255), new Color(0, 103, 255), new Color(0, 153, 255), new Color(0, 204, 255), new Color(0, 255, 255), new Color(0, 255, 204), new Color(0, 255, 153), new Color(0, 255, 103), new Color(0, 255, 41), new Color(0, 255, 0), new Color(41, 255, 0), new Color(153, 255, 0), new Color(204, 255, 0), new Color(255, 255, 0), new Color(255, 204, 0), new Color(255, 153, 0), new Color(255, 102, 0), new Color(255, 41, 0), new Color(255, 0, 0)};
        CMAP2 = new Color[]{new Color(0, 255, 0), new Color(0, 230, 0), new Color(0, 205, 0), new Color(0, 180, 0), new Color(0, 155, 0), new Color(0, 130, 0), new Color(0, 105, 0), new Color(0, 80, 0), new Color(0, 55, 0), new Color(0, 30, 0), new Color(30, 0, 0), new Color(55, 0, 0), new Color(85, 0, 0), new Color(105, 0, 0), new Color(130, 0, 0), new Color(155, 0, 0), new Color(180, 0, 0), new Color(205, 0, 0), new Color(230, 0, 0), new Color(255, 0, 0)};
        fates = new String[]{"alive", "divided", "died"};
    }
}

