/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.tree;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Vector;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import org.rhwlab.tree.Cell;

public class Newick
extends JPanel {
    Cell iRoot;
    Vector iBuffer;
    private static final String[] blastomeres = new String[]{"P0", "P1", "AB", "P2", "EMS", "ABa", "ABp", "MS", "E", "P3", "C", "P4", "D"};

    public Newick(Cell root) {
        this.iRoot = root;
        this.iBuffer = new Vector();
        Vector v = null;
        Cell x = this.iRoot;
        Vector<String> r = new Vector<String>();
        int m = x.getChildCount();
        for (int i = 0; i < m; ++i) {
            Cell c = (Cell)x.getChildAt(i);
            v = this.processTree(c);
            String s = this.buildNewick(v) + "\n";
            r.add(s);
        }
        int rs = r.size();
        String s = null;
        if (rs > 1) {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < rs; ++i) {
                if (i == 0) {
                    sb.append("(");
                } else if (i < rs) {
                    sb.append(",");
                }
                sb.append((String)r.elementAt(i));
            }
            sb.append(")");
            s = sb.toString();
        } else {
            s = (String)r.elementAt(0);
        }
        this.saveNewickFile(s);
    }

    private Vector processTree(Cell x) {
        Vector v = new Vector();
        this.preorder(x, v);
        return v;
    }

    private void showVector(Vector stack, String s) {
        System.out.println(s);
        int k = stack.size();
        String s2 = null;
        for (int i = 0; i < k; ++i) {
            s2 = (String)stack.elementAt(i);
            System.out.println(i + "\t" + s2);
        }
    }

    private void preorder(Cell x, Vector v) {
        Cell c1;
        String name;
        Cell p = (Cell)x.getParent();
        String vname = name = x.toString();
        String s = null;
        boolean addSpecies = false;
        int count = x.getChildCount();
        if (count > 0) {
            vname = this.validateName(name);
        }
        s = vname;
        addSpecies = count > 0 && vname.length() == 0;
        s = s + ":" + x.getLifeTime();
        if (addSpecies) {
            s = s + ":S=" + name + "\n";
        }
        v.add(0, s);
        if (x.getChildCount() == 0) {
            return;
        }
        Cell c0 = (Cell)x.getChildAt(1);
        if (c0 != null) {
            v.add(0, ")");
            this.preorder(c0, v);
        }
        if ((c1 = (Cell)x.getChildAt(0)) != null) {
            v.add(0, ",");
            this.preorder(c1, v);
            v.add(0, "(");
        }
    }

    private String validateName(String name) {
        String s = "";
        boolean found = false;
        if (name.length() < 4) {
            int i;
            for (i = 0; i < blastomeres.length && !(found = name.equals(blastomeres[i])); ++i) {
            }
            if (found) {
                s = blastomeres[i];
            }
        }
        return s;
    }

    private String buildNewick(Vector v) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < v.size(); ++i) {
            String s = (String)v.elementAt(i);
            sb.append(s);
        }
        return sb.toString();
    }

    private void saveNewickFile(String s) {
        JFileChooser fc = new JFileChooser(new File("."));
        int returnVal = fc.showSaveDialog(this);
        if (returnVal == 0) {
            String dir = fc.getCurrentDirectory().toString();
            String name = fc.getName(fc.getSelectedFile());
            try {
                PrintStream ps = new PrintStream(new FileOutputStream(fc.getSelectedFile()));
                ps.print(s);
                ps.flush();
                ps.close();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }

    public static void main(String[] args) {
    }
}

