/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.tree;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.border.Border;
import org.rhwlab.acetree.AceTree;
import org.rhwlab.snight.NucleiMgr;
import org.rhwlab.snight.Nucleus;
import org.rhwlab.tree.AncesTree;
import org.rhwlab.tree.Cell;
import org.rhwlab.tree.VTreeImpl;

public class SubTrees
extends JPanel
implements ActionListener {
    private JFrame iFrame;
    JToolBar iToolBar;
    JTextField iTextField;
    JTextField iTextField2;
    JTextField iTextField3;
    int iLastTime;
    JRadioButton iABala;
    JRadioButton iABalp;
    private VTreeImpl iVTreeImpl;
    ButtonGroup iButtonGroup;
    AceTree iAceTree;
    AncesTree iAncesTree;
    NucleiMgr iNucleiMgr;
    Vector nuclei_record;
    Cell iRoot;
    Hashtable iCellsByName;
    private static final String[] buttons = new String[]{"ABala", "ABalp", "ABara", "ABarp", "ABpla", "ABplp", "ABpra", "ABprp", "MSa", "MSp", "E", "C", "P3"};
    private static final String CS = ", ";
    private static final DecimalFormat DF2 = new DecimalFormat("###.##");
    private static final DecimalFormat DF000 = new DecimalFormat("000");

    public SubTrees() {
        this.setPreferredSize(new Dimension(400, 200));
        this.setLayout(new BoxLayout(this, 1));
        this.iToolBar = new JToolBar("");
        this.iToolBar.setLayout(new GridLayout(1, 0));
        this.add(this.iToolBar);
        this.initialize();
        this.buildOutToolBar();
        this.addButtons();
        this.iFrame = new JFrame("SubTrees");
        this.showMe();
    }

    public void initialize() {
        this.iAceTree = AceTree.getAceTree(null);
        this.iNucleiMgr = this.iAceTree.getNucleiMgr();
        this.nuclei_record = this.iNucleiMgr.getNucleiRecord();
        this.iAncesTree = this.iNucleiMgr.getAncesTree();
        this.iCellsByName = this.iAncesTree.getCellsByName();
        this.iRoot = this.iAceTree.getRoot();
        this.iLastTime = this.estimate350CellStage();
    }

    private int estimate350CellStage() {
        int stage = 355;
        boolean r = false;
        int size = 0;
        int time = 0;
        for (int i = 0; i < this.nuclei_record.size(); ++i) {
            Vector nuclei = (Vector)this.nuclei_record.get(i);
            int t = nuclei.size();
            if (t > size) {
                size = t;
                time = i;
            }
            int count = 0;
            if (size > stage) {
                count = 0;
                for (int j = 0; j < nuclei.size(); ++j) {
                    Nucleus n = (Nucleus)nuclei.get(j);
                    if (n.status <= 0 || n.identity.startsWith("N")) continue;
                    ++count;
                }
            }
            if (count > stage) break;
        }
        return time + 1;
    }

    private void addButtons() {
        JRadioButton rb;
        int i;
        this.iButtonGroup = new ButtonGroup();
        Border blackBorder = BorderFactory.createLineBorder(Color.BLACK);
        JPanel jp = new JPanel(new GridLayout(1, 0));
        jp.setBorder(blackBorder);
        for (i = 0; i < 4; ++i) {
            rb = new JRadioButton(buttons[i]);
            rb.setBorder(blackBorder);
            this.iButtonGroup.add(rb);
            jp.add(rb);
            if (i != 0) continue;
            rb.setSelected(true);
        }
        this.add(jp);
        jp = new JPanel(new GridLayout(1, 0));
        jp.setBorder(blackBorder);
        for (i = 4; i < 8; ++i) {
            rb = new JRadioButton(buttons[i]);
            rb.setBorder(blackBorder);
            this.iButtonGroup.add(rb);
            jp.add(rb);
        }
        this.add(jp);
        jp = new JPanel(new GridLayout(1, 0));
        jp.setBorder(blackBorder);
        for (i = 8; i < buttons.length; ++i) {
            rb = new JRadioButton(buttons[i]);
            rb.setBorder(blackBorder);
            this.iButtonGroup.add(rb);
            jp.add(rb);
        }
        this.add(jp);
    }

    private void buildOutToolBar() {
        this.iToolBar.setMaximumSize(new Dimension(700, 20));
        this.iToolBar.add(new JLabel("end"));
        this.iTextField = new JTextField();
        this.iTextField.setColumns(5);
        this.iTextField.setText(String.valueOf(this.iLastTime));
        this.iToolBar.add(this.iTextField);
        this.iToolBar.add(new JLabel("minRed"));
        this.iTextField2 = new JTextField();
        this.iTextField2.setColumns(6);
        this.iTextField2.setText(String.valueOf(-500));
        this.iToolBar.add(this.iTextField2);
        this.iToolBar.add(new JLabel("maxRed"));
        this.iTextField3 = new JTextField();
        this.iTextField3.setColumns(5);
        this.iTextField3.setText(String.valueOf(5000));
        this.iToolBar.add(this.iTextField3);
        JButton jb = null;
        jb = new JButton("Show");
        this.addToolBarButton(jb);
    }

    protected void addToolBarButton(AbstractButton ab) {
        ab.addActionListener(this);
        this.iToolBar.add(ab);
    }

    public void showMe() {
        this.iFrame.setDefaultCloseOperation(2);
        this.iFrame.setContentPane(this);
        this.iFrame.pack();
        this.iFrame.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String root = this.getRoot();
        if (this.iVTreeImpl == null) {
            this.iVTreeImpl = new VTreeImpl();
        }
        int last = Integer.parseInt(this.iTextField.getText());
        int minRed = Integer.parseInt(this.iTextField2.getText());
        int maxRed = Integer.parseInt(this.iTextField3.getText());
        this.iVTreeImpl.showTree(root, last, minRed, maxRed);
    }

    private String getRoot() {
        String root = "E";
        Enumeration<AbstractButton> e = this.iButtonGroup.getElements();
        while (e.hasMoreElements()) {
            AbstractButton o = e.nextElement();
            JRadioButton jb = (JRadioButton)o;
            root = jb.getText();
            boolean b = jb.isSelected();
            if (!b) continue;
            break;
        }
        return root;
    }

    public static void main(String[] args) {
    }

    private static void println(String s) {
        System.out.println(s);
    }

    private static String fmt4(double d) {
        return new DecimalFormat("####.####").format(d);
    }
}

