/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.tree;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.PrintJob;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.text.DecimalFormat;
import javax.imageio.ImageIO;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import org.rhwlab.acetree.AceTree;
import org.rhwlab.tree.CanonicalTree;
import org.rhwlab.tree.Cell;
import org.rhwlab.tree.TreeCanvas;
import org.rhwlab.tree.TreePanel;

public class SulstonTree
extends JFrame
implements ActionListener,
WindowFocusListener {
    String title;
    TreeCanvas tc;
    int width;
    int height;
    public AceTree iAceTree;
    private CanonicalTree iCanonicalTree;
    private JToolBar iToolBar;
    private JTextField iRootCell;
    private JTextField iLateTimeField;
    private JTextField iMinRedField;
    private JTextField iMaxRedField;
    private JButton iRefresh;
    private Cell iCurrentCell;
    private TreeCanvas iTreeCanvas;
    private TreePanel iTreePanel;
    private TreePanel tp;
    private boolean iCanInterrogate;
    private static final String CS = ", ";
    private static final String IMAGETYPE = "png";
    private static final int WIDTH = 800;
    private static final int HEIGHT = 300;
    private static final int MINWIDTH = 400;
    private static final int MINHEIGHT = 100;
    private static final DecimalFormat DF1 = new DecimalFormat("####.##");
    private static final DecimalFormat DF4 = new DecimalFormat("####.####");

    public SulstonTree(Object tree, String title, Cell c, boolean canInterrogate) {
        super(title);
        this.title = title;
        this.width = 800;
        this.height = 300;
        this.setResizable(true);
        if (canInterrogate) {
            this.iAceTree = (AceTree)tree;
        } else {
            this.iCanonicalTree = (CanonicalTree)tree;
        }
        this.iCurrentCell = c;
        this.iCanInterrogate = canInterrogate;
        this.iToolBar = new JToolBar("");
        this.iToolBar.setLayout(new GridLayout(1, 10));
        JPanel jp = new JPanel(new FlowLayout());
        JLabel rootCell = new JLabel("root");
        jp.add(rootCell);
        this.iRootCell = new JTextField(c.getName(), 10);
        jp.add(this.iRootCell);
        this.iToolBar.add(jp);
        jp = new JPanel(new FlowLayout());
        JLabel endTime = new JLabel("End time");
        jp.add(endTime);
        int endTimeData = this.iCurrentCell.getEndTime();
        this.iLateTimeField = new JTextField(String.valueOf(endTimeData), 7);
        jp.add(this.iLateTimeField);
        this.iToolBar.add(jp);
        jp = new JPanel(new FlowLayout());
        this.iMinRedField = new JTextField("-500", 7);
        this.iMaxRedField = new JTextField("5000", 7);
        jp.add(new JLabel("minRed"));
        jp.add(this.iMinRedField);
        this.iToolBar.add(jp);
        jp = new JPanel(new FlowLayout());
        jp.add(new JLabel("maxRed"));
        jp.add(this.iMaxRedField);
        this.iToolBar.add(jp);
        jp = new JPanel(new FlowLayout());
        this.iRefresh = new JButton("Refresh");
        this.iRefresh.addActionListener(this);
        jp.add(this.iRefresh);
        JButton jb1 = new JButton("Print");
        jb1.addActionListener(this);
        jp.add(jb1);
        this.iToolBar.add(jp);
        this.getContentPane().add((Component)this.iToolBar, "North");
        this.iCurrentCell.setLateTime(Integer.parseInt(this.iLateTimeField.getText()));
        this.tp = new TreePanel(c, this, canInterrogate);
        JScrollPane sp = new JScrollPane(this.tp, 21, 32);
        this.getContentPane().add((Component)sp, "Center");
        this.iTreePanel = this.tp;
        this.refreshTree();
        this.pack();
        this.show();
        this.addWindowFocusListener(this);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.width, this.height);
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(400, 100);
    }

    private void refreshTree(boolean b) {
        if (this.iCanInterrogate) {
            this.iCurrentCell = this.iAceTree.getCellByName(this.iRootCell.getText());
            this.iTreeCanvas.setCell(this.iCurrentCell);
        } else {
            this.iCurrentCell = (Cell)this.iCanonicalTree.getCellsHash().get(this.iRootCell.getText());
            this.iTreeCanvas.setCell(this.iCurrentCell);
        }
        this.iTreeCanvas.setLateTime(Integer.parseInt(this.iLateTimeField.getText()));
        this.iTreeCanvas.setMinRed(Integer.parseInt(this.iMinRedField.getText()));
        this.iTreeCanvas.setMaxRed(Integer.parseInt(this.iMaxRedField.getText()));
        this.iTreeCanvas.repaint();
    }

    private void refreshTree() {
        if (this.iCanInterrogate) {
            this.iCurrentCell = this.iAceTree.getCellByName(this.iRootCell.getText());
            this.iTreePanel.setCell(this.iCurrentCell);
        } else {
            this.iCurrentCell = (Cell)this.iCanonicalTree.getCellsHash().get(this.iRootCell.getText());
            this.iTreePanel.setCell(this.iCurrentCell);
        }
        this.iTreePanel.setLateTime(Integer.parseInt(this.iLateTimeField.getText()));
        this.iTreePanel.setMinRed(Integer.parseInt(this.iMinRedField.getText()));
        this.iTreePanel.setMaxRed(Integer.parseInt(this.iMaxRedField.getText()));
        this.iTreePanel.repaint();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String s = e.getActionCommand();
        if (s.equals("Print")) {
            System.out.println("print requested");
            this.saveImage();
        } else if (s.equals("Refresh")) {
            this.refreshTree();
        }
    }

    public void printIt() {
        Toolkit t = this.getToolkit();
        PrintJob pj = t.getPrintJob(this, "Printing " + this.title, null);
        if (pj != null) {
            Graphics pg = pj.getGraphics();
            this.printAll(pg);
            pg.dispose();
            pj.end();
        }
    }

    private void listWriters() {
        String[] sa = ImageIO.getWriterMIMETypes();
        for (int i = 0; i < sa.length; ++i) {
            System.out.println(sa[i]);
        }
    }

    public void saveImage() {
        this.listWriters();
        JFileChooser iFC = new JFileChooser();
        int returnVal = iFC.showSaveDialog(this);
        if (returnVal == 0) {
            String dir = iFC.getCurrentDirectory().toString();
            String name = iFC.getName(iFC.getSelectedFile());
            String iTitle = dir + "/" + name;
            this.iTreePanel.captureImage(name, dir);
        }
    }

    public static void main(String[] args) {
    }

    @Override
    public void windowGainedFocus(WindowEvent e) {
        this.refreshTree();
    }

    @Override
    public void windowLostFocus(WindowEvent e) {
    }

    private static void println(String s) {
        System.out.println(s);
    }
}

