/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.tree;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.swing.event.MouseInputAdapter;
import org.rhwlab.tree.Cell;
import org.rhwlab.tree.SulstonTree;

class TreeCanvas
extends Canvas {
    Cell c;
    int width;
    int height;
    SulstonTree iSulstonTree;
    Hashtable iCellXHash;
    int[] iInt;
    boolean iCanInterrogate;
    int iLateTime;
    int iMinRed;
    int iMaxRed;
    private static final String CS = ", ";
    private static final int XSCALE = 20;
    private static final int YSCALE = 70;
    private static final int YFIXEDSCALE = 1000;
    private static final int MINWIDTH = 400;

    public TreeCanvas(Cell c, SulstonTree sulstonTree, boolean canInterrogate) {
        this.c = c;
        this.iSulstonTree = sulstonTree;
        this.iCanInterrogate = canInterrogate;
        this.iCellXHash = new Hashtable();
        this.width = 20 * c.getLeafCount();
        Cell.setXScale(20);
        if (canInterrogate) {
            MouseHandler mh = new MouseHandler(this);
            this.addMouseMotionListener(mh);
            this.addMouseListener(mh);
        }
        this.iLateTime = Cell.getEndingIndex();
        this.setBackground(Color.white);
    }

    public void setLateTime(int time) {
        this.iLateTime = time;
    }

    public void setMinRed(int min) {
        this.iMinRed = min;
    }

    public void setMaxRed(int max) {
        this.iMaxRed = max;
    }

    public void setCell(Cell cSet) {
        this.c = cSet;
        this.width = 20 * this.c.getLeafCount();
        this.width = Math.max(this.width, 400);
        Dimension d = this.getSize();
        d.width = this.width;
        this.setSize(d);
    }

    @Override
    public void paint(Graphics g) {
        Dimension d = this.getSize();
        if (this.c != null) {
            this.iCellXHash.clear();
            this.c.setLateTime(this.iLateTime);
            Cell.setMinRed(this.iMinRed);
            Cell.setMaxRed(this.iMaxRed);
            this.c.draw(g, d.width, d.height, this.iSulstonTree.getWidth(), this.iCellXHash);
        }
    }

    public void captureImage(String filePath) {
        BufferedImage image = new BufferedImage(this.getWidth(), this.getHeight(), 1);
        Graphics g = image.getGraphics();
        this.paint(g);
        File f = new File(filePath);
        try {
            ImageIO.write((RenderedImage)image, "png", f);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    private void displayHash() {
        Enumeration eKeys = this.iCellXHash.keys();
        while (eKeys.hasMoreElements()) {
            Integer x = (Integer)eKeys.nextElement();
            Cell cname = (Cell)this.iCellXHash.get(x);
            System.out.println("displayHash: " + cname + CS + x + CS + cname.iEndingIndex + CS + cname.getTime() + CS + cname.getEndTime());
        }
    }

    @Override
    public Dimension getPreferredSize() {
        System.out.println("getPreferredSize: " + this.width + CS + this.height);
        return new Dimension(this.width, this.height);
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    private Cell findIt(int x, int y) {
        Enumeration ev = this.iCellXHash.elements();
        int xs = 10000;
        Cell cs = null;
        double timex = (double)this.c.getTime() + (double)(y - 20) / this.c.ysc;
        int time = (int)(timex + 0.5);
        while (ev.hasMoreElements()) {
            int xtest;
            Cell c = (Cell)ev.nextElement();
            int cystart = c.yStartUse;
            int cyend = cystart + (int)((double)(c.getEndTime() - c.getTime() + 1) * this.c.ysc + 0.5);
            if (time < c.getTime() || time > c.getEndTime() || (xtest = Math.abs(x - c.xUse)) >= xs || xtest >= Cell.xsc) continue;
            xs = xtest;
            cs = c;
        }
        return cs;
    }

    public void notifyAceTree(Cell c, int time) {
        Vector<String> v = new Vector<String>();
        v.add("InputCtrl1");
        v.add(String.valueOf(time));
        v.add(c.getName());
        this.iSulstonTree.iAceTree.controlCallback(v);
    }

    class MouseHandler
    extends MouseInputAdapter {
        public MouseHandler(Object o) {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            double time = (double)TreeCanvas.this.c.getTime() + (double)(e.getY() - 20) / TreeCanvas.this.c.ysc;
            Cell cs = TreeCanvas.this.findIt(e.getX(), e.getY());
            if (cs != null) {
                int intTime = (int)(time + 0.5);
                int button = e.getButton();
                if (button == 1) {
                    TreeCanvas.this.notifyAceTree(cs, intTime);
                } else if (button == 3) {
                    TreeCanvas.this.notifyAceTree(cs, cs.getEndTime());
                }
            }
        }
    }
}

