/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.tree;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.swing.JPanel;
import javax.swing.event.MouseInputAdapter;
import org.rhwlab.tree.Cell;
import org.rhwlab.tree.SulstonTree;

public class TreePanel
extends JPanel {
    Cell c;
    int width;
    int height;
    SulstonTree iSulstonTree;
    Hashtable iCellXHash;
    int[] iInt;
    boolean iCanInterrogate;
    int iLateTime;
    int iMinRed;
    int iMaxRed;
    int iNoPaint;
    private static final String CS = ", ";
    private static final int XSCALE = 20;
    private static final int YSCALE = 70;
    private static final int YFIXEDSCALE = 1000;
    private static final int MINWIDTH = 400;

    public TreePanel(Cell c, SulstonTree sulstonTree, boolean canInterrogate) {
        this.c = c;
        this.iSulstonTree = sulstonTree;
        this.iCanInterrogate = canInterrogate;
        this.iCellXHash = new Hashtable();
        this.width = 20 * c.getLeafCount();
        Cell.setXScale(20);
        this.height = 1000;
        if (canInterrogate) {
            MouseHandler mh = new MouseHandler(this);
            this.addMouseMotionListener(mh);
            this.addMouseListener(mh);
        }
        this.iLateTime = Cell.getEndingIndex();
        this.setBackground(Color.white);
    }

    public void setLateTime(int time) {
        this.iLateTime = time;
    }

    public void setMinRed(int min) {
        this.iMinRed = min;
    }

    public void setMaxRed(int max) {
        this.iMaxRed = max;
    }

    public void setCell(Cell cSet) {
        this.c = cSet;
        this.width = 20 * this.c.getLeafCount();
        this.width = Math.max(this.width, 400);
        Dimension d = this.getSize();
        d.width = this.width;
        d.height = this.height = 70 * this.c.getDepth();
        this.setSize(d);
    }

    public void captureImage(String fileName, String dir) {
        BufferedImage image = new BufferedImage(this.getWidth(), this.getHeight(), 1);
        Graphics g = image.getGraphics();
        this.paint(g);
        File f = new File(dir + "/" + fileName);
        try {
            ImageIO.write((RenderedImage)image, "png", f);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        this.makeWebPage(fileName, dir);
    }

    public void makeWebPage(String fileName, String dir) {
        String s = fileName.substring(0, fileName.length() - 4);
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(dir + "/" + s + ".html", false);
        }
        catch (FileNotFoundException fnfe) {
            fnfe.printStackTrace();
            return;
        }
        PrintWriter pw = new PrintWriter(fos, true);
        pw.println("<html>");
        pw.println("<head><title>" + s + "</title></head>");
        pw.println("<body>");
        pw.println("<img src=\"" + s + ".png\">");
        pw.println("</body>");
        pw.println("</html>");
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Dimension d = this.getSize();
        Dimension pd = this.iSulstonTree.getSize();
        if (this.c != null) {
            this.iCellXHash.clear();
            this.c.setLateTime(this.iLateTime);
            Cell.setMinRed(this.iMinRed);
            Cell.setMaxRed(this.iMaxRed);
            this.c.draw(g, d.width, pd.height - 89, this.iSulstonTree.getWidth(), this.iCellXHash);
        }
    }

    private void displayHash() {
        Enumeration eKeys = this.iCellXHash.keys();
        while (eKeys.hasMoreElements()) {
            Integer x = (Integer)eKeys.nextElement();
            Cell cell = (Cell)this.iCellXHash.get(x);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.width, this.height);
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    private Cell findIt(int x, int y) {
        Enumeration ev = this.iCellXHash.elements();
        int xs = 10000;
        Cell cs = null;
        double timex = (double)this.c.getTime() + (double)(y - 20) / this.c.ysc;
        int time = (int)(timex + 0.5);
        while (ev.hasMoreElements()) {
            int xtest;
            Cell c = (Cell)ev.nextElement();
            int cystart = c.yStartUse;
            int cyend = cystart + (int)((double)(c.getEndTime() - c.getTime() + 1) * this.c.ysc + 0.5);
            if (time < c.getTime() || time > c.getEndTime() || (xtest = Math.abs(x - c.xUse)) >= xs || xtest >= Cell.xsc) continue;
            xs = xtest;
            cs = c;
        }
        return cs;
    }

    public void notifyAceTree(Cell c, int time) {
        Vector<String> v = new Vector<String>();
        v.add("InputCtrl1");
        v.add(String.valueOf(time));
        v.add(c.getName());
        this.iSulstonTree.iAceTree.controlCallback(v);
    }

    public static void main(String[] args) {
    }

    private static void println(String s) {
        System.out.println(s);
    }

    class MouseHandler
    extends MouseInputAdapter {
        public MouseHandler(Object o) {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            double time = (double)TreePanel.this.c.getTime() + (double)(e.getY() - 20) / TreePanel.this.c.ysc;
            Cell cs = TreePanel.this.findIt(e.getX(), e.getY());
            if (cs != null) {
                int intTime = (int)(time + 0.5);
                int button = e.getButton();
                if (button == 1) {
                    TreePanel.this.notifyAceTree(cs, intTime);
                } else if (button == 3) {
                    TreePanel.this.notifyAceTree(cs, cs.getEndTime());
                }
            }
            TreePanel.this.iSulstonTree.iAceTree.requestFocus();
        }
    }
}

