/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.tree;

import java.awt.Color;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import org.rhwlab.acetree.AceTree;
import org.rhwlab.snight.NucleiMgr;
import org.rhwlab.tree.VTreeImpl;
import org.rhwlab.tree.VTreeImplZ;

public class VTree
implements ActionListener {
    private JFrame iFrame;
    private JTextField[] iFields;
    private JLabel[] iLabels;
    private JButton iColor;
    private JToolBar iToolBar;
    private JButton iShow;
    private JButton iTestZ;
    private JButton iPrint;
    private VTreeImpl iVTreeImpl;
    private JRadioButton iPng;
    private JRadioButton iPs;
    private JCheckBox iLabelRoot;
    private JCheckBox iLabelLeaves;
    private String[] labels = new String[]{"rootCell", "endTime", "minRed", "maxRed", "yInc", "lineWidth", "hue"};
    private String[] initValues = new String[]{"E", "200", "-500", "5000", "10", "5", "0"};
    private static final String CS = ", ";

    public VTree() {
        this.iFrame = new JFrame("VTree");
        JPanel pWhole = new JPanel();
        pWhole.setLayout(new BoxLayout(pWhole, 3));
        JScrollPane p = this.makePanel();
        pWhole.add(p);
        this.makeToolBar();
        pWhole.add(this.iToolBar);
        AceTree acetree = AceTree.getAceTree(null);
        NucleiMgr nucleiMgr = acetree.getNucleiMgr();
        JFrame.setDefaultLookAndFeelDecorated(false);
        String s = nucleiMgr.getConfig().iConfigFileName;
        File fs = new File(s);
        s = fs.getName();
        this.iFrame.setTitle(s);
        this.iFrame.getContentPane().add(pWhole);
        this.iFrame.pack();
        this.iFrame.show();
    }

    private void makeToolBar() {
        this.iToolBar = new JToolBar();
        this.iShow = new JButton("show");
        this.iShow.addActionListener(this);
        this.iToolBar.add(this.iShow);
        this.iPrint = new JButton("print");
        this.iPrint.addActionListener(this);
        this.iToolBar.add(this.iPrint);
    }

    private JScrollPane makePanel() {
        JPanel pWhole = new JPanel();
        pWhole.setLayout(new BoxLayout(pWhole, 3));
        this.iFields = new JTextField[this.labels.length];
        this.iLabels = new JLabel[this.labels.length];
        for (int i = 0; i < this.labels.length; ++i) {
            JPanel p = new JPanel();
            p.setLayout(new GridLayout(1, 2));
            this.iLabels[i] = new JLabel(this.labels[i]);
            this.iFields[i] = new JTextField(this.initValues[i], 10);
            p.add(this.iLabels[i]);
            p.add(this.iFields[i]);
            pWhole.add(p);
        }
        this.iColor = new JButton("choose color");
        pWhole.add(this.iColor);
        this.iColor.addActionListener(this);
        this.iLabelRoot = new JCheckBox("label root", true);
        this.iLabelLeaves = new JCheckBox("label leaves", true);
        pWhole.add(this.iLabelRoot);
        pWhole.add(this.iLabelLeaves);
        JScrollPane sPane = new JScrollPane(pWhole);
        return sPane;
    }

    public static void main(String[] args) {
        new VTree();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Color c;
        Object o = e.getSource();
        if (o == this.iShow) {
            if (this.iVTreeImpl == null) {
                this.iVTreeImpl = new VTreeImpl();
            }
            this.iVTreeImpl.showTree(this.iFields, this.iLabelRoot.isSelected(), this.iLabelLeaves.isSelected());
        } else if (o == this.iPrint) {
            JFileChooser iFC = new JFileChooser();
            int returnVal = iFC.showSaveDialog(this.iFrame);
            String dir = "";
            String name = "default.png";
            if (returnVal == 0) {
                dir = iFC.getCurrentDirectory().toString();
                name = iFC.getName(iFC.getSelectedFile());
            }
            if (this.iVTreeImpl == null) {
                this.iVTreeImpl = new VTreeImpl();
            }
            this.iVTreeImpl.printTree(this.iFields, this.iLabelRoot.isSelected(), this.iLabelLeaves.isSelected(), name, dir);
        } else if (o == this.iTestZ) {
            VTreeImplZ vtz = new VTreeImplZ();
            vtz.printTree(this.iFields, "testZ.ps", "/home/biowolp/0tmp/errorBars/");
            vtz.showTree(this.iFields);
        } else if (o == this.iColor && (c = JColorChooser.showDialog(null, "Choose expression color", Color.RED)) != null) {
            float[] hsb = Color.RGBtoHSB(c.getRed(), c.getGreen(), c.getBlue(), null);
            this.iFields[6].setText(String.valueOf(hsb[0]));
        }
    }

    private static void println(String s) {
        System.out.println(s);
    }
}

