/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.tree;

import flanagan.plot.PlotGraph;
import java.awt.BasicStroke;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.ScrollPane;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.swing.JFrame;
import javax.swing.JTextField;
import javax.swing.event.MouseInputAdapter;
import javax.swing.tree.TreeNode;
import org.rhwlab.acetree.AceTree;
import org.rhwlab.snight.NucleiMgr;
import org.rhwlab.tree.AncesTree;
import org.rhwlab.tree.Cell;
import org.rhwlab.tree.CellData;

public class VTreeImpl {
    AceTree iAceTree;
    NucleiMgr iNucleiMgr;
    Vector nuclei_record;
    AncesTree iAncesTree;
    Hashtable iCellsByName;
    Cell iRoot;
    String iShortName;
    String iRootCell;
    int iEndTime;
    boolean iLeafNames;
    boolean iRootName;
    int iRootK;
    Vector iCellLines;
    Vector iLines;
    Vector iNames;
    int iKlast;
    int iKincInit;
    String iPSFileName;
    int iLineWidth;
    int iLineInc;
    int iFontSize;
    float iHue;
    Hashtable iDaughters;
    TestCanvas iTestCanvas;
    double[] iLimits;
    double iYScale;
    int iYTranslate;
    private static final String[][] SUBLINEAGES = new String[][]{{"P1", "EMS", "MS", "E", "P2", "C", "P3", "D", "P4", "Z"}, {"P2", "C", "P3", "D", "P4", "Z"}, {"P3", "D", "P4", "Z"}, {"P4", "Z"}, {"EMS", "MS", "E"}};
    private static final String[] PSHEADER = new String[]{"%!", "/n {newpath} bind def", "/m {moveto} bind def", "/l {lineto} bind def", "/r {rlineto} bind def", "/c {setrgbcolor} bind def", "/cp {closepath} bind def", "/s {stroke} bind def", "/x {moveto setrgbcolor lineto closepath stroke} bind def", "/sg {setgray} bind def", "/Courier findfont "};
    private static final String MOVETO = " m";
    private static final String LINETO = " l";
    private static final String RLINETO = " r";
    private static final String NEWPATH = "n";
    private static final String COLOR = " c";
    private static final String CLOSEPATH = "cp";
    private static final String X = "x";
    private static final String FILL = "fill";
    private static final String STROKE = "s";
    private static final String SHOW = " show";
    private static final String COMMENT = " %";
    private static final String SP = " ";
    private static final String LEFT = "(";
    private static final String RITE = ")";
    public static final int ROOTNAME = 0;
    public static final int ENDTIME = 1;
    public static final int MINRED = 2;
    public static final int MAXRED = 3;
    public static final int YINCLOC = 4;
    public static final int LINEWIDTH = 5;
    public static final int HUELOC = 6;
    private static final int TOP = 8000;
    private static final int OFFSET = 100;
    private static final int DELTAY = 5;
    private static final int DELTAT = 1;
    private static final int YINC = 20;
    private static final int YOFFSET = 500;
    private static final int MINFONTSIZE = 10;
    private static final String CS = ", ";

    public VTreeImpl() {
        this.initialize();
        this.iKincInit = 20;
        this.iFontSize = 10;
    }

    public void initialize() {
        this.iAceTree = AceTree.getAceTree(null);
        this.iNucleiMgr = this.iAceTree.getNucleiMgr();
        this.nuclei_record = this.iNucleiMgr.getNucleiRecord();
        this.iAncesTree = this.iNucleiMgr.getAncesTree();
        this.iCellsByName = this.iAncesTree.getCellsByName();
        this.iRoot = this.iAncesTree.getRoot();
        this.iRootName = true;
        this.iLeafNames = true;
        this.iEndTime = 200;
    }

    private String setParams(JTextField[] params) {
        String rootName = params[0].getText();
        String endTime = params[1].getText();
        String minRed = params[2].getText();
        String maxRed = params[3].getText();
        String yInc = params[4].getText();
        String sHue = params[6].getText();
        Cell.setMinRed(Integer.parseInt(minRed));
        Cell.setMaxRed(Integer.parseInt(maxRed));
        this.iEndTime = Integer.parseInt(endTime);
        this.iKincInit = Integer.parseInt(yInc);
        this.iLineWidth = Integer.parseInt(params[5].getText());
        this.iLineInc = Integer.parseInt(yInc);
        this.iHue = Float.parseFloat(sHue);
        return rootName;
    }

    private void prepareIt(String rootName) {
        this.iCellLines = new Vector();
        this.iLines = new Vector();
        this.iNames = new Vector();
        this.prepare(rootName);
    }

    public void showTree(String rootName, int endTime, int minRed, int maxRed) {
        this.iRootCell = rootName;
        this.iRootName = true;
        this.iLeafNames = true;
        Cell.setMinRed(minRed);
        Cell.setMaxRed(maxRed);
        this.iEndTime = endTime;
        this.iKincInit = 10;
        this.iLineWidth = 2;
        this.iLineInc = 5;
        this.iHue = 0.0f;
        this.prepareIt(rootName);
        if (this.iTestCanvas != null) {
            this.iTestCanvas.dispose();
            this.iTestCanvas = null;
        }
        TestCanvas tc = new TestCanvas(rootName);
        tc.showIt();
        this.iTestCanvas = tc;
    }

    public void showTree(JTextField[] params, boolean labelRoot, boolean labelLeaves) {
        String rootName;
        this.iRootCell = rootName = this.setParams(params);
        this.iRootName = labelRoot;
        this.iLeafNames = labelLeaves;
        this.prepareIt(rootName);
        if (this.iTestCanvas != null) {
            this.iTestCanvas.dispose();
            this.iTestCanvas = null;
        }
        TestCanvas tc = new TestCanvas(rootName);
        tc.showIt();
        this.iTestCanvas = tc;
    }

    public void printTree(JTextField[] params, boolean labelRoot, boolean labelLeaves, String fileName, String dir) {
        String rootName = this.setParams(params);
        this.iRootName = labelRoot;
        this.iLeafNames = labelLeaves;
        this.iPSFileName = dir + "/" + fileName;
        if (fileName.indexOf("png") >= 0) {
            this.iTestCanvas.captureImage(fileName, dir);
            return;
        }
        Vector vSep = this.getSeparators("NONE");
        this.prepareIt(rootName);
        Vector v = this.packageIt();
        v = this.segregate(v, vSep);
        this.printIt(v);
    }

    private Vector getSeparators(String ss) {
        Vector<String[]> v = new Vector<String[]>();
        String[] sa = null;
        String[] sb = null;
        sb = new String[]{""};
        v.add(sb);
        if (ss.indexOf("NONE") != 0) {
            sa = ss.split(",");
            for (int i = 0; i < sa.length; ++i) {
                if (sa[i].equals("P1")) {
                    v.add(0, SUBLINEAGES[0]);
                    continue;
                }
                if (sa[i].equals("P2")) {
                    v.add(0, SUBLINEAGES[1]);
                    continue;
                }
                if (sa[i].equals("P3")) {
                    v.add(0, SUBLINEAGES[2]);
                    continue;
                }
                if (sa[i].equals("P2")) {
                    v.add(0, SUBLINEAGES[3]);
                    continue;
                }
                if (sa[i].equals("EMS")) {
                    v.add(0, SUBLINEAGES[4]);
                    continue;
                }
                sb = new String[]{sa[i]};
                v.add(0, sb);
            }
        }
        return v;
    }

    private Vector segregate(Vector vIn, Vector vSep) {
        Vector va = new Vector();
        Vector<String> v = null;
        String pattern = null;
        Object patternVec = null;
        Vector<String> vKill = null;
        for (int j = 0; j < vSep.size(); ++j) {
            this.println("segregate j=" + j);
            String[] sa = (String[])vSep.get(j);
            this.println("segregate sa=" + sa);
            v = new Vector<String>();
            vKill = new Vector<String>();
            Enumeration e = vIn.elements();
            while (e.hasMoreElements()) {
                String s = (String)e.nextElement();
                this.println("segregate s=" + s);
                for (int i = 0; i < sa.length; ++i) {
                    pattern = sa[i];
                    if (s.indexOf(COMMENT + pattern) >= 0) {
                        v.add(s);
                        this.println("segregate: " + s);
                        vKill.add(s);
                        continue;
                    }
                    this.println("segregate not using: " + s);
                }
            }
            Enumeration ee = vKill.elements();
            while (ee.hasMoreElements()) {
                vIn.remove(ee.nextElement());
            }
            v.add("showpage");
            va.add(v);
        }
        this.println("segregate va.size: " + va.size());
        v = (Vector<String>)va.get(0);
        this.println("segregate v.size: " + v.size());
        return va;
    }

    public Vector packageIt() {
        this.iLimits = this.findYLimits();
        double scale = 700.0 / (this.iLimits[0] - this.iLimits[1]);
        this.iYScale = Math.ceil(scale * 100.0) / 100.0;
        this.iYScale = Math.min(this.iYScale, 1.0);
        this.iYTranslate = (int)this.iLimits[0] - 8000 + 100;
        Vector<String> v = new Vector<String>();
        int offset = 100;
        for (int i = 0; i < this.iCellLines.size(); ++i) {
            Object p;
            Object o = this.iCellLines.get(i);
            if (o instanceof CellLine) {
                int x1;
                p = (CellLine)o;
                int x2 = x1 = ((CellLine)p).c.getTime() + offset;
                if (((CellLine)p).y1 == ((CellLine)p).y2) {
                    x2 = ((CellLine)p).c.getEnd() + offset;
                }
                v.add(this.prepareLine(x1, ((CellLine)p).y1, x2, ((CellLine)p).y2, ((CellLine)p).c));
                continue;
            }
            p = (Name)o;
            v.add(this.prepareString(((Name)p).c, ((Name)p).name, ((Name)p).x, ((Name)p).y));
        }
        return v;
    }

    public double[] findYLimits() {
        int ymax = 0;
        int ymin = Integer.MAX_VALUE;
        int offset = 100;
        for (int i = 0; i < this.iCellLines.size(); ++i) {
            Object p;
            Object o = this.iCellLines.get(i);
            if (o instanceof CellLine) {
                p = (CellLine)o;
                int y = Math.max(((CellLine)p).y1, ((CellLine)p).y2);
                ymax = Math.max(ymax, y);
                y = Math.min(((CellLine)p).y1, ((CellLine)p).y2);
                ymin = Math.min(ymin, y);
                continue;
            }
            p = (Name)o;
            ymax = Math.max(ymax, ((Name)p).y);
            ymin = Math.min(ymin, ((Name)p).y);
        }
        double[] rtn = new double[]{ymax, ymin};
        System.out.println("findYLimits, " + rtn[0] + CS + rtn[1]);
        return rtn;
    }

    public void printIt(Vector vIn) {
        int i;
        PrintWriter pw = null;
        try {
            FileOutputStream fs = new FileOutputStream(this.iPSFileName);
            pw = new PrintWriter(fs);
        }
        catch (FileNotFoundException fnfe) {
            fnfe.printStackTrace();
            return;
        }
        Vector v = null;
        String s = null;
        for (i = 0; i < PSHEADER.length; ++i) {
            pw.println(PSHEADER[i]);
        }
        pw.println(this.iLineInc + " scalefont setfont");
        pw.println(this.iLineWidth + " setlinewidth");
        System.out.println("printIt, " + this.iYScale + CS + this.iYTranslate);
        pw.println("1 " + this.iYScale + " scale");
        pw.println("0 " + this.iYTranslate + " translate");
        for (i = 0; i < vIn.size(); ++i) {
            v = (Vector)vIn.get(i);
            for (int j = 0; j < v.size(); ++j) {
                s = (String)v.get(j);
                pw.println(s);
            }
        }
        pw.flush();
        pw.close();
    }

    private String prepareLine(int x1, int y1, int x2, int y2, Cell c) {
        Vector cellData = c.getCellData();
        DecimalFormat df = new DecimalFormat("#.##");
        int top = 8000;
        String s = "";
        StringBuffer sb = new StringBuffer();
        int y = top - y1;
        if (x1 == x2) {
            sb = new StringBuffer(NEWPATH);
            s = SP + x1 + SP + (top - y1) + MOVETO;
            sb.append(SP + s);
            Color cc = null;
            try {
                cc = this.getColor(cellData, 0);
            }
            catch (Exception e) {
                cc = Color.BLACK;
            }
            float[] cf = cc.getColorComponents(null);
            s = SP + df.format(cf[0]) + SP + df.format(cf[1]) + SP + df.format(cf[2]);
            s = s + COLOR;
            s = s + SP + 0 + SP + (y1 - y2) + RLINETO;
            sb.append(SP + s);
            sb.append(" cp s %" + c.getName());
            return sb.toString();
        }
        for (int x = x1; x <= x2; ++x) {
            Color cc = null;
            try {
                cc = this.getColor(cellData, x - x1);
            }
            catch (Exception e) {
                cc = Color.BLACK;
            }
            float[] cf = cc.getColorComponents(null);
            s = NEWPATH;
            s = s + SP + x + SP + y;
            s = s + SP + df.format(cf[0]) + SP + df.format(cf[1]) + SP + df.format(cf[2]);
            s = s + SP + (x + 1) + SP + y + SP + X;
            sb.append(SP + s);
        }
        sb.append(COMMENT + c.getName());
        return sb.toString();
    }

    private String prepareLineX(int x1, int y1, int x2, int y2, Cell c) {
        DecimalFormat df = new DecimalFormat("#.##");
        int top = 8000;
        String s = "";
        StringBuffer sb = new StringBuffer(NEWPATH);
        s = x1 + SP + (top - y1) + MOVETO;
        sb.append(SP + s);
        int y = y1 - y2;
        if (x1 == x2) {
            s = "0 " + y + RLINETO;
            sb.append(SP + s);
        } else {
            for (int x = 1; x <= x2 - x1; ++x) {
                Color cc = null;
                try {
                    cc = c.getColor(x - 1);
                }
                catch (Exception e) {
                    cc = Color.BLACK;
                }
                float[] cf = cc.getColorComponents(null);
                s = df.format(cf[0]) + SP + df.format(cf[1]) + SP + df.format(cf[2]) + COLOR;
                s = s + SP + 1 + SP + y + SP + RLINETO;
                sb.append(SP + s);
            }
        }
        sb.append(" cp s %" + c.getName());
        return sb.toString();
    }

    private String prepareString(Cell c, String n, int x, int y) {
        Vector cellData = c.getCellData();
        int top = 8000;
        DecimalFormat df = new DecimalFormat("#.##");
        String s = null;
        Color cc = this.getColor(cellData, cellData.size() - 1);
        float[] cf = cc.getColorComponents(null);
        s = df.format(cf[0]) + SP + df.format(cf[1]) + SP + df.format(cf[2]) + COLOR;
        s = s + SP + x + SP + (top - y) + MOVETO + SP + LEFT + n + RITE + SHOW + COMMENT + n;
        return s;
    }

    private Cell getNewTree() {
        AncesTree ances = new AncesTree(null, this.iNucleiMgr, this.iNucleiMgr.getStartingIndex(), this.iEndTime);
        this.iCellsByName = ances.getCellsByName();
        return ances.getRoot();
    }

    public void prepare(String rootName) {
        this.println("Analysis5.prepare: " + rootName);
        Hashtable<Cell, Cell> doneHash = new Hashtable<Cell, Cell>();
        this.iDaughters = new Hashtable();
        String s = "";
        int kStart = 50;
        this.iKlast = 0;
        int k = kStart;
        int kInc = this.iKincInit;
        int nameInterval = Math.max(this.iFontSize / kInc, 1);
        int xOffset = 100;
        this.getNewTree();
        Cell root = (Cell)this.iCellsByName.get(rootName);
        if (root == null) {
            System.out.println("rootName not found: " + rootName);
            return;
        }
        int rootLevel = root.getLevel();
        int rootDepth = root.getDepth();
        this.println("depthOf: " + rootName + CS + rootLevel + CS + rootDepth);
        Cell x = null;
        Object y = null;
        Cell parent = null;
        Vector v = this.getLeaves(rootName);
        boolean leafPass = true;
        Hashtable allCells = this.getAllCells(rootName);
        Vector<Cell> p = new Vector<Cell>();
        for (int i = 0; i <= root.getDepth(); ++i) {
            this.println("\nfor i: " + i);
            Vector<Cell> readds = new Vector<Cell>();
            if (i > 0) {
                v = (Vector)p.clone();
                p = new Vector();
                leafPass = false;
            }
            s = "v size: " + v.size();
            this.println(s);
            for (int j = 0; j < v.size(); ++j) {
                int xStart;
                block29: {
                    x = (Cell)v.get(j);
                    if (allCells.get(x) == null || x == this.iRoot) continue;
                    this.println("\nNOW CONSIDERING: " + x.getName());
                    parent = (Cell)x.getParent();
                    xStart = x.getTime() + xOffset;
                    if (parent == null) {
                        parent = x;
                    }
                    if (parent.getName() != "P") {
                        boolean itsInThere = false;
                        Cell sister = null;
                        int childCount = parent.getChildCount();
                        if (childCount == 1) {
                            System.out.println("prepare, debug cell=" + x.getName());
                            itsInThere = false;
                        } else {
                            sister = (Cell)parent.getChildAt(1);
                            if (x == sister) {
                                sister = (Cell)parent.getChildAt(0);
                            }
                            itsInThere = v.contains(sister);
                            this.println("sister: " + sister.getName() + CS + itsInThere + CS + (i > 0));
                        }
                        if (!itsInThere && i > 0) {
                            this.println("add parent: " + x.getName() + " because sister not present ");
                            p.add(x);
                        }
                        boolean soloLeaf = false;
                        if (i == 0 && itsInThere && x.getDepth() < sister.getDepth()) {
                            soloLeaf = true;
                        }
                        if (soloLeaf) {
                            this.println("add parent: " + parent + " because of soloLeaf " + x.getName());
                            p.add(parent);
                        }
                    }
                    Daughters myD = null;
                    Daughter da = null;
                    Daughter db = null;
                    if (i > 0) {
                        try {
                            myD = (Daughters)this.iDaughters.get(x);
                            da = myD.da[0];
                            db = myD.da[1];
                            this.println("available daughters: " + da + CS + db);
                            if (da != null && db != null) {
                                k = (da.y + db.y) / 2;
                                if (doneHash.get(x) == null) {
                                    doneHash.put(x, x);
                                    Cell o = (Cell)allCells.remove(x);
                                    if (o == null) {
                                        this.println("REMOVING NON EXISTANT CELL: " + o.getName());
                                    }
                                    this.println("606 drawing from " + x.getName() + CS + da + CS + db + CS + k + CS + this.iKlast);
                                    this.handleCellLine(x, k, k);
                                    if (x.getName().equals(root.getName())) {
                                        this.iRootK = k;
                                    }
                                    this.iKlast = Math.max(k, this.iKlast);
                                }
                            } else if (da == null || db == null) {
                                if (!readds.contains(x)) {
                                    readds.add(x);
                                    v.add(x);
                                    this.println("readded: " + x.getName());
                                    continue;
                                }
                                p.add(x);
                                this.println("add parent: " + x.getName() + " because I cannot process it this time");
                                continue;
                            }
                            break block29;
                        }
                        catch (NullPointerException npe) {
                            this.println("NULLPOINTER: " + x.getName() + CS + myD);
                            break block29;
                        }
                    }
                    if (doneHash.get(x) == null) {
                        this.println("drawing from " + x.getName() + CS + da + CS + db + CS + k);
                        this.handleCellLine(x, k, k);
                        this.iKlast = Math.max(k, this.iKlast);
                        doneHash.put(x, x);
                        Cell o = (Cell)allCells.remove(x);
                        if (o == null) {
                            this.println("REMOVING NON EXISTANT CELL: " + o.getName());
                        }
                    }
                }
                Daughter d1 = new Daughter(x, xStart, k);
                Daughters ds = (Daughters)this.iDaughters.get(parent);
                if (ds == null) {
                    ds = new Daughters(d1, null);
                    this.iDaughters.put(parent, ds);
                    p.add(parent);
                    this.println("add parent: " + parent.getName() + " create daughters with daughter " + d1.d.getName());
                } else {
                    ds.addSecond(d1);
                    this.println("adding to daughters of parent " + parent.getName() + " with daughter " + d1.d.getName());
                    Daughter d2 = ds.getFirst();
                    if (d2 != null) {
                        this.println("drawing connector between " + x.getName() + CS + d2.d.getName());
                        this.handleCellLine(x, k, d2.y);
                    }
                }
                if (i == 0 && j % nameInterval == 0 && this.iLeafNames) {
                    this.handleString(x, this.iEndTime + xOffset + 10, k + 3);
                }
                k += this.iKincInit * (parent.getLeafCount() - 1);
            }
            s = "parentSize: " + p.size();
            this.println(s);
        }
        if (this.iRootName) {
            String ss = root.getName();
            this.println("prepare, rootName, " + root.getTime() + CS + xOffset);
            this.handleString(root, xOffset + root.getTime() - ss.length() * 7, this.iRootK + 3);
        }
        this.println("check all cells: " + allCells.size());
        this.println("iKlast: " + this.iKlast);
    }

    private void println(String s) {
    }

    private void handleCellLine(Cell c, int y1, int y2) {
        this.println("handleCellLine, " + c.getName() + CS + y1 + CS + y2);
        CellLine cLine = new CellLine(c, y1, y2);
        this.iCellLines.add(cLine);
    }

    private void handleString(Cell c, int x, int y) {
        this.println("handleString, " + c.getName() + CS + x + CS + y);
        Name name = new Name(c, x, y);
        this.iCellLines.add(name);
    }

    private Hashtable getAllCells(String rootName) {
        Hashtable<Cell, Cell> h = new Hashtable<Cell, Cell>();
        Cell x = (Cell)this.iCellsByName.get(rootName);
        Enumeration<TreeNode> e = x.breadthFirstEnumeration();
        while (e.hasMoreElements()) {
            Cell cn = (Cell)e.nextElement();
            h.put(cn, cn);
        }
        return h;
    }

    private Vector getLeaves(String rootName) {
        Vector<Cell> v = new Vector<Cell>();
        Cell d = (Cell)this.iCellsByName.get(rootName);
        int last = d.getLeafCount();
        boolean k = false;
        Cell x = (Cell)d.getFirstLeaf();
        for (int i = 0; i < last; ++i) {
            int endTime = x.getEndTime();
            v.add(0, x);
            x = (Cell)x.getNextLeaf();
            if (x == null) break;
        }
        return v;
    }

    private Vector fakeLeaves(String rootName) {
        Vector<Cell> v = new Vector<Cell>();
        Cell c = null;
        c = (Cell)this.iCellsByName.get("Epr");
        v.add(0, c);
        c = (Cell)this.iCellsByName.get("Epl");
        v.add(0, c);
        c = (Cell)this.iCellsByName.get("Ear");
        v.add(0, c);
        c = (Cell)this.iCellsByName.get("Eal");
        v.add(0, c);
        return v;
    }

    private Color getColor(Vector cellData, int k) {
        if (k < 0 || k > cellData.size()) {
            return Color.black;
        }
        CellData cd = (CellData)cellData.elementAt(k);
        int red = cd.iNucleus.rweight;
        float frac = ((float)red - (float)Cell.cMin) / ((float)Cell.cMax - (float)Cell.cMin);
        frac = Math.min(frac, 1.0f);
        frac = Math.max(frac, 0.0f);
        float hue = this.iHue;
        float sat = 1.0f;
        int col = Color.HSBtoRGB(hue, sat, frac);
        return new Color(col);
    }

    private void plottest(Cell c) {
        Vector<Cell> path = new Vector<Cell>();
        path.add(0, c);
        Cell parent = c;
        while (!parent.getName().equals(this.iRootCell)) {
            parent = (Cell)parent.getParent();
            path.add(0, parent);
        }
        Vector<Double> yVec = new Vector<Double>();
        for (int j = 0; j < path.size(); ++j) {
            Cell cc = (Cell)path.get(j);
            Vector cellData = cc.getCellData();
            for (int n = 0; n < cellData.size(); ++n) {
                CellData cd = (CellData)cellData.get(n);
                yVec.add(new Double(cd.iNucleus.rweight));
            }
        }
        double[] xxdata = new double[yVec.size()];
        double[] yydata = new double[yVec.size()];
        for (int i = 0; i < yVec.size(); ++i) {
            xxdata[i] = i;
            yydata[i] = (Double)yVec.get(i);
        }
        PlotGraph pg = new PlotGraph(xxdata, yydata);
        pg.setCloseChoice(2);
        pg.rescaleY(0.5);
        pg.rescaleX(0.5);
        pg.setPoint(0);
        pg.setGraphTitle(c.getName() + CS + this.iShortName);
        pg.plot();
    }

    private class Daughters {
        Daughter[] da = new Daughter[2];

        private Daughters(Daughter d1, Daughter d2) {
            this.da[0] = d1;
            this.da[1] = d2;
        }

        private boolean addSecond(Daughter d2) {
            if (this.da[0].d.getName().equals(d2.d.getName())) {
                return false;
            }
            this.da[1] = d2;
            return true;
        }

        private Daughter getFirst() {
            return this.da[0];
        }
    }

    private class Daughter {
        Cell d;
        int x;
        int y;

        private Daughter(Cell c, int xx, int yy) {
            this.d = c;
            this.x = xx;
            this.y = yy;
        }

        public String toString() {
            String s = "";
            s = s + this.d.getName();
            s = s + VTreeImpl.CS + this.x + VTreeImpl.CS + this.y;
            return s;
        }
    }

    private class Name {
        Cell c;
        String name;
        int x;
        int y;

        private Name(Cell cc, int xx, int yy) {
            this.c = cc;
            this.name = this.c.getName();
            this.x = xx;
            this.y = yy;
        }
    }

    private class CellLine {
        Cell c;
        int y1;
        int y2;

        private CellLine(Cell cc, int yy1, int yy2) {
            this.c = cc;
            this.y1 = yy1;
            this.y2 = yy2;
        }
    }

    class TestCanvas
    extends Canvas {
        private JFrame iFrame;
        private boolean iWasDrawn;
        private String rootName;
        int height;
        int width;

        public TestCanvas(String rName) {
            this.rootName = rName;
            this.setBackground(Color.white);
            int height = VTreeImpl.this.iKlast + 100;
            this.width = 500;
            this.setSize(new Dimension(this.width, height));
            MouseHandler mh = new MouseHandler(this);
            this.addMouseMotionListener(mh);
            this.addMouseListener(mh);
        }

        public void dispose() {
            this.iFrame.dispose();
            this.iFrame = null;
        }

        private void println(String s) {
        }

        @Override
        public void paint(Graphics g) {
            g.setColor(Color.white);
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            int offset = 100;
            Graphics2D g2 = (Graphics2D)g;
            int width = 5;
            g2.setStroke(new BasicStroke(VTreeImpl.this.iLineWidth));
            for (int i = 0; i < VTreeImpl.this.iCellLines.size(); ++i) {
                Object p;
                Object o = VTreeImpl.this.iCellLines.get(i);
                if (o instanceof CellLine) {
                    int x1;
                    p = (CellLine)o;
                    int x2 = x1 = ((CellLine)p).c.getTime() + offset;
                    if (((CellLine)p).y1 == ((CellLine)p).y2) {
                        x2 = ((CellLine)p).c.getEnd() + offset;
                    }
                    this.drawLine(g2, x1, ((CellLine)p).y1, x2, ((CellLine)p).y2, ((CellLine)p).c);
                    continue;
                }
                p = (Name)o;
                this.drawString(g2, ((Name)p).x, ((Name)p).y, ((Name)p).c);
            }
        }

        public void captureImage(String fileName, String dir) {
            BufferedImage image = new BufferedImage(this.getWidth(), this.getHeight(), 1);
            Graphics g = image.getGraphics();
            this.paint(g);
            File f = new File(dir + "/" + fileName);
            try {
                ImageIO.write((RenderedImage)image, "png", f);
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
            this.makeWebPage(fileName, dir);
        }

        public void makeWebPage(String fileName, String dir) {
            String s = fileName.substring(0, fileName.length() - 4);
            FileOutputStream fos = null;
            try {
                fos = new FileOutputStream(dir + "/" + s + ".html", false);
            }
            catch (FileNotFoundException fnfe) {
                fnfe.printStackTrace();
                return;
            }
            PrintWriter pw = new PrintWriter(fos, true);
            pw.println("<html>");
            pw.println("<head><title>" + s + "</title></head>");
            pw.println("<body>");
            pw.println("<img src=\"" + s + ".png\">");
            pw.println("</body>");
            pw.println("</html>");
        }

        public void showIt() {
            JFrame jf = this.iFrame = new JFrame();
            JFrame.setDefaultLookAndFeelDecorated(false);
            String s = VTreeImpl.this.iNucleiMgr.getConfig().iConfigFileName;
            File cf = new File(s);
            VTreeImpl.this.iShortName = s = cf.getName();
            jf.setTitle(s);
            ScrollPane sp = new ScrollPane(1);
            sp.add(this);
            jf.getContentPane().add((Component)sp, "Center");
            jf.setSize(new Dimension(600, 500));
            jf.setVisible(true);
        }

        private Cell findIt(int xx, int yy) {
            CellLine cL = null;
            Cell c = null;
            int t = xx - 100;
            for (int i = 0; i < VTreeImpl.this.iCellLines.size(); ++i) {
                Object o = VTreeImpl.this.iCellLines.get(i);
                if (!(o instanceof CellLine)) continue;
                cL = (CellLine)o;
                if (yy >= cL.y1 - 5 && yy <= cL.y2 + 5 && t >= (c = cL.c).getTime() - 1 && t <= c.getEnd() + 1) break;
            }
            return c;
        }

        private void drawLine(Graphics g, int x1, int y1, int x2, int y2, Cell c) {
            Vector cellData = c.getCellData();
            if (x1 == x2) {
                try {
                    Color cc = VTreeImpl.this.getColor(cellData, 0);
                    g.setColor(cc);
                }
                catch (Exception e) {
                    g.setColor(Color.BLACK);
                }
                g.drawLine(x1, y1, x2, y2);
            } else {
                int k = 0;
                for (int x = x1; x < x2; ++x) {
                    try {
                        Color cc = VTreeImpl.this.getColor(cellData, k++);
                        g.setColor(cc);
                    }
                    catch (Exception e) {
                        g.setColor(Color.BLACK);
                    }
                    g.drawLine(x, y1, x + 1, y2);
                }
            }
        }

        private void drawLine(Graphics g, int x1, int y1, int x2, int y2, Cell c, boolean bogus) {
            if (x1 == x2) {
                try {
                    Color cc = c.getColor(0);
                    g.setColor(cc);
                }
                catch (Exception e) {
                    g.setColor(Color.BLACK);
                }
                g.drawLine(x1, y1, x2, y2);
            } else {
                int k = 0;
                for (int x = x1; x < x2; ++x) {
                    try {
                        Color cc = c.getColor(k++);
                        g.setColor(cc);
                    }
                    catch (Exception e) {
                        g.setColor(Color.BLACK);
                    }
                    g.drawLine(x, y1, x + 1, y2);
                }
            }
        }

        private void drawString(Graphics g, int x, int y, Cell c) {
            Vector cellData = c.getCellData();
            Color cc = VTreeImpl.this.getColor(cellData, cellData.size() - 1);
            g.setColor(cc);
            Font f = new Font("Courier", 0, 10);
            g.setFont(f);
            g.drawString(c.getName(), x, y);
        }

        private void drawString(Graphics g, int x, int y, Cell c, boolean bogus) {
            Color cc = c.getLastColor();
            g.setColor(cc);
            Font f = new Font("Courier", 0, 10);
            g.setFont(f);
            g.drawString(c.getName(), x, y);
        }

        class MouseHandler
        extends MouseInputAdapter {
            public MouseHandler(Object o) {
            }

            @Override
            public void mouseMoved(MouseEvent e) {
            }

            public void notifyAceTree(Cell c, int time) {
                Vector<String> v = new Vector<String>();
                v.add("InputCtrl1");
                v.add(String.valueOf(time));
                v.add(c.getName());
                VTreeImpl.this.iAceTree.controlCallback(v);
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                Cell cs = TestCanvas.this.findIt(e.getX(), e.getY());
                if (cs != null) {
                    int intTime = e.getX() - 100;
                    int button = e.getButton();
                    if (button == 1) {
                        VTreeImpl.this.iAceTree.restoreTree(VTreeImpl.this.iShortName);
                        this.notifyAceTree(cs, intTime);
                    } else if (button == 3) {
                        VTreeImpl.this.iAceTree.restoreTree(VTreeImpl.this.iShortName);
                        this.notifyAceTree(cs, cs.getEndTime());
                    } else if (button == 2) {
                        VTreeImpl.this.iAceTree.restoreTree(VTreeImpl.this.iShortName);
                        this.notifyAceTree(cs, cs.getEndTime());
                        VTreeImpl.this.plottest(cs);
                    }
                }
            }
        }
    }
}

