/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.utils;

import java.awt.Polygon;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.nio.channels.FileChannel;
import java.text.ParseException;
import java.util.GregorianCalendar;
import javax.swing.text.MaskFormatter;

public class EUtils {
    public static String makeVersion() {
        GregorianCalendar c = new GregorianCalendar();
        int year = c.get(1);
        int month = c.get(2) + 1;
        int day = c.get(5);
        int hr = c.get(11);
        int min = c.get(12);
        String version = String.valueOf(year) + EUtils.padInt(month) + EUtils.padInt(day) + EUtils.padInt(hr) + EUtils.padInt(min);
        return version;
    }

    public static String padInt(int k) {
        String s = "00" + k;
        return s.substring(s.length() - 2);
    }

    public static String makePaddedInt(int k) {
        int width = 3;
        int fullwidth = String.valueOf(k).length();
        width = Math.max(width, fullwidth);
        String s = "000" + String.valueOf(k);
        int j = s.length();
        s = s.substring(j - width, j);
        return s;
    }

    public static String makePaddedInt(int k, int width) {
        int fullwidth = String.valueOf(k).length();
        width = Math.max(width, fullwidth);
        String s = "0000" + String.valueOf(k);
        int j = s.length();
        s = s.substring(j - width, j);
        return s;
    }

    public static String stringArrayToString(String[] sa) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < sa.length; ++i) {
            sb.append(sa[i]);
            sb.append(", ");
        }
        return sb.toString();
    }

    public static void printMs() {
        System.out.println(System.currentTimeMillis());
    }

    public static void copyFile(String inName, String otName) throws Exception {
        File inFile = null;
        File otFile = null;
        try {
            inFile = new File(inName);
            otFile = new File(otName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (inFile == null || otFile == null) {
            return;
        }
        FileChannel sourceChannel = new FileInputStream(inFile).getChannel();
        FileChannel destinationChannel = new FileOutputStream(otFile).getChannel();
        sourceChannel.transferTo(0L, sourceChannel.size(), destinationChannel);
        sourceChannel.close();
        destinationChannel.close();
    }

    public static Polygon pCircle(int x, int y, int r) {
        int n;
        int m;
        int k;
        Polygon p = new Polygon();
        for (k = -r; k < r; ++k) {
            m = x + k;
            n = (int)Math.sqrt(r * r - k * k);
            p.addPoint(m, y + n);
        }
        for (k = r; k > -r; --k) {
            m = x + k;
            n = (int)Math.sqrt(r * r - k * k);
            p.addPoint(m, y - n);
        }
        return p;
    }

    public static Polygon pPoly(int x, int y, int r) {
        int b;
        int a;
        double u;
        double v;
        double m;
        Polygon p = new Polygon();
        double M = 4.0;
        double R = r;
        for (m = 0.0; m < M; m += 1.0) {
            v = R * Math.sqrt(4.0 * m / M - 4.0 * m * m / M / M);
            u = R * (2.0 * m / M - 1.0);
            a = x + (int)Math.round(u);
            b = y + (int)Math.round(v);
            p.addPoint(a, b);
        }
        for (m = M; m > 0.0; m -= 1.0) {
            v = R * Math.sqrt(4.0 * m / M - 4.0 * m * m / M / M);
            u = R * (2.0 * m / M - 1.0);
            a = x + (int)Math.round(u);
            b = y - (int)Math.round(v);
            p.addPoint(a, b);
        }
        return p;
    }

    public static MaskFormatter createFormatter(String s) {
        MaskFormatter formatter = null;
        try {
            formatter = new MaskFormatter(s);
        }
        catch (ParseException exc) {
            System.err.println("formatter is bad: " + exc.getMessage());
            System.exit(-1);
        }
        return formatter;
    }

    public static void main(String[] args) throws Exception {
        String inPath = "/home/biowolp/wolp/stuff/gamma2/test/4to100cells-1min/tiffs/centroids/";
        String name1 = "4to100cells-";
        String name2 = "t071-p15.tif";
        String otPath = "/home/biowolp/work/temp/4to100cells-1min/centroids/";
        String src = inPath + name1 + name2;
        String dst = otPath + name2;
        System.out.println("src: " + src);
        System.out.println("dst: " + dst);
        EUtils.printMs();
        EUtils.copyFile(src, dst);
        EUtils.printMs();
    }
}

