/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.utils;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.ScrollPane;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.Border;
import org.rhwlab.utils.HeatMap;
import org.rhwlab.utils.HeatMapPanel;

public class HeatMapFrame
extends JFrame {
    HeatMap iHeatMap;
    int iWidth;
    int iHeight;
    JTabbedPane iTabbedPane;
    JPanel iControlPanel;

    public HeatMapFrame(String title, HeatMap heatMap, int width, int height, int numFrames) {
        super(title);
        this.iHeatMap = heatMap;
        this.iWidth = width;
        this.iHeight = height;
        this.iTabbedPane = new JTabbedPane();
        this.iTabbedPane.addTab("Image", null, new HeatMapPanel(this.iHeatMap, this.iWidth, this.iHeight), "View 3D image");
        PropertiesTab pt = new PropertiesTab();
        this.iControlPanel = pt.getPanel();
        this.iTabbedPane.addTab("Properties", null, this.iControlPanel, "Set color scheme");
        this.getContentPane().setLayout(new GridLayout(numFrames, 1));
        this.getContentPane().add(this.iTabbedPane);
        this.pack();
        this.show();
    }

    public void addHeatMap(ScrollPane heatMapPane) {
        this.getContentPane().add(heatMapPane);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.iWidth, this.iHeight);
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public static int[][] getDataVector() {
        int iNumCells = 50;
        int iNumTimes = 100;
        int[][] r = new int[iNumCells][iNumTimes];
        for (int i = 0; i < iNumCells; ++i) {
            for (int j = 0; j < iNumTimes; ++j) {
                r[i][j] = 25000 + (int)(25000.0 * Math.random());
            }
        }
        return r;
    }

    public static void main(String[] args) {
        int[][] test = HeatMapFrame.getDataVector();
        String[] labels = new String[50];
        for (int i = 0; i < labels.length; ++i) {
            labels[i] = Integer.toString(i);
        }
        HeatMap heatMap = new HeatMap(test, labels, 25000, 50000);
        HeatMapPanel heatMapPanel = new HeatMapPanel(heatMap, 300, 100);
        HeatMapFrame hmf = new HeatMapFrame("HeatMap Frame", heatMap, 400, 200, 1);
        int[][] test2 = HeatMapFrame.getDataVector();
        System.out.println(test.length);
        int[] one = test[0];
        System.out.println(one.length);
    }

    public class PropertiesTab
    implements ActionListener {
        JPanel iPanel;
        JTextField iMin;
        JTextField iMax;
        JButton iSetMinMax;
        JTextField iXinc;
        JTextField iYinc;
        JButton iSetSpotSize;

        public PropertiesTab() {
            Border blackline = BorderFactory.createLineBorder(Color.black);
            Border grayline = BorderFactory.createLineBorder(Color.darkGray);
            this.iPanel = new JPanel();
            this.iPanel.setLayout(new GridLayout(2, 1));
            this.iPanel.setBorder(blackline);
            JPanel jp = new JPanel();
            jp.setBorder(blackline);
            jp.setPreferredSize(new Dimension(100, 100));
            jp.setLayout(new GridLayout(3, 2));
            this.iPanel.add(jp);
            JLabel jl = new JLabel("Min");
            jl.setBorder(grayline);
            jp.add(jl);
            this.iMin = new JTextField(10);
            this.iMin.setBorder(blackline);
            jp.add(this.iMin);
            jl = new JLabel("Max");
            jl.setBorder(grayline);
            jp.add(jl);
            this.iMax = new JTextField(10);
            this.iMax.setBorder(blackline);
            jp.add(this.iMax);
            this.iSetMinMax = new JButton("Set");
            jp.add(this.iSetMinMax);
            jp = new JPanel();
            jp.setPreferredSize(new Dimension(100, 100));
            jp.setBorder(blackline);
            jp.setLayout(new GridLayout(3, 2));
            this.iPanel.add(jp);
            jl = new JLabel("xinc");
            jl.setBorder(grayline);
            jp.add(jl);
            this.iXinc = new JTextField(10);
            this.iXinc.setBorder(blackline);
            jp.add(this.iXinc);
            jl = new JLabel("yinc");
            jl.setBorder(grayline);
            jp.add(jl);
            this.iYinc = new JTextField(10);
            this.iYinc.setBorder(blackline);
            jp.add(this.iYinc);
            this.iSetSpotSize = new JButton("Set");
            jp.add(this.iSetSpotSize);
            this.iSetMinMax.addActionListener(this);
            this.iSetSpotSize.addActionListener(this);
            this.iMin.setText(Integer.toString(HeatMapFrame.this.iHeatMap.getMin()));
            this.iMax.setText(Integer.toString(HeatMapFrame.this.iHeatMap.getMax()));
            this.iXinc.setText(Integer.toString(HeatMapFrame.this.iHeatMap.getXinc()));
            this.iYinc.setText(Integer.toString(HeatMapFrame.this.iHeatMap.getYinc()));
        }

        public JPanel getPanel() {
            return this.iPanel;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object o = e.getSource();
            String command = e.getActionCommand();
            if (o == this.iSetMinMax) {
                int min = Integer.parseInt(this.iMin.getText());
                int max = Integer.parseInt(this.iMax.getText());
                HeatMapFrame.this.iHeatMap.setMinMax(min, max);
            } else if (o == this.iSetSpotSize) {
                int xinc = Integer.parseInt(this.iXinc.getText());
                int yinc = Integer.parseInt(this.iYinc.getText());
                HeatMapFrame.this.iHeatMap.setSpotSize(xinc, yinc);
            }
        }
    }
}

