/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.volumeview;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.gui.Roi;
import ij.measure.Calibration;
import ij.process.ImageProcessor;
import java.awt.Color;
import org.rhwlab.volumeview.AceUniverse;

public class AceCropExecuter {
    private AceUniverse univ;
    private ImagePlus currentImage;

    public AceCropExecuter(AceUniverse univ) {
        this.univ = univ;
    }

    public void newCrop() {
        try {
            this.currentImage = null;
            this.currentImage = IJ.openImage(this.univ.getPath());
            this.transformImg(this.currentImage);
            this.currentImage.show();
            this.setRectangleTool();
        }
        catch (NullPointerException exception) {
            System.out.println("The image path you are trying to open is not available.");
        }
    }

    public void setWindowLevel() {
        try {
            double min = IJ.getImage().getDisplayRangeMin();
            double max = IJ.getImage().getDisplayRangeMax();
            Double minimum = new Double(min);
            Double maximum = new Double(max);
            AceUniverse.getSettings().put("RangeMin", minimum);
            AceUniverse.getSettings().put("RangeMax", maximum);
        }
        catch (RuntimeException f) {
            System.out.println("No image is open");
        }
    }

    public void setCrop() {
        try {
            this.univ.updateContent();
            this.univ.removeAllContents();
            this.univ.addContent();
        }
        catch (RuntimeException f) {
            System.out.println("No image is open");
        }
    }

    public void reverseStack(ImagePlus imp) {
        ImageStack stack = imp.getStack();
        for (int i = 1; i <= stack.getSize(); ++i) {
            ImageProcessor ip = stack.getProcessor(i);
            ip.flipHorizontal();
            stack.setProcessor(ip, i);
        }
    }

    public void transformImg(ImagePlus img) {
        Calibration cal = img.getCalibration();
        cal.pixelDepth = 4.0;
        img.setCalibration(cal);
        this.reverseStack(img);
    }

    public void reloadCrop() {
        AceUniverse.getSettings().remove("ROI");
        AceUniverse.getSettings().remove("RangeMin");
        AceUniverse.getSettings().remove("RangeMax");
        AceUniverse.getSettings().remove("TransformMatrix");
        AceUniverse.getSettings().remove("Zoom");
        this.reloadCropZ();
        this.setCrop();
        this.setHandTool();
    }

    public void saveROI() {
        if (WindowManager.getCurrentWindow() != null) {
            ImagePlus imp = IJ.getImage();
            Roi roi = imp.getRoi();
            if (roi == null) {
                System.out.println("There is no highlighted region of interest.");
                return;
            }
            AceUniverse.getSettings().put("ROI", roi);
            System.out.println("Crop Roi and Contrast saved");
            this.setWindowLevel();
            this.setCrop();
            this.setHandTool();
        } else {
            System.out.println("No window is open.");
        }
    }

    public void cropZ() {
        if (WindowManager.getCurrentWindow() != null) {
            try {
                String userInput = this.showDialog();
                userInput = userInput.replaceAll("\\s", "");
                String[] range = userInput.split("-");
                int first = Integer.parseInt(range[0]);
                int last = Integer.parseInt(range[1]);
                int maxStackHeight = IJ.openImage(this.univ.getPath()).getStack().getSize();
                if (first >= last || first < 1 || first > maxStackHeight || last < 1 || last > maxStackHeight) {
                    throw new Exception();
                }
                AceUniverse.getSettings().put("stackFirst", new Integer(first));
                AceUniverse.getSettings().put("stackLast", new Integer(last));
                System.out.println("cropped Z, " + userInput);
                this.setCrop();
                this.setHandTool();
            }
            catch (Exception e) {
                System.out.println("Your input is invalid.");
            }
        } else {
            System.out.println("no ImageJ image is open");
        }
    }

    String showDialog() {
        GenericDialog gd = new GenericDialog("Substack Maker");
        gd.setInsets(10, 45, 0);
        gd.addMessage("Enter a range (e.g. 2-14).\nThe range spans the original stack, only.", null, Color.darkGray);
        gd.addStringField("Slices:", "", 40);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return null;
        }
        return gd.getNextString();
    }

    public void reloadCropZ() {
        AceUniverse.getSettings().put("stackFirst", new Integer(1));
        AceUniverse.getSettings().put("stackLast", new Integer(IJ.openImage(this.univ.getPath()).getStack().getSize()));
        System.out.println("restoring image stack height");
    }

    public void setHandTool() {
        this.univ.ui.setHandTool();
    }

    public void setRectangleTool() {
        this.univ.ui.setTool(0);
    }

    public void contrastAdjuster() {
        try {
            IJ.runPlugIn(IJ.getImage(), "ij.plugin.frame.ContrastAdjuster", "wl");
        }
        catch (RuntimeException e) {
            IJ.getInstance().setVisible(true);
            IJ.getInstance().setVisible(false);
            System.out.println("no ImageJ image is open");
        }
    }
}

