/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.volumeview;

import ij.IJ;
import ij.ImagePlus;
import ij3d.Content;
import ij3d.Image3DUniverse;
import java.awt.Toolkit;
import java.awt.event.WindowEvent;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.media.j3d.Transform3D;
import javax.swing.ImageIcon;
import javax.swing.JMenuBar;
import org.rhwlab.acetree.AceTree;
import org.rhwlab.volumeview.Ace3DCropMenu;
import org.rhwlab.volumeview.AceExecuter;

public class AceUniverse
extends Image3DUniverse {
    private Ace3DCropMenu cropMenu = null;
    private AceExecuter executer = new AceExecuter(this);
    private JMenuBar menuBar;
    private Content content;
    private String path3D = "empty";
    private String basedir = "empty";
    private String title = "empty";
    private ImagePlus imp3D;
    private static Map globalSettings = new HashMap();

    @Override
    public AceExecuter getExecuter() {
        if (this.executer == null) {
            this.executer = new AceExecuter(this);
        }
        return this.executer;
    }

    public void setPath(String title) {
        this.title = title;
        this.path3D = this.basedir + title;
    }

    public String getPath() {
        return this.path3D;
    }

    public void setBaseDir(String basedir) {
        this.basedir = basedir;
    }

    public void setImage(ImagePlus imp3D) {
        this.imp3D = imp3D;
    }

    public ImagePlus getImage() {
        return this.imp3D;
    }

    public Content getContent() {
        return this.content;
    }

    public static Map getSettings() {
        return globalSettings;
    }

    public void updateContent() {
        this.imp3D = IJ.openImage(this.path3D);
        if (this.imp3D == null) {
            this.setPath(this.getAlternativeTitle(this.title));
            this.imp3D = IJ.openImage(this.path3D);
        }
        this.executer.setCalibration(4);
        this.executer.updateWindowLevel();
        if (this.shouldFlip()) {
            this.executer.reverseStack();
        }
        this.executer.setROI();
        this.executer.updateCropZ();
        this.executer.convertToGray8();
        System.out.println(this.path3D);
    }

    private String getAlternativeTitle(String title) {
        if (title.matches("\\w*_[tT]\\d*\\.\\w*")) {
            return title.replaceFirst("_[tT]", "_");
        }
        return title.replaceFirst("_", "_t");
    }

    private boolean shouldFlip() {
        return this.title.matches("\\w*_[tT]\\d*\\.\\w*");
    }

    @Override
    public void show() {
        super.show();
        this.menuBar = this.getMenuBar();
        this.menuBar.remove(0);
        this.menuBar.remove(3);
        this.menuBar.remove(3);
        this.cropMenu = new Ace3DCropMenu(this.menuBar, this);
        this.menuBar.add(this.cropMenu);
        this.win.setTitle("AceTree 3D Viewer");
        URL imageURL = AceUniverse.class.getResource("/images/icon2.gif");
        ImageIcon test = new ImageIcon(imageURL, "x");
        this.win.setIconImage(test.getImage());
    }

    public void addContent() {
        this.content = this.addVoltex(this.imp3D, 1);
        this.updateSettings();
        this.content.applyTranslation(0.01f, 0.01f, 0.01f);
    }

    public void closeWindow() {
        WindowEvent closingEvent = new WindowEvent(this.win, 201);
        Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(closingEvent);
    }

    public void updateSettings() {
        this.executer.updateDisplayAs();
        this.executer.updateZoom();
        this.executer.updateTransform();
        this.executer.updateTransferFunction();
        this.executer.updateTransparency();
        this.executer.updateThreshold();
    }

    public void setTransform() {
        Transform3D t3d = new Transform3D();
        this.getZoomTG().getTransform(t3d);
        AceUniverse.getSettings().put("Zoom", AceUniverse.toString(t3d).trim());
        Content c = this.getContent();
        Transform3D t1 = new Transform3D();
        c.getLocalTranslate().getTransform(t1);
        Transform3D t2 = new Transform3D();
        c.getLocalRotate().getTransform(t2);
        t1.mul(t2);
        float[] matrix = new float[16];
        t1.get(matrix);
        AceUniverse.getSettings().put("TransformMatrix", matrix);
    }

    private static final String toString(Transform3D t3d) {
        float[] xf = new float[16];
        t3d.get(xf);
        String ret = "";
        for (int i = 0; i < 16; ++i) {
            ret = ret + " " + xf[i];
        }
        return ret;
    }

    @Override
    public void cleanup() {
        if (AceTree.getWasClosed() != 0) {
            this.setTransform();
        }
        super.cleanup();
        System.out.println("closing AceUniverse");
    }
}

