/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.volumeview;

import ij.IJ;
import ij.ImageJ;
import ij.gui.GUI;
import java.awt.Frame;
import org.rhwlab.acetree.AceTree;
import org.rhwlab.volumeview.AceUniverse;

public class Display3D {
    private AceUniverse universe3D = new AceUniverse();
    private Thread thread;
    private Frame mainControl;

    public void setBaseDir(String path) {
        this.universe3D.setBaseDir(path);
    }

    public void updateUniverse(String title) {
        this.universe3D.setPath(title);
        this.universe3D.updateContent();
    }

    public void addNext() {
        this.universe3D.setTransform();
        this.universe3D.removeAllContents();
        this.universe3D.addContent();
    }

    public void showContent() {
        this.universe3D.show();
        GUI.center(this.universe3D.getWindow());
        this.universe3D.addContent();
        System.out.println("content added");
    }

    public void runThread(String isClose) {
        if (IJ.getInstance() == null) {
            this.mainControl = new ImageJ();
            IJ.getInstance().setLocation(5000, 5000);
            IJ.getInstance().setVisible(false);
        }
        this.thread = isClose == "close" ? new Thread(new thread3DClose()) : new Thread(new thread3D());
        this.thread.start();
    }

    public AceUniverse getUniverse() {
        return this.universe3D;
    }

    public class thread3DClose
    implements Runnable {
        @Override
        public void run() {
            try {
                Display3D.this.universe3D.show();
                Display3D.this.universe3D.closeWindow();
                return;
            }
            catch (Exception e) {
                return;
            }
        }
    }

    public class thread3D
    implements Runnable {
        @Override
        public void run() {
            try {
                Display3D.this.showContent();
                AceTree.setWasClosed(1);
            }
            catch (Exception e) {
                return;
            }
        }
    }
}

