/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.acetree;

import ij.IJ;
import ij.ImageJ;
import ij.ImagePlus;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Vector;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import org.rhwlab.acetree.AceTree;
import org.rhwlab.acetree.EllipseViewer;
import org.rhwlab.acetree.ExampleFileFilter;
import org.rhwlab.acetree.OpenFromDB;
import org.rhwlab.acetree.Options;
import org.rhwlab.analyze.Analysis;
import org.rhwlab.analyze.Analysis11;
import org.rhwlab.analyze.Analysis2;
import org.rhwlab.analyze.Analysis3;
import org.rhwlab.analyze.Analysis4;
import org.rhwlab.analyze.Analysis5;
import org.rhwlab.analyze.Analysis6;
import org.rhwlab.analyze.Analysis8;
import org.rhwlab.analyze.Analysis9;
import org.rhwlab.analyze.DeathAndDivisionLog;
import org.rhwlab.analyze.ExtractRed;
import org.rhwlab.analyze.RedBkgComp;
import org.rhwlab.analyze.RedCompSeries;
import org.rhwlab.analyze.RedCorrector2;
import org.rhwlab.analyze.UsePlugin;
import org.rhwlab.help.AceTreeHelp;
import org.rhwlab.image.DepthViews;
import org.rhwlab.nucedit.Overlaps;
import org.rhwlab.nucedit.SkipFalseNegatives;
import org.rhwlab.snight.Config;
import org.rhwlab.snight.WormGUIDESWindow;
import org.rhwlab.tree.SubTrees;
import org.rhwlab.utils.Log;

public class AceMenuBar
extends JMenuBar
implements ActionListener,
ItemListener {
    AceTree iAceTree;
    JMenuItem iQuickOpen;
    JMenuItem iOpenFromDB;
    JMenuItem iOpen;
    JMenuItem iOpenSeries;
    JMenuItem iOptions;
    JMenuItem iSave;
    JMenuItem iSaveConfig;
    JMenuItem iJLaunch;
    JMenuItem iExit;
    JMenuItem iBuildTree;
    JMenuItem iReBuildTree;
    JMenuItem iClearTree;
    JMenuItem iExpandTree;
    JMenuItem iExport;
    JMenuItem iNuclei;
    JMenuItem iShowLog;
    JMenuItem iDDLog;
    JMenuItem iAnalyze;
    JMenuItem iAnalyze2;
    JMenuItem iAnalyze3;
    JMenuItem iAnalyze4;
    JMenuItem iAnalyze5;
    JMenuItem iAnalyze6;
    JMenuItem iExtractRed;
    JMenuItem iFixCrosstalk;
    JMenuItem iRedBkgComp;
    JMenuItem iRedCompSeries;
    JMenuItem iAnalyze8;
    JMenuItem iAnalyze9;
    JMenuItem iAnalyze10;
    JMenuItem iEditTraverse;
    JMenuItem iAdjacencies;
    JMenuItem iLazarus;
    JMenuItem iSiamese;
    JMenuItem iJuvenesence;
    JMenuItem iZafer1;
    JMenuItem iOrientation;
    JMenuItem iOverlaps;
    JMenuItem iUsePlugin;
    JMenuItem iEdit;
    JMenuItem iEdit2;
    JMenuItem iViewNuclei;
    JMenuItem iRelink;
    JMenuItem iSkipFalseNegatives;
    JMenuItem iKillCells;
    JMenuItem iSetEndTime;
    JMenuItem iIncrementEndTime;
    JMenuItem iUndo;
    JMenuItem iATVTree;
    JMenuItem iAncestralTree;
    JMenuItem iSulstonTree;
    JMenuItem iVTree;
    JMenuItem iSubTrees;
    JMenuItem iTest;
    JMenuItem iNew;
    JMenuItem iTestWindow;
    JMenuItem i3D;
    JMenuItem i3D2;
    JMenuItem i3D3;
    JMenuItem i3D2Z;
    JMenuItem i3DViewer;
    JMenuItem iZoomView;
    JMenuItem iAnnotationProperties;
    JCheckBoxMenuItem i3Dsave;
    JCheckBoxMenuItem i3D2save;
    JCheckBoxMenuItem i3D2Zsave;
    JCheckBoxMenuItem i2Dsave;
    JMenuItem iViewEllipse;
    JMenuItem iDepthViews;
    JMenuItem iAllCentroids;
    JMenuItem iCellMovementImage;
    JMenuItem iDebugLog;
    int i3DsaveState;
    int i3D2saveState;
    int i3D2ZsaveState;
    JMenu iHelp;
    JMenuItem iAbout;
    JFileChooser iFileChooser;
    Log iDLog;
    JMenu iRecent;
    JMenu iRemoveRecent;
    JMenuItem iClearAll;
    JMenuItem iBookmark;
    JMenuItem iViewImgWin;
    Vector iConfigsVector;
    private static final String FILE = "File";
    private static final String QUICKOPEN = "Quick open (no config file needed)";
    private static final String OPEN = "Open config file";
    private static final String OPENSERIES = "Open series";
    private static final String CLEARALL = "Clear all";
    private static final String OPTIONS = "Options";
    private static final String SAVE = "Save nuclei as zip";
    private static final String SAVECONFIG = "Save config file";
    private static final String IJ = "Launch ImageJ";
    private static final String EXIT = "Exit";
    private static final String EXPORT = "Export newick lineage";
    private static final String ACTION = "Action";
    private static final String BUILDTREE = "Build Tree";
    private static final String REBUILDTREE = "Rebuild Tree";
    private static final String CLEAR = "Clear tree";
    private static final String EXPAND = "Expand tree";
    private static final String TEST = "Test";
    private static final String TEST1 = "test1";
    private static final String TREES = "Trees";
    private static final String ATVTREE = "Save tree as Newick file";
    private static final String SULSTON = "Interactive Lineage";
    private static final String VTREE = "Lineage Plot";
    private static final String CANONICAL = "Sulston tree";
    private static final String SHOW = "Show";
    private static final String NUCLEI = "nuclei";
    private static final String EDIT = "Edit";
    private static final String EDITTOOLS = "Edit tools";
    private static final String SHOWLOG = "Show log";
    private static final String DDLOG = "Div/death log";
    private static final String ANALYZE = "Analyze";
    private static final String ANALYSISDEVELOPMENT = "Nuclei rotation";
    private static final String ANALYSIS3 = "Analysis3";
    private static final String ANALYSIS4 = "Identity data";
    private static final String ANALYSIS5 = "Analysis5";
    private static final String ANALYSIS6 = "Analysis6";
    private static final String ANALYSIS7 = "Extract red";
    private static final String REDBKGCOMP = "Red Bkg Comp";
    private static final String REDCOMPSERIES = "Red Comp Series";
    private static final String ANALYSIS8 = "Analysis8";
    private static final String ANALYSIS9 = "Red expression";
    private static final String ANALYSIS10 = "Imaging test";
    private static final String EDITTRAVERSE = "Traverse Divisions";
    private static final String ADJACENCIES = "Deaths/Adjacencies";
    private static final String USEPLUGIN = "Use Plugin";
    private static final String DOEDIT = "Edit nuclei";
    private static final String DOEDIT2 = "Edit nuclei test";
    private static final String VIEWNUCLEI = "View nuclei";
    private static final String RELINK = "Relink nuclei";
    private static final String SKIPFALSENEGATIVES = "Skip false negatives";
    private static final String KILLCELL = "Kill cell";
    private static final String KILLCELLS = "Kill cells";
    private static final String KILLDEEPNUCS = "Kill deep nucs";
    private static final String SETENDTIME = "Set end time";
    private static final String INCREMENTENDTIME = "Increment end time";
    private static final String UNDO = "Undo";
    private static final String VIEW = "View";
    private static final String THREED = "3D old View";
    private static final String THREED2 = "3D View";
    private static final String THREED3 = "3D Sister View";
    private static final String THREEDSAVE = "Save 3D old";
    private static final String THREEDTWOSAVE = "Save 3D View";
    private static final String THREEDTWOZSAVE = "Save 3D Sister View";
    private static final String TWODSAVE = "Save 2D";
    private static final String ANNOTATIONPROPERTIES = "Annotation Properties";
    private static final String VIEWELLIPSE = "View ellipse";
    private static final String DEPTHVIEWS = "Depth views";
    private static final String ALLCENTROIDS = "All Centroids";
    private static final String CELLMOVEMENT = "Cell Movement";
    private static final String DEBUGLOG = "Debug Log";
    private static final String HELP = "Help";
    private static final String ABOUT = "About";
    private static final String NEW = "New features";
    private static final String ZOOMVIEW = "Zoom View";
    private static final String NEWTHREEDVIEW = "IJ 3D Image View";
    private static final String THREED4 = "WormGUIDES";

    public AceMenuBar(AceTree aceTree) {
        boolean fullgui = aceTree.getFullGUI();
        System.out.println("AceMenuBar constructor " + fullgui);
        this.iAceTree = aceTree;
        this.iDLog = aceTree.getDebugLog();
        JMenu menu = new JMenu(FILE);
        this.add(menu);
        if (fullgui) {
            this.iQuickOpen = new JMenuItem(QUICKOPEN);
            this.iQuickOpen.addActionListener(this);
            menu.add(this.iQuickOpen);
        }
        this.iOpenFromDB = new JMenuItem("Open from DB");
        this.iOpenFromDB.addActionListener(this);
        menu.add(this.iOpenFromDB);
        this.iOpen = new JMenuItem(OPEN);
        this.iOpen.addActionListener(this);
        menu.add(this.iOpen);
        this.iBookmark = new JMenuItem("Bookmarks");
        this.iBookmark.addActionListener(this);
        menu.add(this.iBookmark);
        if (fullgui) {
            this.iOpenSeries = new JMenuItem(OPENSERIES);
            this.iOpenSeries.addActionListener(this);
            menu.add(this.iOpenSeries);
            this.iRecent = new JMenu("Open recent");
            menu.add(this.iRecent);
            this.iRecent.addActionListener(this);
            menu.add(new JMenuItem("    "));
            menu.addSeparator();
            this.iRemoveRecent = new JMenu("Remove recent");
            menu.add(this.iRemoveRecent);
            this.iRemoveRecent.addActionListener(this);
            this.iClearAll = new JMenuItem(CLEARALL);
            this.iClearAll.addActionListener(this);
            menu.add(this.iClearAll);
            menu.addSeparator();
        }
        this.iOptions = new JMenuItem(OPTIONS);
        this.iOptions.addActionListener(this);
        menu.add(this.iOptions);
        menu.addSeparator();
        this.iFileChooser = new JFileChooser("./*.zip");
        this.iSave = new JMenuItem(SAVE);
        this.iSave.addActionListener(this);
        menu.add(this.iSave);
        if (fullgui) {
            this.iSaveConfig = new JMenuItem(SAVECONFIG);
            this.iSaveConfig.addActionListener(this);
            menu.add(this.iSaveConfig);
        }
        menu.addSeparator();
        this.iJLaunch = new JMenuItem(IJ);
        this.iJLaunch.addActionListener(this);
        menu.add(this.iJLaunch);
        menu.add(new JMenuItem("    "));
        this.iExit = new JMenuItem(EXIT);
        this.iExit.addActionListener(this);
        menu.add(this.iExit);
        if (fullgui) {
            JMenu menu2 = new JMenu(ACTION);
            this.add(menu2);
            this.iBuildTree = new JMenuItem(BUILDTREE);
            this.iBuildTree.addActionListener(this);
            menu2.add(this.iBuildTree);
            this.iReBuildTree = new JMenuItem(REBUILDTREE);
            this.iReBuildTree.addActionListener(this);
            menu2.add(this.iReBuildTree);
            this.iClearTree = new JMenuItem(CLEAR);
            this.iClearTree.addActionListener(this);
            menu2.add(this.iClearTree);
            this.iExpandTree = new JMenuItem(EXPAND);
            this.iExpandTree.addActionListener(this);
            menu2.add(this.iExpandTree);
        }
        menu = new JMenu(EDIT);
        this.add(menu);
        this.iEdit2 = new JMenuItem(EDITTOOLS);
        this.iEdit2.addActionListener(this);
        menu.add(this.iEdit2);
        if (fullgui) {
            this.iRelink = new JMenuItem(RELINK);
            this.iRelink.addActionListener(this);
            menu.add(this.iRelink);
            this.iEdit = new JMenuItem(DOEDIT);
            this.iEdit.addActionListener(this);
            menu.add(this.iEdit);
            this.iKillCells = new JMenuItem(KILLCELLS);
            this.iKillCells.addActionListener(this);
            menu.add(this.iKillCells);
        }
        if (fullgui) {
            this.iSkipFalseNegatives = new JMenuItem(SKIPFALSENEGATIVES);
            this.iSkipFalseNegatives.addActionListener(this);
            menu.add(this.iSkipFalseNegatives);
        }
        menu.addSeparator();
        JMenu qualityGroupmenu = new JMenu("Quality Control");
        qualityGroupmenu.addActionListener(this);
        menu.add(qualityGroupmenu);
        menu.addSeparator();
        this.iUsePlugin = new JMenuItem(USEPLUGIN);
        this.iUsePlugin.addActionListener(this);
        menu.add(this.iUsePlugin);
        this.iEditTraverse = new JMenuItem(EDITTRAVERSE);
        this.iEditTraverse.addActionListener(this);
        qualityGroupmenu.add(this.iEditTraverse);
        this.iAdjacencies = new JMenuItem(ADJACENCIES);
        this.iAdjacencies.addActionListener(this);
        qualityGroupmenu.add(this.iAdjacencies);
        this.iLazarus = new JMenuItem("Lazarus");
        this.iLazarus.addActionListener(this);
        qualityGroupmenu.add(this.iLazarus);
        this.iSiamese = new JMenuItem("Siamese");
        this.iSiamese.addActionListener(this);
        qualityGroupmenu.add(this.iSiamese);
        this.iJuvenesence = new JMenuItem("Juvenesence");
        this.iJuvenesence.addActionListener(this);
        qualityGroupmenu.add(this.iJuvenesence);
        this.iZafer1 = new JMenuItem("Zafer1");
        this.iZafer1.addActionListener(this);
        qualityGroupmenu.add(this.iZafer1);
        this.iOrientation = new JMenuItem("Orientation");
        this.iOrientation.addActionListener(this);
        qualityGroupmenu.add(this.iOrientation);
        this.iOverlaps = new JMenuItem("Overlaps");
        this.iOverlaps.addActionListener(this);
        qualityGroupmenu.add(this.iOverlaps);
        if (fullgui) {
            menu.addSeparator();
            this.iUndo = new JMenuItem(UNDO);
            this.iUndo.addActionListener(this);
            menu.add(this.iUndo);
            menu.addSeparator();
            this.iSetEndTime = new JMenuItem(SETENDTIME);
            this.iSetEndTime.addActionListener(this);
            menu.add(this.iSetEndTime);
            this.iIncrementEndTime = new JMenuItem(INCREMENTENDTIME);
            this.iIncrementEndTime.addActionListener(this);
            menu.add(this.iIncrementEndTime);
        }
        if (fullgui) {
            menu = new JMenu(ANALYZE);
            this.add(menu);
            this.iShowLog = new JMenuItem(SHOWLOG);
            this.iShowLog.addActionListener(this);
            menu.add(this.iShowLog);
            this.iDDLog = new JMenuItem(DDLOG);
            this.iDDLog.addActionListener(this);
            menu.add(this.iDDLog);
            this.iAnalyze = new JMenuItem(ANALYZE);
            this.iAnalyze.addActionListener(this);
            menu.add(this.iAnalyze);
            this.iAnalyze2 = new JMenuItem(ANALYSISDEVELOPMENT);
            this.iAnalyze2.addActionListener(this);
            menu.add(this.iAnalyze2);
            this.iAnalyze3 = new JMenuItem(ANALYSIS3);
            this.iAnalyze3.addActionListener(this);
            menu.add(this.iAnalyze3);
            this.iAnalyze4 = new JMenuItem(ANALYSIS4);
            this.iAnalyze4.addActionListener(this);
            menu.add(this.iAnalyze4);
            this.iAnalyze5 = new JMenuItem(ANALYSIS5);
            this.iAnalyze5.addActionListener(this);
            menu.add(this.iAnalyze5);
            this.iAnalyze6 = new JMenuItem(ANALYSIS6);
            this.iAnalyze6.addActionListener(this);
            menu.add(this.iAnalyze6);
            this.iExtractRed = new JMenuItem(ANALYSIS7);
            this.iExtractRed.addActionListener(this);
            menu.add(this.iExtractRed);
            this.iFixCrosstalk = new JMenuItem("FixCrosstalk");
            this.iFixCrosstalk.addActionListener(this);
            menu.add(this.iFixCrosstalk);
            this.iRedBkgComp = new JMenuItem(REDBKGCOMP);
            this.iRedBkgComp.addActionListener(this);
            menu.add(this.iRedBkgComp);
            this.iRedCompSeries = new JMenuItem(REDCOMPSERIES);
            this.iRedCompSeries.addActionListener(this);
            menu.add(this.iRedCompSeries);
            this.iAnalyze8 = new JMenuItem(ANALYSIS8);
            this.iAnalyze8.addActionListener(this);
            menu.add(this.iAnalyze8);
            this.iAnalyze9 = new JMenuItem(ANALYSIS9);
            this.iAnalyze9.addActionListener(this);
            menu.add(this.iAnalyze9);
            this.iAnalyze10 = new JMenuItem(ANALYSIS10);
            this.iAnalyze10.addActionListener(this);
            menu.add(this.iAnalyze10);
            this.iViewNuclei = new JMenuItem(VIEWNUCLEI);
            this.iViewNuclei.addActionListener(this);
            menu.add(this.iViewNuclei);
        }
        menu = new JMenu(TREES);
        this.add(menu);
        this.iAncestralTree = new JMenuItem(SULSTON);
        this.iAncestralTree.addActionListener(this);
        menu.add(this.iAncestralTree);
        if (fullgui) {
            this.iSulstonTree = new JMenuItem(CANONICAL);
            this.iSulstonTree.addActionListener(this);
            menu.add(this.iSulstonTree);
        }
        this.iVTree = new JMenuItem(VTREE);
        this.iVTree.addActionListener(this);
        menu.add(this.iVTree);
        if (fullgui) {
            this.iSubTrees = new JMenuItem("SubTrees");
            this.iSubTrees.addActionListener(this);
            menu.add(this.iSubTrees);
            this.iATVTree = new JMenuItem(ATVTREE);
            this.iATVTree.addActionListener(this);
            menu.add(this.iATVTree);
        }
        menu = new JMenu(VIEW);
        this.add(menu);
        this.iViewImgWin = new JMenuItem("Image Window");
        this.iViewImgWin.addActionListener(this);
        menu.add(this.iViewImgWin);
        menu = new JMenu("3D Rendering");
        menu.addActionListener(this);
        this.add(menu);
        this.i3D2 = new JMenuItem(THREED2);
        this.i3D2.addActionListener(this);
        menu.add(this.i3D2);
        this.i3DViewer = new JMenuItem(NEWTHREEDVIEW);
        this.i3DViewer.addActionListener(this);
        menu.add(this.i3DViewer);
        this.i3D3 = new JMenuItem(THREED4);
        this.i3D3.addActionListener(this);
        menu.add(this.i3D3);
        if (fullgui) {
            menu = new JMenu(VIEW);
            this.add(menu);
            this.i2Dsave = new JCheckBoxMenuItem(TWODSAVE);
            this.i2Dsave.addItemListener(this);
            menu.add(this.i2Dsave);
            this.iViewEllipse = new JMenuItem(VIEWELLIPSE);
            this.iViewEllipse.addActionListener(this);
            menu.add(this.iViewEllipse);
        }
        if (fullgui) {
            this.iAllCentroids = new JMenuItem(ALLCENTROIDS);
            this.iAllCentroids.addActionListener(this);
            menu.add(this.iAllCentroids);
            this.iCellMovementImage = new JMenuItem(CELLMOVEMENT);
            this.iCellMovementImage.addActionListener(this);
            menu.add(this.iCellMovementImage);
            menu = new JMenu(HELP);
            this.add(menu);
            this.iHelp = new JMenu(HELP);
            this.iHelp.addActionListener(this);
            menu.add(this.iHelp);
            this.addAllHelpFiles();
            this.iAbout = new JMenuItem(ABOUT);
            this.iAbout.addActionListener(this);
            menu.add(this.iAbout);
            this.iNew = new JMenuItem(NEW);
            this.iNew.addActionListener(this);
            menu.add(this.iNew);
            this.iTestWindow = new JMenuItem("TestWindow");
            this.iTestWindow.addActionListener(this);
            menu.add(this.iTestWindow);
            this.setEnabled(false);
            this.iClearTree.setEnabled(false);
        }
    }

    private void addAllHelpFiles() {
        this.addToHelp("AceTreeDemo");
        this.addToHelp("ConfigHelp");
        this.addToHelp("Tools");
    }

    public void addToHelp(String helpFileName) {
        JMenuItem item = new JMenuItem(helpFileName);
        item.addActionListener(this);
        this.iHelp.add(item);
    }

    public void addToRecent(String configName) {
        JMenuItem item = new JMenuItem(configName);
        item.addActionListener(this);
        this.iRecent.add(item);
        JMenuItem item2 = new JMenuItem(configName);
        item2.addActionListener(this);
        this.iRemoveRecent.add(item2);
    }

    private void removeFromRecent(String itemString) {
        int k = this.iRecent.getItemCount();
        int i = 0;
        while (i < k) {
            JMenuItem menuItem = this.iRecent.getItem(i);
            if (menuItem.getText().equals(itemString)) {
                this.iRecent.remove(menuItem);
                break;
            }
            ++i;
        }
    }

    private String getManifestVersion() {
        URL url = AceTree.class.getResource("/org/rhwlab/help/messages/manifest.html");
        InputStream istream = null;
        String s = "";
        try {
            istream = url.openStream();
            BufferedReader br = new BufferedReader(new InputStreamReader(istream));
            while (br.ready()) {
                s = br.readLine();
                if (s.indexOf("Manifest-Version:") == 0) {
                    s = s.substring(17);
                    break;
                }
                System.out.println("read: " + s);
            }
            br.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "Version: " + s + "\n";
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        if (this.iRecent != null && this.iRecent.isMenuComponent((JMenuItem)o)) {
            String item = ((JMenuItem)e.getSource()).getText();
            this.iAceTree.restoreTree(item);
        } else if (this.iRemoveRecent != null && this.iRemoveRecent.isMenuComponent((JMenuItem)o)) {
            JMenuItem menuItem = (JMenuItem)e.getSource();
            String item = menuItem.getText();
            this.iRemoveRecent.remove(menuItem);
            this.removeFromRecent(item);
            this.iAceTree.removeRecent(item);
        } else if (this.iClearAll == o) {
            this.iRecent.removeAll();
            this.iRemoveRecent.removeAll();
            this.iAceTree.clearAll();
        } else if (this.iBuildTree == o) {
            this.iAceTree.buildTree(false);
            this.iClearTree.setEnabled(true);
        } else if (this.iReBuildTree == o) {
            this.iAceTree.clearTree();
            this.iAceTree.buildTree(true);
            this.iClearTree.setEnabled(true);
        } else if (this.iClearTree == o) {
            this.iAceTree.clearTree();
        } else if (this.iExpandTree == o) {
            this.iAceTree.expandTree();
        } else if (this.iQuickOpen == o) {
            this.iAceTree.quickOpen();
        } else if (this.iOpenFromDB == o) {
            new OpenFromDB(this.iAceTree);
        } else if (this.iOpen == o) {
            ExampleFileFilter filter = new ExampleFileFilter();
            filter.addExtension("xml");
            filter.addExtension("dat");
            filter.setDescription("Config Files");
            this.iFileChooser.setFileFilter(filter);
            this.iFileChooser.setSelectedFile(new File("."));
            int returnVal = this.iFileChooser.showOpenDialog(this);
            if (returnVal == 0) {
                File file = this.iFileChooser.getSelectedFile();
                String path = file.getPath();
                this.iAceTree.setConfigFileName(path);
                this.iAceTree.bringUpSeriesUI(path);
            }
        } else if (this.iBookmark == o) {
            this.iAceTree.bookmarkTool();
        } else if (this.iViewImgWin == o) {
            this.iAceTree.showImageWindow();
        } else if (this.iOpenSeries == o) {
            this.iFileChooser.setSelectedFile(new File(""));
            int returnVal = this.iFileChooser.showOpenDialog(this);
            if (returnVal == 0) {
                File file = this.iFileChooser.getSelectedFile();
                String path = file.getPath();
                this.iAceTree.openSeveralConfigs(path);
            }
        } else if (this.iOptions == o) {
            this.options();
        } else if (this.iSave == o) {
            ExampleFileFilter filter = new ExampleFileFilter();
            filter.addExtension("zip");
            filter.setDescription("Annotation Files");
            this.iFileChooser.setFileFilter(filter);
            JFileChooser fileChooser = this.iFileChooser;
            Config config = this.iAceTree.getNucleiMgr().getConfig();
            String s = config.iConfigFileName;
            AceMenuBar.println("AceMenuBar.actionListener: " + s);
            String ss = new File(s).getParent();
            fileChooser.setCurrentDirectory(new File(ss));
            fileChooser.setSelectedFile(new File(""));
            int returnVal = fileChooser.showSaveDialog(this);
            if (returnVal == 0) {
                File file = new File("" + fileChooser.getSelectedFile());
                String path = file.getPath();
                if (path.lastIndexOf(".") != -1) {
                    String extension = path.substring(path.lastIndexOf("."), path.length());
                    if (!extension.equals(".zip")) {
                        file = new File(fileChooser.getSelectedFile() + ".zip");
                    }
                } else {
                    file = new File(fileChooser.getSelectedFile() + ".zip");
                }
                this.iAceTree.saveNuclei(file);
            } else {
                System.out.println("Save command cancelled by user.");
            }
        } else if (this.iSaveConfig == o) {
            Config config = this.iAceTree.getNucleiMgr().getConfig();
            config.saveConfigXMLFile();
        } else if (this.iJLaunch == o) {
            ImageJ ijin = new ImageJ();
            if (this.iAceTree.getImageWindow() != null) {
                System.out.println("loading image " + this.iAceTree.getImageWindow().getCurrentImageName());
                ImagePlus imp = ij.IJ.openImage((String)this.iAceTree.getImageWindow().getCurrentImageName());
                imp.show();
            }
        } else if (this.iExit == o) {
            this.iAceTree.exit();
        } else if (this.iEdit == o) {
            this.iAceTree.editImage3();
        } else if (this.iEdit2 == o) {
            this.iAceTree.editTools();
        } else if (this.iShowLog == o) {
            this.iAceTree.getEditLog().showMe();
        } else if (this.iDDLog == o) {
            new DeathAndDivisionLog(this.iAceTree, "DeathsAndDivisions");
        } else if (this.iAnalyze == o) {
            new Analysis(this.iAceTree, "Overviews");
        } else if (this.iAnalyze2 == o) {
            try {
                new Analysis2("Analysis Development");
            }
            catch (NoClassDefFoundError nce) {
                new AceTreeHelp("/org/rhwlab/help/messages/SGTerror.html", 400, 200);
            }
        } else if (this.iAnalyze3 == o) {
            new Analysis3(ANALYSIS3);
        } else if (this.iAnalyze4 == o) {
            new Analysis4("Analysis4");
        } else if (this.iAnalyze5 == o) {
            new Analysis5(ANALYSIS5);
        } else if (this.iAnalyze6 == o) {
            new Analysis6(ANALYSIS6);
        } else if (this.iExtractRed == o) {
            new ExtractRed("ExtractRed");
        } else if (this.iFixCrosstalk == o) {
            new RedCorrector2();
        } else if (this.iRedBkgComp == o) {
            new RedBkgComp();
        } else if (this.iRedCompSeries == o) {
            new RedCompSeries("Red comp series");
        } else if (this.iAnalyze8 == o) {
            new Analysis8(ANALYSIS8);
        } else if (this.iAnalyze9 == o) {
            new Analysis9("Analysis9");
        } else if (this.iAnalyze10 == o) {
            new Analysis11("Analysis11");
        } else if (this.iUsePlugin == o) {
            new UsePlugin();
        } else if (this.iEditTraverse == o) {
            this.iAceTree.editTraverse();
        } else if (this.iAdjacencies == o) {
            this.iAceTree.showDeathsAdjacencies();
        } else if (this.iLazarus == o) {
            this.iAceTree.showLazarus();
        } else if (this.iSiamese == o) {
            this.iAceTree.showSiamese();
        } else if (this.iJuvenesence == o) {
            this.iAceTree.showJuvenesence();
        } else if (this.iZafer1 == o) {
            this.iAceTree.showZafer1();
        } else if (this.iOrientation == o) {
            this.iAceTree.showOrientation();
        } else if (this.iOverlaps == o) {
            new Overlaps();
        } else if (this.iViewNuclei == o) {
            this.iAceTree.viewNuclei();
        } else if (this.iRelink == o) {
            this.iAceTree.relinkNucleus();
        } else if (this.iSkipFalseNegatives == o) {
            new SkipFalseNegatives();
        } else if (this.iKillCells == o) {
            this.iAceTree.killCells();
        } else if (this.iSetEndTime == o) {
            this.iAceTree.setEndTime();
        } else if (this.iIncrementEndTime == o) {
            this.iAceTree.incrementEndTime();
        } else if (this.iUndo == o) {
            this.iAceTree.undo();
        } else if (this.iAncestralTree == o) {
            this.iAceTree.ancestral();
        } else if (this.iSulstonTree == o) {
            this.iAceTree.canonical();
        } else if (this.iVTree == o) {
            this.iAceTree.vtree();
        } else if (this.iSubTrees == o) {
            new SubTrees();
        } else if (this.iATVTree == o) {
            this.iAceTree.exportNewick();
        } else if (this.iTest == o) {
            this.iAceTree.test();
        } else if (this.i3D != o) {
            if (this.i3D2 == o) {
                this.iAceTree.threeDview();
            } else if (this.i3DViewer == o) {
                this.iAceTree.run3Dviewer();
            } else if (this.i3D3 == o) {
                AceMenuBar.println("starting WormGUIDES...");
                WormGUIDESWindow view = new WormGUIDESWindow();
                WormGUIDESWindow.initializeWormGUIDES(this.iAceTree.getNucleiMgr());
            } else if (this.i3D2Z != o) {
                if (this.iViewEllipse == o) {
                    new EllipseViewer();
                } else if (this.iDepthViews == o) {
                    new DepthViews("");
                } else if (this.iAllCentroids == o) {
                    this.iAceTree.allCentroidsView();
                } else if (this.iCellMovementImage == o) {
                    this.iAceTree.cellMovementImage();
                } else if (this.iDebugLog == o) {
                    this.iDLog.showMe();
                } else if (this.iAbout == o) {
                    String message = this.getManifestVersion();
                    message = String.valueOf(message) + "Copyright 2005, Genome Sciences\n";
                    message = String.valueOf(message) + "University of Washington\n";
                    message = String.valueOf(message) + "biowolp@u.washington.edu";
                    JOptionPane pane = new JOptionPane(message);
                    JDialog dialog = pane.createDialog(this.iAceTree, "About AceTree");
                    dialog.setVisible(true);
                } else if (this.iHelp != null && this.iHelp.isMenuComponent((JMenuItem)o)) {
                    String item = ((JMenuItem)e.getSource()).getText();
                    item = "/org/rhwlab/help/html/" + item + ".html";
                    new AceTreeHelp(item);
                } else if (this.iNew == o) {
                    new AceTreeHelp("/org/rhwlab/help/html/NewFeatures.html");
                } else if (this.iTestWindow == o) {
                    this.iAceTree.testWindow();
                }
            }
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        JMenuItem source = (JMenuItem)e.getSource();
        if (source != this.i3Dsave) {
            if (source == this.i3D2save) {
                this.i3D2saveState = e.getStateChange();
                this.iAceTree.image3DSave(this.i3D2save.getState());
            } else if (source == this.i2Dsave) {
                this.iAceTree.image2DSave(this.i2Dsave.getState());
            }
        }
    }

    public void resetSaveState() {
        AceMenuBar.println("resetSaveState: RESETTING!");
        this.i2Dsave.setState(false);
        this.i3Dsave.setState(false);
        this.i3D2save.setState(false);
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (this.iAceTree.getFullGUI()) {
            this.iBuildTree.setEnabled(enabled);
            this.iEdit.setEnabled(enabled);
        }
        this.iSave.setEnabled(enabled);
    }

    public void setClearEnabled(boolean enabled) {
        if (this.iAceTree.getFullGUI()) {
            this.iClearTree.setEnabled(enabled);
        }
    }

    public void setEditEnabled(boolean enabled) {
        if (this.iAceTree.getFullGUI()) {
            this.iEdit.setEnabled(enabled);
        }
    }

    private void options() {
        new Options();
    }

    public static void main(String[] args) {
    }

    private static void println(String s) {
        System.out.println(s);
    }
}

