/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.acetree;

import ij.ImagePlus;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.KeyboardFocusManager;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.Collections;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreePath;
import org.rhwlab.acetree.AceMenuBar;
import org.rhwlab.acetree.BookmarkDialog;
import org.rhwlab.acetree.ControlCallback;
import org.rhwlab.acetree.FocusControl;
import org.rhwlab.acetree.InputCtrl;
import org.rhwlab.acetree.NucUtils;
import org.rhwlab.acetree.PartsList;
import org.rhwlab.acetree.PlayerControl;
import org.rhwlab.acetree.QuickOpen;
import org.rhwlab.help.AceTreeHelp;
import org.rhwlab.help.GeneralStartupError;
import org.rhwlab.help.Java3DError;
import org.rhwlab.help.TestWindow;
import org.rhwlab.image.CellMovementImage;
import org.rhwlab.image.DepthViews;
import org.rhwlab.image.Image3D;
import org.rhwlab.image.ImageAllCentroids;
import org.rhwlab.image.ImageWindow;
import org.rhwlab.nucedit.AddOneDialog;
import org.rhwlab.nucedit.DeathsAdjacencies;
import org.rhwlab.nucedit.EditLog;
import org.rhwlab.nucedit.EditTraverse;
import org.rhwlab.nucedit.Juvenesence;
import org.rhwlab.nucedit.KillCellsDialog;
import org.rhwlab.nucedit.KillDeepNucsDialog;
import org.rhwlab.nucedit.Lazarus;
import org.rhwlab.nucedit.NucEditDialog;
import org.rhwlab.nucedit.NucRelinkDialog;
import org.rhwlab.nucedit.Orientation;
import org.rhwlab.nucedit.SetEndTimeDialog;
import org.rhwlab.nucedit.Siamese;
import org.rhwlab.nucedit.UnifiedNucRelinkDialog;
import org.rhwlab.nucedit.Zafer1;
import org.rhwlab.snight.Config;
import org.rhwlab.snight.NucZipper;
import org.rhwlab.snight.NucleiMgr;
import org.rhwlab.snight.Nucleus;
import org.rhwlab.tree.AncesTree;
import org.rhwlab.tree.CanonicalTree;
import org.rhwlab.tree.Cell;
import org.rhwlab.tree.CellData;
import org.rhwlab.tree.Newick;
import org.rhwlab.tree.SulstonTree;
import org.rhwlab.tree.VTree;
import org.rhwlab.utils.AuxFrame;
import org.rhwlab.utils.EUtils;
import org.rhwlab.utils.Log;
import org.rhwlab.volumeview.Display3D;

public class AceTree
extends JPanel
implements ActionListener,
ControlCallback,
Runnable {
    private Display3D display3D;
    protected static AceTree iAceTree;
    private Hashtable iNucleiMgrHash;
    private JLabel iSeriesLabel;
    private String iConfigFileName;
    private JTree iTree;
    private String[] iImgSuffix;
    private Cell iRoot;
    private JTextPane iText;
    private JTextPane iText2;
    private JTextPane iText3;
    protected JFrame iMainFrame;
    private Vector iTempV;
    private String iFilePath;
    private boolean iRootEstablished;
    private int iImageTime;
    private int iImagePlane;
    public ImageWindow iImgWin;
    private boolean iImgWinSet;
    private NucleiMgr iNucleiMgr;
    public AncesTree iAncesTree;
    private String iOrientation;
    public AceMenuBar iAceMenuBar;
    private EditLog iEditLog;
    private Log iDDLog;
    private Log iDLog;
    protected WindowEventHandler iWinEvtHandler;
    private FileInputStream iFstream;
    private BufferedReader iBReader;
    private JPanel iToolControls;
    private JButton iCopy;
    private JButton iShow;
    private JButton iClear;
    private JButton iNext;
    private JButton iPrev;
    private JButton iUp;
    private JButton iDown;
    protected JButton iHome;
    private JButton iDefault;
    private JButton iShowC;
    private JButton iTrack;
    private JButton iSister;
    private JButton iColorToggle;
    private JLabel iLabel;
    private int iTimeInc;
    private int iPlaneInc;
    private Cell iCurrentCell;
    private boolean iCurrentCellPresent;
    private int iCurrentCellXloc;
    private int iCurrentCellYloc;
    private float iCurrentCellZloc;
    protected InputCtrl iInputCtrl;
    private String iZipFileName;
    private String iZipNucDir;
    private String iZipTifFilePath;
    private String iTifPrefix;
    private int iStartingIndex;
    private int iEndingIndex;
    private int iNamingMethod;
    private Hashtable iConfigHash;
    public Hashtable iCellsByName;
    private double iZPixRes;
    private int iPlaneEnd;
    private int iPlaneStart;
    private boolean iShowAnnotations;
    private boolean iShowAnnotationsSave;
    private boolean iShowCentroids;
    public Integer iTrackPosition;
    public Integer iTrackPositionSave;
    private boolean iIgnoreValueChanged;
    protected Image3D iImage3D;
    private Object iDispProps3D;
    private Object iDispProps3D2;
    private Object iDispProps3D2Z;
    public boolean iEditTools;
    private CellMovementImage iCellMovementImage;
    private boolean iCallSaveImage;
    private int iUseZip;
    private int iUseStack;
    private int iFileNameType;
    private CanonicalTree iCanonicalTree;
    protected PlayerControl iPlayerControl;
    private EditTraverse iEditTraverse;
    private boolean iDebugTest;
    private int iColor;
    public NucRelinkDialog iNucRelinkDialog;
    public AddOneDialog iAddOneDialog;
    private BookmarkDialog iBookmarkDialog;
    private JList iBookmarkJList;
    private JButton iAddActiveCell;
    private SulstonTree iSulstonTree;
    private LinkedList<Integer> iKeyQueue;
    private static boolean fullGUI;
    private int iStartTime;
    private static int wasClosed;
    public static final int LEFTCLICKONTREE = 1;
    public static final int RIGHTCLICKONTREE = 2;
    public static final int RIGHTCLICKONIMAGE = 3;
    public static final int CONTROLCALLBACK = 4;
    public static final int NEXTTIME = 5;
    public static final int PREVTIME = 6;
    public static final int RIGHTCLICKONEDITIMAGE = 7;
    private static final int WIDTH = 330;
    private static final int HEIGHT200 = 200;
    private static final int HEIGHT100 = 100;
    private static final int HEIGHT75 = 75;
    private static final int HEIGHT30 = 30;
    private static final int XINC = 8;
    private static final int YINC = 12;
    public static final String PARAMETERS = "parameters";
    public static final String POSITION = "Mouse position: ";
    public static final String SPACES15 = "               ";
    public static final String TITLE = "AceTree";
    public static final String HELPMSG = "you must provide file: ";
    public static final String SEP = ", ";
    public static final String ROOTNAME = "ROOT";
    public static final String NEXTT = "Next";
    public static final String PREV = "Prev";
    public static final String UP = "Up Z";
    public static final String DOWN = "Down Z";
    public static final String HOME = "Cell Birth";
    public static final String SHOW = "Show Names";
    public static final String SHOWC = "Show Cells";
    public static final String HIDE = "Hide Names";
    public static final String HIDEC = "Hide Cells";
    public static final String CLEAR = "Clear Names";
    public static final String COPY = "Copy";
    public static final String EDIT = "Edit";
    public static final String NOTRACK = "No Track";
    public static final String TRACK = "Track";
    public static final String SISTER = "Sister";
    public static final String COLORTOGGLE = "Channel";
    public static final String CS = ", ";
    public static final String DEPTHVIEWS = "Depth View";
    protected static final int ZIPFILENAME = 0;
    protected static final int TIFDIRECTORY = 1;
    protected static final int TIFPREFIX = 2;
    protected static final int NUCLEIDIRECTORY = 3;
    protected static final int ROOTNAMEI = 4;
    protected static final int STARTINGINDEX = 5;
    protected static final int ENDINGINDEX = 6;
    protected static final int USEZIP = 7;
    protected static final int NAMINGMETHOD = 8;
    private static final float HALFROUND = 0.5f;
    Orientation iOrientationPanel;
    Zafer1 iZafer1Panel;
    Juvenesence iJuvenesencePanel;
    Lazarus iLazarusPanel;
    Siamese iSiamesePanel;
    DeathsAdjacencies iDeathsAdjacenciesPanel;
    private boolean iCmdLineRun;

    static {
        fullGUI = false;
        wasClosed = 0;
    }

    protected AceTree() {
        this((String)null, false);
        System.out.println("AceTree empty constructor");
    }

    protected AceTree(String configFileName, boolean fullGUI) {
        AceTree.fullGUI = fullGUI;
        System.out.println("string constructor");
        iAceTree = this;
        this.iMainFrame = new JFrame(TITLE);
        URL imageURL = PlayerControl.class.getResource("/images/icon2.gif");
        ImageIcon test = new ImageIcon(imageURL, "x");
        this.iMainFrame.setIconImage(test.getImage());
        this.iAceMenuBar = new AceMenuBar(this);
        this.iTempV = new Vector();
        this.iConfigFileName = configFileName;
        this.iNucleiMgrHash = new Hashtable();
        this.iRootEstablished = false;
        this.iImageTime = 0;
        this.iImagePlane = 0;
        this.iTimeInc = 0;
        this.iPlaneInc = 0;
        this.iCurrentCell = null;
        this.iCurrentCellXloc = 0;
        this.iCurrentCellYloc = 0;
        this.setShowAnnotations(false);
        this.iShowCentroids = false;
        this.iInputCtrl = null;
        this.iRoot = new Cell(ROOTNAME);
        this.iTree = new JTree(this.iRoot);
        this.iTree.addMouseListener(new TreeMouseAdapter());
        this.iEditLog = new EditLog("EditLog");
        this.iDLog = new Log("Debug Log");
        this.setKeyboardActions();
        this.displayTree();
        try {
            this.iTrackPositionSave = this.iTrackPosition = ImageWindow.ANTERIOR;
            this.iDebugTest = false;
            this.iCanonicalTree = CanonicalTree.getCanonicalTree();
            this.iColor = 0;
            this.iTree.addMouseListener(new TreeMouseAdapter());
            if (this.iConfigFileName != null) {
                this.bringUpSeriesUI(this.iConfigFileName);
            }
            this.iTree.setCellRenderer(new AceTreeCellRenderer(this));
            this.setDefaultKeyboardActions();
            this.iSulstonTree = null;
        }
        catch (Throwable t) {
            new GeneralStartupError(this.getMainFrame(), t);
        }
        this.iKeyQueue = new LinkedList();
    }

    public String transformTitle() {
        String oldTitle = this.getImageTitle();
        int index = oldTitle.indexOf(116);
        System.out.println("Transforming title " + oldTitle);
        try {
            int num = Integer.parseInt(oldTitle.substring(index + 1, index + 4));
            return oldTitle.replace(oldTitle.substring(index - 1), "_t" + String.valueOf(num) + ".TIF");
        }
        catch (NumberFormatException numberFormatException) {
            return "";
        }
    }

    public static int getWasClosed() {
        return wasClosed;
    }

    public static void setWasClosed(int i) {
        wasClosed = i;
    }

    public void run3Dviewer() {
        try {
            if (this.display3D == null) {
                this.display3D = new Display3D();
            } else if (this.display3D.getUniverse().getWindow() == null) {
                this.display3D = null;
                this.display3D = new Display3D();
            } else {
                System.out.println("You cannot open up more than one main universe.");
                return;
            }
            if (wasClosed == 0) {
                this.display3D.runThread("close");
                this.display3D = null;
                this.display3D = new Display3D();
            }
            System.out.println("Base directory: " + this.iZipTifFilePath.substring(0, this.iZipTifFilePath.length() - 5));
            System.out.println("Image Title: " + this.transformTitle());
            this.display3D.setBaseDir(this.iZipTifFilePath.substring(0, this.iZipTifFilePath.length() - 5));
            this.display3D.updateUniverse(this.transformTitle());
            this.display3D.runThread("");
        }
        catch (NullPointerException e) {
            this.display3D = null;
            System.out.println("Image stack is not loaded");
        }
    }

    public void addNext3D() {
        if (this.display3D != null) {
            if (this.display3D.getUniverse().getWindow() == null) {
                this.display3D = null;
            } else {
                this.display3D.updateUniverse(this.transformTitle());
                this.display3D.addNext();
            }
        }
    }

    public PlayerControl getPlayerControl() {
        return this.iPlayerControl;
    }

    private void testRoot() {
        System.out.println("testRoot: " + this.iRoot.getLeafCount());
    }

    public static synchronized AceTree getAceTree(String configFileName) {
        if (iAceTree == null) {
            System.out.println("AceTree.getAceTree making a new AceTree: " + configFileName);
            iAceTree = configFileName != null ? (configFileName.equals("-full") ? new AceTree(null, true) : new AceTree(configFileName, false)) : new AceTree(null, false);
        }
        return iAceTree;
    }

    public static synchronized AceTree getAceTree(Object configFileName) {
        System.out.println("array factory");
        if (iAceTree == null) {
            if (configFileName != null) {
                String[] configs = (String[])configFileName;
                if (configs.length == 1) {
                    if (configs[0].equals("-full")) {
                        System.out.println("about to call null boolean con");
                        iAceTree = new AceTree(null, true);
                    } else {
                        System.out.println("about to call string boolean con");
                        iAceTree = new AceTree(configs[0], false);
                    }
                } else {
                    System.out.println("about to call string boolean con");
                    iAceTree = new AceTree(configs[0], true);
                }
                iAceTree.setConfigFileName(configs[0]);
                iAceTree.bringUpSeriesUI(configs[0]);
            } else {
                System.out.println("about to call empty con");
                iAceTree = new AceTree(null, false);
            }
        }
        return iAceTree;
    }

    public void bringUpSeriesUI(String configFileName) {
        try {
            System.out.println("ImageWindow stack flag reset to 0 in AceTree.");
            ImageWindow.setUseStack(0);
            System.out.println("\n\nbringUpSeriesUI: " + configFileName);
            System.gc();
            String shortName = Config.getShortName(configFileName);
            NucleiMgr nucMgr = (NucleiMgr)this.iNucleiMgrHash.get(shortName);
            if (nucMgr == null) {
                try {
                    FileInputStream fis = new FileInputStream(configFileName);
                    fis.close();
                }
                catch (Exception fnfe) {
                    new AceTreeHelp("/org/rhwlab/help/messages/ConfigError.html", 200, 200);
                    return;
                }
                int k = this.bringUpSeriesData(configFileName);
                if (k != 0) {
                    return;
                }
            }
            this.iNucleiMgr = (NucleiMgr)this.iNucleiMgrHash.get(shortName);
            if (this.iNucleiMgr == null) {
                System.out.println(HELPMSG + configFileName);
                System.exit(1);
            }
            this.iEditLog = this.iNucleiMgr.getEditLog();
            this.iNucleiMgr.sendStaticParametersToImageWindow();
            ImageWindow.setNucleiMgr(this.iNucleiMgr);
            this.setConfigFileName(configFileName);
            this.grabConfigStuff();
            this.iPlaneEnd = this.iNucleiMgr.getPlaneEnd();
            this.iPlaneStart = this.iNucleiMgr.getPlaneStart();
            this.iZPixRes = this.iNucleiMgr.getZPixRes();
            this.buildTree(false);
            this.setShowAnnotations(true);
            try {
                Class.forName("javax.media.j3d.VirtualUniverse");
            }
            catch (ClassNotFoundException e) {
                new Java3DError(this.iMainFrame);
            }
        }
        catch (Throwable t) {
            new GeneralStartupError(this.getMainFrame(), t);
        }
    }

    public void bringUpSeriesUI(Config config) {
        int k;
        System.out.println("ImageWindow stack flag reset to 0 in AceTree.");
        ImageWindow.setUseStack(0);
        String configFileName = config.iConfigFileName;
        System.out.println("\n\nbringUpSeriesUI: " + configFileName);
        System.gc();
        String shortName = Config.getShortName(configFileName);
        NucleiMgr nucMgr = (NucleiMgr)this.iNucleiMgrHash.get(shortName);
        if (nucMgr == null && (k = this.bringUpSeriesData(config)) != 0) {
            return;
        }
        this.iNucleiMgr = (NucleiMgr)this.iNucleiMgrHash.get(shortName);
        if (this.iNucleiMgr == null) {
            System.out.println(HELPMSG + configFileName);
            System.exit(1);
        }
        this.iEditLog = this.iNucleiMgr.getEditLog();
        this.iNucleiMgr.sendStaticParametersToImageWindow();
        ImageWindow.setNucleiMgr(this.iNucleiMgr);
        this.setConfigFileName(configFileName);
        this.grabConfigStuff();
        this.iPlaneEnd = this.iNucleiMgr.getPlaneEnd();
        this.iPlaneStart = this.iNucleiMgr.getPlaneStart();
        this.buildTree(false);
        this.setShowAnnotations(true);
    }

    public int bringUpSeriesData(String configFileName) {
        System.out.println("bringUpSeriesData: " + configFileName);
        File fx = new File(configFileName);
        this.iSeriesLabel.setText(fx.getName());
        this.iMainFrame.setTitle(TITLE);
        NucleiMgr nucMgr = new NucleiMgr(configFileName);
        ImageWindow.setUseStack(this.iUseStack);
        if (!nucMgr.iGoodNucleiMgr) {
            return -1;
        }
        nucMgr.processNuclei(true, nucMgr.getConfig().iNamingMethod);
        String config = nucMgr.getConfig().getShortName();
        AceTree.println("bringUpSeriesData, " + config);
        if (!this.iNucleiMgrHash.containsKey(config)) {
            this.iNucleiMgrHash.put(config, nucMgr);
            if (fullGUI) {
                this.iAceMenuBar.addToRecent(config);
            }
        }
        System.gc();
        return 0;
    }

    public int bringUpSeriesData(Config config) {
        String configFileName = config.iConfigFileName;
        System.out.println("bringUpSeriesData: " + configFileName);
        File fx = new File(configFileName);
        String ss = "AceTree: " + fx.getName();
        this.iMainFrame.setTitle(ss);
        NucleiMgr nucMgr = new NucleiMgr(config);
        ImageWindow.setUseStack(this.iUseStack);
        if (!nucMgr.iGoodNucleiMgr) {
            return -1;
        }
        nucMgr.processNuclei(true, nucMgr.getConfig().iNamingMethod);
        String configName = nucMgr.getConfig().getShortName();
        if (!this.iNucleiMgrHash.containsKey(configName)) {
            this.iNucleiMgrHash.put(configName, nucMgr);
            if (fullGUI) {
                this.iAceMenuBar.addToRecent(configName);
            }
        }
        System.gc();
        return 0;
    }

    public void openSeveralConfigs(String configList) {
        String sr = null;
        boolean first = true;
        try {
            FileInputStream fis = new FileInputStream(configList);
            BufferedReader br = new BufferedReader(new InputStreamReader(fis));
            sr = br.readLine();
            while (sr != null && sr.length() > 2) {
                if (sr.indexOf("#") != 0) {
                    String[] sa = sr.split(" ");
                    sr = sa[0];
                    System.out.println("\n\n***config file: " + sr);
                    this.bringUpSeriesData(sr);
                    if (first) {
                        this.bringUpSeriesUI(sr);
                        first = false;
                    }
                }
                sr = br.readLine();
            }
            br.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public void removeRecent(String item) {
        this.iNucleiMgrHash.remove(item);
        System.gc();
    }

    public void clearAll() {
        Enumeration e = this.iNucleiMgrHash.keys();
        while (e.hasMoreElements()) {
            NucleiMgr nm = (NucleiMgr)this.iNucleiMgrHash.get(e.nextElement());
            nm = null;
            System.gc();
        }
        this.iNucleiMgrHash = new Hashtable();
        System.gc();
    }

    private void grabConfigStuff() {
        Config c = this.iNucleiMgr.getConfig();
        this.iTifPrefix = c.iTifPrefix;
        this.iStartingIndex = c.iStartingIndex;
        this.iEndingIndex = c.iEndingIndex;
        this.iUseZip = c.iUseZip;
        this.iUseStack = c.iUseStack;
        this.iZipTifFilePath = c.iZipTifFilePath;
        this.iStartTime = c.getStartTime();
    }

    public void clearTree() {
        Hashtable x;
        if (this.iAncesTree == null) {
            return;
        }
        Cell root = this.iRoot;
        if (root == null) {
            AceTree.println("Root is null. Acetree cannot cleartree().");
            return;
        }
        int m = 0;
        int count = 0;
        Cell cc = null;
        while (this.iRoot.getChildCount() > 1) {
            Cell c = (Cell)this.iRoot.getFirstLeaf();
            while ((cc = (Cell)c.getNextLeaf()) != null) {
                c.removeFromParent();
                c = null;
                c = cc;
                ++count;
            }
            ++m;
        }
        AceTree.println("clearTree: removed: " + count + ", " + m);
        Runtime runtime = Runtime.getRuntime();
        runtime.gc();
        AceTree.println("clearTree: memory: " + runtime.freeMemory() + ", " + runtime.totalMemory() + ", " + runtime.maxMemory());
        if (root != null) {
            root.removeAllChildren();
        }
        if ((x = this.iAncesTree.getCells()) != null) {
            x.clear();
        }
        this.iTree.updateUI();
    }

    private void clearTreeTest() {
        Hashtable x;
        if (this.iAncesTree == null) {
            return;
        }
        Cell root = this.iAncesTree.getRoot();
        root = this.iRoot;
        System.out.println("\nAceTree.clearTree entered with root=" + root);
        int count = 0;
        int m = 0;
        Cell cc = null;
        while (this.iRoot.getChildCount() > 1) {
            Cell c = (Cell)this.iRoot.getFirstLeaf();
            while ((cc = (Cell)c.getNextLeaf()) != null) {
                c.removeFromParent();
                c = null;
                c = cc;
                ++count;
            }
            ++m;
        }
        AceTree.println("clearTreeTest: removed: " + count + ", " + m);
        if (root != null) {
            root.removeAllChildren();
        }
        if ((x = this.iAncesTree.getCells()) != null) {
            x.clear();
        }
        this.iTree.updateUI();
    }

    void reviewNuclei() {
        Vector nr = this.iNucleiMgr.getNucleiRecord();
        int i = 189;
        while (i < 195) {
            Vector nuclei = (Vector)nr.get(i);
            int j = 0;
            while (j < nuclei.size()) {
                Nucleus n = (Nucleus)nr.get(j);
                AceTree.println("reviewNuclei, " + i + ", " + j);
                ++j;
            }
            ++i;
        }
    }

    public void buildTree(boolean doIdentity) {
        this.iShowAnnotationsSave = this.iShowAnnotations;
        this.setShowAnnotations(false);
        this.iShowCentroids = false;
        this.iShowC.setText(SHOWC);
        if (doIdentity) {
            this.iNucleiMgr.processNuclei(doIdentity, this.iNamingMethod);
        }
        if (this.iEditLog != null) {
            this.iEditLog.append("buildTree(" + doIdentity + ") start = " + this.iStartingIndex + " end = " + this.iEndingIndex + this.iEditLog.getTime());
        }
        this.grabConfigStuff();
        System.out.println("StartingIndex: " + this.iStartingIndex);
        System.out.println("EndingIndexX: " + this.iEndingIndex);
        Cell.setEndingIndexS(this.iEndingIndex);
        this.iAncesTree = this.iNucleiMgr.getAncesTree();
        this.iCellsByName = this.iAncesTree.getCellsByName();
        this.updateRoot(this.iAncesTree.getRootCells());
        this.iCellsByName = this.iAncesTree.getCellsByName();
        boolean k = false;
        Cell c = this.walkUpToAGoodCell();
        this.iAceMenuBar.setEditEnabled(true);
        this.iAceMenuBar.setEnabled(true);
        this.iTree.updateUI();
        this.setTreeSelectionMode();
        this.setStartingCell(c, this.iStartTime);
        this.iTree.getSelectionModel().setSelectionMode(1);
        ((DefaultTreeCellRenderer)this.iTree.getCellRenderer()).setOpenIcon(null);
        ((DefaultTreeCellRenderer)this.iTree.getCellRenderer()).setClosedIcon(null);
        ((DefaultTreeCellRenderer)this.iTree.getCellRenderer()).setLeafIcon(null);
        if (this.iEditTraverse != null) {
            this.iEditTraverse.buildNotification();
        }
        this.setShowAnnotations(this.iShowAnnotationsSave);
    }

    private Cell walkUpToAGoodCell() {
        Cell c = null;
        if (this.iRoot.getChildCount() <= 1) {
            return this.iRoot;
        }
        c = (Cell)this.iRoot.getChildAt(0);
        while (c.getTime() < 0 && c.getChildCount() > 0) {
            c = (Cell)c.getChildAt(0);
        }
        if (c.getTime() < 0) {
            int i = 1;
            while (i < this.iRoot.getChildCount()) {
                c = (Cell)this.iRoot.getChildAt(i);
                if (c.getTime() > 0) break;
                ++i;
            }
        }
        return c;
    }

    public void restoreTree(String shortName) {
        System.out.println("\n\nAceTree.restoreTree called: " + shortName);
        this.iMainFrame.setTitle("AceTree: " + shortName);
        NucleiMgr nucMgr = (NucleiMgr)this.iNucleiMgrHash.get(shortName);
        if (nucMgr == null) {
            System.out.println("SORRY: " + shortName + " is not hashed");
            return;
        }
        this.iNucleiMgr = nucMgr;
        this.iEditLog = this.iNucleiMgr.getEditLog();
        this.grabConfigStuff();
        this.iPlaneEnd = this.iNucleiMgr.getPlaneEnd();
        this.iPlaneStart = this.iNucleiMgr.getPlaneStart();
        ImageWindow.setNucleiMgr(this.iNucleiMgr);
        ImageWindow.setStaticParameters(this.iNucleiMgr.getConfig().iZipTifFilePath, this.iNucleiMgr.getConfig().iTifPrefix, this.iNucleiMgr.getConfig().iUseZip, this.iNucleiMgr.getConfig().iSplitChannelImage);
        System.out.println("StartingIndex: " + this.iStartingIndex);
        System.out.println("EndingIndex: " + this.iEndingIndex);
        Cell.setEndingIndexS(this.iEndingIndex);
        this.iAncesTree = this.iNucleiMgr.getAncesTree();
        this.updateRoot(this.iAncesTree.getRootCells());
        this.iCellsByName = this.iAncesTree.getCellsByName();
        this.setShowAnnotations(false);
        this.iShow.setText(SHOW);
        this.iShowCentroids = false;
        this.iShowC.setText(SHOWC);
        Cell.setEndingIndexS(this.iEndingIndex);
        Cell c = this.walkUpToAGoodCell();
        this.iTree.updateUI();
        this.setTreeSelectionMode();
        this.setStartingCell(c, this.iStartTime);
        this.iTree.getSelectionModel().setSelectionMode(1);
        ((DefaultTreeCellRenderer)this.iTree.getCellRenderer()).setOpenIcon(null);
        ((DefaultTreeCellRenderer)this.iTree.getCellRenderer()).setClosedIcon(null);
        ((DefaultTreeCellRenderer)this.iTree.getCellRenderer()).setLeafIcon(null);
    }

    private void updateRoot(Vector rootCells) {
        Cell PP = (Cell)this.iCellsByName.get("P");
        int kk = PP.getChildCount();
        this.iRoot.removeAllChildren();
        Vector<Cell> v = new Vector<Cell>();
        Enumeration e = rootCells.elements();
        while (e.hasMoreElements()) {
            Cell c = (Cell)e.nextElement();
            v.add(c);
        }
        int i = 0;
        while (i < v.size()) {
            Cell cc = (Cell)v.elementAt(i);
            cc.removeFromParent();
            this.iRoot.add(cc);
            ++i;
        }
        this.iCellsByName.remove("P");
        this.iCellsByName.put("P", this.iRoot);
        this.iRoot.setEndTime(1);
    }

    public void setStartingCell(Cell c, int time) {
        System.out.println("setStartingCell, cell, time: " + c + ", " + time);
        if (c != this.iRoot) {
            if (c == null) {
                c = (Cell)this.iRoot.getChildAt(0);
            }
            while (c.getChildCount() > 0 && c.getTime() < 1) {
                c = (Cell)c.getChildAt(0);
            }
            time = Math.max(time, c.getTime());
            this.iImageTime = time = Math.min(time, c.getEndTime());
            this.iTimeInc = 0;
            this.getTimeAndPlane(c);
            this.getCurrentCellParameters();
            this.showTreeCell(this.iCurrentCell);
        } else {
            this.iImageTime = 1;
            this.iTimeInc = 0;
            this.iImagePlane = 15;
            this.iPlaneInc = 0;
        }
        this.handleCellSelectionChange(c, time - this.iImageTime);
        if (!c.getName().equals("P") && this.iRoot.getChildCount() > 0) {
            this.iShowCentroids = true;
            this.iShowC.setText(HIDEC);
            this.addMainAnnotation();
        }
        this.iAceMenuBar.setClearEnabled(true);
        if (this.iImgWin != null) {
            this.iImgWin.refreshDisplay(null);
        }
    }

    @Override
    public void run() {
        AceTree.println("AceTree.run: entered");
        try {
            Thread.sleep(5L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.nextImage();
        try {
            Thread.sleep(5L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.prevTime();
    }

    public void expandTree() {
        Cell c = (Cell)this.iRoot.getFirstLeaf();
        while (c != null) {
            this.showTreeCell(c);
            c = (Cell)c.getNextLeaf();
        }
    }

    private void setTreeSelectionMode() {
        this.iTree.getSelectionModel().setSelectionMode(1);
        ((DefaultTreeCellRenderer)this.iTree.getCellRenderer()).setOpenIcon(null);
        ((DefaultTreeCellRenderer)this.iTree.getCellRenderer()).setClosedIcon(null);
        ((DefaultTreeCellRenderer)this.iTree.getCellRenderer()).setLeafIcon(null);
    }

    private void displayTree() {
        this.iTree.getSelectionModel().setSelectionMode(1);
        ((DefaultTreeCellRenderer)this.iTree.getCellRenderer()).setOpenIcon(null);
        ((DefaultTreeCellRenderer)this.iTree.getCellRenderer()).setClosedIcon(null);
        ((DefaultTreeCellRenderer)this.iTree.getCellRenderer()).setLeafIcon(null);
        this.setLayout(new BoxLayout(this, 3));
        if (this.iSeriesLabel == null) {
            this.iSeriesLabel = new JLabel(TITLE);
            this.iSeriesLabel.setAlignmentX(0.5f);
        }
        this.add(this.iSeriesLabel);
        JPanel treev = new JPanel();
        treev.setLayout(new BorderLayout());
        JScrollPane treeView = new JScrollPane(this.iTree);
        treeView.setPreferredSize(new Dimension(330, 500));
        treeView.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        treev.add(treeView);
        this.add(treev);
        JPanel textv = new JPanel();
        textv.setLayout(new BorderLayout());
        textv.setMaximumSize(new Dimension(Integer.MAX_VALUE, 150));
        textv.setPreferredSize(new Dimension(330, 100));
        this.iText = new JTextPane();
        this.iText.setEditable(false);
        JScrollPane textView = new JScrollPane(this.iText);
        textView.setPreferredSize(new Dimension(330, 100));
        textv.add(textView);
        this.add(textv);
        this.iInputCtrl = new InputCtrl(this);
        this.add(this.iInputCtrl);
        this.iToolControls = new JPanel();
        this.iToolControls.setLayout(new BoxLayout(this.iToolControls, 3));
        this.iPlayerControl = new PlayerControl(this);
        this.iToolControls.add(this.iPlayerControl);
        JPanel pad = this.createPad();
        this.iToolControls.add(pad);
        JPanel textv2 = new JPanel();
        textv2.setLayout(new BorderLayout());
        textv2.setPreferredSize(new Dimension(165, 30));
        textv2.setMaximumSize(new Dimension(330, 30));
        this.iText2 = new JTextPane();
        this.iText2.setPreferredSize(new Dimension(165, 30));
        this.iText2.setEditable(false);
        textv2.add((Component)this.iText2, "West");
        this.iText3 = new JTextPane();
        this.iText3.setPreferredSize(new Dimension(165, 30));
        this.iText3.setEditable(false);
        this.iPlayerControl.addToToolbar(textv2);
    }

    private JPanel createPad() {
        JPanel p = new JPanel();
        this.iNext = new JButton(NEXTT);
        this.iPrev = new JButton(PREV);
        this.iUp = new JButton(UP);
        this.iDown = new JButton(DOWN);
        this.iDefault = this.iHome = new JButton(HOME);
        this.iMainFrame.getRootPane().setDefaultButton(this.iDefault);
        this.iNext.addActionListener(this);
        this.iPrev.addActionListener(this);
        this.iUp.addActionListener(this);
        this.iDown.addActionListener(this);
        this.iHome.addActionListener(this);
        p.setLayout(new BoxLayout(p, 2));
        this.iShow = new JButton(SHOW);
        this.iShowC = new JButton(SHOWC);
        this.iClear = new JButton(CLEAR);
        this.iShow.addActionListener(this);
        this.iShowC.addActionListener(this);
        this.iClear.addActionListener(this);
        JButton iDepthViews = new JButton(DEPTHVIEWS);
        iDepthViews.addActionListener(this);
        this.iCopy = new JButton(COPY);
        this.iCopy.addActionListener(this);
        this.iTrack = new JButton(TRACK);
        this.iTrack.addActionListener(this);
        this.iSister = new JButton(SISTER);
        this.iSister.addActionListener(this);
        this.iColorToggle = new JButton(COLORTOGGLE);
        this.iColorToggle.addActionListener(this);
        p.add(this.iShow);
        p.add(this.iClear);
        p.add(this.iShowC);
        p.add(iDepthViews);
        p.add(this.iTrack);
        p.add(this.iSister);
        p.add(this.iHome);
        return p;
    }

    private void setSpecialKeyboardActions() {
        KeyStroke key = null;
        String xxx = null;
        final AceTree aceTree = this;
        xxx = "ctrl_left";
        AbstractAction ctrl_left = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (AceTree.this.iAddOneDialog != null) {
                    ActionEvent ae = new ActionEvent(aceTree, 1, "LEFT");
                    AceTree.this.iAddOneDialog.actionPerformed(ae);
                }
            }
        };
        key = KeyStroke.getKeyStroke(37, 2, false);
        this.getInputMap(1).put(key, xxx);
        this.getActionMap().put(xxx, ctrl_left);
        xxx = "ctrl_left_a";
        AbstractAction ctrl_left_a = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (AceTree.this.iAddOneDialog != null) {
                    ActionEvent ae = new ActionEvent(aceTree, 1, "LEFT");
                    AceTree.this.iAddOneDialog.actionPerformed(ae);
                }
            }
        };
        key = KeyStroke.getKeyStroke(65, 2, false);
        this.getInputMap(1).put(key, xxx);
        this.getActionMap().put(xxx, ctrl_left);
        xxx = "ctrl_right";
        AbstractAction ctrl_right = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (AceTree.this.iAddOneDialog == null) {
                    return;
                }
                ActionEvent ae = new ActionEvent(aceTree, 1, "RIGHT");
                AceTree.this.iAddOneDialog.actionPerformed(ae);
            }
        };
        key = KeyStroke.getKeyStroke(39, 2, false);
        this.getInputMap(1).put(key, xxx);
        this.getActionMap().put(xxx, ctrl_right);
        xxx = "ctrl_right_d";
        AbstractAction ctrl_right_d = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (AceTree.this.iAddOneDialog == null) {
                    return;
                }
                ActionEvent ae = new ActionEvent(aceTree, 1, "RIGHT");
                AceTree.this.iAddOneDialog.actionPerformed(ae);
            }
        };
        key = KeyStroke.getKeyStroke(68, 2, false);
        this.getInputMap(1).put(key, xxx);
        this.getActionMap().put(xxx, ctrl_right);
        xxx = "ctrl_up";
        AbstractAction ctrl_up = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (AceTree.this.iAddOneDialog == null) {
                    return;
                }
                ActionEvent ae = new ActionEvent(aceTree, 1, "UP");
                AceTree.this.iAddOneDialog.actionPerformed(ae);
            }
        };
        key = KeyStroke.getKeyStroke(38, 2, false);
        this.getInputMap(1).put(key, xxx);
        this.getActionMap().put(xxx, ctrl_up);
        xxx = "ctrl_up_w";
        AbstractAction ctrl_up_w = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (AceTree.this.iAddOneDialog == null) {
                    return;
                }
                ActionEvent ae = new ActionEvent(aceTree, 1, "UP");
                AceTree.this.iAddOneDialog.actionPerformed(ae);
            }
        };
        key = KeyStroke.getKeyStroke(87, 2, false);
        this.getInputMap(1).put(key, xxx);
        this.getActionMap().put(xxx, ctrl_up);
        xxx = "ctrl_down";
        AbstractAction ctrl_down = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (AceTree.this.iAddOneDialog == null) {
                    return;
                }
                ActionEvent ae = new ActionEvent(aceTree, 1, "DOWN");
                AceTree.this.iAddOneDialog.actionPerformed(ae);
            }
        };
        key = KeyStroke.getKeyStroke(40, 2, false);
        this.getInputMap(1).put(key, xxx);
        this.getActionMap().put(xxx, ctrl_down);
        xxx = "ctrl_down_s";
        AbstractAction ctrl_down_s = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (AceTree.this.iAddOneDialog == null) {
                    return;
                }
                ActionEvent ae = new ActionEvent(aceTree, 1, "DOWN");
                AceTree.this.iAddOneDialog.actionPerformed(ae);
            }
        };
        key = KeyStroke.getKeyStroke(83, 2, false);
        this.getInputMap(1).put(key, xxx);
        this.getActionMap().put(xxx, ctrl_down);
        xxx = "shift_left";
        AbstractAction shift_left = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (AceTree.this.iAddOneDialog == null) {
                    return;
                }
                ActionEvent ae = new ActionEvent(aceTree, 1, "BIG");
                AceTree.this.iAddOneDialog.actionPerformed(ae);
            }
        };
        key = KeyStroke.getKeyStroke(37, 1, false);
        this.getInputMap(1).put(key, xxx);
        this.getActionMap().put(xxx, shift_left);
        xxx = "shift_left_a";
        AbstractAction shift_left_a = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (AceTree.this.iAddOneDialog == null) {
                    return;
                }
                ActionEvent ae = new ActionEvent(aceTree, 1, "BIG");
                AceTree.this.iAddOneDialog.actionPerformed(ae);
            }
        };
        key = KeyStroke.getKeyStroke(65, 1, false);
        this.getInputMap(1).put(key, xxx);
        this.getActionMap().put(xxx, shift_left);
        xxx = "shift_right";
        AbstractAction shift_right = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (AceTree.this.iAddOneDialog == null) {
                    return;
                }
                ActionEvent ae = new ActionEvent(aceTree, 1, "SMALL");
                AceTree.this.iAddOneDialog.actionPerformed(ae);
            }
        };
        key = KeyStroke.getKeyStroke(39, 1, false);
        this.getInputMap(1).put(key, xxx);
        this.getActionMap().put(xxx, shift_right);
        xxx = "shift_right_d";
        AbstractAction shift_right_d = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (AceTree.this.iAddOneDialog == null) {
                    return;
                }
                ActionEvent ae = new ActionEvent(aceTree, 1, "SMALL");
                AceTree.this.iAddOneDialog.actionPerformed(ae);
            }
        };
        key = KeyStroke.getKeyStroke(68, 1, false);
        this.getInputMap(1).put(key, xxx);
        this.getActionMap().put(xxx, shift_right);
        xxx = "shift_up";
        AbstractAction shift_up = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (AceTree.this.iAddOneDialog == null) {
                    return;
                }
                ActionEvent ae = new ActionEvent(aceTree, 1, "DECZ");
                AceTree.this.iAddOneDialog.actionPerformed(ae);
            }
        };
        key = KeyStroke.getKeyStroke(38, 1, false);
        this.getInputMap(1).put(key, xxx);
        this.getActionMap().put(xxx, shift_up);
        xxx = "shift_up_w";
        AbstractAction shift_up_w = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (AceTree.this.iAddOneDialog == null) {
                    return;
                }
                ActionEvent ae = new ActionEvent(aceTree, 1, "DECZ");
                AceTree.this.iAddOneDialog.actionPerformed(ae);
            }
        };
        key = KeyStroke.getKeyStroke(87, 1, false);
        this.getInputMap(1).put(key, xxx);
        this.getActionMap().put(xxx, shift_up);
        xxx = "shift_down";
        AbstractAction shift_down = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (AceTree.this.iAddOneDialog == null) {
                    return;
                }
                ActionEvent ae = new ActionEvent(aceTree, 1, "INCZ");
                AceTree.this.iAddOneDialog.actionPerformed(ae);
            }
        };
        key = KeyStroke.getKeyStroke(40, 1, false);
        this.getInputMap(1).put(key, xxx);
        this.getActionMap().put(xxx, shift_down);
        xxx = "shift_down_s";
        AbstractAction shift_down_s = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (AceTree.this.iAddOneDialog == null) {
                    return;
                }
                ActionEvent ae = new ActionEvent(aceTree, 1, "INCZ");
                AceTree.this.iAddOneDialog.actionPerformed(ae);
            }
        };
        key = KeyStroke.getKeyStroke(83, 1, false);
        this.getInputMap(1).put(key, xxx);
        this.getActionMap().put(xxx, shift_down);
        xxx = "DELETE";
        AbstractAction DELETE = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (AceTree.this.iAddOneDialog == null) {
                    return;
                }
                AceTree.this.killCell(0);
            }
        };
        key = KeyStroke.getKeyStroke(127, 0, false);
        this.getInputMap(1).put(key, xxx);
        this.getActionMap().put(xxx, DELETE);
        xxx = "BACKSPACE";
        AbstractAction BACKSPACE = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (AceTree.this.iAddOneDialog == null) {
                    return;
                }
                AceTree.this.killCell(0);
            }
        };
        key = KeyStroke.getKeyStroke(8, 0, false);
        this.getInputMap(1).put(key, xxx);
        this.getActionMap().put(xxx, BACKSPACE);
        xxx = "F5";
        AbstractAction F5 = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (AceTree.this.iAddOneDialog == null) {
                    return;
                }
                ActionEvent ae = new ActionEvent(aceTree, 1, "rebuildAndRename");
                AceTree.this.iAddOneDialog.actionPerformed(ae);
            }
        };
        key = KeyStroke.getKeyStroke(116, 0, false);
        this.getInputMap(1).put(key, xxx);
        this.getActionMap().put(xxx, F5);
        xxx = "F1";
        AbstractAction F1 = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (AceTree.this.iNucRelinkDialog == null) {
                    return;
                }
                ActionEvent ae = new ActionEvent(aceTree, 1, "Use Active Cell");
                AceTree.this.iNucRelinkDialog.actionPerformed(ae);
            }
        };
        key = KeyStroke.getKeyStroke(112, 0, false);
        this.getInputMap(1).put(key, xxx);
        this.getActionMap().put(xxx, F1);
        xxx = "F2";
        AbstractAction F2 = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (AceTree.this.iNucRelinkDialog == null) {
                    return;
                }
                ActionEvent ae = new ActionEvent(aceTree, 1, "Use Active Cell ");
                AceTree.this.iNucRelinkDialog.actionPerformed(ae);
            }
        };
        key = KeyStroke.getKeyStroke(113, 0, false);
        this.getInputMap(1).put(key, xxx);
        this.getActionMap().put(xxx, F2);
        xxx = "F3";
        AbstractAction F3 = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (AceTree.this.iNucRelinkDialog == null) {
                    return;
                }
                ActionEvent ae = new ActionEvent(aceTree, 1, "old apply only");
                AceTree.this.iNucRelinkDialog.actionPerformed(ae);
            }
        };
        key = KeyStroke.getKeyStroke(114, 0, false);
        this.getInputMap(1).put(key, xxx);
        this.getActionMap().put(xxx, F3);
        xxx = "F4";
        AbstractAction F4 = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (AceTree.this.iNucRelinkDialog == null) {
                    return;
                }
                ActionEvent ae = new ActionEvent(aceTree, 1, "Apply");
                AceTree.this.iNucRelinkDialog.actionPerformed(ae);
            }
        };
        key = KeyStroke.getKeyStroke(115, 0, false);
        this.getInputMap(1).put(key, xxx);
        this.getActionMap().put(xxx, F4);
    }

    private void setKeyboardActions() {
        this.setSpecialKeyboardActions();
        String actionKey = "";
        KeyStroke stroke = null;
        InputMap inputMap = null;
        ActionMap actionMap = null;
        String s = "PAGE_UP";
        AbstractAction PageUp = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (AceTree.this.iShow.getText().equals(AceTree.HIDE)) {
                    AceTree.this.setShowAnnotations(false);
                } else {
                    AceTree.this.setShowAnnotations(true);
                }
                AceTree.this.updateDisplay();
            }
        };
        this.getInputMap(1).put(KeyStroke.getKeyStroke("PAGE_UP"), "PAGE_UP");
        this.getActionMap().put(s, PageUp);
        s = "PAGE_DOWN";
        AbstractAction PageDn = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (AceTree.this.iShowC.getText().equals(AceTree.HIDEC)) {
                    AceTree.this.iShowCentroids = false;
                    AceTree.this.iShowC.setText(AceTree.SHOWC);
                } else {
                    AceTree.this.iShowCentroids = true;
                    AceTree.this.iShowC.setText(AceTree.HIDEC);
                }
                AceTree.this.updateDisplay();
            }
        };
        this.getInputMap(1).put(KeyStroke.getKeyStroke(s), s);
        this.getActionMap().put(s, PageDn);
        s = "END";
        AbstractAction end = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AceTree.this.copyImage();
            }
        };
        this.getInputMap(1).put(KeyStroke.getKeyStroke(s), s);
        this.getActionMap().put(s, end);
        s = "HOME";
        AbstractAction home = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AceTree.this.iPlaneInc = 0;
                AceTree.this.iTimeInc = 0;
                AceTree.this.updateDisplay();
            }
        };
        this.getInputMap(1).put(KeyStroke.getKeyStroke(s), s);
        this.getActionMap().put(s, home);
        s = "UP";
        AbstractAction up = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AceTree.this.incPlane(-1);
                AceTree.this.iTrackPosition = ImageWindow.NONE;
                AceTree.this.updateDisplay();
            }
        };
        this.getInputMap(1).put(KeyStroke.getKeyStroke(s), s);
        this.getActionMap().put(s, up);
        actionKey = "w_up";
        stroke = KeyStroke.getKeyStroke("typed w");
        inputMap = this.getInputMap(1);
        inputMap.put(stroke, actionKey);
        this.getActionMap().put(actionKey, up);
        s = "shift UP";
        AbstractAction shift_up = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AceTree.this.incPlane(-5);
                AceTree.this.iTrackPosition = ImageWindow.NONE;
                AceTree.this.updateDisplay();
            }
        };
        this.getInputMap(1).put(KeyStroke.getKeyStroke(s), s);
        this.getActionMap().put(s, shift_up);
        s = "DOWN";
        AbstractAction down = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AceTree.this.incPlane(1);
                AceTree.this.iTrackPosition = ImageWindow.NONE;
                AceTree.this.updateDisplay();
            }
        };
        this.getInputMap(1).put(KeyStroke.getKeyStroke(s), s);
        this.getActionMap().put(s, down);
        actionKey = "s_down";
        stroke = KeyStroke.getKeyStroke("typed s");
        inputMap = this.getInputMap(1);
        inputMap.put(stroke, actionKey);
        actionMap = this.getActionMap();
        actionMap.put(actionKey, down);
        s = "shift DOWN";
        AbstractAction shift_down = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AceTree.this.incPlane(5);
                AceTree.this.iTrackPosition = ImageWindow.NONE;
                AceTree.this.updateDisplay();
            }
        };
        this.getInputMap(1).put(KeyStroke.getKeyStroke(s), s);
        this.getActionMap().put(s, shift_down);
        s = "LEFT";
        AbstractAction left = new AbstractAction("LEFT"){

            @Override
            public void actionPerformed(ActionEvent e) {
                AceTree.this.prevImage();
            }
        };
        this.getInputMap(1).put(KeyStroke.getKeyStroke(s), s);
        this.getActionMap().put(s, left);
        actionKey = "a_left";
        stroke = KeyStroke.getKeyStroke("typed a");
        inputMap = this.getInputMap(1);
        inputMap.put(stroke, actionKey);
        actionMap = this.getActionMap();
        actionMap.put(actionKey, left);
        s = "shift LEFT";
        AbstractAction shift_left = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AceTree.this.prevImageFast();
            }
        };
        this.getInputMap(1).put(KeyStroke.getKeyStroke(s), s);
        this.getActionMap().put(s, shift_left);
        s = "RIGHT";
        AbstractAction right = new AbstractAction(s){

            @Override
            public void actionPerformed(ActionEvent e) {
                AceTree.this.nextImage();
            }
        };
        this.getInputMap(1).put(KeyStroke.getKeyStroke(s), s);
        this.getActionMap().put(s, right);
        actionKey = "d_right";
        stroke = KeyStroke.getKeyStroke("typed d");
        inputMap = this.getInputMap(1);
        inputMap.put(stroke, actionKey);
        actionMap = this.getActionMap();
        actionMap.put(actionKey, right);
        s = "shift RIGHT";
        AbstractAction shift_right = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AceTree.this.nextImageFast();
            }
        };
        this.getInputMap(1).put(KeyStroke.getKeyStroke(s), s);
        this.getActionMap().put(s, shift_right);
        s = "ENTER";
        AbstractAction get = new AbstractAction(s){

            @Override
            public void actionPerformed(ActionEvent e) {
                AceTree.this.iInputCtrl.getIt();
                AceTree.this.updateDisplay();
            }
        };
        this.getInputMap(1).put(KeyStroke.getKeyStroke(s), s);
        this.getActionMap().put(s, get);
    }

    private void setDefaultKeyboardActions() {
        String s = "F2";
        AbstractAction home = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AceTree.println("setDefaultKeyboardActions, ");
                Component compFocusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
                Window windowFocusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusedWindow();
                if (compFocusOwner instanceof JButton) {
                    AceTree.println("its a button");
                }
                AceTree.println("setKeyboardActions, " + compFocusOwner);
            }
        };
        this.iDefault.getInputMap(2).put(KeyStroke.getKeyStroke(s), s);
        this.iDefault.getActionMap().put(s, home);
    }

    private void handleCellSelectionChange(Cell c, int timeInc) {
        if (c == null) {
            return;
        }
        this.getTimeAndPlane(c);
        this.iTimeInc = timeInc;
        this.iPlaneInc = 0;
        if (this.iImageTime < 1 || this.iImagePlane < 1) {
            return;
        }
        this.updateDisplay();
    }

    private void getTimeAndPlane(Cell c) {
        if (c == null) {
            return;
        }
        if (c == this.iRoot) {
            this.iImageTime = 1;
            this.iImagePlane = 15;
        } else {
            this.iImageTime = c.getTime();
            this.iImagePlane = (int)((double)c.getPlane() + 0.5);
        }
        this.iTimeInc = 0;
        this.iPlaneInc = 0;
        this.iCurrentCell = c;
    }

    public void updateDisplay() {
        if (this.iDebugTest) {
            AceTree.println("updateDisplay:1 " + System.currentTimeMillis());
        }
        if (this.iImageTime + this.iTimeInc < this.iStartingIndex) {
            return;
        }
        if (this.iImagePlane + this.iPlaneInc <= 0) {
            this.iPlaneInc = -1 * this.iImagePlane + 1;
        }
        this.getCurrentCellParameters();
        this.handleImage();
        if (this.iCallSaveImage) {
            this.iCallSaveImage = false;
            if (this.iImgWin != null) {
                this.iImgWin.saveImageIfEnabled();
            }
        }
        String s = this.makeDisplayText();
        this.iText.setText(s);
        if (this.iDebugTest) {
            this.debugTest(false);
            AceTree.println("updateDisplay:2 " + System.currentTimeMillis());
        }
        if (this.iAddOneDialog != null) {
            this.iAddOneDialog.updateCellInfo();
        }
    }

    public void handleImage() {
        String cfile = this.makeImageName();
        ImagePlus ip = null;
        ImageWindow.setUseStack(this.iUseStack);
        if (cfile == null) {
            ImageWindow.makeImage(null);
            return;
        }
        if (this.iImgWin != null) {
            try {
                ip = this.iImgWin.refreshDisplay(String.valueOf(this.iTifPrefix) + cfile);
            }
            catch (Exception e) {
                System.out.println("handleImage -- no image available: " + this.iTifPrefix + cfile);
                System.out.println(e);
                e.printStackTrace();
                this.iPlayerControl.pause();
            }
        } else {
            System.out.println("\nhandleImage making new one: " + ip + ", " + this.iTifPrefix + ", " + cfile);
            ip = ImageWindow.makeImage2(String.valueOf(this.iTifPrefix) + cfile, this.getImagePlane(), this.getUseStack());
            try {
                this.iImgWin = new ImageWindow(String.valueOf(this.iTifPrefix) + cfile, ip, this.iPlayerControl);
                this.iImgWin.setAceTree(this);
                if (this.iBookmarkJList != null) {
                    this.iImgWin.setBookmarkList(this.iBookmarkJList.getModel());
                }
                this.iImgWin.add((Component)this.iToolControls, "South");
                this.iImgWin.pack();
                this.iImgWinSet = true;
            }
            catch (Throwable t) {
                new GeneralStartupError(this.getMainFrame(), t);
            }
        }
    }

    public void addMainAnnotation() {
        if (this.iCurrentCellXloc <= 0) {
            return;
        }
        if (this.iImgWin != null) {
            this.iImgWin.addAnnotation(this.iCurrentCellXloc, this.iCurrentCellYloc, true);
        }
    }

    public String makeImageName() {
        return this.imageNameHandler(this.iImageTime + this.iTimeInc, this.iImagePlane + this.iPlaneInc);
    }

    public String makeImageName(int time, int plane) {
        return this.imageNameHandler(time, plane);
    }

    public boolean checkExists(File f) {
        return f.exists();
    }

    public String imageNameHandler(int time, int plane) {
        StringBuffer namebuf = new StringBuffer("t");
        namebuf.append(EUtils.makePaddedInt(time));
        namebuf.append("-p");
        String p = EUtils.makePaddedInt(plane, 2);
        namebuf.append(p);
        String original_name = namebuf.toString();
        StringBuffer namebuf2 = new StringBuffer("t");
        namebuf2.append(String.valueOf(time));
        String new_name = namebuf2.toString();
        if (this.iFileNameType == 0) {
            switch (1) {
                default: 
            }
            if (this.checkExists(new File(String.valueOf(this.iZipTifFilePath) + "/" + this.iTifPrefix + original_name + ".tif"))) {
                this.iFileNameType = 1;
            } else if (this.checkExists(new File(String.valueOf(this.iZipTifFilePath) + "/" + this.iTifPrefix + new_name + ".TIF"))) {
                this.iFileNameType = 8;
            } else if (this.checkExists(new File(String.valueOf(this.iZipTifFilePath) + "/" + this.iTifPrefix + original_name + ".TIF"))) {
                this.iFileNameType = 2;
            } else if (this.checkExists(new File(String.valueOf(this.iZipTifFilePath) + "/" + this.iTifPrefix + original_name + ".tiff"))) {
                this.iFileNameType = 3;
            } else if (this.checkExists(new File(String.valueOf(this.iZipTifFilePath) + "/" + this.iTifPrefix + original_name + ".TIFF"))) {
                this.iFileNameType = 4;
            } else if (this.checkExists(new File(String.valueOf(this.iZipTifFilePath) + "/" + this.iTifPrefix + original_name + ".zip"))) {
                this.iFileNameType = 5;
            } else if (this.checkExists(new File(String.valueOf(this.iZipTifFilePath) + "/" + this.iTifPrefix + original_name + ".ZIP"))) {
                this.iFileNameType = 6;
            } else if (this.checkExists(new File(String.valueOf(this.iZipTifFilePath) + "/" + this.iTifPrefix + new_name + ".tif"))) {
                this.iFileNameType = 7;
            } else if (this.checkExists(new File(String.valueOf(this.iZipTifFilePath) + "/" + this.iTifPrefix + new_name + ".tiff"))) {
                this.iFileNameType = 9;
            } else if (this.checkExists(new File(String.valueOf(this.iZipTifFilePath) + "/" + this.iTifPrefix + new_name + ".TIFF"))) {
                this.iFileNameType = 10;
            } else if (this.checkExists(new File(String.valueOf(this.iZipTifFilePath) + "/" + this.iTifPrefix + new_name + ".zip"))) {
                this.iFileNameType = 11;
            } else if (this.checkExists(new File(String.valueOf(this.iZipTifFilePath) + "/" + this.iTifPrefix + new_name + ".ZIP"))) {
                this.iFileNameType = 12;
            }
        }
        switch (this.iFileNameType) {
            case 1: {
                return String.valueOf(original_name) + ".tif";
            }
            case 8: {
                return String.valueOf(new_name) + ".TIF";
            }
            case 2: {
                return String.valueOf(original_name) + ".TIF";
            }
            case 3: {
                return String.valueOf(original_name) + ".tiff";
            }
            case 4: {
                return String.valueOf(original_name) + ".TIFF";
            }
            case 5: {
                return String.valueOf(original_name) + ".zip";
            }
            case 6: {
                return String.valueOf(original_name) + ".ZIP";
            }
            case 7: {
                return String.valueOf(new_name) + ".tif";
            }
            case 9: {
                return String.valueOf(new_name) + ".tiff";
            }
            case 10: {
                return String.valueOf(new_name) + ".TIFF";
            }
            case 11: {
                return String.valueOf(new_name) + ".zip";
            }
            case 12: {
                return String.valueOf(new_name) + ".ZIP";
            }
        }
        return null;
    }

    private int trackCellPlane() {
        if (this.iTrackPosition != ImageWindow.NONE) {
            this.iPlaneInc = 0;
            return (int)((double)this.iCurrentCellZloc + 0.5);
        }
        return this.iImagePlane;
    }

    private void getCurrentCellParameters() {
        if (this.iCurrentCell == null) {
            return;
        }
        int time = this.iImageTime + this.iTimeInc;
        if (time == 0) {
            time = 1;
            this.iImageTime = 1;
        }
        Nucleus n = null;
        try {
            Vector nuclei = this.iNucleiMgr.getElementAt(time - 1);
            n = NucUtils.getCurrentCellNucleus(nuclei, this.iCurrentCell);
        }
        catch (Exception e) {
            System.out.println("AceTree.getCurrentCellParameters error at time=" + time);
        }
        this.iCurrentCellXloc = -1;
        this.iCurrentCellYloc = -1;
        this.iCurrentCellZloc = -1.0f;
        this.iCurrentCellPresent = false;
        if (n != null) {
            this.iCurrentCellXloc = n.x;
            this.iCurrentCellYloc = n.y;
            this.iCurrentCellZloc = n.z;
            this.iImagePlane = this.trackCellPlane();
            this.iCurrentCellPresent = true;
        }
    }

    private String getRedDataFromCell(int time) {
        Vector vcd = this.iCurrentCell.getCellData();
        int item = time - this.iCurrentCell.getTime();
        CellData cd = (CellData)vcd.elementAt(item);
        String s = ", rweight: " + cd.iNucleus.rweight;
        return s;
    }

    private String makeDisplayText() {
        int time = this.iImageTime + this.iTimeInc;
        Vector nuclei = this.iNucleiMgr.getElementAt(time - 1);
        String name = "";
        if (this.iCurrentCell != null) {
            name = this.iCurrentCell.getName();
        }
        StringBuffer sb2 = new StringBuffer();
        if (this.iCurrentCell == null) {
            this.iCurrentCellPresent = false;
        }
        if (this.iCurrentCellPresent) {
            sb2.append(String.valueOf(name) + " is one of ");
            sb2.append(String.valueOf(NucUtils.countLiveCells(nuclei)) + " cells at time " + (this.iImageTime + this.iTimeInc));
            Nucleus n = NucUtils.getCurrentCellNucleus(nuclei, this.iCurrentCell);
            if (n != null) {
                String track;
                sb2.append("\nlocation: " + this.iCurrentCellXloc + ", " + this.iCurrentCellYloc + ", " + n.z);
                double d = this.iNucleiMgr.nucDiameter(n, this.iImagePlane + this.iPlaneInc);
                String sd = new DecimalFormat("###.#").format(d);
                sb2.append("\nsize: " + n.size + " displayed diameter: " + sd);
                sb2.append("\ncurrent index: " + n.index);
                sb2.append(" weightg/r: " + n.weight);
                sb2.append(", " + n.rweight);
                sb2.append("\nstart=" + this.iCurrentCell.getTime());
                sb2.append(", end=" + this.iCurrentCell.getEnd());
                sb2.append(", fate=" + this.iCurrentCell.getFate());
                switch (this.iTrackPosition) {
                    case 1: {
                        track = "\ntrack anterior";
                        break;
                    }
                    case 2: {
                        track = "\ntrack posterior";
                        break;
                    }
                    default: {
                        track = "\nnot tracking";
                    }
                }
                sb2.append(track);
            }
        } else {
            sb2.append(String.valueOf(name) + " not present");
        }
        return sb2.toString();
    }

    public void setConfigFileName(String name) {
        this.iConfigFileName = name;
        if (this.iBookmarkDialog != null) {
            this.iBookmarkDialog.setPath(this.iConfigFileName);
        }
    }

    public void quickOpen() {
        AceTree.println("AceTree.quickOpen");
        new QuickOpen();
    }

    public String getConfigFileName() {
        return this.iConfigFileName;
    }

    private void copyImage() {
        ImagePlus ip = this.iImgWin.getImagePlus();
        String s = String.valueOf(this.iTifPrefix) + this.makeImageName() + Math.random();
        ImageWindow iw = new ImageWindow(s, ip, this.iPlayerControl);
        iw.setDefaultCloseOperation(2);
        iw.setAceTree(this);
        iw.setLocation(iw.getX() + 8, iw.getY() + 12);
        iw.removeHandlers();
        iw.setAceTree(null);
        iw = null;
    }

    public void editImage3() {
    }

    public void editTools() {
        this.relinkNucleus();
        if (this.iAddOneDialog != null) {
            return;
        }
        this.iEditTools = true;
        this.iAddOneDialog = new AddOneDialog(this, this.iImgWin, false, this.iCurrentCell, this.iImageTime);
        this.iImgWin.iDialog = this.iAddOneDialog;
    }

    public synchronized void bookmarkTool() {
        if (this.iBookmarkDialog != null) {
            this.iBookmarkDialog.displayWindow();
        } else {
            this.iBookmarkDialog = new BookmarkDialog(this.iConfigFileName);
            this.iBookmarkJList = this.iBookmarkDialog.getJList();
            this.iBookmarkJList.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent me) {
                    String selected = (String)AceTree.this.iBookmarkJList.getSelectedValue();
                    if (selected != null) {
                        try {
                            Cell c = (Cell)AceTree.this.iAncesTree.getCellsByName().get(selected);
                            if (c != null) {
                                System.out.println("Setting active cell to: " + selected);
                                AceTree.this.showTreeCell(c);
                                if (c.getTime() < 0) {
                                    if (AceTree.this.iCurrentCell != null) {
                                        c = AceTree.this.iCurrentCell;
                                    } else {
                                        return;
                                    }
                                }
                                int time = c.getTime();
                                AceTree.this.setCurrentCell(c, time, 1);
                            }
                        }
                        catch (NullPointerException npe) {
                            return;
                        }
                    }
                }
            });
            if (this.iImgWin != null) {
                this.iImgWin.setBookmarkList(this.iBookmarkJList.getModel());
            }
            this.iAddActiveCell = this.iBookmarkDialog.getAddButton();
            this.iAddActiveCell.addActionListener(this);
            if (this.iSulstonTree != null) {
                this.iSulstonTree.setBookmarkList(this.iBookmarkJList.getModel());
            }
        }
    }

    public void cellMovementImage() {
        String s1;
        ImagePlus ip = this.iImgWin.getImagePlus();
        String s = s1 = String.valueOf(this.iTifPrefix) + this.makeImageName();
        this.iCellMovementImage = new CellMovementImage(s, ip);
    }

    public void setEditImageNull(int which) {
        switch (which) {
            case 1: {
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                this.iCellMovementImage = null;
            }
        }
    }

    public void valueChanged(TreeSelectionEvent e) {
    }

    public void imageUp() {
        this.incPlane(-1);
        this.iTrackPosition = ImageWindow.NONE;
        this.iCallSaveImage = true;
        this.updateDisplay();
    }

    public void imageDown() {
        this.incPlane(1);
        this.iTrackPosition = ImageWindow.NONE;
        this.iCallSaveImage = true;
        this.updateDisplay();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.iAddActiveCell) {
            try {
                if (this.iCurrentCell != null || !this.iCurrentCell.equals("")) {
                    String name = this.iCurrentCell.getName();
                    this.iBookmarkDialog.addCell(name);
                }
            }
            catch (NullPointerException npe) {
                return;
            }
            return;
        }
        AceTree.println("AceTree.actionPerformed, " + e);
        boolean doUpdate = true;
        if (!this.iImgWinSet) {
            return;
        }
        this.iImgWin.setSpecialEffect(null);
        String cmd = e.getActionCommand();
        boolean inc = false;
        if (e.getActionCommand().equals(NEXTT)) {
            doUpdate = this.nextTime();
        } else if (cmd.equals("F2")) {
            AceTree.println("AceTree.actionPerformed, F2");
        } else if (e.getActionCommand().equals(PREV)) {
            this.prevImage();
        } else {
            if (e.getActionCommand().equals(UP)) {
                this.imageUp();
                return;
            }
            if (e.getActionCommand().equals(DOWN)) {
                this.imageDown();
                return;
            }
            if (e.getActionCommand().equals(HOME)) {
                this.getTimeAndPlane(this.iCurrentCell);
                this.iTrackPosition = this.iCurrentCell.isAnterior() ? ImageWindow.ANTERIOR : ImageWindow.POSTERIOR;
            } else if (e.getActionCommand().equals(SHOW)) {
                this.setShowAnnotations(true);
            } else if (e.getActionCommand().equals(HIDE)) {
                this.setShowAnnotations(false);
            } else if (e.getActionCommand().equals(SHOWC)) {
                this.iShowCentroids = true;
                this.iShowC.setText(HIDEC);
            } else if (e.getActionCommand().equals(HIDEC)) {
                this.iShowCentroids = false;
                this.iShowC.setText(SHOWC);
            } else if (e.getActionCommand().equals(CLEAR)) {
                this.setShowAnnotations(false);
                this.iImgWin.clearAnnotations();
            } else if (!e.getActionCommand().equals(COPY)) {
                if (e.getActionCommand().equals(DEPTHVIEWS)) {
                    new DepthViews("");
                } else if (e.getActionCommand().equals(EDIT)) {
                    this.editImage3();
                } else if (e.getSource() == this.iTrack) {
                    this.setTrack();
                } else if (e.getSource() == this.iSister) {
                    this.handleSisterRequest();
                } else if (e.getSource() == this.iColorToggle) {
                    this.toggleColor();
                }
            }
        }
        if (doUpdate) {
            this.updateDisplay();
        }
    }

    public void toggleColor() {
        this.iColor = (this.iColor + 1) % 4;
    }

    public int getColor() {
        return this.iColor;
    }

    private void setTrack() {
        if (this.iTrackPosition != ImageWindow.NONE) {
            this.iTrackPositionSave = this.iTrackPosition;
            this.iTrackPosition = ImageWindow.NONE;
        } else {
            this.iTrackPosition = this.iTrackPositionSave;
        }
    }

    public void forceTrackingOn() {
        this.iTrackPosition = ImageWindow.ANTERIOR;
        this.iTrackPositionSave = ImageWindow.POSTERIOR;
    }

    @Override
    public void controlCallback(Vector v) {
        if (this.iImgWin == null) {
            return;
        }
        this.iImgWin.setSpecialEffect(null);
        String ctrl = (String)v.elementAt(0);
        boolean haveTime = false;
        boolean haveCellName = false;
        boolean haveCellIndex = false;
        if (ctrl.equals("InputCtrl1")) {
            boolean valid;
            String time = ((String)v.elementAt(1)).trim();
            int requestedTime = -1;
            Vector v2 = null;
            try {
                requestedTime = Integer.parseInt(time);
                v2 = this.iNucleiMgr.getElementAt(requestedTime - 1);
                haveTime = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
            String cell = ((String)v.elementAt(2)).trim();
            String target = cell.toLowerCase();
            String cellproper = PartsList.lookupProper(cell);
            System.out.println("ControlCallback looked up cell, proper: " + cell + ", " + cellproper);
            if (cellproper != null) {
                target = cellproper.toLowerCase();
            }
            boolean numeric = false;
            if (cell.length() > 0) {
                numeric = Character.isDigit(cell.charAt(0));
                if (numeric) {
                    haveCellIndex = true;
                } else {
                    haveCellName = true;
                }
            }
            boolean bl = valid = haveCellName || haveTime;
            if (!valid) {
                AceTree.println("controlCallback: invalid choice");
                return;
            }
            Cell c = null;
            if (numeric) {
                int index = Integer.parseInt(cell);
                try {
                    cell = ((Nucleus)v2.elementAt((int)(index - 1))).identity;
                    c = (Cell)this.iAncesTree.getCellsByName().get(cell);
                    c = null;
                }
                catch (ArrayIndexOutOfBoundsException aiob) {
                    System.out.println("bad cell index: " + cell);
                    return;
                }
                catch (Exception e) {
                    System.out.println("ControlCallback: " + e);
                    return;
                }
            } else if (target.length() > 0) {
                c = (Cell)this.iAncesTree.getCellsByNameLowerCase().get(target);
                if (c == null) {
                    System.out.println("Couldn't get cell from hash");
                }
            } else {
                c = null;
            }
            Cell csave = null;
            if (c != null) {
                if (!haveTime) {
                    requestedTime = c.getEnd();
                }
            } else if (haveTime) {
                int i = 0;
                while (i < v2.size()) {
                    Nucleus n = (Nucleus)v2.get(i);
                    c = null;
                    if (n.status > 0) {
                        c = (Cell)this.iAncesTree.getCellsByName().get(n.identity);
                        if (csave == null) {
                            csave = c;
                        }
                        if (n.z > 15.0f && n.z < 18.0f) break;
                    }
                    ++i;
                }
                if (c == null) {
                    c = csave;
                }
            }
            this.setCurrentCell(c, requestedTime, 4);
            System.out.println(this.transformTitle());
            this.addNext3D();
        }
    }

    public void controlCallback(Vector v, int oldversion) {
        this.iImgWin.setSpecialEffect(null);
        String ctrl = (String)v.elementAt(0);
        if (ctrl.equals("InputCtrl1")) {
            String time = ((String)v.elementAt(1)).trim();
            int requestedTime = -1;
            Vector v2 = null;
            try {
                requestedTime = Integer.parseInt(time);
                v2 = this.iNucleiMgr.getElementAt(requestedTime - 1);
            }
            catch (Exception e) {
                System.out.println("bad image time: " + time);
                return;
            }
            String cell = ((String)v.elementAt(2)).trim();
            boolean numeric = Character.isDigit(cell.charAt(0));
            Cell c = null;
            if (numeric) {
                int index = Integer.parseInt(cell);
                try {
                    cell = ((Nucleus)v2.elementAt((int)(index - 1))).identity;
                    c = (Cell)this.iAncesTree.getCellsByName().get(cell);
                }
                catch (ArrayIndexOutOfBoundsException aiob) {
                    System.out.println("bad cell index: " + cell);
                    return;
                }
                catch (Exception e) {
                    System.out.println("ControlCallback: " + e);
                    return;
                }
            } else {
                c = (Cell)this.iAncesTree.getCellsByName().get(cell);
            }
            if (c == null) {
                System.out.println("bad cell name: " + cell);
                return;
            }
            this.setCurrentCell(c, requestedTime, 4);
        }
    }

    public Cell getCellByName(String name) {
        if (this.iAncesTree == null) {
            return null;
        }
        return (Cell)this.iAncesTree.getCellsByName().get(name);
    }

    public Cell getCellByHash(String hashKey) {
        return (Cell)this.iAncesTree.getCells().get(hashKey);
    }

    public AncesTree getAncesTree() {
        return this.iAncesTree;
    }

    public JTree getJTree() {
        return this.iTree;
    }

    public NucleiMgr getNucleiMgr() {
        return this.iNucleiMgr;
    }

    public boolean nextTime() {
        if (this.iImageTime + this.iTimeInc == this.iEndingIndex) {
            return false;
        }
        ++this.iTimeInc;
        this.iCallSaveImage = true;
        int now = this.iImageTime + this.iTimeInc;
        int end = 9999;
        if (this.iCurrentCell != null) {
            end = this.iCurrentCell.getEnd();
        }
        if (now <= end) {
            return true;
        }
        if (this.iCurrentCell.getFateInt() == 2) {
            this.iCurrentCellPresent = false;
            this.iImageTime += this.iTimeInc;
            this.iTimeInc = 0;
            this.iTrackPosition = ImageWindow.NONE;
            return true;
        }
        this.setCurrentCell(this.iCurrentCell, now, 5);
        return true;
    }

    public boolean prevTime() {
        if (this.iImageTime + this.iTimeInc <= this.iStartingIndex) {
            return false;
        }
        --this.iTimeInc;
        this.iCallSaveImage = true;
        int now = this.iImageTime + this.iTimeInc;
        int start = 0;
        if (this.iCurrentCell != null) {
            start = this.iCurrentCell.getTime();
        }
        if (now >= start) {
            return true;
        }
        this.setCurrentCell(this.iCurrentCell, now, 6);
        return true;
    }

    private void showTreeCell(Cell c) {
        this.iIgnoreValueChanged = true;
        Object[] tna = c.getPath();
        TreePath tp = new TreePath(tna);
        this.iTree.makeVisible(tp);
        int row = this.iTree.getRowForPath(tp);
        this.iTree.setSelectionInterval(row, row);
        this.iTree.scrollRowToVisible(row);
        this.iTree.makeVisible(tp);
    }

    private void makeDaughterDisplay(Cell c) {
        this.iTimeInc = 0;
        this.iPlaneInc = 0;
        this.getTimeAndPlane(c);
        if (this.iImageTime < 1 || this.iImagePlane < 1) {
            return;
        }
        this.doDaughterDisplayWork((Cell)c.getParent(), c);
    }

    private void doDaughterDisplayWork(Cell parent, Cell selectedDaughter) {
        if (parent == null) {
            System.out.println("*******NULL PARENT");
        }
        if (!this.isTracking()) {
            return;
        }
        if (parent.getName() == ROOTNAME) {
            return;
        }
        if (this.iTimeInc != 0) {
            return;
        }
        int k = parent.getChildCount();
        if (k <= 1) {
            return;
        }
        Cell anteriorCell = (Cell)parent.getChildAt(0);
        Cell posteriorCell = (Cell)parent.getChildAt(1);
        if (selectedDaughter != null) {
            this.iTrackPosition = selectedDaughter == anteriorCell ? ImageWindow.ANTERIOR : ImageWindow.POSTERIOR;
        }
        Cell save = this.iCurrentCell;
        this.iCurrentCell = this.iTrackPosition == ImageWindow.ANTERIOR ? anteriorCell : posteriorCell;
        if (this.iCurrentCell == null) {
            this.iCurrentCell = save;
            return;
        }
        Vector nuclei = this.iNucleiMgr.getElementAt(this.iImageTime + this.iTimeInc - 1);
        String currentName = parent.getName();
        StringBuffer dummy = new StringBuffer();
        Nucleus anterior = NucUtils.getCurrentCellData(nuclei, anteriorCell.getName());
        Nucleus posterior = NucUtils.getCurrentCellData(nuclei, posteriorCell.getName());
        if (anterior != null && posterior != null) {
            this.makeAndSetSpecialEffects(anterior, posterior);
        }
    }

    private void makeAndSetSpecialEffects(Nucleus anterior, Nucleus posterior) {
        Object[] se = new Object[8];
        if (this.iTrackPosition == ImageWindow.ANTERIOR) {
            se[0] = new Integer(anterior.x);
            se[1] = new Integer(anterior.y);
            se[2] = new Integer((int)(anterior.z + 0.5f));
            se[3] = new Integer(posterior.x);
            se[4] = new Integer(posterior.y);
            se[5] = new Integer(posterior.size / 2);
            se[6] = new Integer((int)(posterior.z + 0.5f));
            se[7] = posterior.identity;
        } else {
            se[0] = new Integer(posterior.x);
            se[1] = new Integer(posterior.y);
            se[2] = new Integer((int)(posterior.z + 0.5f));
            se[3] = new Integer(anterior.x);
            se[4] = new Integer(anterior.y);
            se[5] = new Integer(anterior.size / 2);
            se[6] = new Integer((int)(anterior.z + 0.5f));
            se[7] = anterior.identity;
        }
        if (this.iImgWin != null) {
            this.iImgWin.setSpecialEffect(se);
        }
    }

    private void trackingActionsOnCurrentCellChange() {
        int time = this.iImageTime + this.iTimeInc;
        this.iImageTime = this.iCurrentCell.getTime();
        this.iTimeInc = time - this.iImageTime;
        int plane = this.iImagePlane + this.iPlaneInc;
        this.iImagePlane = this.iCurrentCell.getPlane();
        this.iPlaneInc = plane - this.iImagePlane;
    }

    public void setCurrentCell(Cell c, int time, int source) {
        if (this.iCellsByName == null) {
            return;
        }
        if (c == null) {
            if (source == 4) {
                this.showSelectedCell(c, time);
            }
            return;
        }
        if (this.iImgWin != null) {
            this.iImgWin.setSpecialEffect(null);
        }
        if (source != 7 && !this.iCellsByName.containsKey(c.getName())) {
            return;
        }
        if (source == 3) {
            Cell old = this.iCurrentCell;
            this.iCurrentCell = c;
            this.trackingActionsOnCurrentCellChange();
            iAceTree.forceTrackingOn();
            this.showTreeCell(this.iCurrentCell);
            String s = this.makeDisplayText();
            this.iText.setText(s);
            if (this.iImgWin != null) {
                this.iImgWin.updateCurrentCellAnnotation(this.iCurrentCell, old, -1);
            }
            Cell parent = (Cell)c.getParent();
            if (this.iTimeInc == 0 && !parent.getName().equals("P0")) {
                this.doDaughterDisplayWork((Cell)c.getParent(), c);
            } else {
                this.iTrackPosition = this.iCurrentCell.isAnterior() ? ImageWindow.ANTERIOR : ImageWindow.POSTERIOR;
            }
            this.updateDisplay();
        } else if (source == 7) {
            Cell old = this.iCurrentCell;
            this.iCurrentCell = c;
            this.trackingActionsOnCurrentCellChange();
            iAceTree.forceTrackingOn();
            this.showTreeCell(this.iCurrentCell);
            String s = "added cell in progress";
            if (this.iImgWin != null) {
                this.iImgWin.updateCurrentCellAnnotation(this.iCurrentCell, old, -1);
            }
            this.iText.setText(s);
            this.updateDisplay();
        } else if (source == 1) {
            this.showSelectedCell(c, time);
            this.updateDisplay();
        } else if (source == 2) {
            this.iTrackPosition = c.isAnterior() ? ImageWindow.ANTERIOR : ImageWindow.POSTERIOR;
            this.showSelectedCell(c, time);
        } else if (source == 4) {
            this.showSelectedCell(c, time);
        } else if (source == 5) {
            this.iImageTime = time;
            this.iTimeInc = 0;
            Cell currentCellSave = this.iCurrentCell;
            this.doDaughterDisplayWork(this.iCurrentCell, null);
            if (currentCellSave != this.iCurrentCell) {
                this.trackingActionsOnCurrentCellChange();
                if (this.iImgWin != null) {
                    this.iImgWin.updateCurrentCellAnnotation(this.iCurrentCell, currentCellSave, time);
                }
            }
            this.showTreeCell(this.iCurrentCell);
        } else if (source == 6) {
            Vector nuclei1 = this.iNucleiMgr.getElementAt(this.iImageTime + this.iTimeInc);
            Vector nuclei0 = this.iNucleiMgr.getElementAt(this.iImageTime + this.iTimeInc - 1);
            Nucleus n = NucUtils.getParent(nuclei0, nuclei1, this.iCurrentCell.getName());
            Cell currentCellSave = this.iCurrentCell;
            if (n != null) {
                this.iCurrentCell = (Cell)this.iAncesTree.getCellsByName().get(n.identity);
                if (this.iCurrentCell == null) {
                    this.iCurrentCell = currentCellSave;
                    return;
                }
                if (currentCellSave != this.iCurrentCell) {
                    this.trackingActionsOnCurrentCellChange();
                    if (this.iImgWin != null) {
                        this.iImgWin.updateCurrentCellAnnotation(this.iCurrentCell, currentCellSave, time);
                    }
                }
                this.showTreeCell(this.iCurrentCell);
            } else {
                this.iTrackPosition = ImageWindow.NONE;
                this.iCurrentCell = null;
                this.showTreeCell(this.iRoot);
            }
        }
    }

    private void showSelectedCell(Cell c, int requestedTime) {
        if (this.iImgWin == null) {
            return;
        }
        if (c == null) {
            this.iImageTime = requestedTime;
            this.iTimeInc = 0;
            this.iImagePlane = 15;
            this.iPlaneInc = 0;
            this.iCurrentCell = this.iRoot;
            this.showTreeCell(this.iCurrentCell);
            this.updateDisplay();
            return;
        }
        String name = c.getName();
        Nucleus n = this.iNucleiMgr.getCurrentCellData(name, requestedTime);
        if (n != null) {
            Cell old = this.iCurrentCell;
            this.iImageTime = c.getTime();
            this.iTimeInc = requestedTime - this.iImageTime;
            this.iImagePlane = (int)(n.z + 0.5f);
            this.iPlaneInc = 0;
            this.iCurrentCell = c;
            if (this.iImageTime < 1) {
                return;
            }
            this.iCurrentCellPresent = true;
            this.iTrackPosition = this.iCurrentCell.isAnterior() ? ImageWindow.ANTERIOR : ImageWindow.POSTERIOR;
            this.showTreeCell(this.iCurrentCell);
            int baseTime = c.getTime();
            this.iImgWin.updateCurrentCellAnnotation(this.iCurrentCell, old, -1);
            this.updateDisplay();
        } else {
            this.iImageTime = requestedTime;
            this.iTimeInc = 0;
            this.iImagePlane = 15;
            this.iPlaneInc = 0;
            this.iCurrentCell = c;
            this.showTreeCell(this.iCurrentCell);
            this.updateDisplay();
        }
    }

    private void incPlane(int inc) {
        if (inc > 0) {
            if (this.iImagePlane + this.iPlaneInc < this.iPlaneEnd) {
                this.iPlaneInc += inc;
            }
        } else if (inc < 0 && this.iImagePlane + this.iPlaneInc > 1) {
            this.iPlaneInc += inc;
        }
    }

    private void handleSisterRequest() {
        int k = this.iCurrentCell.getSiblingCount();
        if (k != 2) {
            return;
        }
        Cell parent = (Cell)this.iCurrentCell.getParent();
        Cell anteriorCell = (Cell)parent.getChildAt(0);
        Cell posteriorCell = (Cell)parent.getChildAt(1);
        int now = this.iImageTime + this.iTimeInc;
        Nucleus anterior = this.iNucleiMgr.getCurrentCellData(anteriorCell.getName(), now);
        Nucleus posterior = this.iNucleiMgr.getCurrentCellData(posteriorCell.getName(), now);
        if (anterior == null || posterior == null) {
            System.out.println("sister not present");
            return;
        }
        this.makeAndSetSpecialEffects(anterior, posterior);
    }

    public void mouseMoved(MouseEvent e) {
        String s = POSITION + e.getX() + ", " + e.getY();
        this.iText2.setText(s);
    }

    public void cellAnnotated(String name) {
        this.iText3.setText(name);
    }

    public void saveNuclei(File file) {
        System.out.println("saveNuclei: " + file);
        NucZipper nz = new NucZipper(file, this.iNucleiMgr);
        nz = null;
        System.out.println("Finished saving nuclei.");
    }

    public void viewNuclei() {
        new NucEditDialog(this, this.iMainFrame, false);
    }

    public void relinkNucleus() {
        int time = this.iImageTime + this.iTimeInc;
        if (this.iNucRelinkDialog == null) {
            this.iNucRelinkDialog = new UnifiedNucRelinkDialog(this, this.iMainFrame, false, this.iCurrentCell, time);
            this.iImgWin.iDialog2 = this.iNucRelinkDialog;
        } else {
            this.iNucRelinkDialog.setVisible(true);
        }
    }

    public void killCell(int x) {
        AceTree.println("killCell, ");
        int currenttime = this.iImageTime + this.iTimeInc - 1;
        Vector nuclei = this.iNucleiMgr.getElementAt(currenttime);
        String name = this.iCurrentCell.getName();
        Nucleus n = null;
        int j = 0;
        while (j < nuclei.size()) {
            n = (Nucleus)nuclei.elementAt(j);
            if (n.identity.equals(name)) {
                n.status = -1;
                break;
            }
            ++j;
        }
        this.prevImage();
        this.clearTree();
        this.buildTree(true);
        AncesTree ances = this.getAncesTree();
        Hashtable h = ances.getCellsByName();
        Cell c = (Cell)h.get(name);
        if (c != null) {
            iAceTree.setStartingCell(c, currenttime);
            System.out.println("Setting starting in delete key" + c);
        }
    }

    public void killDeepNucs() {
        new KillDeepNucsDialog(this, this.iMainFrame, true);
    }

    public void killDeepNucs(int zLim) {
        Vector nucRec = this.iNucleiMgr.getNucleiRecord();
        int i = 0;
        while (i < nucRec.size()) {
            Vector nuclei = (Vector)nucRec.get(i);
            int j = 0;
            while (j < nuclei.size()) {
                Nucleus n = (Nucleus)nuclei.get(j);
                if (n.status != -1 && !(n.z < (float)zLim)) {
                    AceTree.println("killDeepNucs, " + i + ", " + n);
                    n.status = -1;
                }
                ++j;
            }
            ++i;
        }
        this.clearTree();
        this.buildTree(true);
    }

    public void testWindow() {
        new TestWindow(this, this.iMainFrame, false);
    }

    public void killCells() {
        int time = this.iImageTime + this.iTimeInc;
        new KillCellsDialog(this, this.iMainFrame, true, this.iCurrentCell, time, this.iEditLog);
    }

    public void pausePlayerControl() {
        this.iPlayerControl.pause();
    }

    public void setEndTime() {
        new SetEndTimeDialog(this, this.iMainFrame, true);
    }

    public void incrementEndTime() {
        this.setEndingIndex(++this.iEndingIndex);
    }

    public void setEndingIndex(int endTime) {
        this.iEndingIndex = endTime;
        this.iNucleiMgr.setEndingIndex(endTime);
        this.clearTree();
        Hashtable oldHash = this.iAncesTree.getCellsByName();
        this.buildTree(true);
        Hashtable newHash = this.iAncesTree.getCellsByName();
        String name = null;
        Cell c = null;
        Enumeration newKeys = newHash.keys();
        Vector<String> newNames = new Vector<String>();
        while (newKeys.hasMoreElements()) {
            name = (String)newKeys.nextElement();
            if (oldHash.containsKey(name)) continue;
            c = (Cell)newHash.get(name);
            newNames.add(name);
        }
        Collections.sort(newNames);
        int i = 0;
        while (i < newNames.size()) {
            c = (Cell)newHash.get((String)newNames.elementAt(i));
            ++i;
        }
    }

    public void undo() {
        this.iEditLog.append("UNDO");
        this.iNucleiMgr.restoreNucleiRecord();
        this.iNucleiMgr.clearAllHashkeys();
        this.clearTree();
        this.buildTree(true);
        this.setStartingCell((Cell)this.iRoot.getFirstChild(), this.iStartTime);
        this.iEditLog.setModified(true);
    }

    public void exit() {
        if (this.iEditLog.getModified()) {
            String msg = "Warning, you have unsaved edits.\nClick OK to continue.";
            Object[] options = new Object[]{"OK", "CANCEL"};
            int choice = JOptionPane.showOptionDialog(null, msg, "Warning", -1, 2, null, options, options[0]);
            if (choice == 0) {
                this.iWinEvtHandler.windowClosing(null);
            }
        } else {
            this.iWinEvtHandler.windowClosing(null);
        }
    }

    public void editTraverse() {
        this.iEditTraverse = new EditTraverse(this.iCurrentCell);
    }

    public void setEditTraverseNull() {
        this.iEditTraverse = null;
    }

    public void setFocusHome() {
        this.iHome.grabFocus();
    }

    public void ancestral() {
        this.iSulstonTree = this.iBookmarkDialog != null ? new SulstonTree(this, "Ancestral Tree", this.iCurrentCell, true, this.iBookmarkJList.getModel()) : new SulstonTree(this, "Ancestral Tree", this.iCurrentCell, true, null);
    }

    public void canonical() {
        if (this.iCanonicalTree == null) {
            this.iCanonicalTree = CanonicalTree.getCanonicalTree();
        }
        new AuxFrame(this, "Sulston Tree", this.iCanonicalTree);
    }

    public void vtree() {
        new VTree();
    }

    public void test() {
        new AceTreeHelp("/org/rhwlab/help/messages/J3Derror.html", 600, 300);
    }

    public CanonicalTree getCanonicalTree() {
        return this.iCanonicalTree;
    }

    public void threeDview() {
        String s = this.getImageTitle();
        if (this.iUseStack == 1) {
            s = this.getTifPathWithPrefix();
        }
        System.out.println("AceTree passing to Image3D title: " + s);
        try {
            this.iImage3D = new Image3D(this, s);
        }
        catch (NoClassDefFoundError ee) {
            new Java3DError(this.iMainFrame);
        }
    }

    public String getTifPathWithPrefix() {
        return String.valueOf(this.iTifPrefix) + this.makeImageName();
    }

    public void allCentroidsView() {
        String s = this.getImageTitle();
        new ImageAllCentroids(this, s);
    }

    public String getImageTitle() {
        String s2;
        int j;
        int k;
        String s = this.makeImageName();
        if (s != null && this.iUseStack == 0 && (k = s.lastIndexOf("-")) != -1) {
            s = s.substring(0, k);
        }
        if ((j = (s2 = this.iTifPrefix).lastIndexOf("/")) > 0) {
            s2 = s2.substring(j + 1);
        }
        return String.valueOf(s2) + s;
    }

    public void image3DSave(boolean saveIt) {
        Image3D.setSaveImageState(saveIt);
        if (!saveIt) {
            return;
        }
        if (this.iImage3D == null) {
            System.out.println("no active image3d");
            this.threeDview();
        } else {
            String name = this.iImgWin.getTitle();
            name = name.substring(0, name.length() - 8);
            name = name.substring(4, name.length());
            this.iImage3D.offScreenRendering(name);
        }
    }

    public boolean hasActiveImage3D() {
        return this.iImage3D != null;
    }

    public void image2DSave(boolean saveIt) {
        this.iImgWin.setSaveImageState(saveIt);
        this.iImgWin.saveImageIfEnabled();
    }

    public void zoomView() {
        this.iImgWin.zoomView();
    }

    private void delay(int n) {
        long t = System.currentTimeMillis();
        long e = t + (long)n;
        while (t < e) {
            t = System.currentTimeMillis();
        }
    }

    public boolean nextImage() {
        if (this.iImgWin != null) {
            this.iImgWin.setSpecialEffect(null);
        }
        boolean b = this.nextTime();
        if (this.iImage3D != null && this.iImage3D.getImage3DFrame().isVisible()) {
            this.iImage3D.insertContent(this.getImageTitle());
            this.addNext3D();
        }
        this.updateDisplay();
        return b;
    }

    public boolean nextImageFast() {
        if (this.iImgWin != null) {
            this.iImgWin.setSpecialEffect(null);
        }
        boolean b = this.nextTime();
        int i = 0;
        while (i < 4 & b) {
            b = this.nextTime();
            ++i;
        }
        if (this.iImage3D != null && this.iImage3D.getImage3DFrame().isVisible()) {
            this.iImage3D.insertContent(this.getImageTitle());
            this.addNext3D();
        }
        this.updateDisplay();
        return b;
    }

    public boolean prevImage() {
        boolean b = this.prevTime();
        if (this.iImage3D != null) {
            this.iImage3D.insertContent(this.getImageTitle());
        }
        this.addNext3D();
        this.updateDisplay();
        return b;
    }

    public boolean prevImageFast() {
        if (this.iImgWin != null) {
            this.iImgWin.setSpecialEffect(null);
        }
        boolean b = this.prevTime();
        int i = 0;
        while (i < 4 & b) {
            b = this.prevTime();
            ++i;
        }
        if (this.iImage3D != null) {
            this.iImage3D.insertContent(this.getImageTitle());
        }
        this.addNext3D();
        this.updateDisplay();
        return b;
    }

    public void updateUseZip(int useZip) {
        this.iUseZip = useZip;
        AceTree.println("updateUseZip, " + useZip);
        ImageWindow.cUseZip = useZip;
        this.iNucleiMgr.getConfig().iUseZip = useZip;
    }

    public void exportNewick() {
        try {
            Newick newick = new Newick(this.iRoot);
        }
        catch (Exception e) {
            System.out.println("ATVapp unavailable");
        }
        catch (NoClassDefFoundError ee) {
            System.out.println("you need to get ATVTree.jar");
            new AceTreeHelp("/org/rhwlab/help/messages/ATVerror.html");
        }
    }

    public EditLog getEditLog() {
        return this.iEditLog;
    }

    public Log getDebugLog() {
        return this.iDLog;
    }

    public int getTimeInc() {
        return this.iTimeInc;
    }

    public int getPlaneInc() {
        return this.iPlaneInc;
    }

    public int getUseStack() {
        return this.iUseStack;
    }

    public int getImageTime() {
        return this.iImageTime;
    }

    public int getImagePlane() {
        return this.iImagePlane;
    }

    public boolean getShowCentroids() {
        return this.iShowCentroids;
    }

    public void setShowCentroids(boolean show) {
        this.iShowCentroids = show;
    }

    public boolean getShowAnnotations() {
        return this.iShowAnnotations;
    }

    public void setShowAnnotations(boolean show) {
        this.iShowAnnotations = show;
        if (this.iShow != null) {
            if (show) {
                this.iShow.setText(HIDE);
            } else {
                this.iShow.setText(SHOW);
            }
        }
    }

    public Cell getCurrentCell() {
        return this.iCurrentCell;
    }

    public JFrame getMainFrame() {
        return this.iMainFrame;
    }

    public Object getDispProps3D() {
        return this.iDispProps3D;
    }

    public Object getDispProps3D2() {
        return this.iDispProps3D2;
    }

    public Object getDispProps3D2Z() {
        return this.iDispProps3D2Z;
    }

    public void setDispProps3D(Object obj) {
        this.iDispProps3D = obj;
    }

    public void setDispProps3D2(Object obj) {
        this.iDispProps3D2 = obj;
    }

    public void setDispProps3D2Z(Object obj) {
        this.iDispProps3D2Z = obj;
    }

    public Cell getRoot() {
        return this.iRoot;
    }

    public boolean getFullGUI() {
        return fullGUI;
    }

    public double getiZPixRes() {
        return this.iZPixRes;
    }

    public boolean isTracking() {
        return this.iTrackPosition != ImageWindow.NONE;
    }

    public void setOrientation(String orientation) {
        this.iOrientation = orientation;
        System.out.println("setOrientation: " + this.iOrientation);
    }

    public String getOrientation() {
        System.out.println("getOrientation: " + this.iOrientation);
        return this.iOrientation;
    }

    public Hashtable getNucleiMgrHash() {
        return this.iNucleiMgrHash;
    }

    public ImageWindow getImageWindow() {
        return this.iImgWin;
    }

    public void showImageWindow() {
        if (this.iImgWin != null) {
            this.iImgWin.setVisible(true);
        }
    }

    private void debugShow(int testTime) {
        System.out.println();
        System.out.println("setup for edit");
        Vector nuclei = null;
        nuclei = this.iNucleiMgr.getElementAt(testTime - 1);
        Enumeration e = nuclei.elements();
        System.out.println("time: " + (testTime - 1));
        while (e.hasMoreElements()) {
            System.out.println((Nucleus)e.nextElement());
        }
        nuclei = this.iNucleiMgr.getElementAt(testTime);
        e = nuclei.elements();
        System.out.println("time: " + testTime);
        while (e.hasMoreElements()) {
            System.out.println((Nucleus)e.nextElement());
        }
    }

    public String getiTifPrefix() {
        return this.iTifPrefix;
    }

    public void debugTest(boolean b) {
        this.iDebugTest = b;
    }

    protected void createAndShowGUI() {
        JFrame.setDefaultLookAndFeelDecorated(true);
        this.iMainFrame.setDefaultCloseOperation(0);
        this.iMainFrame.getContentPane().setLayout(new BorderLayout());
        int height = 560;
        this.setMinimumSize(new Dimension(330, height));
        this.setOpaque(true);
        this.iMainFrame.setJMenuBar(this.iAceMenuBar);
        this.iMainFrame.getContentPane().add((Component)this, "Center");
        this.iMainFrame.pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension windowSize = this.iMainFrame.getSize();
        this.iMainFrame.setLocation(Math.max(0, (screenSize.width - windowSize.width) / 2), Math.max(0, (screenSize.height - windowSize.height) / 2));
        this.iWinEvtHandler = new WindowEventHandler();
        this.iMainFrame.addWindowListener(this.iWinEvtHandler);
        this.iMainFrame.setFocusTraversalPolicy(new FocusControl(this.iHome, this.iInputCtrl.getTimeField(), this.iInputCtrl.getNameField()));
        this.iMainFrame.setVisible(true);
    }

    public void run(String arg0) {
        this.createAndShowGUI();
    }

    void showOrientation() {
        this.iOrientationPanel = new Orientation();
    }

    void showZafer1() {
        this.iZafer1Panel = new Zafer1();
    }

    void showJuvenesence() {
        this.iJuvenesencePanel = new Juvenesence();
    }

    void showLazarus() {
        this.iLazarusPanel = new Lazarus();
    }

    void showSiamese() {
        this.iSiamesePanel = new Siamese();
    }

    void showDeathsAdjacencies() {
        this.iDeathsAdjacenciesPanel = new DeathsAdjacencies();
    }

    public static void main(String[] args) throws IOException {
        AceTree ot;
        System.out.println("AceTree launched: " + new GregorianCalendar().getTime());
        boolean setui = false;
        String osName = System.getProperty("os.name").toLowerCase();
        if (!osName.contains("mac")) {
            try {
                UIManager.LookAndFeelInfo[] lookAndFeelInfoArray = UIManager.getInstalledLookAndFeels();
                int n = lookAndFeelInfoArray.length;
                int n2 = 0;
                while (n2 < n) {
                    UIManager.LookAndFeelInfo info = lookAndFeelInfoArray[n2];
                    if ("Nimbus".equals(info.getName())) {
                        UIManager.setLookAndFeel(info.getClassName());
                        UIManager.put("control", new Color(240, 240, 255));
                        setui = true;
                        break;
                    }
                    ++n2;
                }
                if (!setui) {
                    UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                }
            }
            catch (UnsupportedLookAndFeelException info) {
            }
            catch (ClassNotFoundException info) {
            }
            catch (InstantiationException info) {
            }
            catch (IllegalAccessException info) {
                // empty catch block
            }
        }
        Object config = null;
        if (args.length > 0) {
            System.out.println("AceTree args[0]: " + args[0]);
            ot = AceTree.getAceTree(args);
        } else {
            ot = AceTree.getAceTree(null);
        }
        ot.run("");
        ot.debugTest(false);
        ot.iCmdLineRun = true;
        System.out.println("main exiting");
    }

    private static void println(String s) {
        System.out.println(s);
    }

    class AceTreeActions
    extends AbstractAction {
        int iID;

        public AceTreeActions(String name, int id) {
            super(name);
            this.iID = id;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AceTree.println("AceTreeActions.actionPerformed, " + e);
        }
    }

    private class AceTreeCellRenderer
    extends DefaultTreeCellRenderer {
        AceTree iAceTree;

        public AceTreeCellRenderer(AceTree aceTree2) {
            this.iAceTree = aceTree2;
        }

        @Override
        public Font getFont() {
            Font f = super.getFont();
            if (this.iAceTree != null) {
                Cell x = this.iAceTree.getCellByName(this.getText());
                f = x == null ? f.deriveFont(0) : (x.getTime() < 1 ? f.deriveFont(2) : f.deriveFont(1));
            }
            return f;
        }

        @Override
        public Icon getLeafIcon() {
            return null;
        }

        @Override
        public Icon getOpenIcon() {
            return null;
        }

        @Override
        public Icon getClosedIcon() {
            return null;
        }
    }

    private class TreeMouseAdapter
    extends MouseInputAdapter {
        private TreeMouseAdapter() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            int time;
            int button = e.getButton();
            Cell c = null;
            if (button == 2) {
                return;
            }
            int selRow = AceTree.this.iTree.getRowForLocation(e.getX(), e.getY());
            TreePath selPath = AceTree.this.iTree.getPathForLocation(e.getX(), e.getY());
            if (selPath == null) {
                return;
            }
            c = (Cell)selPath.getLastPathComponent();
            if (button == 1) {
                AceTree.this.showTreeCell(c);
                if (c.getTime() < 0) {
                    if (AceTree.this.iCurrentCell != null) {
                        c = AceTree.this.iCurrentCell;
                    } else {
                        return;
                    }
                }
                time = c.getTime();
                AceTree.this.setCurrentCell(c, time, 1);
            } else if (button == 3 | e.isControlDown()) {
                AceTree.this.showTreeCell(c);
                if (c.getTime() < 0) {
                    if (AceTree.this.iCurrentCell != null) {
                        c = AceTree.this.iCurrentCell;
                    } else {
                        return;
                    }
                }
                time = c.getEnd();
                AceTree.this.setCurrentCell(c, time, 2);
            }
        }
    }

    protected class WindowEventHandler
    extends WindowAdapter {
        protected WindowEventHandler() {
        }

        @Override
        public void windowActivated(WindowEvent e) {
            AceTree.this.iHome.requestFocusInWindow();
        }

        @Override
        public void windowClosing(WindowEvent e) {
            System.out.println("AceTree shutdown " + new GregorianCalendar().getTime() + ", " + AceTree.this.iCmdLineRun);
            AceTree.this.iMainFrame.dispose();
            if (AceTree.this.iImgWin != null) {
                AceTree.this.iImgWin.dispose();
            }
            if (AceTree.this.iCmdLineRun) {
                System.exit(0);
            }
        }
    }
}

