/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.acetree;

import ij.IJ;
import ij.ImagePlus;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.tree.TreeNode;
import org.rhwlab.acetree.NucUtils;
import org.rhwlab.help.AceTreeHelp;
import org.rhwlab.image.ImageWindow;
import org.rhwlab.image.ImageWindowNoUI;
import org.rhwlab.snight.Config;
import org.rhwlab.snight.NucleiMgr;
import org.rhwlab.snight.NucleiMgrHeadless;
import org.rhwlab.snight.Nucleus;
import org.rhwlab.tree.AncesTree;
import org.rhwlab.tree.Cell;
import org.rhwlab.tree.CellData;
import org.rhwlab.utils.EUtils;

public class AceTreeNoUI {
    private Hashtable iNucleiMgrHash;
    private String iConfigFileName;
    private String[] iImgSuffix;
    private Cell iRoot;
    private Vector iTempV;
    private String iFilePath;
    private boolean iRootEstablished;
    private int iImageTime;
    private int iImagePlane;
    public ImageWindowNoUI iImgWin;
    private boolean iImgWinSet;
    private NucleiMgr iNucleiMgr;
    public AncesTree iAncesTree;
    private String iOrientation;
    private FileInputStream iFstream;
    private BufferedReader iBReader;
    private int iTimeInc;
    private int iPlaneInc;
    private Cell iCurrentCell;
    private boolean iCurrentCellPresent;
    private int iCurrentCellXloc;
    private int iCurrentCellYloc;
    private float iCurrentCellZloc;
    private String iZipFileName;
    private String iZipNucDir;
    private String iZipTifFilePath;
    private String iTifPrefix;
    private int iStartingIndex;
    private int iEndingIndex;
    private int iNamingMethod;
    private Hashtable iConfigHash;
    public Hashtable iCellsByName;
    private double iZPixRes;
    private int iPlaneEnd;
    private int iPlaneStart;
    private boolean iShowAnnotations;
    private boolean iShowAnnotationsSave;
    private boolean iShowCentroids;
    public Integer iTrackPosition;
    public Integer iTrackPositionSave;
    private boolean iIgnoreValueChanged;
    private boolean iCallSaveImage;
    private int iUseZip;
    private int iColor;
    PrintWriter iPrintWriter;
    public static final String PARAMETERS = "parameters";
    public static final String POSITION = "Mouse position: ";
    public static final String SPACES15 = "               ";
    public static final String TITLE = "AceTree";
    public static final String HELPMSG = "you must provide file: ";
    public static final String SEP = ", ";
    public static final String ROOTNAME = "P";
    private static final float HALFROUND = 0.5f;
    private static final String CS = ", ";
    private static final String TAB = "\t";
    private static final DecimalFormat DF0 = new DecimalFormat("####");
    private static final DecimalFormat DF1 = new DecimalFormat("####.#");
    private static final DecimalFormat DF4 = new DecimalFormat("####.####");

    public AceTreeNoUI(String configFileName) {
        this.iTempV = new Vector();
        this.iConfigFileName = configFileName;
        System.out.println("AceTreeNoUI constructor using config file: " + this.iConfigFileName);
        this.iNucleiMgrHash = new Hashtable();
        this.iRootEstablished = false;
        this.iImageTime = 0;
        this.iImagePlane = 0;
        this.iTimeInc = 0;
        this.iPlaneInc = 0;
        this.iCurrentCell = null;
        this.iCurrentCellXloc = 0;
        this.iCurrentCellYloc = 0;
        this.setShowAnnotations(false);
        this.iShowCentroids = true;
        this.iRoot = new Cell(ROOTNAME);
        this.bringUpSeries(this.iConfigFileName);
    }

    public AceTreeNoUI(Config config, PrintWriter pw) {
        this.iPrintWriter = pw;
        this.iTempV = new Vector();
        this.iConfigFileName = config.iConfigFileName;
        this.iNucleiMgrHash = new Hashtable();
        this.iRootEstablished = false;
        this.iImageTime = 0;
        this.iImagePlane = 0;
        this.iTimeInc = 0;
        this.iPlaneInc = 0;
        this.iCurrentCell = null;
        this.iCurrentCellXloc = 0;
        this.iCurrentCellYloc = 0;
        this.setShowAnnotations(false);
        this.iShowCentroids = true;
        this.iRoot = new Cell(ROOTNAME);
        this.bringUpSeries(config);
    }

    public NucleiMgr getNucleiMgr() {
        return this.iNucleiMgr;
    }

    public void test() {
        Enumeration<TreeNode> e = this.iRoot.breadthFirstEnumeration();
        while (e.hasMoreElements()) {
            Cell cell = (Cell)e.nextElement();
        }
        this.iImgWin.test();
    }

    private void bringUpSeries(String configFileName) {
        String shortName = Config.getShortName(configFileName);
        NucleiMgr nucMgr = (NucleiMgr)this.iNucleiMgrHash.get(shortName);
        if (nucMgr == null) {
            try {
                FileInputStream fis = new FileInputStream(configFileName);
                fis.close();
            }
            catch (Exception fnfe) {
                new AceTreeHelp("/org/rhwlab/help/messages/ConfigError.html", 200, 200);
                return;
            }
            int k = this.bringUpSeriesData(configFileName);
            if (k != 0) {
                return;
            }
        }
        this.iNucleiMgr = (NucleiMgr)this.iNucleiMgrHash.get(shortName);
        if (this.iNucleiMgr == null) {
            System.out.println(HELPMSG + configFileName);
            System.exit(1);
        }
        ImageWindowNoUI.setStaticParameters(this.iNucleiMgr.getConfig().iZipTifFilePath, this.iNucleiMgr.getConfig().iTifPrefix, this.iNucleiMgr.getConfig().iUseZip);
        ImageWindowNoUI.setNucleiMgr(this.iNucleiMgr);
        this.setConfigFileName(configFileName);
        this.grabConfigStuff();
        this.iPlaneEnd = this.iNucleiMgr.getPlaneEnd();
        this.iPlaneStart = this.iNucleiMgr.getPlaneStart();
        this.buildTree(false);
        this.setShowAnnotations(true);
    }

    private void bringUpSeries(Config config) {
        int k = this.bringUpSeriesData(config);
        if (k != 0) {
            return;
        }
        ImageWindowNoUI.setStaticParameters(this.iNucleiMgr.getConfig().iZipTifFilePath, this.iNucleiMgr.getConfig().iTifPrefix, this.iNucleiMgr.getConfig().iUseZip);
        ImageWindowNoUI.setNucleiMgr(this.iNucleiMgr);
        this.grabConfigStuff();
        this.iPlaneEnd = this.iNucleiMgr.getPlaneEnd();
        this.iPlaneStart = this.iNucleiMgr.getPlaneStart();
        this.buildTree(false);
        this.setShowAnnotations(true);
    }

    public int bringUpSeriesData(Config config) {
        String configFileName = config.iConfigFileName;
        File fx = new File(configFileName);
        String ss = "AceTree: " + fx.getName();
        this.iNucleiMgr = new NucleiMgrHeadless(config, this.iPrintWriter);
        if (!this.iNucleiMgr.iGoodNucleiMgr) {
            return -1;
        }
        this.iNucleiMgr.processNuclei(true, this.iNucleiMgr.getConfig().iNamingMethod);
        System.gc();
        return 0;
    }

    public int bringUpSeriesData(String configFileName) {
        File fx = new File(configFileName);
        String ss = "AceTree: " + fx.getName();
        NucleiMgrHeadless nucMgr = new NucleiMgrHeadless(configFileName);
        if (!nucMgr.iGoodNucleiMgr) {
            return -1;
        }
        ((NucleiMgr)nucMgr).processNuclei(true, ((NucleiMgr)nucMgr).getConfig().iNamingMethod);
        String config = ((NucleiMgr)nucMgr).getConfig().getShortName();
        if (!this.iNucleiMgrHash.containsKey(config)) {
            this.iNucleiMgrHash.put(config, nucMgr);
        }
        return 0;
    }

    public void buildTree(boolean doIdentity) {
        this.iShowAnnotationsSave = this.iShowAnnotations;
        this.setShowAnnotations(false);
        this.iShowCentroids = true;
        if (doIdentity) {
            this.iNucleiMgr.processNuclei(doIdentity, this.iNamingMethod);
        }
        this.grabConfigStuff();
        Cell.setEndingIndexS(this.iEndingIndex);
        this.iAncesTree = this.iNucleiMgr.getAncesTree();
        this.updateRoot(this.iAncesTree.getRootCells());
        this.iCellsByName = this.iAncesTree.getCellsByName();
        boolean k = false;
        Cell c = this.walkUpToAGoodCell();
    }

    private void updateRoot(Vector rootCells) {
        this.iRoot.removeAllChildren();
        Vector<Cell> v = new Vector<Cell>();
        Enumeration e = rootCells.elements();
        while (e.hasMoreElements()) {
            Cell c = (Cell)e.nextElement();
            v.add(c);
        }
        int i = 0;
        while (i < v.size()) {
            Cell cc = (Cell)v.elementAt(i);
            cc.removeFromParent();
            this.iRoot.add(cc);
            ++i;
        }
        this.iRoot.setEndTime(1);
        Cell xx = this.iAncesTree.getCellsByName().put(this.iRoot.getName(), this.iRoot);
    }

    private Cell walkUpToAGoodCell() {
        Cell c = null;
        if (this.iRoot.getChildCount() <= 1) {
            return this.iRoot;
        }
        c = (Cell)this.iRoot.getChildAt(0);
        while (c.getTime() < 0 && c.getChildCount() > 0) {
            c = (Cell)c.getChildAt(0);
        }
        if (c.getTime() < 0) {
            int i = 1;
            while (i < this.iRoot.getChildCount()) {
                c = (Cell)this.iRoot.getChildAt(i);
                if (c.getTime() > 0) break;
                ++i;
            }
        }
        return c;
    }

    private void grabConfigStuff() {
        Config c = this.iNucleiMgr.getConfig();
        this.iTifPrefix = c.iTifPrefix;
        this.iStartingIndex = c.iStartingIndex;
        this.iEndingIndex = c.iEndingIndex;
        this.iUseZip = c.iUseZip;
    }

    public void setStartingCell(Cell c, int time) {
        if (c != this.iRoot) {
            if (c == null) {
                c = (Cell)this.iRoot.getChildAt(0);
            }
            while (c.getChildCount() > 0 && c.getTime() < 1) {
                c = (Cell)c.getChildAt(0);
            }
            time = Math.max(time, c.getTime());
            this.iImageTime = time = Math.min(time, c.getEndTime());
            this.iTimeInc = 0;
            this.getTimeAndPlane(c);
            this.getCurrentCellParameters();
        } else {
            this.iImageTime = 1;
            this.iTimeInc = 0;
            this.iImagePlane = 15;
            this.iPlaneInc = 0;
        }
        this.handleCellSelectionChange(c, time - this.iImageTime);
        if (!c.getName().equals(ROOTNAME) && this.iRoot.getChildCount() > 0) {
            this.iShowCentroids = true;
            this.addMainAnnotation();
        }
        this.iImgWin.refreshDisplay(null);
    }

    private void getTimeAndPlane(Cell c) {
        if (c == null) {
            return;
        }
        if (c == this.iRoot) {
            this.iImageTime = 1;
            this.iImagePlane = 15;
        } else {
            this.iImageTime = c.getTime();
            this.iImagePlane = (int)((double)c.getPlane() + 0.5);
        }
        this.iTimeInc = 0;
        this.iPlaneInc = 0;
        this.iCurrentCell = c;
    }

    private void getCurrentCellParameters() {
        if (this.iCurrentCell == null) {
            return;
        }
        int time = this.iImageTime + this.iTimeInc;
        if (time == 0) {
            time = 1;
            this.iImageTime = 1;
        }
        Nucleus n = null;
        try {
            Vector nuclei = (Vector)this.iNucleiMgr.getNucleiRecord().elementAt(time - 1);
            n = NucUtils.getCurrentCellNucleus(nuclei, this.iCurrentCell);
        }
        catch (Exception e) {
            System.out.println("AceTree.getCurrentCellParameters error at time=" + time);
        }
        this.iCurrentCellXloc = -1;
        this.iCurrentCellYloc = -1;
        this.iCurrentCellZloc = -1.0f;
        this.iCurrentCellPresent = false;
        if (n != null) {
            this.iCurrentCellXloc = n.x;
            this.iCurrentCellYloc = n.y;
            this.iCurrentCellZloc = n.z;
            this.iImagePlane = this.trackCellPlane();
            this.iCurrentCellPresent = true;
        }
    }

    private void handleCellSelectionChange(Cell c, int timeInc) {
        if (c == null) {
            return;
        }
        this.getTimeAndPlane(c);
        this.iTimeInc = timeInc;
        this.iPlaneInc = 0;
        if (this.iImageTime < 1 || this.iImagePlane < 1) {
            return;
        }
        this.updateDisplay();
    }

    private int trackCellPlane() {
        if (this.iTrackPosition != ImageWindow.NONE) {
            this.iPlaneInc = 0;
            return (int)((double)this.iCurrentCellZloc + 0.5);
        }
        return this.iImagePlane;
    }

    public void updateDisplay() {
        if (this.iImageTime + this.iTimeInc < this.iStartingIndex) {
            return;
        }
        if (this.iImagePlane + this.iPlaneInc <= 0) {
            return;
        }
        this.getCurrentCellParameters();
        this.handleImage();
    }

    public void updateDisplay(int time, int plane, int color) {
        this.iImageTime = time;
        this.iImagePlane = plane;
        this.iColor = color;
        this.updateDisplay();
    }

    public void handleImage() {
        String cfile = this.makeImageName();
        ImagePlus ip = null;
        if (cfile == null) {
            IJ.error((String)"no image available");
            ImageWindowNoUI.makeImage(null);
            return;
        }
        if (this.iImgWin != null) {
            try {
                ip = this.iImgWin.refreshDisplay(String.valueOf(this.iTifPrefix) + cfile);
            }
            catch (Exception e) {
                System.out.println("handleImage -- no image available: " + this.iTifPrefix + cfile);
                e.printStackTrace();
            }
        } else {
            ip = ImageWindowNoUI.makeImage(String.valueOf(this.iTifPrefix) + cfile);
            this.iImgWin = new ImageWindowNoUI(String.valueOf(this.iTifPrefix) + cfile, ip);
            this.iImgWin.setAceTree(this);
            ip = this.iImgWin.refreshDisplay(String.valueOf(this.iTifPrefix) + cfile);
            this.iImgWinSet = true;
        }
    }

    private String makeImageName() {
        StringBuffer name = new StringBuffer("t");
        name.append(EUtils.makePaddedInt(this.iImageTime + this.iTimeInc));
        name.append("-p");
        String p = EUtils.makePaddedInt(this.iImagePlane + this.iPlaneInc, 2);
        name.append(p);
        switch (this.iUseZip) {
            case 0: 
            case 1: {
                name.append(".tif");
                break;
            }
            default: {
                name.append(".zip");
            }
        }
        return name.toString();
    }

    public void addMainAnnotation() {
        if (this.iCurrentCellXloc <= 0) {
            return;
        }
        this.iImgWin.addAnnotation(this.iCurrentCellXloc, this.iCurrentCellYloc, true);
    }

    public void setShowAnnotations(boolean show) {
        this.iShowAnnotations = show;
    }

    public void setConfigFileName(String name) {
        this.iConfigFileName = name;
    }

    public Cell getRoot() {
        return this.iRoot;
    }

    public int getTimeInc() {
        return this.iTimeInc;
    }

    public int getPlaneInc() {
        return this.iPlaneInc;
    }

    public int getImageTime() {
        return this.iImageTime;
    }

    public int getImagePlane() {
        return this.iImagePlane;
    }

    public int getColor() {
        return this.iColor;
    }

    public boolean isTracking() {
        return this.iTrackPosition != ImageWindow.NONE;
    }

    public boolean getShowAnnotations() {
        return this.iShowAnnotations;
    }

    public boolean getShowCentroids() {
        return this.iShowCentroids;
    }

    public ImageWindowNoUI getImageWindowNoUI() {
        return this.iImgWin;
    }

    public static void processUsingEditedPoints(String s) {
        s = "081505";
    }

    public static void main(String[] args) {
        String configFileName = "/nfs/waterston1/annots/murray/102405_pha4red/dats/102405_pha4red.xml";
        configFileName = "/nfs/waterston1/annots/murray/010306_pha4red/dats/010306_pha4red.xml";
        configFileName = "/nfs/waterston1/annots/murray/20070719_lin-39_10/dats/20070719_lin-39_10.xml";
        Config config = Config.createConfigFromXMLFile(configFileName);
        config.setEndingIndex(200);
        AceTreeNoUI acenui = new AceTreeNoUI(configFileName);
        Hashtable h = acenui.iAncesTree.getCellsByName();
        Cell c = (Cell)h.get("ABalaaaala");
        Vector v = c.getCellData();
        int tstart = c.getTime();
        int tend = c.getEndTime();
        int length = v.size();
        AceTreeNoUI.println("main, " + tstart + ", " + tend + ", " + length);
        CellData cd = (CellData)v.get(v.size() - 1);
        int plane = Math.round(cd.iNucleus.z);
        boolean showAllCentroids = false;
        boolean showAllAnnotations = true;
        boolean showSelectedCell = true;
        acenui.updateDisplay(tend, plane, 0);
        ImageWindowNoUI imgwin = acenui.getImageWindowNoUI();
        if (showAllCentroids) {
            imgwin.showCentroids();
        }
        if (showSelectedCell) {
            imgwin.showSingleCentroid(cd.iNucleus);
        }
        BufferedImage bi = imgwin.createBufferedImage();
        Graphics g = bi.getGraphics();
        if (showSelectedCell) {
            imgwin.showSingleCentroid(cd.iNucleus);
            imgwin.showSingleAnnotation(cd.iNucleus, g);
        }
        if (showAllAnnotations) {
            imgwin.showAnnotations(g);
        }
        g.dispose();
        JFrame frame = new JFrame("LabelDemo");
        frame.setDefaultCloseOperation(3);
        frame.setSize(500, 1000);
        frame.setTitle("test");
        ImageIcon ii = new ImageIcon(bi);
        JLabel label = new JLabel(ii);
        JScrollPane pane = new JScrollPane(label);
        pane.setVerticalScrollBarPolicy(22);
        frame.setContentPane(pane);
        frame.pack();
        frame.setVisible(true);
        AceTreeNoUI.println("main, ending");
    }

    private static void println(String s) {
        System.out.println(s);
    }

    private static void print(String s) {
        System.out.print(s);
    }

    private static String fmt4(double d) {
        return DF4.format(d);
    }

    private static String fmt1(double d) {
        return DF1.format(d);
    }

    private static String fmt0(double d) {
        return DF0.format(d);
    }
}

