/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.acetree;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class BookmarkDialog
extends JFrame
implements ActionListener {
    protected JMenuBar iMenuBar;
    protected JMenu iFileMenu;
    protected JMenuItem iLoad;
    protected JMenuItem iAppend;
    protected JMenuItem iSave;
    protected JMenuItem iClose;
    protected JButton iAdd;
    protected JButton iDelete;
    protected JButton iClear;
    protected JPanel iContainerPanel;
    protected String iPath;
    protected JList iJList;
    protected DefaultListModel iListModel;

    public BookmarkDialog(String path) {
        super("Bookmarked Cells");
        this.fillWindow();
        this.setLocationRelativeTo(null);
        this.setSize(new Dimension(260, 540));
        this.setDefaultCloseOperation(1);
        this.setVisible(true);
    }

    public void fillWindow() {
        this.iContainerPanel = new JPanel();
        this.iContainerPanel.setLayout(new BoxLayout(this.iContainerPanel, 1));
        this.addMenu();
        this.addList();
        this.add(this.iContainerPanel);
    }

    public void addMenu() {
        this.iMenuBar = new JMenuBar();
        this.iFileMenu = new JMenu("File");
        this.iLoad = new JMenuItem("Load From File");
        this.iLoad.addActionListener(this);
        this.iFileMenu.add(this.iLoad);
        this.iAppend = new JMenuItem("Append From File");
        this.iAppend.addActionListener(this);
        this.iFileMenu.add(this.iAppend);
        this.iSave = new JMenuItem("Save To File");
        this.iSave.addActionListener(this);
        this.iFileMenu.add(this.iSave);
        this.iClose = new JMenuItem("Close");
        this.iClose.addActionListener(this);
        this.iFileMenu.addSeparator();
        this.iFileMenu.add(this.iClose);
        this.iMenuBar.add(this.iFileMenu);
        this.setJMenuBar(this.iMenuBar);
        this.iAdd = new JButton("Add Active Cell");
        this.iAdd.setAlignmentX(0.5f);
        this.iContainerPanel.add(this.iAdd);
        this.iDelete = new JButton("Delete Selected Cell");
        this.iDelete.addActionListener(this);
        this.iDelete.setAlignmentX(0.5f);
        this.iContainerPanel.add(this.iDelete);
        this.iClear = new JButton("Clear List");
        this.iClear.addActionListener(this);
        this.iClear.setAlignmentX(0.5f);
        this.iContainerPanel.add(this.iClear);
    }

    public void addList() {
        JLabel test = new JLabel("Bookmarked Cells List");
        test.setAlignmentX(0.5f);
        this.iContainerPanel.add(test);
        this.iListModel = new DefaultListModel();
        this.iJList = new JList(this.iListModel);
        this.iJList.setLayoutOrientation(0);
        this.iJList.setSelectionMode(1);
        JScrollPane scrollList = new JScrollPane(this.iJList);
        scrollList.setAlignmentX(0.5f);
        this.iContainerPanel.add(scrollList);
    }

    public void setPath(String path) {
        this.iPath = path;
    }

    public void addCell(String name) {
        if (!this.iListModel.contains(name)) {
            this.iListModel.addElement(name);
            this.sortList();
        }
    }

    public void deleteCell(int index) {
        this.iListModel.remove(index);
    }

    public void clearList() {
        this.iListModel.clear();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        if (o == this.iClose) {
            this.hideWindow();
        } else if (o == this.iClear) {
            int confirm;
            if (!this.iListModel.isEmpty() && (confirm = JOptionPane.showConfirmDialog(this, "Are you sure you want\nto clear this list?\n", "Confirm", 0)) == 0) {
                this.clearList();
            }
        } else if (o == this.iDelete) {
            if (this.iJList.getSelectedIndex() != -1) {
                this.deleteCell(this.iJList.getSelectedIndex());
            }
        } else if (o == this.iLoad) {
            this.loadFromFile(false);
        } else if (o == this.iAppend) {
            this.loadFromFile(true);
        } else if (o == this.iSave) {
            this.saveToFile();
        }
    }

    public void windowGainedFocus(WindowEvent e) {
    }

    public void windowLostFocus(WindowEvent e) {
    }

    public void displayWindow() {
        this.setVisible(true);
    }

    public void hideWindow() {
        this.setVisible(false);
    }

    public void sortList() {
        Object[] array = this.iListModel.toArray();
        Arrays.sort(array);
        this.clearList();
        Object[] objectArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            Object name = objectArray[n2];
            this.iListModel.addElement((String)name);
            ++n2;
        }
    }

    public void loadFromFile(boolean toAppend) {
        JFileChooser fileChooser = new JFileChooser();
        FileNameExtensionFilter xmlFilter = new FileNameExtensionFilter("xml files (*.xml)", "xml");
        if (this.iPath != null) {
            fileChooser.setSelectedFile(new File(this.iPath));
        } else {
            fileChooser.setSelectedFile(new File("."));
        }
        fileChooser.setDialogTitle("Load xml File");
        fileChooser.setFileFilter(xmlFilter);
        int returnVal = fileChooser.showOpenDialog(this);
        if (returnVal == 0) {
            File file = fileChooser.getSelectedFile();
            try {
                DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
                Document doc = dBuilder.parse(file);
                NodeList nodeList = doc.getElementsByTagName("cell");
                if (!toAppend) {
                    this.clearList();
                }
                this.populateListModel(nodeList);
            }
            catch (FileNotFoundException fnfe) {
                System.out.println("File not found.");
                return;
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
            System.out.println("Loaded bookmarked cells from: " + file);
        }
    }

    public void populateListModel(NodeList nodeList) {
        if (nodeList == null || nodeList.getLength() < 1) {
            return;
        }
        int i = 0;
        while (i < nodeList.getLength()) {
            Node node = nodeList.item(i);
            Element nodeElem = (Element)node;
            String name = nodeElem.getAttribute("name");
            this.iListModel.addElement(name);
            ++i;
        }
        this.sortList();
    }

    public void saveToFile() {
        JFileChooser fileChooser = new JFileChooser();
        if (this.iPath != null) {
            fileChooser.setSelectedFile(new File(this.iPath));
        } else {
            fileChooser.setSelectedFile(new File("."));
        }
        fileChooser.setDialogTitle("Save xml File");
        int returnVal = fileChooser.showSaveDialog(this);
        if (returnVal == 0) {
            File file = new File("" + fileChooser.getSelectedFile());
            String path = file.getPath();
            if (path.lastIndexOf(".") != -1) {
                String extension = path.substring(path.lastIndexOf("."), path.length());
                if (!extension.equals(".xml")) {
                    file = new File(fileChooser.getSelectedFile() + ".xml");
                }
            } else {
                file = new File(fileChooser.getSelectedFile() + ".xml");
            }
            path = file.getPath();
            try {
                PrintWriter pw = new PrintWriter(new FileOutputStream(path), true);
                pw.println("<?xml version='1.0' encoding='utf-8'?>");
                pw.println();
                pw.println("<cells>");
                int i = 0;
                while (i < this.iListModel.size()) {
                    StringBuffer sb = new StringBuffer();
                    sb.append("<cell ");
                    sb.append("name=\"" + (String)this.iListModel.get(i) + "\"/>");
                    pw.println(sb.toString());
                    ++i;
                }
                pw.println("</cells>");
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                return;
            }
            System.out.println("Saved bookmarked cells to: " + file);
        }
    }

    public JList getJList() {
        return this.iJList;
    }

    public JButton getAddButton() {
        return this.iAdd;
    }
}

