/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.acetree;

import ij.ImagePlus;
import ij.Prefs;
import ij.gui.ImageCanvas;
import ij.gui.ImageWindow;
import ij.gui.PolygonRoi;
import ij.gui.Roi;
import ij.process.ImageProcessor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.text.DecimalFormat;
import javax.swing.JDialog;
import org.rhwlab.acetree.AceTree;
import org.rhwlab.snight.Config;
import org.rhwlab.snight.MeasureCSV;
import org.rhwlab.snight.NucleiMgr;
import org.rhwlab.utils.EUtils;

public class EllipseViewer
extends JDialog
implements ActionListener {
    private AceTree iAceTree = AceTree.getAceTree(null);
    private NucleiMgr iNucleiMgr = this.iAceTree.getNucleiMgr();
    MeasureCSV iMeasureCSV;
    String iSeries;
    Config iConfig = this.iNucleiMgr.getConfig();
    String iImages;
    ImagePlus iPlus;
    int iTime;
    int iCenter;
    double iZCenter;
    int iXCenter;
    int iYCenter;
    double iMajor;
    double iMinor;
    double iAngle;
    double iTheta;
    public int[] xCoordinates;
    public int[] yCoordinates;
    public int nCoordinates = 0;
    public double xCenter;
    public double yCenter;
    public double major;
    public double minor;
    public double angle;
    public double theta;
    boolean record;
    private static final String CS = ", ";
    private static final String C = ",";
    private static final String TAB = "\t";
    private static final DecimalFormat DF0 = new DecimalFormat("####");
    private static final DecimalFormat DF1 = new DecimalFormat("####.#");
    private static final DecimalFormat DF4 = new DecimalFormat("####.####");

    public EllipseViewer() {
        super((Frame)AceTree.getAceTree(null).getMainFrame(), false);
        this.iMeasureCSV = this.iNucleiMgr.getMeasureCSV();
        String image = this.iConfig.iTypicalImage;
        File f = new File(image);
        image = f.getParent();
        this.iImages = new File(image).getParent();
        this.iTime = Integer.parseInt(this.iMeasureCSV.get("time"));
        this.iCenter = (int)Double.parseDouble(this.iMeasureCSV.get("zc"));
        this.iXCenter = Integer.parseInt(this.iMeasureCSV.get("xc"));
        this.iYCenter = Integer.parseInt(this.iMeasureCSV.get("yc"));
        this.iMajor = Integer.parseInt(this.iMeasureCSV.get("maj"));
        this.iMinor = Integer.parseInt(this.iMeasureCSV.get("min"));
        this.iAngle = Double.parseDouble(this.iMeasureCSV.get("ang"));
        this.iZCenter = 14.6875;
        this.xCenter = this.iXCenter;
        this.yCenter = this.iYCenter;
        this.major = this.iMajor;
        this.minor = this.iMinor;
        this.angle = this.iAngle;
        this.theta = Math.PI * 2 * this.angle / 360.0;
        EllipseViewer.println("EllipseViewer, " + this.iImages);
        this.getImage();
        ImageProcessor imgproc = this.iPlus.getProcessor();
        this.makeRoi(imgproc);
        PolygonRoi proi = new PolygonRoi(this.xCoordinates, this.yCoordinates, this.nCoordinates, 2);
        this.iPlus.setRoi((Roi)proi);
        this.showImage();
    }

    int getImage() {
        ImagePlus iplus;
        boolean r = false;
        String s = String.valueOf(this.iImages) + "/tif/";
        String[] d = new File(s).list();
        if (d == null || d.length < 100) {
            EllipseViewer.println("Failure, EllipseFit could not open image for, " + this.iSeries);
            return 1;
        }
        String ss = d[0];
        ss = ss.substring(0, ss.length() - 13);
        String s2 = EUtils.makePaddedInt(this.iTime);
        ss = String.valueOf(ss) + "-t" + s2;
        s2 = EUtils.makePaddedInt(this.iCenter, 2);
        ss = String.valueOf(ss) + "-p" + s2 + ".tif";
        ss = String.valueOf(s) + ss;
        Prefs.open100Percent = true;
        this.iPlus = iplus = new ImagePlus(ss);
        if (this.iPlus.getProcessor() == null) {
            EllipseViewer.println("Failure, EllipseFit, bogus ImagePlus could not open image for, " + this.iSeries);
            return 1;
        }
        this.showImage();
        return 0;
    }

    void showImage() {
        ImageProcessor iproc = this.iPlus.getProcessor();
        ImageCanvas icanvas = new ImageCanvas(this.iPlus);
        ImageWindow iwin = new ImageWindow(this.iPlus, icanvas);
        iwin.setSize(new Dimension(this.iPlus.getWidth(), this.iPlus.getHeight()));
    }

    public void drawEllipse(ImageProcessor ip) {
        int x;
        if (this.major == 0.0 && this.minor == 0.0) {
            return;
        }
        int xc = (int)Math.round(this.xCenter);
        int yc = (int)Math.round(this.yCenter);
        int maxY = ip.getHeight();
        int[] txmin = new int[maxY];
        int[] txmax = new int[maxY];
        double sint = Math.sin(this.theta);
        double cost = Math.cos(this.theta);
        double rmajor2 = 1.0 / this.sqr(this.major / 2.0);
        double rminor2 = 1.0 / this.sqr(this.minor / 2.0);
        double g11 = rmajor2 * this.sqr(cost) + rminor2 * this.sqr(sint);
        double g12 = (rmajor2 - rminor2) * sint * cost;
        double g22 = rmajor2 * this.sqr(sint) + rminor2 * this.sqr(cost);
        double k1 = -g12 / g11;
        double k3 = 1.0 / g11;
        double k2 = (this.sqr(g12) - g11 * g22) / this.sqr(g11);
        int ymax = (int)Math.floor(Math.sqrt(Math.abs(k3 / k2)));
        if (ymax > maxY) {
            ymax = maxY;
        }
        if (ymax < 1) {
            ymax = 1;
        }
        int ymin = -ymax;
        int y = 0;
        while (y <= ymax) {
            double j2 = Math.sqrt(k2 * this.sqr(y) + k3);
            double j1 = k1 * (double)y;
            txmin[y] = (int)Math.round(j1 - j2);
            txmax[y] = (int)Math.round(j1 + j2);
            ++y;
        }
        if (this.record) {
            this.xCoordinates[this.nCoordinates] = xc + txmin[ymax - 1];
            this.yCoordinates[this.nCoordinates] = yc + ymin;
            ++this.nCoordinates;
        } else {
            ip.moveTo(xc + txmin[ymax - 1], yc + ymin);
        }
        y = ymin;
        while (y < ymax) {
            int n = x = y < 0 ? txmax[-y] : -txmin[y];
            if (this.record) {
                this.xCoordinates[this.nCoordinates] = xc + x;
                this.yCoordinates[this.nCoordinates] = yc + y;
                ++this.nCoordinates;
            } else {
                ip.lineTo(xc + x, yc + y);
            }
            ++y;
        }
        y = ymax;
        while (y > ymin) {
            int n = x = y < 0 ? txmin[-y] : -txmax[y];
            if (this.record) {
                this.xCoordinates[this.nCoordinates] = xc + x;
                this.yCoordinates[this.nCoordinates] = yc + y;
                ++this.nCoordinates;
            } else {
                ip.lineTo(xc + x, yc + y);
            }
            --y;
        }
    }

    public void makeRoi(ImageProcessor ip) {
        this.record = true;
        int size = ip.getHeight() * 3;
        size = Math.max(1500, size);
        this.xCoordinates = new int[size];
        this.yCoordinates = new int[size];
        this.nCoordinates = 0;
        this.drawEllipse(ip);
        this.record = false;
    }

    private double sqr(double x) {
        return x * x;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }

    public static void main(String[] args) {
        EllipseViewer.println("EllipseViewer.main, ");
        new EllipseViewer();
    }

    private static void println(String s) {
        System.out.println(s);
    }

    private static void print(String s) {
        System.out.print(s);
    }

    private static String fmt4(double d) {
        return DF4.format(d);
    }

    private static String fmt1(double d) {
        return DF1.format(d);
    }

    private static String fmt0(double d) {
        return DF0.format(d);
    }
}

