/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.acetree;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.Border;
import org.rhwlab.acetree.AceTree;
import org.rhwlab.image.ImageWindow;
import org.rhwlab.snight.Config;
import org.rhwlab.snight.Identity3;
import org.rhwlab.snight.NucleiMgr;

public class Options
extends JDialog
implements ActionListener {
    private AceTree iAceTree = AceTree.getAceTree(null);
    private NucleiMgr iNucleiMgr = this.iAceTree.getNucleiMgr();
    private JSpinner iLineWidth;
    private JSpinner iDivisor;
    private JSpinner iMinCutoff;
    private JRadioButton iStandard;
    private JRadioButton iCanonical;
    private JRadioButton iNewCanonical;
    private JRadioButton iManual;
    private JCheckBox iPermanentChoice;
    private JButton iApply;
    private JButton iCancel;
    private boolean iCanonicalInUse;
    private int iNamingMethod;
    private int iLineWidthInUse;
    private int iDivisorInUse;
    private int iMinCutoffInUse;
    private JComboBox iAxis;
    private JCheckBox iUseAxis;
    private String iAxisInUse;
    JRadioButton iRCNone;
    JRadioButton iRCGlobal;
    JRadioButton iRCLocal;
    JRadioButton iRCBlot;
    JRadioButton iRCCross;
    JRadioButton[] iRCChoice;
    JRadioButton[] iZipChoice;
    static final String[] ZIPCHOICE = new String[]{"tif", "zip1", "zip2", "jpg"};
    private static final String[] AXES = new String[]{"auto", "adl", "avr"};
    private static final String TITLE = "Options";
    private static final String STANDARD = "Standard";
    private static final String NEWCANONICAL = "New canonical";
    private static final String MANUAL = "Manual";
    private static final String APPLY = "Apply";
    private static final String CANCEL = "Cancel";
    private static final String CS = ", ";

    public Options() {
        super((Frame)AceTree.getAceTree(null).getMainFrame(), false);
        JFrame owner = this.iAceTree.getMainFrame();
        this.setTitle(TITLE);
        this.iNamingMethod = 2;
        this.iDivisorInUse = 8;
        this.iMinCutoffInUse = 5;
        this.iLineWidthInUse = 2;
        this.iAxisInUse = "";
        if (this.iNucleiMgr != null) {
            Identity3 identity = this.iNucleiMgr.getIdentity();
            this.iNamingMethod = identity.getNamingMethod();
            this.iLineWidthInUse = ImageWindow.cLineWidth;
        }
        Options dialog = this;
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 3));
        p.setPreferredSize(new Dimension(200, 600));
        this.addCentroidStyle(p);
        this.addIdentityChoices(p);
        this.addAxisSelection(p);
        this.addIdentitySettings(p);
        this.addRedCorrectionSelection(p);
        this.addUseZipSelection(p);
        this.addButtons(p);
        p.setOpaque(true);
        dialog.setContentPane(p);
        dialog.pack();
        dialog.setLocationRelativeTo(owner);
        dialog.setVisible(true);
        dialog.setModal(false);
    }

    private void addCentroidStyle(JPanel mp) {
        JPanel s = new JPanel();
        s.setBorder(BorderFactory.createLineBorder(Color.black));
        s.setLayout(new GridLayout(0, 1));
        s.add(new JLabel("Centroid style"));
        JPanel x = new JPanel();
        x.setLayout(new GridLayout(1, 0));
        JLabel sl = new JLabel("Line width");
        x.add(sl);
        this.iLineWidth = new JSpinner(new SpinnerNumberModel(this.iLineWidthInUse, 1, 5, 1));
        x.add(this.iLineWidth);
        s.add(x);
        mp.add(s);
    }

    private void addIdentityChoices(JPanel mp) {
        this.iStandard = new JRadioButton(STANDARD);
        this.iNewCanonical = new JRadioButton(NEWCANONICAL);
        this.iManual = new JRadioButton(MANUAL);
        ButtonGroup bg = new ButtonGroup();
        JPanel rp = new JPanel();
        Border blackline = BorderFactory.createLineBorder(Color.black);
        rp.setBorder(blackline);
        rp.setLayout(new GridLayout(0, 1));
        bg.add(this.iStandard);
        bg.add(this.iNewCanonical);
        bg.add(this.iManual);
        this.iStandard.setSelected(this.iNamingMethod == 1);
        this.iNewCanonical.setSelected(this.iNamingMethod == 3);
        this.iManual.setSelected(this.iNamingMethod == 2);
        rp.add(new JLabel("Identification mode"));
        rp.add(this.iStandard);
        rp.add(this.iNewCanonical);
        rp.add(this.iManual);
        mp.add(rp);
    }

    private void addIdentitySettings(JPanel mp) {
        JPanel s = new JPanel();
        s.setBorder(BorderFactory.createLineBorder(Color.black));
        s.setLayout(new GridLayout(0, 1));
        s.add(new JLabel("Centroid style"));
        JPanel x = new JPanel();
        x.setLayout(new GridLayout(2, 0));
        x.add(new JLabel("Divisor"));
        this.iDivisor = new JSpinner(new SpinnerNumberModel(this.iDivisorInUse, 1, 20, 1));
        x.add(this.iDivisor);
        x.add(new JLabel("MinCutoff"));
        this.iMinCutoff = new JSpinner(new SpinnerNumberModel(this.iMinCutoffInUse, 1, 20, 1));
        x.add(this.iMinCutoff);
        s.add(x);
        mp.add(s);
    }

    private void addAxisSelection(JPanel mp) {
        JPanel p = new JPanel();
        p.setBorder(BorderFactory.createLineBorder(Color.black));
        p.setLayout(new GridLayout(0, 1));
        this.iUseAxis = new JCheckBox("set axis ", false);
        p.add(this.iUseAxis);
        this.iAxis = new JComboBox<String>(AXES);
        this.iAxis.setEditable(true);
        p.add(this.iAxis);
        if (this.iNucleiMgr != null) {
            String s = this.iNucleiMgr.getConfig().iAxisGiven;
            if (s.length() == 0) {
                this.iAxis.setSelectedItem(AXES[0]);
                this.iUseAxis.setSelected(false);
            } else {
                this.iAxis.setSelectedItem(s);
                this.iUseAxis.setSelected(true);
            }
            this.iAxisInUse = s;
        }
        mp.add(p);
    }

    private void addRedCorrectionSelection(JPanel mp) {
        this.iRCChoice = new JRadioButton[5];
        JPanel p = new JPanel();
        p.setBorder(BorderFactory.createLineBorder(Color.black));
        p.setLayout(new GridLayout(0, 1));
        this.iRCChoice[0] = new JRadioButton(Config.REDCHOICE[0]);
        this.iRCChoice[1] = new JRadioButton(Config.REDCHOICE[1]);
        this.iRCChoice[2] = new JRadioButton(Config.REDCHOICE[2]);
        this.iRCChoice[3] = new JRadioButton(Config.REDCHOICE[3]);
        this.iRCChoice[4] = new JRadioButton(Config.REDCHOICE[4]);
        ButtonGroup bg = new ButtonGroup();
        p.add(new JLabel("Red background compensation"));
        int i = 0;
        while (i < 5) {
            this.iRCChoice[i] = new JRadioButton(Config.REDCHOICE[i]);
            bg.add(this.iRCChoice[i]);
            p.add(this.iRCChoice[i]);
            ++i;
        }
        int c = this.iNucleiMgr.getConfig().getRedChoiceNumber();
        this.iRCChoice[c].setSelected(true);
        mp.add(p);
    }

    private void addUseZipSelection(JPanel mp) {
        this.iZipChoice = new JRadioButton[4];
        JPanel p = new JPanel();
        p.setBorder(BorderFactory.createLineBorder(Color.black));
        p.setLayout(new GridLayout(0, 1));
        ButtonGroup bg = new ButtonGroup();
        p.add(new JLabel("Image type (\"usezip\")"));
        int i = 0;
        while (i < 4) {
            this.iZipChoice[i] = new JRadioButton(ZIPCHOICE[i]);
            bg.add(this.iZipChoice[i]);
            p.add(this.iZipChoice[i]);
            ++i;
        }
        int c = this.iNucleiMgr.getConfig().iUseZip;
        this.iZipChoice[c].setSelected(true);
        mp.add(p);
    }

    private int getRedChoice() {
        int i = 0;
        i = 0;
        while (i < this.iRCChoice.length) {
            if (this.iRCChoice[i].isSelected()) break;
            ++i;
        }
        return i;
    }

    private int getZipChoice() {
        int i = 0;
        i = 0;
        while (i < this.iZipChoice.length) {
            if (this.iZipChoice[i].isSelected()) break;
            ++i;
        }
        return i;
    }

    private void addButtons(JPanel mp) {
        this.iApply = new JButton(APPLY);
        this.iCancel = new JButton(CANCEL);
        this.iApply.addActionListener(this);
        this.iCancel.addActionListener(this);
        JPanel p = new JPanel();
        p.setBorder(BorderFactory.createLineBorder(Color.black));
        p.add(this.iApply);
        p.add(this.iCancel);
        mp.add(p);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object x = e.getSource();
        if (x != this.iCancel) {
            int k;
            String axis;
            boolean useAxis;
            int divisor = (Integer)this.iDivisor.getValue();
            int minCutoff = (Integer)this.iMinCutoff.getValue();
            int m = (Integer)this.iLineWidth.getValue();
            if (m != this.iLineWidthInUse) {
                ImageWindow.cLineWidth = m;
            }
            int namingMethod = 2;
            if (this.iStandard.isSelected()) {
                namingMethod = 1;
            } else if (this.iNewCanonical.isSelected()) {
                namingMethod = 3;
            }
            if (namingMethod != this.iNamingMethod) {
                this.iNucleiMgr.getConfig().iNamingMethod = namingMethod;
            }
            boolean bl = useAxis = !(axis = (String)this.iAxis.getSelectedItem()).equals(this.iAxisInUse) && this.iNewCanonical.isSelected() && this.iUseAxis.isSelected();
            if (useAxis) {
                this.iNucleiMgr.getConfig().iAxisGiven = axis;
            }
            if (namingMethod != this.iNamingMethod || divisor != this.iDivisorInUse || minCutoff != this.iMinCutoffInUse || useAxis) {
                this.iNucleiMgr.getConfig().iNamingMethod = namingMethod;
                this.iAceTree.clearTree();
                this.iAceTree.buildTree(true);
            }
            if ((k = this.getRedChoice()) != this.iNucleiMgr.getConfig().getRedChoiceNumber()) {
                this.iNucleiMgr.getConfig().iExprCorr = Config.REDCHOICE[k];
                this.iNucleiMgr.computeRWeights();
            }
            if ((k = this.getZipChoice()) != this.iNucleiMgr.getConfig().iUseZip) {
                this.iAceTree.updateUseZip(k);
            }
        }
        this.dispose();
    }

    public static void main(String[] args) {
        new Options();
    }

    private static void println(String s) {
        System.out.println(s);
    }
}

