/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.acetree;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import org.rhwlab.acetree.AceTree;

public class PlayerControl
extends JPanel
implements ActionListener,
Runnable {
    protected AceTree iAceTree;
    protected JToolBar iToolBar;
    protected JButton iPlay;
    protected JButton iPause;
    protected JButton iReverse;
    protected JButton iStepForward;
    protected JButton iStepBack;
    JButton iStepUp;
    JButton iStepDown;
    JButton iStepChannel;
    JButton iProperties;
    JButton iContrast;
    JLabel iZoomLabel;
    protected boolean iRunning;
    protected boolean iForward;
    protected int iDwell;
    protected JButton iZoomPlus;
    protected JButton iZoomEqual;
    protected JButton iZoomMinus;

    public PlayerControl(AceTree aceTree) {
        super(new BorderLayout());
        this.iAceTree = aceTree;
        this.iToolBar = new JToolBar("");
        this.addButtons();
        this.setPreferredSize(new Dimension(130, 30));
        this.add((Component)this.iToolBar, "First");
        this.iRunning = false;
        this.iForward = true;
        this.iDwell = 200;
    }

    protected void addButtons() {
        this.iStepBack = this.makeButton("/images/StepBack16");
        this.iStepBack.setToolTipText("Step Backwards");
        this.iToolBar.add(this.iStepBack);
        this.iReverse = this.makeButton("/images/PlayBack16");
        this.iReverse.setToolTipText("Play Backwards");
        this.iToolBar.add(this.iReverse);
        this.iToolBar.add(new JToolBar.Separator());
        this.iPause = this.makeButton("/images/Pause16");
        this.iPause.setToolTipText("Pause");
        this.iToolBar.add(this.iPause);
        this.iToolBar.add(new JToolBar.Separator());
        this.iPlay = this.makeButton("/images/Play16");
        this.iPlay.setToolTipText("Play");
        this.iToolBar.add(this.iPlay);
        this.iStepForward = this.makeButton("/images/StepForward16");
        this.iStepForward.setToolTipText("Step Forward");
        this.iToolBar.add(this.iStepForward);
        this.iToolBar.add(new JToolBar.Separator());
        this.iStepUp = this.makeButton("/images/StepUp16");
        this.iStepUp.setToolTipText("Slice Up");
        this.iToolBar.add(this.iStepUp);
        this.iStepDown = this.makeButton("/images/StepDown16");
        this.iStepDown.setToolTipText("Slice Down");
        this.iToolBar.add(this.iStepDown);
        this.iToolBar.add(new JToolBar.Separator());
        this.iStepChannel = this.makeButton("/images/StepChannel16");
        this.iStepChannel.setToolTipText("Channel Visibility");
        this.iToolBar.add(this.iStepChannel);
        this.iProperties = this.makeButton("/images/Properties");
        this.iProperties.setToolTipText("Annotation Display");
        this.iToolBar.add(this.iProperties);
        this.iContrast = this.makeButton("/images/contrast");
        this.iContrast.setToolTipText("Adjust Contrast");
        this.iToolBar.add(this.iContrast);
        this.iToolBar.add(new JToolBar.Separator());
        this.iZoomPlus = this.makeButton("/images/ZoomPlus16");
        this.iZoomPlus.setToolTipText("Zoom In");
        this.iToolBar.add(this.iZoomPlus);
        this.iZoomEqual = this.makeButton("/images/ZoomEqual16");
        this.iZoomEqual.setToolTipText("Actual Pixels");
        this.iToolBar.add(this.iZoomEqual);
        this.iZoomMinus = this.makeButton("/images/ZoomMinus16");
        this.iZoomMinus.setToolTipText("Zoom Out");
        this.iToolBar.add(this.iZoomMinus);
        this.iZoomLabel = new JLabel("100%");
        this.iToolBar.add(this.iZoomLabel);
        this.iToolBar.add(new JToolBar.Separator());
        this.setEnabledAll(true);
        this.iPause.setEnabled(false);
    }

    public JButton getiZoomEqual() {
        return this.iZoomEqual;
    }

    public JButton getiZoomPlus() {
        return this.iZoomPlus;
    }

    public JButton getiZoomMinus() {
        return this.iZoomMinus;
    }

    public JLabel getiZoomLabel() {
        return this.iZoomLabel;
    }

    protected void setEnabledAll(boolean enabled) {
        Component c;
        int i = 0;
        while ((c = this.iToolBar.getComponentAtIndex(i++)) != null) {
            c.setEnabled(enabled);
        }
    }

    protected JButton makeButton(String imageName) {
        JButton b = new JButton();
        String imgLoc = String.valueOf(imageName) + ".gif";
        URL imageURL = PlayerControl.class.getResource(imgLoc);
        b.setIcon(new ImageIcon(imageURL, "x"));
        b.addActionListener(this);
        return b;
    }

    @Override
    public void run() {
        while (this.iRunning) {
            boolean b = this.iForward ? this.iAceTree.nextImage() : this.iAceTree.prevImage();
            if (b) {
                try {
                    Thread.sleep(this.iDwell);
                }
                catch (InterruptedException ie) {
                    ie.printStackTrace();
                }
                continue;
            }
            this.iRunning = false;
        }
        this.setEnabledAll(true);
        this.iPause.setEnabled(false);
    }

    public void stop() {
        this.iRunning = false;
    }

    public void pause() {
        this.iRunning = false;
        this.setEnabledAll(true);
        this.iPause.setEnabled(false);
    }

    public void addToToolbar(JComponent element) {
        this.iToolBar.add(element);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        if (o == this.iPause) {
            this.pause();
        }
        if (o == this.iPlay) {
            this.iRunning = true;
            this.iForward = true;
            this.setEnabledAll(false);
            this.iPause.setEnabled(true);
            new Thread((Runnable)this, "TEST").start();
        } else if (o == this.iReverse) {
            if (this.iRunning) {
                return;
            }
            this.iRunning = true;
            this.iForward = false;
            this.setEnabledAll(false);
            this.iPause.setEnabled(true);
            new Thread((Runnable)this, "TEST").start();
        } else if (o == this.iStepForward) {
            if (this.iRunning) {
                return;
            }
            this.iAceTree.nextImage();
        } else if (o == this.iStepBack) {
            if (this.iRunning) {
                return;
            }
            this.iAceTree.prevImage();
        } else if (o == this.iStepUp) {
            this.iAceTree.imageUp();
        } else if (o == this.iStepDown) {
            this.iAceTree.imageDown();
        } else if (o == this.iStepChannel) {
            this.iAceTree.toggleColor();
            this.iAceTree.updateDisplay();
        } else if (o == this.iProperties) {
            this.iAceTree.getImageWindow().launchImageParamsDialog();
        } else if (o == this.iContrast) {
            this.iAceTree.getImageWindow().launchContrastTool();
        }
    }

    public static void main(String[] args) {
    }
}

