/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.acetree;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.rhwlab.acetree.AceTree;

public class QuickOpen
extends JDialog
implements ActionListener {
    JTextField iTypicalImage;
    JButton iBrowseForImage;
    JTextField iNucleiZipFile;
    JButton iBrowseForNucleiZip;
    JButton iOpen;
    String iImageDir;
    AceTree iAceTree;
    JComboBox iAxis;
    private static final String[] AXES = new String[]{"auto", "adl", "avr"};
    private static final String TITLE = "QuickOpen";
    private static final String CS = ", ";

    public QuickOpen() {
        this.setTitle(TITLE);
        this.setSize(new Dimension(400, 200));
        this.setDefaultCloseOperation(2);
        this.iImageDir = ".";
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 3));
        this.setContentPane(p);
        JPanel pp = new JPanel();
        pp.setLayout(new FlowLayout());
        pp.add(new JLabel("typical image:"));
        this.iTypicalImage = new JTextField(15);
        pp.add(this.iTypicalImage);
        this.iBrowseForImage = new JButton("browse");
        pp.add(this.iBrowseForImage);
        this.iBrowseForImage.addActionListener(this);
        p.add(pp);
        pp = new JPanel();
        pp.setLayout(new FlowLayout());
        pp.add(new JLabel("nuclei zip file:"));
        this.iNucleiZipFile = new JTextField("NULL", 15);
        pp.add(this.iNucleiZipFile);
        this.iBrowseForNucleiZip = new JButton("browse");
        pp.add(this.iBrowseForNucleiZip);
        this.iBrowseForNucleiZip.addActionListener(this);
        p.add(pp);
        pp = new JPanel();
        pp.setLayout(new FlowLayout());
        pp.add(new JLabel("set axis:"));
        this.iAxis = new JComboBox<String>(AXES);
        this.iAxis.setEditable(true);
        pp.add(this.iAxis);
        p.add(pp);
        pp = new JPanel();
        pp.setLayout(new FlowLayout());
        this.iOpen = new JButton("open");
        pp.add(this.iOpen);
        this.iOpen.addActionListener(this);
        p.add(pp);
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        if (o == this.iBrowseForImage) {
            QuickOpen.println("actionPerformed: browseForImage");
            JFileChooser fileChooser = new JFileChooser(this.iImageDir);
            fileChooser.setCurrentDirectory(new File(this.iImageDir));
            fileChooser.setSelectedFile(new File(""));
            int returnVal = fileChooser.showOpenDialog(this);
            if (returnVal == 0) {
                File file = fileChooser.getSelectedFile();
                String path = file.getPath();
                this.iImageDir = file.getParent();
                this.iTypicalImage.setText(path);
            } else {
                System.out.println("Save command cancelled by user.");
            }
        } else if (o == this.iBrowseForNucleiZip) {
            QuickOpen.println("actionPerformed: browseForNucleiZip");
            JFileChooser fileChooser = new JFileChooser(this.iImageDir);
            fileChooser.setCurrentDirectory(new File(this.iImageDir));
            fileChooser.setSelectedFile(new File(""));
            int returnVal = fileChooser.showOpenDialog(this);
            if (returnVal == 0) {
                String path;
                File file = fileChooser.getSelectedFile();
                this.iImageDir = path = file.getPath();
                this.iNucleiZipFile.setText(path);
            } else {
                System.out.println("Save command cancelled by user.");
            }
        } else if (o == this.iOpen) {
            QuickOpen.println("actionPerformed: open");
            String image = this.iTypicalImage.getText();
            String parent = new File(image).getParent();
            parent = new File(parent).getParent();
            QuickOpen.println("actionPerformed: parent of parent: " + parent);
            String dats = String.valueOf(parent) + "/dats";
            File fdats = new File(dats);
            QuickOpen.println("actionPerformed: dats: " + dats);
            if (!fdats.exists()) {
                QuickOpen.println("actionPerformed: making directory: " + fdats);
                fdats.mkdir();
                try {
                    Runtime.getRuntime().exec("chmod 777 " + fdats);
                }
                catch (Exception ee) {
                    ee.printStackTrace();
                    System.out.println("exiting -- unable to set directory permissions");
                    System.exit(11);
                }
            }
            String nuclei = this.iNucleiZipFile.getText();
            if (image.length() == 0) {
                return;
            }
            if (nuclei.length() == 0) {
                return;
            }
            String configName = new File(image).getName();
            int m = configName.lastIndexOf(46);
            configName = configName.substring(0, m);
            String configPath = String.valueOf(dats) + "/" + configName + ".dat";
            QuickOpen.println("actionPerformed: configPath: " + configPath);
            String axis = (String)this.iAxis.getSelectedItem();
            boolean useAxis = !axis.equals(AXES[0]);
            File f = new File(configPath);
            FileOutputStream fos = null;
            try {
                fos = new FileOutputStream(f);
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
            PrintWriter pw = new PrintWriter(fos);
            pw.println("typical image, " + image);
            pw.println("zipFileName, " + nuclei);
            if (useAxis) {
                pw.println("axis, " + axis);
            }
            if (nuclei.equals("NULL")) {
                pw.println("ending index, 10000");
            }
            pw.close();
            this.dispose();
            if (this.iAceTree == null) {
                this.iAceTree = AceTree.getAceTree("");
            }
            this.iAceTree.setConfigFileName(configPath);
            this.iAceTree.bringUpSeriesUI(configPath);
        }
    }

    public static void main(String[] args) {
        QuickOpen.println("QuickOpen.main");
        new QuickOpen();
    }

    private static void println(String s) {
        System.out.println(s);
    }
}

