/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.analyze;

import java.awt.event.ActionEvent;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.tree.TreeNode;
import org.rhwlab.acetree.AceTree;
import org.rhwlab.snight.Identity3;
import org.rhwlab.snight.NucleiMgr;
import org.rhwlab.snight.Nucleus;
import org.rhwlab.tree.AncesTree;
import org.rhwlab.tree.CanonicalTree;
import org.rhwlab.tree.Cell;
import org.rhwlab.utils.CleanString;
import org.rhwlab.utils.EUtils;
import org.rhwlab.utils.Log;

public class Analysis
extends Log {
    AceTree iAceTree;
    AncesTree iAncesTree;
    NucleiMgr iNucleiMgr;
    Vector nuclei_record;
    Cell iRoot;
    Hashtable iCellsByName;
    Vector iDied;
    Vector iDividedTooSoon;
    Vector iAliveTooOld;
    Vector iAllCells;
    private static final String TEST1 = "Test1";
    private static final String TEST2 = "Test2";
    private static final String TEST3 = "Test3";
    private static final String TEST4 = "Test4";
    private static final String TEST5 = "Test5";
    private static final String TEST6 = "Test6";
    private static final String CLEAR = "Clear";
    private static final String SAVEAS = "Save as";
    private static final String OVERVIEW = "Overview";
    private static final String IDENTITYCHECK = "IdentityCheck";
    private static final String FATECHECK = "FateCheck";
    private static final String DIVISIONCHECK = "DivisionCheck";
    private static final String ACTIONS = "Actions";
    private static final String FILE = "File";
    private static final String CS = ", ";
    private static final String NL = "\n";
    private static final int SHORTLIFE = 15;
    private static final int LONGLIFE = 50;

    public Analysis(AceTree aceTree, String title) {
        super(title);
        this.iAceTree = aceTree;
        this.showMe();
        this.getFrame().setJMenuBar(this.createMenuBar());
        JButton jb = null;
        jb = new JButton(CLEAR);
        this.addToolBarButton(jb);
        this.initialize();
    }

    public Analysis() {
        super("");
    }

    public void initialize() {
        this.iAceTree = AceTree.getAceTree(null);
        this.iNucleiMgr = this.iAceTree.getNucleiMgr();
        this.nuclei_record = this.iNucleiMgr.getNucleiRecord();
        this.iAncesTree = this.iNucleiMgr.getAncesTree();
        this.iCellsByName = this.iAncesTree.getCellsByName();
        this.iRoot = this.iAncesTree.getRoot();
    }

    public void test1() {
        this.initialize();
        this.append("config file: " + this.iNucleiMgr.getConfig().iConfigFileName);
        this.append("nuclei_record length: " + this.nuclei_record.size());
        this.append("series ending index: " + this.iNucleiMgr.getEndingIndex());
        this.append("cells hash size: " + this.iCellsByName.size());
        this.append("tree leaves: " + this.iRoot.getLeafCount());
        this.append("tree leaves: " + this.iAceTree.getRoot().getLeafCount());
        this.append("live cells at end: " + this.countLiveCells(this.iNucleiMgr.getEndingIndex()));
        this.showLeaves();
    }

    private int countLiveCells(int time) {
        int count = 0;
        Vector nuclei = (Vector)this.nuclei_record.elementAt(time - 1);
        int j = 0;
        while (j < nuclei.size()) {
            Nucleus n = (Nucleus)nuclei.elementAt(j);
            if (n.status >= 0) {
                Cell c;
                ++count;
                if (time == this.nuclei_record.size() && (c = (Cell)this.iCellsByName.get(n.identity)).getFateInt() != 0) {
                    this.append(c + CS + c.getFate());
                }
            }
            ++j;
        }
        return count;
    }

    private void showLeaves() {
        Cell c = (Cell)this.iRoot.getFirstLeaf();
        int fate = -1;
        int deaths = 0;
        int alive = 0;
        boolean dividing = false;
        int i = 0;
        do {
            ++i;
            fate = c.getFateInt();
            if (fate == 0 || fate == 1) {
                ++alive;
                continue;
            }
            if (fate != 2) continue;
            ++deaths;
        } while ((c = (Cell)c.getNextLeaf()) != null);
        this.append("summary, alive=" + alive + ", died=" + deaths);
    }

    private void breadthFirstEnumeration() {
        Enumeration<TreeNode> e = this.iRoot.breadthFirstEnumeration();
        boolean i = false;
        while (e.hasMoreElements()) {
            Cell c = (Cell)e.nextElement();
            this.categorize(c);
        }
    }

    private void categorizeCells() {
        Enumeration e = this.iCellsByName.elements();
        while (e.hasMoreElements()) {
            Cell c = (Cell)e.nextElement();
            this.categorize(c);
        }
    }

    private void cellCountVersesTime() {
        int time = 1;
        while (time <= this.nuclei_record.size()) {
            this.append(String.valueOf(time) + CS + this.countLiveCells(time));
            ++time;
        }
    }

    private void categorize(Cell c) {
        String name = c.getName();
        int fate = c.getFateInt();
        if (fate == 2) {
            this.iDied.add(name);
            return;
        }
        int lifeTime = c.getLifeTime();
        if (fate == 1) {
            if (lifeTime < 15) {
                this.iDividedTooSoon.add(name);
                return;
            }
        } else if (lifeTime > 50) {
            this.iAliveTooOld.add(name);
        }
    }

    private void test3() {
        int found = 0;
        int notFound = 0;
        CanonicalTree ct = this.iAceTree.getCanonicalTree();
        Vector sortedCellNames = ct.getSortedCellNames();
        Hashtable ourCells = this.iAncesTree.getCellsByName();
        Enumeration e = sortedCellNames.elements();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            if (!ourCells.containsKey(name)) {
                this.append(name);
                ++notFound;
                continue;
            }
            ++found;
        }
        this.append("found: " + found + CS + "notFound: " + notFound);
    }

    private void test4() {
        this.initialize();
        this.iAllCells = new Vector();
        int found = 0;
        int notFound = 0;
        CanonicalTree ct = this.iAceTree.getCanonicalTree();
        Hashtable canonicalCellsHash = ct.getCellsHash();
        Hashtable ourCells = this.iAncesTree.getCellsByName();
        Enumeration<Object> e = this.iCellsByName.elements();
        while (e.hasMoreElements()) {
            Cell c = (Cell)e.nextElement();
            this.iAllCells.add(c.getName());
        }
        Collections.sort(this.iAllCells);
        e = this.iAllCells.elements();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            if (name.indexOf("polar") == 0) continue;
            if (!canonicalCellsHash.containsKey(name)) {
                String parentName = name.substring(0, name.length() - 1);
                Cell parent = (Cell)canonicalCellsHash.get(parentName);
                String report = "";
                if (parent == null) {
                    report = " error is earlier in lineage";
                } else {
                    String dau0 = "";
                    String dau1 = "";
                    int children = parent.getChildCount();
                    if (children > 0) {
                        dau0 = ((Cell)parent.getChildAt(0)).getName();
                        if (children > 1) {
                            dau1 = ((Cell)parent.getChildAt(1)).getName();
                        }
                    }
                    report = " vs parent " + parentName + " with " + children + " children: " + dau0 + CS + dau1;
                }
                if (report.length() <= 0) continue;
                this.append(String.valueOf(name) + report);
                ++notFound;
                continue;
            }
            ++found;
        }
        this.append("found: " + found + CS + "notFound: " + notFound);
    }

    private void test5() {
        this.append("\ncollect data for new sister naming approach");
        this.append("fields: cellname, birth, end, cellCountAtBirth,");
        this.append("fields: x1, y1, z1, d1, x2, y2, z2, d2, x3, y3, z3, d3");
        this.append("where x1, ... denotes position and size at birth");
        this.append("where x2, .,. denotes position and size at birth + 2");
        this.append("where x3, ... denotes position and size at end");
        this.iAllCells = new Vector();
        boolean found = false;
        boolean notFound = false;
        CanonicalTree ct = this.iAceTree.getCanonicalTree();
        Hashtable canonicalCellsHash = ct.getCellsHash();
        Hashtable ourCells = this.iAncesTree.getCellsByName();
        Enumeration<Object> e = ourCells.elements();
        while (e.hasMoreElements()) {
            Cell c = (Cell)e.nextElement();
            this.iAllCells.add(c.getName());
        }
        Collections.sort(this.iAllCells);
        e = this.iAllCells.elements();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            Cell c = (Cell)ourCells.get(name);
            CellData cd = new CellData();
            cd.name = name;
            cd.birth = c.getTime();
            cd.end = c.getEndTime();
            cd.cellCount = this.countCells(cd.birth);
            Nucleus n = this.iNucleiMgr.getCurrentCellData(name, cd.birth);
            cd.x1 = n.x;
            cd.y1 = n.y;
            cd.z1 = (int)((double)n.z * this.iNucleiMgr.getZPixRes());
            cd.d1 = n.size;
            n = this.iNucleiMgr.getCurrentCellData(name, cd.birth + 2);
            cd.x2 = n.x;
            cd.y2 = n.y;
            cd.z2 = (int)((double)n.z * this.iNucleiMgr.getZPixRes());
            cd.d2 = n.size;
            n = this.iNucleiMgr.getCurrentCellData(name, cd.end);
            cd.x3 = n.x;
            cd.y3 = n.y;
            cd.z3 = (int)((double)n.z * this.iNucleiMgr.getZPixRes());
            cd.d3 = n.size;
            this.append(cd.toString());
        }
    }

    private void examineDivisions() {
        boolean count = false;
        boolean diffs = false;
        boolean comps = false;
        Hashtable<String, String> h = new Hashtable<String, String>();
        Identity3 identity = this.iNucleiMgr.getIdentity();
        Hashtable cells = CanonicalTree.getCanonicalTree().getCellsHash();
        Enumeration e = this.iCellsByName.keys();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            String sis = identity.makeSisterName(name);
            Cell canon = (Cell)cells.get(name);
            Cell parent = (Cell)canon.getParent();
            if (parent == null || h.containsKey(sis)) continue;
            h.put(sis, name);
            Cell ours = (Cell)this.iCellsByName.get(name);
            CleanString cs = new CleanString();
            cs.insertText(name);
            cs.setPosition(15);
            cs.insertX(canon.getTime());
            cs.insertX(canon.getEndTime());
            cs.insertX(ours.getTime());
            cs.insertX(ours.getEndTime(), false);
        }
    }

    private int countCells(int time) {
        Vector nuclei = this.iNucleiMgr.getNuclei(time);
        Enumeration e = nuclei.elements();
        int count = 0;
        while (e.hasMoreElements()) {
            Nucleus n = (Nucleus)e.nextElement();
            if (n.status <= 0) continue;
            ++count;
        }
        return count;
    }

    private void test2() {
        this.append("\nTest2 " + new GregorianCalendar().getTime().toString());
        this.iAncesTree = this.iAceTree.getAncesTree();
        this.iCellsByName = this.iAncesTree.getCellsByName();
        this.iDied = new Vector();
        this.iDividedTooSoon = new Vector();
        this.iAliveTooOld = new Vector();
        this.categorizeCells();
        Collections.sort(this.iDied);
        int nDied = this.iDied.size();
        this.append("died: " + nDied);
        int i = 0;
        while (i < nDied) {
            String c = (String)this.iDied.elementAt(i);
            this.append(c);
            ++i;
        }
        Collections.sort(this.iDividedTooSoon);
        int nDividedTooSoon = this.iDividedTooSoon.size();
        this.append("divided early: " + nDividedTooSoon + " (lived < " + 15 + ")");
        int i2 = 0;
        while (i2 < nDividedTooSoon) {
            String c = (String)this.iDividedTooSoon.elementAt(i2);
            this.append(c);
            ++i2;
        }
        int nAliveTooOld = this.iAliveTooOld.size();
        Collections.sort(this.iAliveTooOld);
        this.append("alive too long: " + nAliveTooOld + " (lived > " + 50 + ")");
        int i3 = 0;
        while (i3 < nAliveTooOld) {
            String c = (String)this.iAliveTooOld.elementAt(i3);
            this.append(c);
            ++i3;
        }
    }

    @Override
    protected JMenuBar createMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        JMenu menu = null;
        JMenuItem test = null;
        menu = new JMenu(ACTIONS);
        menuBar.add(menu);
        test = new JMenuItem(OVERVIEW);
        menu.add(test);
        test.addActionListener(this);
        test = new JMenuItem(IDENTITYCHECK);
        menu.add(test);
        test.addActionListener(this);
        test = new JMenuItem(FATECHECK);
        menu.add(test);
        test.addActionListener(this);
        return menuBar;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String s = e.getActionCommand();
        if (s.equals(OVERVIEW)) {
            this.append("\nOverview");
            this.test1();
        } else if (s.equals(IDENTITYCHECK)) {
            this.append("\nIdentityCheck");
            this.test4();
        } else if (s.equals(FATECHECK)) {
            this.append("\nFateCheck");
            this.test2();
        } else if (s.equals(DIVISIONCHECK)) {
            this.append("\nDivisionCheck");
        } else if (s.equals(TEST1)) {
            this.append(TEST1);
            this.test1();
        } else if (s.equals(CLEAR)) {
            this.iText.setText("");
        } else if (s.equals(TEST2)) {
            this.test2();
        } else if (s.equals(TEST3)) {
            this.test3();
        } else if (s.equals(TEST4)) {
            this.test4();
        } else if (s.equals(TEST5)) {
            this.test5();
        } else if (!s.equals(TEST6)) {
            super.actionPerformed(e);
        }
    }

    public static void main(String[] args) {
        Analysis a = new Analysis();
        CellData cd = a.new CellData();
        cd.name = "ABalp";
        cd.birth = 20;
        cd.end = 40;
        System.out.println(cd);
        cd = a.new CellData();
        cd.name = "ABala";
        cd.birth = 20;
        cd.end = 42;
        System.out.println(cd);
    }

    public class CellData {
        StringBuffer iSB;
        int iPos;
        String name;
        int birth;
        int end;
        int cellCount;
        int x1;
        int y1;
        int z1;
        int d1;
        int x2;
        int y2;
        int z2;
        int d2;
        int x3;
        int y3;
        int z3;
        int d3;

        public CellData() {
            char[] chars = new char[50];
            Arrays.fill(chars, ' ');
            this.iSB = new StringBuffer(new String(chars));
            this.iPos = 0;
        }

        public String toString() {
            this.insertText(this.name);
            this.iPos = 15;
            this.insertX(this.birth);
            this.insertX(this.end);
            this.insertX(this.cellCount);
            this.insertX(this.x1);
            this.insertX(this.y1);
            this.insertX(this.z1);
            this.insertX(this.d1);
            this.insertX(this.x2);
            this.insertX(this.y2);
            this.insertX(this.z2);
            this.insertX(this.d2);
            this.insertX(this.x3);
            this.insertX(this.y3);
            this.insertX(this.z3);
            this.insertX(this.d3, false);
            return this.iSB.toString();
        }

        private void insertText(String text) {
            int k = this.iPos + text.length();
            this.iSB.replace(this.iPos, k, text);
            this.iPos = k;
            k = this.iPos + Analysis.CS.length();
            this.iSB.replace(this.iPos, k, Analysis.CS);
            this.iPos = k;
        }

        private void insertX(int x) {
            this.insertX(x, true);
        }

        private void insertX(int x, boolean putComma) {
            String s = EUtils.makePaddedInt(x);
            int k = this.iPos + s.length();
            this.iSB.replace(this.iPos, k, s);
            if (putComma) {
                this.iPos = k;
                this.addComma();
            }
        }

        private void addComma() {
            int k = this.iPos + Analysis.CS.length();
            this.iSB.replace(this.iPos, k, Analysis.CS);
            this.iPos = k;
        }
    }
}

