/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.analyze;

import ij.gui.PlotWindow;
import java.awt.GridLayout;
import java.text.DecimalFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.rhwlab.acetree.AceTree;
import org.rhwlab.image.ImageWindow;
import org.rhwlab.snight.NucleiMgr;
import org.rhwlab.snight.Nucleus;
import org.rhwlab.tree.AncesTree;
import org.rhwlab.tree.Cell;
import org.rhwlab.utils.Log;

public class Analysis2
extends Log {
    AceTree iAceTree;
    AncesTree iAncesTree;
    NucleiMgr iNucleiMgr;
    Vector nuclei_record;
    Cell iRoot;
    Hashtable iCellsByName;
    Hashtable iNucleiMgrHash;
    private JFrame iFrame;
    private JPanel iPanel;
    private double iXA;
    private double iYA;
    private double iZA;
    private static final String CLEAR = "Clear";
    private static final String LINE = "                                        ";
    private static final String ANGLE = "incAngle";
    private static final String TEST1 = "SeriesAng";
    private static final String TEST2 = "LinAng";
    private static final String TEST3 = "SeriesIncAng";
    private static final String TEST4 = "CountCells";
    private static final String TEST5 = "Test5";

    public Analysis2(String title) {
        super(title);
        this.showMe();
        JButton jb = null;
        jb = new JButton(CLEAR);
        this.addToolBarButton(jb);
        jb = new JButton(TEST1);
        this.addToolBarButton(jb);
        jb = new JButton(TEST2);
        this.addToolBarButton(jb);
        jb = new JButton(ANGLE);
        this.addToolBarButton(jb);
        jb = new JButton(TEST3);
        this.addToolBarButton(jb);
        jb = new JButton(TEST4);
        this.addToolBarButton(jb);
        this.initialize();
    }

    public void initialize() {
        this.iAceTree = AceTree.getAceTree(null);
        this.iNucleiMgr = this.iAceTree.getNucleiMgr();
        this.nuclei_record = this.iNucleiMgr.getNucleiRecord();
        this.iAncesTree = this.iNucleiMgr.getAncesTree();
        this.iCellsByName = this.iAncesTree.getCellsByName();
        this.iRoot = this.iAncesTree.getRoot();
        this.iNucleiMgrHash = this.iAceTree.getNucleiMgrHash();
    }

    private void test3() {
        this.append("test3 entered");
        float[] xValues = new float[this.nuclei_record.size()];
        float[] yValues = new float[this.nuclei_record.size()];
        String yLabel = "cell count";
        String xLabel = "time";
        String title = "cell count vs time";
        int i = 0;
        while (i < this.nuclei_record.size()) {
            Vector nuclei = (Vector)this.nuclei_record.elementAt(i);
            yValues[i] = this.countNuclei(nuclei);
            xValues[i] = i;
            ++i;
        }
        PlotWindow pw = new PlotWindow(title, xLabel, yLabel, xValues, yValues);
        pw.setLimits(0.0, 250.0, 0.0, 500.0);
        pw.draw();
    }

    private int countNuclei(Vector nuclei) {
        int count = 0;
        Enumeration e = nuclei.elements();
        while (e.hasMoreElements()) {
            Nucleus n = (Nucleus)e.nextElement();
            if (n.status <= 0) continue;
            ++count;
        }
        return count;
    }

    private void createFrame() {
        this.iFrame = new JFrame("angle series");
        this.iPanel = new JPanel();
        this.iPanel.setLayout(new GridLayout(3, 4));
    }

    private void showFrame() {
        this.iFrame.getContentPane().add(this.iPanel);
        this.iFrame.pack();
        this.iFrame.setVisible(true);
    }

    private PlotData anglecalc(NucleiMgr nucMgr) {
        Vector nucleirecord = nucMgr.getNucleiRecord();
        double f = 57.29577951308232;
        double zfac = nucMgr.getZPixRes();
        double planeEnd = nucMgr.getPlaneEnd();
        int height = ImageWindow.cImageHeight;
        int first = 1;
        int last = this.nuclei_record.size() - 1;
        double[] xValues = new double[last - first];
        double[] yValues = new double[last - first];
        String yLabel = "angle";
        String xLabel = "time";
        String title = nucMgr.getConfig().iConfigFileName;
        int i = first;
        while (i < last) {
            Vector nuclei = (Vector)nucleirecord.elementAt(i);
            Enumeration e = nuclei.elements();
            double ry = 0.0;
            double rz = 0.0;
            double ly = 0.0;
            double lz = 0.0;
            double countr = 0.0;
            double countl = 0.0;
            while (e.hasMoreElements()) {
                Nucleus n = (Nucleus)e.nextElement();
                if (n.status == -1 || n.identity.indexOf("ABpr") != 0 && n.identity.indexOf("ABpl") != 0) continue;
                double y = height - n.y;
                double z = (planeEnd - (double)n.z) * zfac;
                if (n.identity.indexOf("ABpr") == 0) {
                    ry += y;
                    rz += z;
                    countr += 1.0;
                }
                if (n.identity.indexOf("ABpl") != 0) continue;
                ly += y;
                lz += z;
                countl += 1.0;
            }
            xValues[i - 1] = i;
            if (countr == 0.0 || countl == 0.0) {
                yValues[i - 1] = 0.0;
            } else {
                double m = ((ry /= countr) - (ly /= countl)) / ((rz /= countr) - (lz /= countl));
                double angdeg = Math.atan(m) * f;
                if (angdeg > 50.0) {
                    angdeg -= 180.0;
                }
                String s = String.valueOf(i) + ", " + m + ", " + angdeg + ", ";
                this.debugShow(Integer.toString(i), m, angdeg, ry, rz, ly, lz, ry - ly, rz - lz, 0.0);
                yValues[i - 1] = angdeg;
            }
            ++i;
        }
        this.fakeBeginning(yValues);
        return new PlotData(xValues, yValues);
    }

    private double slope(double sumx, double sumy, double sumx2, double sumxy, double n) {
        double m = 0.0;
        m = (n * sumxy - sumx * sumy) / (n * sumx2 - sumx * sumx);
        return m;
    }

    private void fakeBeginning(double[] yValues) {
        double firstNonZeroValue = 0.0;
        int firstNonZeroIndex = 0;
        int i = 0;
        while (i < yValues.length) {
            if (yValues[i] != 0.0) {
                firstNonZeroIndex = i;
                firstNonZeroValue = yValues[i];
                break;
            }
            ++i;
        }
        i = 0;
        while (i < firstNonZeroIndex) {
            yValues[i] = firstNonZeroValue;
            ++i;
        }
    }

    private PlotData angleByIncrements(NucleiMgr nucMgr) {
        this.initialize();
        double f = 57.29577951308232;
        double zfac = nucMgr.getZPixRes();
        Vector nucleirecord = nucMgr.getNucleiRecord();
        double cumAng = 0.0;
        double avgAng = 0.0;
        int first = nucMgr.getConfig().iStartingIndex;
        int last = nucMgr.getConfig().iEndingIndex;
        Vector nuclei1 = (Vector)nucleirecord.elementAt(first);
        double[] xValues = new double[last - first + 1];
        double[] yValues = new double[last - first + 1];
        DecimalFormat fmt = new DecimalFormat("####.##");
        int i = first;
        while (i <= last) {
            this.getAvgs(nuclei1);
            double xa = this.iXA;
            double ya = this.iYA;
            double za = this.iZA;
            Vector nuclei2 = (Vector)nucleirecord.elementAt(i);
            this.getAvgs(nuclei2);
            Nucleus n1 = null;
            Nucleus n2 = null;
            Object s = null;
            String CS = ", ";
            double r = 0.0;
            double raprod = 0.0;
            Enumeration e = nuclei1.elements();
            while (e.hasMoreElements()) {
                n1 = (Nucleus)e.nextElement();
                if (n1.status == -1 || n1.successor1 <= 0 || n1.successor2 > 0) continue;
                n2 = (Nucleus)nuclei2.elementAt(n1.successor1 - 1);
                if (!n1.identity.equals(n2.identity)) continue;
                double dy1 = (double)n1.y - ya;
                double dz1 = (double)n1.z * nucMgr.getZPixRes() - za;
                double dy2 = (double)n2.y - this.iYA;
                double dz2 = (double)n2.z * nucMgr.getZPixRes() - this.iZA;
                double[] c1 = new double[2];
                double[] c2 = new double[2];
                c1 = this.complex(dy1, dz1);
                c2 = this.complex(dy2, dz2);
                double a1 = c1[1];
                double a2 = c2[1];
                double r1 = c1[0];
                double da = a2 - a1;
                if (da > 4.71238898038469) {
                    da -= Math.PI * 2;
                } else if (da < -4.71238898038469) {
                    da += Math.PI * 2;
                }
                if (i < 8) {
                    this.debugShow(n1.identity, ya, za, dy1, dz1, dy2, dz2, a1 * f, a2 * f, da * f);
                }
                r += r1;
                raprod += r1 * da;
                if (n1.identity.equals(n2.identity)) continue;
                System.out.println("bad data");
            }
            if (r > 0.0) {
                avgAng = raprod / r * f;
            }
            this.append("time, cumAng, avgAng, " + i + CS + fmt.format(cumAng += avgAng) + CS + fmt.format(avgAng) + CS + fmt.format(raprod) + CS + fmt.format(r));
            nuclei1 = nuclei2;
            yValues[i - 1] = cumAng;
            xValues[i - 1] = i;
            ++i;
        }
        double[] xx = new double[last - first];
        System.arraycopy(xValues, 0, xx, 0, last - first);
        double[] yy = new double[last - first];
        System.arraycopy(yValues, 0, yy, 0, last - first);
        return new PlotData(xx, yy);
    }

    private void testResults(double[] xx, double[] yy) {
        int i = 0;
        while (i < xx.length) {
            System.out.println("testResults: " + i + ", " + xx[i] + ", " + yy[i]);
            ++i;
        }
    }

    private double angrad(double y, double z) {
        double angr = Math.atan(y / z);
        if (y < 0.0) {
            angr = z < 0.0 ? (angr += Math.PI) : (angr += Math.PI * 2);
        } else if (z < 0.0) {
            angr += Math.PI;
        }
        return angr;
    }

    private double[] complex(double y, double z) {
        double[] ra = new double[2];
        ra[1] = this.angrad(y, z);
        ra[0] = Math.sqrt(y * y + z * z);
        return ra;
    }

    private void getAvgs(Vector nuclei) {
        Enumeration e = nuclei.elements();
        Nucleus n = null;
        int count = 0;
        this.iXA = 0.0;
        this.iYA = 0.0;
        this.iZA = 0.0;
        while (e.hasMoreElements()) {
            n = (Nucleus)e.nextElement();
            if (n.status == -1) continue;
            ++count;
            this.iXA += (double)n.x;
            this.iYA += (double)n.y;
            this.iZA += (double)n.z * this.iNucleiMgr.getZPixRes();
        }
        if (count > 0) {
            this.iXA /= (double)count;
            this.iYA /= (double)count;
            this.iZA /= (double)count;
        }
    }

    private void debugShow(String cell, double ya, double za, double dy1, double dz1, double dy2, double dz2, double a1, double a2, double da) {
        DecimalFormat fmt = new DecimalFormat("####.##");
        String s = cell;
        s = String.valueOf(s) + ", " + fmt.format(ya);
        s = String.valueOf(s) + ", " + fmt.format(za);
        s = String.valueOf(s) + ", " + fmt.format(dy1);
        s = String.valueOf(s) + ", " + fmt.format(dz1);
        s = String.valueOf(s) + ", " + fmt.format(dy2);
        s = String.valueOf(s) + ", " + fmt.format(dz2);
        s = String.valueOf(s) + ", " + fmt.format(a1);
        s = String.valueOf(s) + ", " + fmt.format(a2);
        s = String.valueOf(s) + ", " + fmt.format(da);
        this.append(s);
    }

    public static void main(String[] args) {
    }

    public class PlotData {
        public double[] yValues;
        public double[] xValues;

        public PlotData(double[] x, double[] y) {
            this.xValues = x;
            this.yValues = y;
        }

        public void showMe() {
        }
    }
}

