/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.analyze;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JTextField;
import org.rhwlab.acetree.AceTree;
import org.rhwlab.snight.Movie;
import org.rhwlab.snight.NucleiMgr;
import org.rhwlab.snight.Nucleus;
import org.rhwlab.snight.Parameters;
import org.rhwlab.tree.AncesTree;
import org.rhwlab.tree.Cell;
import org.rhwlab.utils.Log;

public class Analysis3
extends Log {
    AceTree iAceTree;
    AncesTree iAncesTree;
    NucleiMgr iNucleiMgr;
    Vector nuclei_record;
    Cell iRoot;
    Hashtable iCellsByName;
    Hashtable iNucleiMgrHash;
    Line iLine;
    private double iXA;
    private double iYA;
    private double iZA;
    private JTextField iTextField;
    private Hashtable iNamingHash;
    private Hashtable iCompletedCellsHash;
    private char iTag;
    private int iSampleIndex;
    private JMenuItem iConfigList;
    private JMenuItem iExit;
    private JMenu iMenu;
    private Vector iConfigFiles;
    private int iItem;
    private int iItems;
    private static final int XMM = 350;
    private static final int YMM = 250;
    private static final int ZMM = 180;
    private static final int XSDD = 130;
    private static final int YSDD = 80;
    private static final int ZSDD = 60;
    private static final int SIZESCALE = 5;
    private static final String CLEAR = "Clear";
    private static final String LINE = "                                        ";
    private static final String ANGLE = "Angle";
    private static final String TEST1 = "Test1";
    private static final String TEST2 = "Test2";
    private static final String TEST3 = "Test3";
    private static final String TEST4 = "Test4";
    private static final String TEST5 = "Test5";
    private static final String EXIT = "Exit";
    private static final String CONFIGS = "ConfigFiles";
    private static final String CS = ", ";
    private static final String CNS = ",";

    public Analysis3(String title) {
        super(title);
        this.showMe();
        this.createMenu();
        this.buildOutToolBar();
        this.initialize();
        this.iSampleIndex = 0;
        this.iText.setFont(new Font("courier", 0, 12));
    }

    private void buildOutToolBar() {
        this.iToolBar.setMaximumSize(new Dimension(500, 20));
        this.iToolBar.add(new JLabel("prefix:"));
        this.iTextField = new JTextField();
        this.iTextField.setColumns(15);
        this.iTextField.setText("55");
        this.iToolBar.add(this.iTextField);
        JButton jb = null;
        jb = new JButton(CLEAR);
        this.addToolBarButton(jb);
        jb = new JButton(TEST1);
        this.addToolBarButton(jb);
        jb = new JButton(TEST2);
        this.addToolBarButton(jb);
        jb = new JButton(TEST3);
        this.addToolBarButton(jb);
    }

    private void createMenu() {
        this.iMenu = new JMenu("File");
        this.iMenuBar.add(this.iMenu);
        this.iConfigList = new JMenuItem(CONFIGS);
        this.iExit = new JMenuItem(EXIT);
        this.iMenu.add(this.iConfigList);
        this.iMenu.add(this.iExit);
        this.iConfigList.addActionListener(this);
        this.iExit.addActionListener(this);
    }

    public void initialize() {
        this.iAceTree = AceTree.getAceTree(null);
        this.iNucleiMgr = this.iAceTree.getNucleiMgr();
        this.nuclei_record = this.iNucleiMgr.getNucleiRecord();
        this.iAncesTree = this.iNucleiMgr.getAncesTree();
        this.iCellsByName = this.iAncesTree.getCellsByName();
        this.iRoot = this.iAncesTree.getRoot();
        this.iNucleiMgrHash = this.iAceTree.getNucleiMgrHash();
    }

    private void test2() {
        this.initialize();
        NucleiMgr nucMgr = this.iNucleiMgr;
        int time = Integer.parseInt(this.iTextField.getText());
        Vector normNucs = this.extractNuclei(time, nucMgr);
        Collections.sort(normNucs, new Comparer());
        this.makeAllADL(normNucs, nucMgr);
        int[] ia = new int[6];
        this.computeStats(normNucs, ia);
        String stats = "stats: " + String.valueOf(ia[0]);
        int i = 1;
        while (i < 6) {
            stats = String.valueOf(stats) + CS + ia[i];
            ++i;
        }
        Vector normNucs2 = new Vector();
        Enumeration ee = normNucs.elements();
        while (ee.hasMoreElements()) {
            NormNuc nn = (NormNuc)ee.nextElement();
            this.normalize(nn, ia);
            this.append(nn.toString());
        }
    }

    Hashtable makeTimesHash(String filename) {
        Hashtable<String, String> h = new Hashtable<String, String>();
        try {
            FileInputStream fis = new FileInputStream(filename);
            BufferedReader br = new BufferedReader(new InputStreamReader(fis));
            while (br.ready()) {
                String s = br.readLine();
                if (s.length() >= 2) {
                    String[] sa = s.split(" ");
                    String c = sa[0];
                    int k = c.lastIndexOf("/");
                    c = c.substring(k + 1);
                    h.put(c, sa[1]);
                    Analysis3.println(String.valueOf(c) + CS + sa[1]);
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return h;
    }

    private void test3() {
        this.initialize();
        Hashtable timesHash = this.makeTimesHash("/home/biowolp/work/workspace/weka/series/test88.txt");
        Enumeration e = this.iNucleiMgrHash.keys();
        while (e.hasMoreElements()) {
            String config = (String)e.nextElement();
            NucleiMgr nucMgr = (NucleiMgr)this.iNucleiMgrHash.get(config);
            int time = Integer.parseInt((String)timesHash.get(config));
            this.append("% " + config + CS + time);
            Vector normNucs = this.extractNuclei(time, nucMgr);
            Collections.sort(normNucs, new Comparer());
            this.makeAllADL(normNucs, nucMgr);
            int[] ia = new int[6];
            this.computeStats(normNucs, ia);
            String stats = "stats: " + String.valueOf(ia[0]);
            int i = 1;
            while (i < 6) {
                stats = String.valueOf(stats) + CS + ia[i];
                ++i;
            }
            Vector<NormNuc> normNucs2 = new Vector<NormNuc>();
            boolean m = false;
            Enumeration ee = normNucs.elements();
            while (ee.hasMoreElements()) {
                NormNuc nn = (NormNuc)ee.nextElement();
                this.normalize(nn, ia);
                boolean skip = false;
                String s = nn.identity;
                boolean bl = skip = s.equals("P4") || s.equals("Z2") || s.equals("Z3");
                if (!skip) {
                    this.append(nn.toString());
                }
                normNucs2.add(nn);
            }
            this.computeStats(normNucs2, ia);
            String stats2 = "stats2: " + String.valueOf(ia[0]);
            int i2 = 1;
            while (i2 < 6) {
                stats2 = String.valueOf(stats2) + CS + ia[i2];
                ++i2;
            }
            this.append("% " + stats2);
            StringBuffer sb = new StringBuffer();
            boolean started = false;
            ee = normNucs.elements();
            while (ee.hasMoreElements()) {
                NormNuc nn = (NormNuc)ee.nextElement();
                if (!started) {
                    sb.append("% " + nn.identity);
                    started = true;
                    continue;
                }
                sb.append(CNS + nn.identity);
            }
            this.append(sb.toString());
        }
    }

    private void test1() {
        this.initialize();
        int time = Integer.parseInt(this.iTextField.getText());
        Vector normNucs = this.extractNuclei(time, this.iNucleiMgr);
        Enumeration e = normNucs.elements();
        while (e.hasMoreElements()) {
            NormNuc nn = (NormNuc)e.nextElement();
            this.makeADL(nn, this.iNucleiMgr);
            this.append(nn.toString());
        }
        int[] ia = new int[6];
        this.computeStats(normNucs, ia);
        String stats = "stats: " + String.valueOf(ia[0]);
        int i = 1;
        while (i < 6) {
            stats = String.valueOf(stats) + CS + ia[i];
            ++i;
        }
        this.append(stats);
    }

    private Vector extractNuclei(int time, NucleiMgr nucMgr) {
        Vector nucleiRecord = nucMgr.getNucleiRecord();
        Vector nuclei = (Vector)nucleiRecord.elementAt(time);
        int count = 0;
        Vector<NormNuc> normNucVec = new Vector<NormNuc>();
        double zfac = nucMgr.getZPixRes();
        int i = 0;
        while (i < nuclei.size()) {
            Nucleus n = (Nucleus)nuclei.elementAt(i);
            if (n.status != -1 && n.identity.indexOf("polar") < 0 && n.identity.indexOf("Nuc") < 0) {
                ++count;
                NormNuc normNuc = new NormNuc();
                normNuc.x = n.x;
                normNuc.y = n.y;
                normNuc.z = (int)((double)n.z * zfac);
                normNuc.size = n.size;
                normNuc.identity = n.identity;
                normNucVec.add(normNuc);
            }
            ++i;
        }
        return normNucVec;
    }

    private void makeAllADL(Vector nnv, NucleiMgr nm) {
        Enumeration e = nnv.elements();
        while (e.hasMoreElements()) {
            NormNuc nn = (NormNuc)e.nextElement();
            this.makeADL(nn, nm);
        }
    }

    private void makeADL(NormNuc nn, NucleiMgr nm) {
        Parameters p = nm.getParameters();
        Movie m = nm.getMovie();
        double zfac = nm.getZPixRes();
        int height = nm.getImageHeight();
        int width = nm.getImageWidth();
        int depth = (int)((double)(m.plane_end - m.plane_start + 1) * zfac);
        int ap = nm.getParameters().apInit;
        int dv = nm.getParameters().dvInit;
        if (ap < 0) {
            nn.x = width - nn.x;
        }
        if (ap * dv < 0) {
            nn.y = height - nn.y;
            nn.z = depth - nn.z;
        }
    }

    private void computeStats(Vector nnv, int[] ia) {
        int sumX = 0;
        int sumX2 = 0;
        int sumY = 0;
        int sumY2 = 0;
        int sumZ = 0;
        int sumZ2 = 0;
        NormNuc nn = null;
        int k = nnv.size();
        int i = 0;
        while (i < k) {
            nn = (NormNuc)nnv.elementAt(i);
            sumX += nn.x;
            sumX2 += nn.x * nn.x;
            sumY += nn.y;
            sumY2 += nn.y * nn.y;
            sumZ += nn.z;
            sumZ2 += nn.z * nn.z;
            ++i;
        }
        double dstdx = Math.sqrt((sumX2 - sumX * sumX / k) / (k - 1));
        double dstdy = Math.sqrt((sumY2 - sumY * sumY / k) / (k - 1));
        double dstdz = Math.sqrt((sumZ2 - sumZ * sumZ / k) / (k - 1));
        int avgx = sumX / k;
        int avgy = sumY / k;
        int avgz = sumZ / k;
        int stdx = (int)Math.round(dstdx);
        int stdy = (int)Math.round(dstdy);
        int stdz = (int)Math.round(dstdz);
        ia[0] = avgx;
        ia[1] = avgy;
        ia[2] = avgz;
        ia[3] = stdx;
        ia[4] = stdy;
        ia[5] = stdz;
    }

    private void normalize(NormNuc nn, int[] stats) {
        nn.x = 350 + (nn.x - stats[0]) * 130 / stats[3];
        nn.y = 250 + (nn.y - stats[1]) * 80 / stats[4];
        nn.z = 180 + (nn.z - stats[2]) * 60 / stats[5];
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String s = e.getActionCommand();
        if (s.equals(TEST1)) {
            this.append(TEST1);
            this.test1();
        } else if (s.equals(TEST2)) {
            this.test2();
        } else if (s.equals(TEST3)) {
            this.test3();
        } else if (s.equals(CLEAR)) {
            this.iText.setText("");
        } else if (s.equals(EXIT)) {
            this.iFrame.dispose();
        } else {
            super.actionPerformed(e);
        }
    }

    public static void main(String[] args) {
    }

    private static void println(String s) {
        System.out.println(s);
    }

    class Comparer
    implements Comparator {
        Comparer() {
        }

        public int compare(Object obj1, Object obj2) {
            NormNuc n1 = (NormNuc)obj1;
            NormNuc n2 = (NormNuc)obj2;
            return n1.identity.compareTo(n2.identity);
        }
    }

    private class Line {
        public StringBuffer iBuf;
        int iLast = 0;
        private static final int GAP = 1;

        public Line() {
            char[] ca = new char[150];
            Arrays.fill(ca, ' ');
            this.iBuf = new StringBuffer(new String(ca));
        }

        public void add(int x) {
            String s = this.makePaddedInt(x);
            this.add(s);
        }

        public void add(String s) {
            int len = s.length();
            this.iBuf.replace(this.iLast, this.iLast + len, s);
            this.iLast += len + 1;
        }

        public String makePaddedInt(int k) {
            int width = 4;
            String s = "    " + String.valueOf(k);
            int j = s.length();
            s = s.substring(j - width, j);
            return s;
        }
    }

    private class NormNuc {
        public String identity;
        public int x;
        public int y;
        public int z;
        public int size;

        private NormNuc() {
        }

        public String toString() {
            String s = String.valueOf(this.x);
            s = String.valueOf(s) + Analysis3.CS + this.y;
            s = String.valueOf(s) + Analysis3.CS + this.z;
            s = String.valueOf(s) + Analysis3.CS + this.identity;
            return s;
        }
    }
}

