/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.analyze;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTextField;
import org.rhwlab.acetree.AceTree;
import org.rhwlab.acetree.NucUtils;
import org.rhwlab.snight.Identity3;
import org.rhwlab.snight.Loc;
import org.rhwlab.snight.NucleiMgr;
import org.rhwlab.snight.Nucleus;
import org.rhwlab.tree.AncesTree;
import org.rhwlab.tree.Cell;
import org.rhwlab.utils.ConfigFileList;
import org.rhwlab.utils.Line;
import org.rhwlab.utils.Log;

public class Analysis4
extends Log {
    AceTree iAceTree;
    AncesTree iAncesTree;
    NucleiMgr iNucleiMgr;
    Vector nuclei_record;
    Cell iRoot;
    Hashtable iCellsByName;
    Identity3 iIdentity;
    Line iLine;
    private double iXA;
    private double iYA;
    private double iZA;
    private JTextField iTextField;
    private Hashtable iNamingHash;
    private Hashtable iCompletedCellsHash;
    private char iTag;
    private int iSampleIndex;
    private String iKeyCell;
    private String iStartingCell;
    private int iBreakout;
    private Hashtable[] iArrayOfHashes;
    private Hashtable iCurrentHash;
    private Hashtable iNucleiMgrHash;
    private ConfigFileList iConfigFileList;
    private String iConfigFileName;
    private static final String CLEAR = "Clear";
    private static final String LINE = "                                        ";
    private static final String ANGLE = "Angle";
    private static final String TEST1 = "GetData";
    private static final String TEST2 = "ShowRules";
    private static final String TEST3 = "Test3";
    private static final String TEST4 = "Test4";
    private static final String TEST5 = "Test5";

    public Analysis4(String title) {
        super(title);
        this.showMe();
        this.buildOutToolBar();
        this.initialize();
        this.getNamingHash();
        this.iSampleIndex = 0;
        this.iText.setFont(new Font("courier", 0, 12));
    }

    private void buildOutToolBar() {
        this.iToolBar.setMaximumSize(new Dimension(500, 20));
        this.iToolBar.add(new JLabel("prefix:"));
        this.iTextField = new JTextField();
        this.iTextField.setColumns(15);
        this.iTextField.setText("ABal");
        this.iToolBar.add(this.iTextField);
        JButton jb = null;
        jb = new JButton(CLEAR);
        this.addToolBarButton(jb);
        jb = new JButton(TEST1);
        this.addToolBarButton(jb);
        jb = new JButton(TEST2);
        this.addToolBarButton(jb);
    }

    public void initialize() {
        this.iAceTree = AceTree.getAceTree(null);
        this.iNucleiMgr = this.iAceTree.getNucleiMgr();
        this.nuclei_record = this.iNucleiMgr.getNucleiRecord();
        this.iAncesTree = this.iNucleiMgr.getAncesTree();
        this.iCellsByName = this.iAncesTree.getCellsByName();
        this.iIdentity = this.iNucleiMgr.getIdentity();
        this.iRoot = this.iAncesTree.getRoot();
        this.iNucleiMgrHash = this.iAceTree.getNucleiMgrHash();
    }

    private void test2() {
        this.append("Analysis4.test2 entered");
        Enumeration<Object> e = this.iNamingHash.keys();
        Vector<String> v = new Vector<String>();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String rule = (String)this.iNamingHash.get(key);
            if (rule.length() < 3) continue;
            String s = String.valueOf(key) + ", " + rule;
            v.add(s);
        }
        Collections.sort(v);
        e = v.elements();
        while (e.hasMoreElements()) {
            String s = (String)e.nextElement();
            this.append(s);
        }
    }

    private void test1() {
        this.append("Analysis4.test1 entered");
        this.getNamingHash();
        this.iArrayOfHashes = new Hashtable[this.iNucleiMgrHash.size()];
        this.initialize();
        Enumeration e = this.iNucleiMgrHash.keys();
        int i = -1;
        while (e.hasMoreElements()) {
            String config;
            ++i;
            this.iConfigFileName = config = (String)e.nextElement();
            NucleiMgr nucMgr = (NucleiMgr)this.iNucleiMgrHash.get(config);
            this.iAncesTree = nucMgr.getAncesTree();
            this.iCellsByName = this.iAncesTree.getCellsByName();
            this.iCurrentHash = new Hashtable();
            this.iArrayOfHashes[i] = this.iCurrentHash;
            this.append("test2 using: " + config);
            this.extendRuleData(nucMgr);
        }
        this.processArrayOfHashes();
    }

    private void getNamingHash() {
        File f = new File("namesHash.txt");
        this.iNamingHash = new Hashtable();
        String s = null;
        try {
            FileInputStream fis = new FileInputStream(f);
            BufferedReader br = new BufferedReader(new InputStreamReader(fis));
            boolean i = false;
            while (br.ready()) {
                s = br.readLine();
                System.out.println("getNamingHash: " + s);
                String[] sa = s.split(",");
                this.iNamingHash.put(sa[0], sa[1]);
            }
        }
        catch (FileNotFoundException fnfe) {
            this.append("file not found: namesHash.txt");
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    private void fileAppend(String s) {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream("ruleData.txt", true);
        }
        catch (FileNotFoundException fnfe) {
            fnfe.printStackTrace();
            return;
        }
        PrintWriter pw = new PrintWriter(fos, true);
        pw.println(s);
    }

    public void extendRuleData(NucleiMgr nucMgr) {
        System.out.println("extendRuleData");
        Vector nucleirecord = nucMgr.getNucleiRecord();
        this.iCompletedCellsHash = new Hashtable();
        int[] start = new int[]{1};
        int tp_number = nucMgr.getMovie().tp_number;
        int rotate_axis = 1;
        int nuc_ct = 0;
        Vector nuclei = null;
        Vector nuclei_prev = null;
        Vector nuclei_next = null;
        this.iBreakout = 0;
        int iEndingIndex = nucMgr.getEndingIndex();
        int i = start[0];
        while (i < iEndingIndex - 1) {
            if (this.iBreakout > 0) {
                System.out.println("extendRuleData loop exiting on breakout = " + this.iBreakout);
                break;
            }
            nuclei = (Vector)nucleirecord.elementAt(i);
            nuc_ct = nuclei.size();
            if (i > 0) {
                nuclei_prev = (Vector)nucleirecord.elementAt(i - 1);
            }
            if (i < tp_number - 1) {
                nuclei_next = (Vector)nucleirecord.elementAt(i + 1);
            }
            if (rotate_axis > 0 && nuc_ct > 50) {
                rotate_axis = 0;
            }
            Nucleus parent = null;
            Vector nextNuclei = (Vector)nucleirecord.elementAt(i + 1);
            int j = 0;
            while (j < nuc_ct) {
                String pname;
                if (this.iBreakout > 0) {
                    System.out.println("extendRuleData loop exiting on breakout");
                    break;
                }
                parent = (Nucleus)nuclei.elementAt(j);
                if (parent.status != -1 && this.iNamingHash.containsKey(pname = parent.identity)) {
                    boolean good;
                    boolean bl = good = parent.successor1 > 0 && parent.successor2 > 0;
                    if (good && this.parentRelevant(pname)) {
                        this.append(String.valueOf(String.valueOf(i)) + ", " + String.valueOf(j));
                        Nucleus dau1 = (Nucleus)nextNuclei.elementAt(parent.successor1 - 1);
                        Nucleus dau2 = (Nucleus)nextNuclei.elementAt(parent.successor2 - 1);
                        String prule = (String)this.iNamingHash.get(pname);
                        if (prule.length() >= 2) {
                            String line = this.processDividingCell(i, parent, nucMgr);
                            this.append(line);
                            this.iCurrentHash.put(pname, line);
                        }
                    }
                }
                ++j;
            }
            ++i;
        }
        System.out.println("extendRuleData exiting");
    }

    private boolean parentRelevant(String pname) {
        boolean rtn = true;
        rtn = rtn && !pname.equals("AB");
        rtn = rtn && !pname.equals("ABa");
        rtn = rtn && !pname.equals("ABp");
        rtn = rtn && !pname.equals("EMS");
        rtn = rtn && !pname.equals("P2");
        rtn = rtn && !pname.equals("P3");
        rtn = rtn && !pname.equals("P1");
        rtn = rtn && !pname.equals("Z2");
        rtn = rtn && !pname.equals("Z3");
        return rtn;
    }

    private void processArrayOfHashes() {
        Enumeration<Object> e = this.iNamingHash.keys();
        Vector<String> v = new Vector<String>();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String rule = (String)this.iNamingHash.get(key);
            if (rule.length() < 3) continue;
            String s = String.valueOf(key) + ", " + rule;
            v.add(s);
        }
        Collections.sort(v);
        e = v.elements();
        while (e.hasMoreElements()) {
            String s = (String)e.nextElement();
            this.fileAppend("data for: " + s);
            s = s.substring(0, s.indexOf(44));
            int i = 0;
            while (i < this.iArrayOfHashes.length) {
                Object o = this.iArrayOfHashes[i].get(s);
                if (o != null) {
                    this.fileAppend((String)o);
                }
                ++i;
            }
            this.fileAppend("\n");
        }
    }

    private String getConfigFileInfo(String longName) {
        String s = longName.substring(longName.lastIndexOf(47) + 1);
        s = s.substring(0, s.indexOf(46));
        return s;
    }

    private String processDividingCell(int time, Nucleus n, NucleiMgr nucMgr) {
        this.iLine = new Line();
        String s = this.getConfigFileInfo(this.iConfigFileName);
        if (s.length() <= 6) {
            this.iLine.setGap(3);
        }
        this.iLine.add(s);
        this.iLine.setGap(0);
        Vector nucleirecord = nucMgr.getNucleiRecord();
        int liveCells = NucUtils.countLiveCells((Vector)nucleirecord.elementAt(time));
        this.iLine.setGap(3);
        this.iLine.add(liveCells);
        this.iLine.setGap(0);
        int kd1 = n.successor1 - 1;
        int kd2 = n.successor2 - 1;
        Nucleus nd1 = null;
        Nucleus nd2 = null;
        int i = 1;
        while (i <= 5 && i < nucMgr.getEndingIndex() - time) {
            int k = i + time;
            Vector nuclei = (Vector)nucleirecord.elementAt(k);
            try {
                nd1 = (Nucleus)nuclei.elementAt(kd1);
                nd2 = (Nucleus)nuclei.elementAt(kd2);
            }
            catch (ArrayIndexOutOfBoundsException aiob) {
                System.out.println("ArrayIndexOutOfBounds: " + time + ", " + i + ", " + kd1 + ", " + kd2);
                System.out.println(n);
                System.out.println(nd1);
                System.out.println(nd2);
                break;
            }
            this.processPair(nd1, nd2, nucMgr);
            kd1 = nd1.successor1 - 1;
            kd2 = nd2.successor1 - 1;
            ++i;
        }
        this.iLine.add(n.identity);
        this.iLine.add(time + 1);
        return this.iLine.iBuf.toString();
    }

    private void processPair(Nucleus nd1, Nucleus nd2, NucleiMgr nucMgr) {
        int avg = (nd1.size + nd2.size) / 8;
        Loc nd1L = new Loc(nd1, nucMgr);
        Loc nd2L = new Loc(nd2, nucMgr);
        int x = 100 * (nd1L.x - nd2L.x) / avg;
        int y = 100 * (nd1L.y - nd2L.y) / avg;
        int z = 100 * (nd1L.z - nd2L.z) / avg;
        this.iLine.add(x);
        this.iLine.add(y);
        this.iLine.setGap(3);
        this.iLine.add(z);
        this.iLine.setGap(0);
    }

    private void locateNextRoundOfDivision(Nucleus nd1, Nucleus nd2, NucleiMgr nucMgr) {
        String name1 = nd1.identity;
        String name2 = nd2.identity;
        Cell d1 = (Cell)this.iCellsByName.get(name1);
        Cell d2 = (Cell)this.iCellsByName.get(name2);
        int t1 = d1.getEndTime();
        int t2 = d2.getEndTime();
        int k = Math.min(t1, t2) - 1;
        Vector nucleirecord = nucMgr.getNucleiRecord();
        Vector nuclei = (Vector)nucleirecord.elementAt(k);
        Nucleus n1 = null;
        Nucleus n2 = null;
        int i = 0;
        while (i < nuclei.size()) {
            Nucleus n = (Nucleus)nuclei.elementAt(i);
            if (n.identity.equals(name1)) {
                n1 = n;
            } else if (n.identity.equals(name2)) {
                n2 = n;
            }
            ++i;
        }
        this.processPair(n1, n2, nucMgr);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String s = e.getActionCommand();
        if (s.equals(TEST1)) {
            this.append(TEST1);
            this.test1();
        } else if (s.equals(TEST2)) {
            this.append(TEST2);
            this.test2();
        } else if (s.equals(CLEAR)) {
            this.append("clear");
            this.iText.setText("");
        } else {
            super.actionPerformed(e);
        }
    }

    public static void main(String[] args) {
    }
}

