/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.analyze;

import ij.ImagePlus;
import ij.ImageStack;
import ij.gui.ImageWindow;
import ij.gui.OvalRoi;
import ij.gui.PolygonRoi;
import ij.gui.Roi;
import ij.gui.StackWindow;
import ij.process.ByteProcessor;
import ij.process.ImageProcessor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.zip.ZipEntry;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.rhwlab.acetree.AceTree;
import org.rhwlab.image.ZipImage;
import org.rhwlab.snight.NucleiMgr;
import org.rhwlab.snight.Nucleus;
import org.rhwlab.tree.AncesTree;
import org.rhwlab.tree.Cell;
import org.rhwlab.utils.Log;

public class Analysis8
extends Log {
    AceTree iAceTree;
    AncesTree iAncesTree;
    NucleiMgr iNucleiMgr;
    Vector nuclei_record;
    Cell iRoot;
    Hashtable iCellsByName;
    Hashtable iNucleiMgrHash;
    private double iXA;
    private double iYA;
    private double iZA;
    private JFrame iFrame;
    private JPanel iPanel;
    private JTextField iTextField;
    private ImagePlus iStackPlus;
    private StackWindow iStackWindow;
    private ImagePlus iBlankStackPlus;
    private StackWindow iBlankStackWindow;
    private ImageStack iStack;
    private StackWindow iExtraStackWindow;
    private static final String CLEAR = "Clear";
    private static final String TEST1 = "Test1";
    private static final String TEST2 = "Test2";
    private static final String TEST3 = "Test3";

    public Analysis8(String title) {
        super(title);
        this.showMe();
        this.buildOutToolBar();
        this.initialize();
        this.iStackWindow = null;
    }

    public void initialize() {
        this.iAceTree = AceTree.getAceTree(null);
        this.iNucleiMgr = this.iAceTree.getNucleiMgr();
        this.nuclei_record = this.iNucleiMgr.getNucleiRecord();
        this.iAncesTree = this.iNucleiMgr.getAncesTree();
        this.iCellsByName = this.iAncesTree.getCellsByName();
        this.iRoot = this.iAncesTree.getRoot();
        this.iNucleiMgrHash = this.iAceTree.getNucleiMgrHash();
    }

    public void test2() {
        System.out.println("test2 StackWindow: " + this.iStackWindow);
        if (this.iStackWindow != null) {
            this.append("closing: " + this.iStackWindow);
            this.iStackWindow.close();
            this.iStackWindow = null;
        }
        if (this.iBlankStackWindow != null) {
            this.append("closing: " + this.iBlankStackWindow);
            this.iBlankStackWindow.close();
            this.iBlankStackWindow = null;
        }
        if (this.iExtraStackWindow != null) {
            this.append("closing: " + this.iExtraStackWindow);
            this.iExtraStackWindow.close();
            this.iExtraStackWindow = null;
        }
    }

    public void test3() {
        this.append(TEST1);
        ImagePlus stack = this.createBlankStack("test");
        ImageStack stack2 = stack.getStack();
        this.addCircles(stack2);
        ImagePlus plusStack2 = this.createBlankStack("test add");
        this.computeCrosstalkUsingROI(plusStack2, stack);
        this.iStackWindow = new StackWindow(plusStack2);
    }

    private void addStacks(ImagePlus dst, ImagePlus src) {
        int i = 1;
        while (i <= 7) {
            ImageProcessor dstProc = dst.getStack().getProcessor(i);
            ImageProcessor srcProc = src.getStack().getProcessor(i);
            dstProc.copyBits(srcProc, 0, 0, 3);
            ++i;
        }
    }

    private void computeCrosstalkUsingROI(ImagePlus dst, ImagePlus src) {
        OvalRoi oRoi = this.makeOvalRoi(50, 50, 40);
        double r1 = 0.5;
        double r2 = 0.25;
        ImageProcessor d = dst.getStack().getProcessor(1);
        ImageProcessor s2 = src.getStack().getProcessor(3);
        this.processOneLevel(d, s2, r2, oRoi);
        d = dst.getStack().getProcessor(2);
        ImageProcessor s1 = s2;
        s2 = src.getStack().getProcessor(4);
        this.processOneLevel(d, s1, r1, oRoi);
        this.processOneLevel(d, s2, r2, oRoi);
        d = dst.getStack().getProcessor(3);
        s1 = s2;
        s2 = src.getStack().getProcessor(5);
        this.processOneLevel(d, s1, r1, oRoi);
        this.processOneLevel(d, s2, r2, oRoi);
        d = dst.getStack().getProcessor(4);
        s1 = s2;
        s2 = src.getStack().getProcessor(3);
        this.processOneLevel(d, s1, r1, oRoi);
        this.processOneLevel(d, s2, r1, oRoi);
        d = dst.getStack().getProcessor(5);
        s1 = src.getStack().getProcessor(4);
        this.processOneLevel(d, s1, r1, oRoi);
        this.processOneLevel(d, s2, r2, oRoi);
        d = dst.getStack().getProcessor(6);
        s2 = s1;
        s1 = src.getStack().getProcessor(5);
        this.processOneLevel(d, s1, r1, oRoi);
        this.processOneLevel(d, s2, r2, oRoi);
        d = dst.getStack().getProcessor(7);
        s2 = s1;
        this.processOneLevel(d, s2, r2, oRoi);
    }

    private void processOneLevel(ImageProcessor d, ImageProcessor s, double r, OvalRoi roi) {
        s.snapshot();
        s.setRoi((Roi)roi);
        ImageProcessor s2 = s.crop();
        s2.multiply(r);
        s2.copyBits(roi.getMask(), 0, 0, 9);
        d.copyBits(s2, 30, 30, 3);
        s.setRoi(null);
    }

    private void computeCrosstalk(ImagePlus dst, ImagePlus src) {
        double r1 = 0.5;
        double r2 = 0.25;
        ImageProcessor d = dst.getStack().getProcessor(1);
        ImageProcessor s2 = src.getStack().getProcessor(3);
        s2.snapshot();
        s2.multiply(r2);
        d.copyBits(s2, 0, 0, 3);
        s2.reset();
        d = dst.getStack().getProcessor(2);
        ImageProcessor s1 = s2;
        s2 = src.getStack().getProcessor(4);
        this.processOneLevel(d, s1, r1);
        this.processOneLevel(d, s2, r2);
        d = dst.getStack().getProcessor(3);
        s1 = s2;
        s2 = src.getStack().getProcessor(5);
        this.processOneLevel(d, s1, r1);
        this.processOneLevel(d, s2, r2);
        d = dst.getStack().getProcessor(4);
        s1 = s2;
        s2 = src.getStack().getProcessor(3);
        this.processOneLevel(d, s1, r1);
        this.processOneLevel(d, s2, r1);
        d = dst.getStack().getProcessor(5);
        s1 = src.getStack().getProcessor(4);
        this.processOneLevel(d, s1, r1);
        this.processOneLevel(d, s2, r2);
        d = dst.getStack().getProcessor(6);
        s2 = s1;
        s1 = src.getStack().getProcessor(5);
        this.processOneLevel(d, s1, r1);
        this.processOneLevel(d, s2, r2);
        d = dst.getStack().getProcessor(7);
        s2 = s1;
        this.processOneLevel(d, s2, r2);
    }

    private void processOneLevel(ImageProcessor d, ImageProcessor s, double r) {
        s.snapshot();
        s.multiply(r);
        d.copyBits(s, 0, 0, 3);
        s.reset();
    }

    private ImagePlus createBlankStack(String title) {
        return this.createBlankStack(title, 100, 100, 7);
    }

    private ImagePlus createBlankStack(String title, int width, int height, int planes) {
        ImagePlus iplus = null;
        ImageStack stack = null;
        int i = 1;
        while (i <= planes) {
            ByteProcessor iproc = new ByteProcessor(width, height);
            if (iplus == null) {
                iplus = new ImagePlus(String.valueOf(i), (ImageProcessor)iproc);
                stack = iplus.getStack();
            } else {
                stack.addSlice(String.valueOf(i), (ImageProcessor)iproc);
            }
            ++i;
        }
        return new ImagePlus(title, stack);
    }

    private void addCircle(ImageProcessor iproc) {
        OvalRoi oRoi = this.makeOvalRoi(50, 50, 40);
        ImageProcessor mask = oRoi.getMask();
        System.out.println("addCircle: " + mask);
        ImagePlus iplus = new ImagePlus("test", mask);
        ImageWindow iwin = new ImageWindow(iplus);
        iproc.snapshot();
        iproc.setRoi((Roi)oRoi);
        iproc.add(128);
        iproc.reset(mask);
    }

    private void addCircles(ImageStack stack) {
        int i = 1;
        while (i <= 7) {
            ImageProcessor iproc = stack.getProcessor(i);
            int d = this.getLocalDiameter(40.0, 4.0, i);
            d = i > 2 && i < 6 ? 40 : 0;
            System.out.println("addCircle: " + d);
            if (d > 0) {
                PolygonRoi oRoi = this.makePolygonRoi(50, 50, d);
                ImageProcessor mask = oRoi.getMask();
                iproc.snapshot();
                iproc.setRoi((Roi)oRoi);
                iproc.add(128);
                iproc.reset(mask);
            }
            ++i;
        }
    }

    private PolygonRoi makePolygonRoi(int x, int y, int d) {
        int[] xa = new int[]{x - d / 2, x + d / 2, x + d / 2, x - d / 2};
        int[] ya = new int[]{y - d / 2, y - d / 2, y + d / 2, y + d / 2};
        return new PolygonRoi(xa, ya, 4, 2);
    }

    private OvalRoi makeOvalRoi(int x, int y, int d) {
        return new OvalRoi(x - d / 2, y - d / 2, d, d);
    }

    private int getLocalDiameter(double baseDia, double basePlane, int currentPlane) {
        double r = 0.0;
        double y = (basePlane - (double)currentPlane) * 10.0 / (baseDia / 2.0);
        double r2 = 1.0 - y * y;
        if (r2 >= 0.0) {
            r = Math.sqrt(r2) * (baseDia / 2.0);
        }
        return (int)Math.round(2.0 * r);
    }

    public void test1() {
        this.append(TEST1);
        System.gc();
        long start = System.currentTimeMillis();
        int k = Integer.parseInt(this.iTextField.getText());
        this.makeStack(k);
        Vector allCircles = this.makeAllCircles(k);
        this.processAllCircles(allCircles);
        this.iStackPlus = new ImagePlus("Stack", this.iStack);
        this.iStackWindow = new StackWindow(this.iStackPlus);
        this.iBlankStackWindow = new StackWindow(this.iBlankStackPlus);
        this.subtractShadows();
        this.append("new StackWindow: " + this.iStackWindow);
        System.out.println("new StackWindow: " + this.iStackWindow);
        long elapsed = System.currentTimeMillis() - start;
        this.append("elapsedTime: " + elapsed);
    }

    private void subtractShadows() {
        ImageStack base = this.iStackPlus.getStack();
        ImageStack shadow = this.iBlankStackPlus.getStack();
        ImagePlus iplus = null;
        ImageStack stack = null;
        int i = 0;
        while (i < base.getSize()) {
            ImageProcessor baseP = base.getProcessor(i + 1).crop();
            ImageProcessor shadowP = shadow.getProcessor(i + 1);
            baseP.copyBits(shadowP, 0, 0, 4);
            if (iplus == null) {
                iplus = new ImagePlus(String.valueOf(i + 1), baseP);
                stack = iplus.getStack();
            } else {
                stack.addSlice(String.valueOf(i + 1), baseP);
            }
            ++i;
        }
        this.iExtraStackWindow = new StackWindow(new ImagePlus("adjusted stack", stack));
    }

    private void processAllCircles(Vector allCircles) {
        Collections.sort(allCircles, new Centroid());
        Enumeration e = allCircles.elements();
        int plane = 0;
        ImageProcessor ip = null;
        ImageProcessor ibp = null;
        boolean count = false;
        while (e.hasMoreElements()) {
            Centroid c = (Centroid)e.nextElement();
            System.out.println("centroid: " + c);
            if (c.plane > plane) {
                plane = c.plane;
                ip = this.iStack.getProcessor(plane);
                ibp = this.iBlankStackPlus.getStack().getProcessor(plane);
            }
            OvalRoi oRoi = this.makeOvalRoi(c, plane);
            ImageProcessor mask = oRoi.getMask();
            ip.snapshot();
            ip.setRoi((Roi)oRoi);
            ImageProcessor p = ip.crop();
            this.copyCentroidShadowsToNewStack(ibp, p, (Roi)oRoi, c);
            ip.reset(mask);
        }
    }

    private void copyCentroidToNewStack(ImageProcessor dst, ImageProcessor src, Roi roi, Centroid c) {
        float fxx = c.x;
        float fyy = c.y;
        fxx = (float)((double)fxx - c.d / 2.0);
        fyy = (float)((double)fyy - c.d / 2.0);
        int xx = Math.round(fxx);
        int yy = Math.round(fyy);
        int d = (int)Math.round(c.d);
        src.copyBits(roi.getMask(), 0, 0, 9);
        dst.copyBits(src, xx, yy, 3);
    }

    private void copyCentroidShadowsToNewStack(ImageProcessor dst, ImageProcessor src, Roi roi, Centroid c) {
        float fxx = c.x;
        float fyy = c.y;
        fxx = (float)((double)fxx - c.d / 2.0);
        fyy = (float)((double)fyy - c.d / 2.0);
        int xx = Math.round(fxx);
        int yy = Math.round(fyy);
        int d = (int)Math.round(c.d);
        ImageProcessor mask = roi.getMask();
        src.copyBits(mask, 0, 0, 9);
        int[] ka = new int[]{-3, -2, -1, 1, 2, 3};
        double[] r = new double[]{0.0, 0.25, 0.35, 0.35, 0.25, 0.0};
        double baseFrac = 1.0;
        int numPlanes = this.iNucleiMgr.getPlaneEnd();
        src.snapshot();
        int i = 0;
        while (i < ka.length) {
            int k = c.plane + ka[i];
            if (k >= 1 && k <= numPlanes) {
                ImageProcessor p = this.iBlankStackPlus.getStack().getProcessor(k);
                src.multiply(r[i]);
                p.copyBits(src, xx, yy, 3);
                src.reset();
            }
            ++i;
        }
        ImageProcessor p = this.iBlankStackPlus.getStack().getProcessor(c.plane);
        src.multiply(baseFrac);
        p.copyBits(src, xx, yy, 4);
        src.reset();
    }

    private OvalRoi makeOvalRoi(Centroid c, int plane) {
        float fxx = c.x;
        float fyy = c.y;
        fxx = (float)((double)fxx - c.d / 2.0);
        fyy = (float)((double)fyy - c.d / 2.0);
        int xx = Math.round(fxx);
        int yy = Math.round(fyy);
        int d = (int)Math.round(c.d);
        OvalRoi oRoi = new OvalRoi(xx, yy, d, d);
        return oRoi;
    }

    private Vector makeAllCircles(int time) {
        Vector<Centroid> allCircles = new Vector<Centroid>();
        int k = Integer.parseInt(this.iTextField.getText());
        Vector nuclei = (Vector)this.nuclei_record.elementAt(k - 1);
        Nucleus n = null;
        Enumeration e = nuclei.elements();
        int j = 0;
        while (j < nuclei.size()) {
            n = (Nucleus)nuclei.elementAt(j);
            if (n.status != -1) {
                Vector<Centroid> v = new Vector<Centroid>();
                int plane = 1;
                while (plane <= this.iNucleiMgr.getPlaneEnd()) {
                    double d = this.iNucleiMgr.nucDiameter(n, plane);
                    if (d > 0.0) {
                        Centroid c = new Centroid();
                        c.index = j + 1;
                        c.time = k - 1;
                        c.plane = plane;
                        c.x = n.x;
                        c.y = n.y;
                        c.d = d;
                        c.name = n.identity;
                        c.weight = n.weight;
                        c.n = n;
                        v.add(c);
                        allCircles.add(c);
                    }
                    ++plane;
                }
            }
            ++j;
        }
        return allCircles;
    }

    private void makeStack(int time) {
        String imageFileBase = org.rhwlab.image.ImageWindow.cZipTifFilePath;
        imageFileBase = String.valueOf(imageFileBase) + "/" + org.rhwlab.image.ImageWindow.cTifPrefixR;
        String imageFile = String.valueOf(imageFileBase) + this.iAceTree.makeImageName(time, 1);
        this.append(imageFile);
        ImageProcessor ip = this.getRedData(imageFile);
        int width = ip.getWidth();
        int height = ip.getHeight();
        int numPlanes = this.iNucleiMgr.getPlaneEnd();
        this.iBlankStackPlus = this.createBlankStack("new stack", width, height, numPlanes);
        ImagePlus iplus = null;
        this.iStack = null;
        int plane = 1;
        while (plane <= this.iNucleiMgr.getPlaneEnd()) {
            imageFile = String.valueOf(imageFileBase) + this.iAceTree.makeImageName(time, plane);
            ImageProcessor iproc = this.getRedData(imageFile);
            if (iplus == null) {
                iplus = new ImagePlus(String.valueOf(plane), iproc);
                this.iStack = iplus.getStack();
            } else {
                this.iStack.addSlice(String.valueOf(plane), iproc);
            }
            ++plane;
        }
    }

    private void processStack() {
        int k = this.iStack.getSize();
        int i = 1;
        while (i <= k) {
            ImageProcessor ip = this.iStack.getProcessor(i);
            ip.setRoi(200, 300, 50, 50);
            ip.and(0);
            ++i;
        }
    }

    private void processImage(ImagePlus iplus) {
        iplus.setRoi(this.makeRoi());
        iplus.getProcessor().add(100);
    }

    private Roi makeRoi() {
        int[] x = new int[]{200, 300, 300, 200};
        int[] y = new int[]{300, 300, 400, 400};
        return new PolygonRoi(x, y, 4, 2);
    }

    private Roi makeRoi2() {
        int[] x = new int[]{100, 200, 200, 100};
        int[] y = new int[]{200, 200, 300, 300};
        return new PolygonRoi(x, y, 4, 2);
    }

    private ImageProcessor getRedData(String greenName) {
        if (org.rhwlab.image.ImageWindow.cUseZip == 2) {
            return this.getRedZipData(greenName);
        }
        ImagePlus ip = null;
        try {
            FileInputStream fis = new FileInputStream(greenName);
            byte[] ba = org.rhwlab.image.ImageWindow.readByteArray(fis);
            ip = org.rhwlab.image.ImageWindow.openTiff(new ByteArrayInputStream(ba), false);
            fis.close();
            if (org.rhwlab.image.ImageWindow.imagewindowUseStack == 1) {
                int markerChannel = 1;
                ip = org.rhwlab.image.ImageWindow.splitImage(ip, markerChannel);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (ip != null) {
            return ip.getProcessor();
        }
        return null;
    }

    private ImageProcessor getRedZipData(String redName) {
        ZipImage zipImage = new ZipImage(redName);
        int k1 = redName.lastIndexOf("/") + 1;
        String ss = redName.substring(k1);
        int k2 = ss.indexOf(".");
        ss = ss.substring(0, k2);
        ZipEntry ze = null;
        if (zipImage != null) {
            ze = zipImage.getZipEntry(String.valueOf(ss) + ".tif");
        }
        ImagePlus ip = null;
        ip = zipImage.readData(ze, true);
        if (ip != null) {
            return ip.getProcessor();
        }
        return null;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String s = e.getActionCommand();
        if (s.equals(TEST1)) {
            this.test1();
        } else if (s.equals(TEST2)) {
            this.append(TEST2);
            this.test2();
        } else if (s.equals(TEST3)) {
            this.append(TEST3);
            this.test3();
        } else if (s.equals(CLEAR)) {
            this.append("clear");
            this.iText.setText("");
        } else {
            super.actionPerformed(e);
        }
    }

    private void buildOutToolBar() {
        this.iToolBar.setMaximumSize(new Dimension(500, 20));
        this.iToolBar.add(new JLabel("time:"));
        this.iTextField = new JTextField();
        this.iTextField.setColumns(15);
        this.iTextField.setText("1");
        this.iToolBar.add(this.iTextField);
        JButton jb = null;
        jb = new JButton(CLEAR);
        this.addToolBarButton(jb);
        jb = new JButton(TEST1);
        this.addToolBarButton(jb);
        jb = new JButton(TEST2);
        this.addToolBarButton(jb);
        jb = new JButton(TEST3);
        this.addToolBarButton(jb);
    }

    public static void main(String[] args) {
    }

    private class Centroid
    implements Comparator {
        public int time;
        public int plane;
        public int index;
        public int x;
        public int y;
        public double d;
        public String name;
        public int weight;
        public Nucleus n;
        public int rsum;
        public int rcount;

        private Centroid() {
        }

        public String toString() {
            String s = String.valueOf(this.index);
            s = String.valueOf(s) + ", " + this.time;
            s = String.valueOf(s) + ", " + this.plane;
            s = String.valueOf(s) + ", " + this.x;
            s = String.valueOf(s) + ", " + this.y;
            s = String.valueOf(s) + ", " + this.d;
            s = String.valueOf(s) + ", " + this.name;
            s = String.valueOf(s) + ", " + this.weight;
            s = String.valueOf(s) + ", " + this.rsum;
            s = String.valueOf(s) + ", " + this.rcount;
            return s;
        }

        public int compare(Object o1, Object o2) {
            if (((Centroid)o1).plane < ((Centroid)o2).plane) {
                return -1;
            }
            if (((Centroid)o1).plane > ((Centroid)o2).plane) {
                return 1;
            }
            return 0;
        }
    }
}

