/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.analyze;

import java.awt.event.ActionEvent;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JButton;
import org.rhwlab.acetree.AceTree;
import org.rhwlab.snight.NucleiMgr;
import org.rhwlab.snight.Nucleus;
import org.rhwlab.tree.AncesTree;
import org.rhwlab.tree.Cell;
import org.rhwlab.utils.Log;

public class DeathAndDivisionLog
extends Log {
    private AceTree iAceTree;
    AncesTree iAncesTree;
    NucleiMgr iNucleiMgr;
    Vector nuclei_record;
    Cell iRoot;
    Hashtable iCellsByName;
    int iImageTime;
    int iTimeInc;
    int iEndingIndex;
    private static final String DIVISIONTEMPLATE = "  Division:                 ->                  +                 ";
    private static final String DEATHTEMPLATE = "  Death:                ";
    private static final int DEAD = -1;
    private static final int PARLOC = 12;
    private static final int DAULOC = 31;
    private static final int DAULOC2 = 50;
    private static final int DEATHLOC = 9;
    private static final String UPDATENOW = "Update now";
    private static final String CLEAR = "Clear";

    public DeathAndDivisionLog(AceTree aceTree, String title) {
        super(title);
        this.iAceTree = aceTree;
        JButton jb = new JButton(CLEAR);
        this.addToolBarButton(jb);
        jb = new JButton(UPDATENOW);
        this.addToolBarButton(jb);
        this.initialize();
        this.showDivisionsAndDeaths();
    }

    public void initialize() {
        this.iAceTree = AceTree.getAceTree(null);
        this.iNucleiMgr = this.iAceTree.getNucleiMgr();
        this.nuclei_record = this.iNucleiMgr.getNucleiRecord();
        this.iAncesTree = this.iNucleiMgr.getAncesTree();
        this.iCellsByName = this.iAncesTree.getCellsByName();
        this.iRoot = this.iAncesTree.getRoot();
    }

    public void showDivisionsAndDeaths() {
        this.iImageTime = this.iAceTree.getImageTime();
        this.iTimeInc = this.iAceTree.getTimeInc();
        this.iEndingIndex = this.iNucleiMgr.getEndingIndex();
        int now = this.iImageTime + this.iTimeInc;
        Vector nucleiNow = (Vector)this.iNucleiMgr.getNucleiRecord().elementAt(now - 1);
        Nucleus nnow = null;
        this.append("time: " + now);
        int j = 0;
        while (j < nucleiNow.size()) {
            nnow = (Nucleus)nucleiNow.elementAt(j);
            if (nnow.status > 0) {
                if (nnow.successor2 == -1) {
                    if (nnow.successor1 == -1 && now != this.iEndingIndex) {
                        System.out.println(this.death(nnow.identity));
                        this.append(this.death(nnow.identity));
                    }
                } else if (nnow.successor1 > 0) {
                    Vector nucleiNext = (Vector)this.iNucleiMgr.getNucleiRecord().elementAt(now);
                    Nucleus a = (Nucleus)nucleiNext.elementAt(nnow.successor1 - 1);
                    Nucleus p = (Nucleus)nucleiNext.elementAt(nnow.successor2 - 1);
                    this.append(this.division(nnow.identity, a.identity, p.identity));
                }
            }
            ++j;
        }
        if (!this.isShowing()) {
            this.showMe();
        }
    }

    public String division(String par, String dau, String dau2) {
        StringBuffer sb = new StringBuffer(DIVISIONTEMPLATE);
        sb.replace(12, 12 + par.length(), par);
        sb.replace(31, 31 + dau.length(), dau);
        sb.replace(50, 50 + dau.length(), dau2);
        return sb.toString();
    }

    private String death(String cellName) {
        StringBuffer sb = new StringBuffer(DEATHTEMPLATE);
        sb.replace(9, 9 + cellName.length(), cellName);
        return sb.toString();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String s = e.getActionCommand();
        if (s.equals(UPDATENOW)) {
            this.showDivisionsAndDeaths();
        } else if (s.equals(CLEAR)) {
            this.iText.setText("");
        } else {
            super.actionPerformed(e);
        }
    }

    public static void main(String[] args) {
    }
}

