/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.analyze;

import ij.ImagePlus;
import ij.gui.OvalRoi;
import ij.gui.Roi;
import ij.io.Opener;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ImageStatistics;
import ij.process.ShortProcessor;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.zip.ZipEntry;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import org.rhwlab.acetree.AceTree;
import org.rhwlab.image.ImageWindow;
import org.rhwlab.image.ZipImage;
import org.rhwlab.snight.NucleiMgr;
import org.rhwlab.snight.Nucleus;
import org.rhwlab.tree.AncesTree;
import org.rhwlab.tree.Cell;
import org.rhwlab.utils.EUtils;
import org.rhwlab.utils.Log;

public class ExtractRed
extends Log {
    private JTextField iTextField;
    AceTree iAceTree;
    AncesTree iAncesTree;
    NucleiMgr iNucleiMgr;
    Vector nuclei_record;
    Cell iRoot;
    Hashtable iCellsByName;
    Vector iAllCircles;
    JCheckBox redChannelButton;
    private static final int STANDARDCOUNT = 1000;
    private static final String CLEAR = "Clear";
    private static final String TEST1 = "One";
    private static final String TEST2 = "All";
    private static final String TEST3 = "Test3";
    private static final String REDCHANNEL = "Red?";

    public ExtractRed(String title) {
        super(title);
        this.showMe();
        this.buildOutToolBar();
        this.initialize();
    }

    public void test1() {
        int k;
        long start = System.currentTimeMillis();
        Vector circles = new Vector();
        Vector<Centroid> allCircles = new Vector<Centroid>();
        int i = k = Integer.parseInt(this.iTextField.getText());
        while (i < k + 1) {
            Vector nuclei = (Vector)this.nuclei_record.elementAt(i - 1);
            circles = new Vector();
            Nucleus n = null;
            Enumeration e = nuclei.elements();
            int j = 0;
            while (j < nuclei.size()) {
                n = (Nucleus)nuclei.elementAt(j);
                if (n.status != -1) {
                    Vector<Centroid> v = new Vector<Centroid>();
                    int plane = 1;
                    while (plane <= this.iNucleiMgr.getPlaneEnd()) {
                        double d = this.iNucleiMgr.nucDiameter(n, plane);
                        if (d > 0.0) {
                            Centroid c = new Centroid();
                            c.index = j + 1;
                            c.time = i;
                            c.plane = plane;
                            c.x = n.x;
                            c.y = n.y;
                            c.d = d;
                            c.name = n.identity;
                            c.weight = n.weight;
                            c.n = n;
                            v.add(c);
                            allCircles.add(c);
                        }
                        ++plane;
                    }
                    circles.add(v);
                }
                ++j;
            }
            this.processAllCircles(allCircles, circles, true);
            ++i;
        }
        long elapsed = System.currentTimeMillis() - start;
        this.append("elapsedTime: " + elapsed + ", " + circles.size());
    }

    private void processAllCircles(Vector allCircles, Vector circles, boolean report) {
        Collections.sort(allCircles, new Centroid());
        Enumeration e = allCircles.elements();
        int plane = 0;
        ImageProcessor ipRed = null;
        while (e.hasMoreElements()) {
            Centroid c = (Centroid)e.nextElement();
            if (c.plane > plane) {
                plane = c.plane;
                String imageFile = ImageWindow.cZipTifFilePath;
                if (ImageWindow.imagewindowUseStack == 1) {
                    imageFile = String.valueOf(imageFile) + "/" + ImageWindow.cTifPrefix;
                    imageFile = String.valueOf(imageFile) + this.iAceTree.makeImageName(c.time, c.plane);
                } else {
                    imageFile = String.valueOf(imageFile) + "/" + ImageWindow.cTifPrefixR;
                    imageFile = String.valueOf(imageFile) + this.iAceTree.makeImageName(c.time, c.plane);
                }
                ipRed = this.getRedData(imageFile, c.plane);
            }
            c.rsum = 0;
            c.rcount = 1;
            if (ipRed == null) continue;
            int[] ia = this.processImageUsingPolygon(ipRed, c);
            c.rsum = ia[0];
            c.rcount = ia[1];
        }
        Enumeration ee = circles.elements();
        while (ee.hasMoreElements()) {
            int redWeight;
            Vector vv = (Vector)ee.nextElement();
            int redSum = 0;
            int redCount = 0;
            Centroid cc = null;
            Enumeration ec = vv.elements();
            while (ec.hasMoreElements()) {
                cc = (Centroid)ec.nextElement();
                redSum += cc.rsum;
                redCount += cc.rcount;
            }
            cc.n.rweight = redWeight = redSum * 1000 / redCount;
            cc.n.rsum = redSum;
            cc.n.rcount = redCount;
            cc.n.rwraw = redWeight;
            if (!report) continue;
            this.append(String.valueOf(cc.index) + ", " + redCount + ", " + redWeight + ", " + cc.n.rweight + ", " + redSum + ", " + cc.weight + ", " + cc.name);
        }
    }

    public void test2() {
        long start = System.currentTimeMillis();
        int m = this.iNucleiMgr.getConfig().iStartingIndex;
        int q = this.iNucleiMgr.getConfig().iEndingIndex;
        int i = m;
        while (i <= q) {
            Vector circles = new Vector();
            Vector<Centroid> allCircles = new Vector<Centroid>();
            Vector nuclei = (Vector)this.nuclei_record.elementAt(i - 1);
            circles = new Vector();
            Nucleus n = null;
            Enumeration e = nuclei.elements();
            int j = 0;
            while (j < nuclei.size()) {
                n = (Nucleus)nuclei.elementAt(j);
                if (n.status != -1) {
                    Vector<Centroid> v = new Vector<Centroid>();
                    int plane = 1;
                    while (plane <= this.iNucleiMgr.getPlaneEnd()) {
                        double d = this.iNucleiMgr.nucDiameter(n, plane);
                        if (d > 0.0) {
                            Centroid c = new Centroid();
                            c.index = j + 1;
                            c.time = i;
                            c.plane = plane;
                            c.x = n.x;
                            c.y = n.y;
                            c.d = d;
                            c.name = n.identity;
                            c.weight = n.weight;
                            c.n = n;
                            v.add(c);
                            allCircles.add(c);
                        }
                        ++plane;
                    }
                    circles.add(v);
                }
                ++j;
            }
            this.processAllCircles(allCircles, circles, false);
            if (i % 10 == 0) {
                long elapsed = System.currentTimeMillis() - start;
                System.out.println("elapsedTime: " + elapsed + ", " + circles.size() + ", " + i);
                System.out.flush();
            }
            ++i;
        }
        long elapsed = System.currentTimeMillis() - start;
        this.append("elapsedTime: " + elapsed);
    }

    private int[] processCentroid(Centroid cc) {
        String imageFile = ImageWindow.cZipTifFilePath;
        imageFile = String.valueOf(imageFile) + "/" + ImageWindow.cTifPrefixR;
        imageFile = String.valueOf(imageFile) + this.iAceTree.makeImageName(cc.time, cc.plane);
        ImageProcessor ipRed = this.getRedData(imageFile, cc.plane);
        int[] ia = this.processImage(ipRed, cc);
        return ia;
    }

    public int[] processImage(ImageProcessor ipRed, Centroid c) {
        byte[] redPixels = (byte[])ipRed.getPixels();
        float fxx = c.x;
        float fyy = c.y;
        fxx = (float)((double)fxx - c.d / 2.0);
        fyy = (float)((double)fyy - c.d / 2.0);
        int xx = (int)((double)fxx + 0.5);
        int yy = (int)((double)fyy + 0.5);
        int d = (int)(c.d + 0.5);
        OvalRoi oRoi = new OvalRoi(xx, yy, d, d);
        Rectangle r = oRoi.getBounds();
        int width = ipRed.getWidth();
        int redSum = 0;
        int redCount = 0;
        int y = r.y;
        while (y < r.y + r.height) {
            int offset = y * width;
            int x = r.x;
            while (x <= r.x + r.width) {
                int i = offset + x;
                if (oRoi.contains(x, y)) {
                    int k = ipRed.getPixel(x, y);
                    redSum += k;
                    ++redCount;
                }
                ++x;
            }
            ++y;
        }
        int[] ia = new int[]{redSum, redCount};
        return ia;
    }

    int convert(int u) {
        int v = u >> 8;
        return v &= 0xFF;
    }

    public int[] processImageUsingRoi(ImageProcessor ipRed, Centroid c) {
        float fxx = c.x;
        float fyy = c.y;
        fxx = (float)((double)fxx - c.d / 2.0);
        fyy = (float)((double)fyy - c.d / 2.0);
        int xx = Math.round(fxx);
        int yy = Math.round(fyy);
        int d = (int)Math.round(c.d);
        OvalRoi oRoi = new OvalRoi(xx, yy, d, d);
        ImagePlus iplus2 = new ImagePlus("test", ipRed);
        int area = 0;
        iplus2.setRoi((Roi)oRoi);
        area = (int)(Math.PI * c.d * c.d / 4.0);
        ImageStatistics istat2 = iplus2.getStatistics();
        int[] ia = new int[2];
        int redSum = (int)(istat2.mean * (double)area);
        int redCount = area;
        ia[0] = redSum;
        ia[1] = redCount;
        return ia;
    }

    public int[] processImageUsingPolygon(ImageProcessor ipRed, Centroid c) {
        int rad = (int)Math.round(c.d / 2.0);
        Polygon inner = EUtils.pCircle(c.x, c.y, rad);
        Rectangle r = inner.getBounds();
        double nucleusRed = 0.0;
        double nucleusRedCount = 0.0;
        int y = r.y;
        while (y < r.y + r.height) {
            int x = r.x;
            while (x <= r.x + r.width) {
                if (inner.contains(x, y)) {
                    int p = ipRed.getPixel(x, y);
                    nucleusRed += (double)p;
                    nucleusRedCount += 1.0;
                }
                ++x;
            }
            ++y;
        }
        int[] ia = new int[]{(int)Math.round(nucleusRed), (int)Math.round(nucleusRedCount)};
        return ia;
    }

    private ImageProcessor getRedData(String greenName, int plane) {
        if (ImageWindow.cUseZip == 2) {
            return this.getRedZipData(greenName);
        }
        ImagePlus ip = null;
        ip = ImageWindow.imagewindowUseStack == 1 ? new Opener().openImage(greenName, plane) : new Opener().openImage(greenName);
        if (ImageWindow.imagewindowUseStack == 1) {
            int markerChannel = this.redChannelButton.getModel().isSelected() ? 2 : 1;
            ip = ImageWindow.splitImage(ip, markerChannel);
        }
        System.out.println(ip);
        System.out.println(ip.getProcessor() instanceof FloatProcessor);
        System.out.println(ip.getProcessor() instanceof ShortProcessor);
        if (ip != null) {
            return ip.getProcessor();
        }
        return null;
    }

    private ImageProcessor getRedZipData(String redName) {
        ZipImage zipImage = new ZipImage(redName);
        int k1 = redName.lastIndexOf("/") + 1;
        String ss = redName.substring(k1);
        int k2 = ss.indexOf(".");
        ss = ss.substring(0, k2);
        ZipEntry ze = null;
        if (zipImage != null) {
            ze = zipImage.getZipEntry(String.valueOf(ss) + ".tif");
        }
        ImagePlus ip = null;
        ip = zipImage.readData(ze, true);
        if (ip != null) {
            return ip.getProcessor();
        }
        return null;
    }

    private void processVectorOfROIs(Vector v, int time, int plane) {
        this.append("processVectorOfROIs " + plane);
    }

    public void initialize() {
        this.iAceTree = AceTree.getAceTree(null);
        this.iNucleiMgr = this.iAceTree.getNucleiMgr();
        this.nuclei_record = this.iNucleiMgr.getNucleiRecord();
        this.iAncesTree = this.iNucleiMgr.getAncesTree();
        this.iCellsByName = this.iAncesTree.getCellsByName();
        this.iRoot = this.iAncesTree.getRoot();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String s = e.getActionCommand();
        if (s.equals(TEST1)) {
            this.test1();
        } else if (s.equals(TEST2)) {
            this.test2();
        } else if (s.equals(CLEAR)) {
            this.append("clear");
            this.iText.setText("");
        } else {
            super.actionPerformed(e);
        }
    }

    private void buildOutToolBar() {
        this.iToolBar.add(new JLabel("time:"));
        this.iTextField = new JTextField();
        this.iTextField.setColumns(15);
        this.iTextField.setText("175");
        this.iToolBar.add(this.iTextField);
        JButton jb = null;
        jb = new JButton(CLEAR);
        this.addToolBarButton(jb);
        jb = new JButton(TEST1);
        this.addToolBarButton(jb);
        jb = new JButton(TEST2);
        this.addToolBarButton(jb);
        if (ImageWindow.imagewindowUseStack == 1) {
            this.redChannelButton = new JCheckBox(REDCHANNEL);
            this.addToolBarButton(this.redChannelButton);
        }
    }

    public static void main(String[] args) {
    }

    private class Centroid
    implements Comparator {
        public int time;
        public int plane;
        public int index;
        public int x;
        public int y;
        public double d;
        public String name;
        public int weight;
        public Nucleus n;
        public int rsum;
        public int rcount;

        private Centroid() {
        }

        public String toString() {
            String s = String.valueOf(this.index);
            s = String.valueOf(s) + ", " + this.time;
            s = String.valueOf(s) + ", " + this.plane;
            s = String.valueOf(s) + ", " + this.x;
            s = String.valueOf(s) + ", " + this.y;
            s = String.valueOf(s) + ", " + this.d;
            s = String.valueOf(s) + ", " + this.name;
            s = String.valueOf(s) + ", " + this.weight;
            s = String.valueOf(s) + ", " + this.rsum;
            s = String.valueOf(s) + ", " + this.rcount;
            return s;
        }

        public int compare(Object o1, Object o2) {
            if (((Centroid)o1).plane < ((Centroid)o2).plane) {
                return -1;
            }
            if (((Centroid)o1).plane > ((Centroid)o2).plane) {
                return 1;
            }
            return 0;
        }
    }
}

