/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.analyze;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Vector;

public class PluginClassLoader
extends ClassLoader {
    protected String path;
    protected Hashtable cache = new Hashtable();
    protected Vector jarFiles;

    public PluginClassLoader(String path) {
        this.path = path;
    }

    public Class loadClass(String className) throws ClassNotFoundException {
        return this.loadClass(className, true);
    }

    public synchronized Class loadClass(String className, boolean resolveIt) throws ClassNotFoundException {
        Class<?> result = (Class<?>)this.cache.get(className);
        if (result != null) {
            return result;
        }
        try {
            result = super.findSystemClass(className);
            return result;
        }
        catch (Exception exception) {
            System.out.println("loading from plugins directory");
            byte[] classBytes = this.loadClassBytes(className);
            if (classBytes == null) {
                System.out.println("ClassNotFoundException");
                throw new ClassNotFoundException(className);
            }
            result = this.defineClass(className, classBytes, 0, classBytes.length);
            if (result == null) {
                throw new ClassFormatError();
            }
            if (resolveIt) {
                this.resolveClass(result);
            }
            this.cache.put(className, result);
            return result;
        }
    }

    protected byte[] loadClassBytes(String name) {
        byte[] classBytes = null;
        classBytes = this.loadIt(this.path, name);
        return classBytes;
    }

    private byte[] loadIt(String path, String classname) {
        String filename = classname.replace('.', '/');
        filename = String.valueOf(filename) + ".class";
        File fullname = new File(path, filename);
        try {
            FileInputStream is = new FileInputStream(fullname);
            int bufsize = (int)fullname.length();
            byte[] buf = new byte[bufsize];
            ((InputStream)is).read(buf, 0, bufsize);
            ((InputStream)is).close();
            return buf;
        }
        catch (Exception e) {
            return null;
        }
    }
}

