/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.analyze;

import flanagan.math.Matrix;
import java.text.DecimalFormat;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.rhwlab.acetree.AceTree;
import org.rhwlab.snight.NucleiMgr;
import org.rhwlab.snight.Nucleus;

public class RedCorrector2 {
    AceTree iAceTree;
    NucleiMgr iNucleiMgr;
    static Hashtable cCells;
    static Matrix cM;
    static Hashtable cNuclei;
    static Vector cCellNames;
    private static final double[][] INFL;
    private static final double[][] INFLf;
    private static final String CS = ", ";
    private static final DecimalFormat DF0;
    private static final DecimalFormat DF1;
    private static final DecimalFormat DF2;
    private static final DecimalFormat DF4;

    static {
        INFL = new double[][]{{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0442, 0.0255, 0.0151, 0.0111, 0.0063, 0.0, 0.0}, {0.151, 0.0976, 0.0467, 0.0206, 0.0092, 0.0, 0.0}, {0.3765, 0.2219, 0.0699, 0.0185, 0.0067, 0.0, 0.0}, {0.7416, 0.3884, 0.0893, 0.0179, 0.0057, 0.0, 0.0}, {1.0, 0.5036, 0.1232, 0.0357, 0.0155, 0.0, 0.0}, {0.9505, 0.4869, 0.156, 0.0556, 0.0194, 0.0, 0.0}, {0.7092, 0.3918, 0.1695, 0.0703, 0.0216, 0.0, 0.0}, {0.4957, 0.298, 0.1492, 0.071, 0.0216, 0.0, 0.0}, {0.2738, 0.1797, 0.0927, 0.0476, 0.0167, 0.0, 0.0}, {0.0824, 0.0579, 0.0278, 0.0147, 0.005, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
        INFLf = new double[][]{{0.0271, 0.0228, 0.036, 0.0325, 0.0134, 0.0026, 0.0}, {0.0522, 0.0378, 0.0434, 0.0424, 0.0241, 0.0068, 0.0}, {0.0914, 0.0564, 0.0406, 0.0396, 0.03, 0.0093, 0.0}, {0.1772, 0.1144, 0.0536, 0.0296, 0.0248, 0.0091, 0.0}, {0.3765, 0.2219, 0.0699, 0.0246, 0.024, 0.0122, 0.0}, {0.7416, 0.3884, 0.0893, 0.0273, 0.0325, 0.0189, 0.0}, {1.0, 0.5036, 0.1232, 0.0457, 0.0442, 0.0203, 0.0}, {0.9505, 0.4869, 0.156, 0.0635, 0.042, 0.0159, 0.0}, {0.7092, 0.3918, 0.1695, 0.0778, 0.043, 0.0151, 0.0}, {0.4957, 0.298, 0.1492, 0.0787, 0.0437, 0.0157, 0.0}, {0.337, 0.2213, 0.1111, 0.0623, 0.0403, 0.0158, 0.0}, {0.1969, 0.1425, 0.0741, 0.0509, 0.0436, 0.0213, 0.0}, {0.1168, 0.1034, 0.0778, 0.0717, 0.0644, 0.0281, 0.0}, {0.0513, 0.0621, 0.064, 0.0666, 0.056, 0.0209, 0.0}, {0.019, 0.0259, 0.0307, 0.0317, 0.0236, 0.0068, 0.0}};
        DF0 = new DecimalFormat("####");
        DF1 = new DecimalFormat("######.#");
        DF2 = new DecimalFormat("####.##");
        DF4 = new DecimalFormat("####.####");
    }

    public RedCorrector2() {
        RedCorrector2.println("RedCorrector2 entered");
        long start = System.currentTimeMillis();
        this.iAceTree = AceTree.getAceTree(null);
        this.iNucleiMgr = this.iAceTree.getNucleiMgr();
        int m = this.iNucleiMgr.getConfig().iStartingIndex;
        int q = this.iNucleiMgr.getConfig().iEndingIndex;
        int i = m;
        while (i <= q) {
            RedCorrector2.correctNuclei(this.iNucleiMgr, i);
            if (i % 50 == 0) {
                long elapsed = System.currentTimeMillis() - start;
                RedCorrector2.println("elapsedTime: " + elapsed + CS + i);
                System.out.flush();
            }
            ++i;
        }
    }

    public static void correctNuclei(NucleiMgr nucMgr, int time) {
        Vector nuclei = nucMgr.getNuclei(time - 1);
        Hashtable<String, Nucleus> workingNuclei = new Hashtable<String, Nucleus>();
        int i = 0;
        while (i < nuclei.size()) {
            Nucleus ni = (Nucleus)nuclei.get(i);
            if (ni.status > 0) {
                workingNuclei.put(ni.identity, ni);
            }
            ++i;
        }
        Enumeration keys = workingNuclei.keys();
        Vector<String> cellNames = new Vector<String>();
        while (keys.hasMoreElements()) {
            String name = (String)keys.nextElement();
            cellNames.add(name);
        }
        Collections.sort(cellNames);
        cCellNames = cellNames;
        cCells = new Hashtable();
        int i2 = 0;
        while (i2 < cellNames.size()) {
            String name = (String)cellNames.get(i2);
            cCells.put(name, new Integer(i2));
            ++i2;
        }
        double zpixres = nucMgr.getZPixRes();
        int m = workingNuclei.size();
        Matrix M = new Matrix(m, m);
        int i3 = 0;
        while (i3 < m) {
            String name = (String)cellNames.get(i3);
            Nucleus ni = (Nucleus)workingNuclei.get(name);
            int j = 0;
            while (j < m) {
                String name2 = (String)cellNames.get(j);
                Nucleus nj = (Nucleus)workingNuclei.get(name2);
                double infl = RedCorrector2.influence2D(ni, nj);
                M.setElement(i3, j, infl);
                ++j;
            }
            ++i3;
        }
        double[] b = new double[m];
        int i4 = 0;
        while (i4 < m) {
            String name = (String)cellNames.get(i4);
            Nucleus n = (Nucleus)workingNuclei.get(name);
            if (n.rwcorr1 < 10) {
                n.rwcorr1 = 25000;
            }
            b[i4] = n.rwraw - n.rwcorr1;
            ++i4;
        }
        double[] x = M.solveLinearSet(b);
        int i5 = 0;
        while (i5 < x.length) {
            String name = (String)cellNames.get(i5);
            Nucleus n = (Nucleus)workingNuclei.get(name);
            n.rwcorr4 = n.rwraw - (int)Math.round(x[i5]);
            n.rweight = (int)Math.round(x[i5]);
            ++i5;
        }
        cM = M;
        cNuclei = workingNuclei;
    }

    public static void extractTerms(String cellName) {
        double meas = 0.0;
        int cols = cCellNames.size();
        int row = (Integer)cCells.get(cellName);
        int j = 0;
        while (j < cols) {
            String name = (String)cCellNames.get(j);
            double infl = cM.getElement(row, j);
            Nucleus n = (Nucleus)cNuclei.get(name);
            double t = n.rwraw - n.rwcorr4;
            double c = t * infl;
            meas += c;
            if (infl != 0.0) {
                RedCorrector2.println("extractTerms, " + j + CS + name + CS + RedCorrector2.fmt4(infl) + CS + RedCorrector2.fmt0(t) + CS + RedCorrector2.fmt1(c));
            }
            ++j;
        }
        Nucleus n = (Nucleus)cNuclei.get(cellName);
        double t = n.rwraw - n.rwcorr4;
        RedCorrector2.println("extractTerms, meas=" + RedCorrector2.fmt0(meas) + CS + RedCorrector2.fmt0(t) + CS + RedCorrector2.fmt0(meas - t) + CS + RedCorrector2.fmt0(n.rwraw));
    }

    public static void showResults(NucleiMgr nucMgr, int time) {
        Vector nuclei = nucMgr.getNuclei(time - 1);
        Hashtable<String, Nucleus> nucHash = new Hashtable<String, Nucleus>();
        Vector<String> cellNames = new Vector<String>();
        int i = 0;
        while (i < nuclei.size()) {
            Nucleus ni = (Nucleus)nuclei.get(i);
            if (ni.status > 0) {
                nucHash.put(ni.identity, ni);
                cellNames.add(ni.identity);
            }
            ++i;
        }
        Collections.sort(cellNames);
        i = 0;
        while (i < cellNames.size()) {
            String name = (String)cellNames.get(i);
            Nucleus n = (Nucleus)nucHash.get(name);
            StringBuffer sb = new StringBuffer(name);
            sb.append(CS + DF1.format(n.rwraw - n.rwcorr1));
            sb.append(CS + DF1.format(n.rwraw - n.rwcorr2));
            sb.append(CS + DF1.format(n.rwraw - n.rwcorr3));
            sb.append(CS + DF1.format(n.rwraw - n.rwcorr4));
            sb.append(CS + DF1.format(n.rwraw));
            sb.append(CS + DF1.format(n.rwcorr1));
            sb.append(CS + DF1.format(n.rwcorr2));
            sb.append(CS + DF1.format(n.rwcorr3));
            sb.append(CS + DF1.format(n.rwcorr4));
            RedCorrector2.println(sb.toString());
            ++i;
        }
    }

    private void showM(Matrix M) {
        int rows = M.getNrow();
        int cols = M.getNcol();
        int i = 0;
        while (i < rows) {
            String s = "";
            int j = 0;
            while (j < cols) {
                double x = M.getElement(i, j);
                s = String.valueOf(s) + RedCorrector2.fmt4(x) + CS;
                ++j;
            }
            RedCorrector2.println(s);
            ++i;
        }
    }

    private double correction(double infl, int weight, int background) {
        return infl * (double)(weight - background);
    }

    private double influence(double d) {
        if (d >= 90.0) {
            return 0.0;
        }
        double[] pattern = new double[]{1.0, 0.35, 0.15, 0.05, 0.025, 0.01, 0.0};
        int k = (int)Math.floor(d / 15.0);
        double f = (d - (double)(15 * k)) / 15.0;
        double infl = f * pattern[k + 1] + (1.0 - f) * pattern[k];
        return infl;
    }

    private double influenceN(Nucleus ni, Nucleus nj, double maxDistance) {
        double x = Math.abs(ni.x - nj.x);
        if (x > maxDistance) {
            return 0.0;
        }
        double y = Math.abs(ni.y - nj.y);
        if (y > maxDistance) {
            return 0.0;
        }
        double z = (double)Math.abs(ni.z - nj.z) * this.iNucleiMgr.getZPixRes();
        if (z > maxDistance) {
            return 0.0;
        }
        double d = Math.sqrt(x * x + y * y + z * z);
        if (d > maxDistance) {
            return 0.0;
        }
        return this.influence(d);
    }

    private static double infl(int i, int j) {
        double infl = 0.0;
        if (i >= 0 && j >= 0 && i < 15 && j < 7) {
            return INFLf[i][j];
        }
        return 0.0;
    }

    private static double influence2D(Nucleus nFrom, Nucleus nTo) {
        int r = INFL.length - 1;
        int c = INFL[0].length - 1;
        double nomz = 0.0;
        double nomx = 10.0;
        int zb = 6;
        double infl = 0.0;
        double zdiff = (double)(nTo.z - nFrom.z) - nomz + (double)zb;
        if (zdiff >= (double)r) {
            return 0.0;
        }
        double dx = nTo.x - nFrom.x;
        double dy = nTo.y - nFrom.y;
        double xdiff = Math.sqrt(dx * dx + dy * dy) / nomx;
        if (xdiff >= (double)c) {
            return 0.0;
        }
        int r1 = (int)Math.floor(zdiff);
        int c1 = (int)Math.floor(xdiff);
        if (r1 < 0) {
            return 0.0;
        }
        double zinc = zdiff - (double)r1;
        double xinc = xdiff - (double)c1;
        double d = 0.0;
        double a = 0.0;
        double b = 0.0;
        try {
            d = RedCorrector2.infl(r1, c1);
            a = RedCorrector2.infl(r1 + 1, c1) - d;
            b = RedCorrector2.infl(r1, c1 + 1) - d;
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(0);
        }
        infl = d + a * zinc + b * xinc;
        if (infl <= 0.0) {
            infl = 0.0;
        }
        return infl;
    }

    private void testInfluence() {
        Nucleus nFrom = new Nucleus();
        nFrom.x = 100;
        nFrom.y = 150;
        nFrom.z = 15.0f;
        Nucleus nTo = new Nucleus();
        nTo.x = 100;
        nTo.y = 120;
        nTo.z = 17.5f;
        double infl = RedCorrector2.influence2D(nFrom, nTo);
        RedCorrector2.println("testInfluence, " + DF4.format(infl));
    }

    public static void main(String[] args) {
        RedCorrector2.println("RedCorrector2, ");
    }

    private static void println(String s) {
        System.out.println(s);
    }

    private static String fmt1(double d) {
        return DF1.format(d);
    }

    private static String fmt0(double d) {
        return DF1.format(d);
    }

    private static String fmt4(double d) {
        return DF4.format(d);
    }
}

