/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.analyze;

import ij.IJ;
import java.io.File;
import javax.swing.JFileChooser;
import org.rhwlab.acetree.AceTree;
import org.rhwlab.analyze.PluginClassLoader;

public class UsePlugin {
    AceTree iAceTree;

    public UsePlugin() {
        this.initialize();
        this.getFile();
    }

    public void initialize() {
        this.iAceTree = AceTree.getAceTree(null);
    }

    private void getFile() {
        JFileChooser fileChooser = new JFileChooser(new File("."));
        int returnVal = fileChooser.showOpenDialog(this.iAceTree);
        if (returnVal == 0) {
            File file = fileChooser.getSelectedFile();
            String path = file.getPath();
            String parent = file.getParent();
            String name = file.getName();
            name = name.substring(0, name.indexOf("."));
            this.runUserPlugin(parent, name);
        }
    }

    int compile(String path) {
        System.out.println("path: " + path);
        String classpath = System.getProperty("java.class.path");
        File f = new File(path);
        if (f != null) {
            classpath = String.valueOf(classpath) + File.pathSeparator + f.getParent();
        }
        System.out.println("compile failed");
        return 0;
    }

    Object runUserPlugin(String pluginsDir, String className) {
        PluginClassLoader loader;
        boolean createNewLoader = true;
        PluginClassLoader classLoader = null;
        if (createNewLoader) {
            loader = new PluginClassLoader(pluginsDir);
        } else {
            if (classLoader == null) {
                classLoader = new PluginClassLoader(pluginsDir);
            }
            loader = classLoader;
        }
        Object thePlugIn = null;
        try {
            thePlugIn = loader.loadClass(className).newInstance();
            ((Runnable)thePlugIn).run();
        }
        catch (ClassNotFoundException e) {
            if (className.indexOf(95) != -1) {
                IJ.error((String)("Plugin not found: " + className));
            }
        }
        catch (InstantiationException e) {
            IJ.error((String)"Unable to load plugin (ins)");
        }
        catch (IllegalAccessException e) {
            IJ.error((String)"Unable to load plugin, possibly \nbecause it is not public.");
        }
        return thePlugIn;
    }
}

