/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.dbaccess;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Hashtable;
import org.rhwlab.dbaccess.DBAccess;
import org.rhwlab.manifest.ManifestX;
import qdxml.DocHandler;
import qdxml.QDParser;

public class EmbryoXML
implements DocHandler {
    public String[] iRecord = new String[elem.length];
    public Hashtable<String, Integer> iTags = new Hashtable();
    public static final String S = "<";
    public static final String SP = " ";
    public static final String E = "\"/>";
    public static final String EQ = "=\"";
    public static final String XML = ".xml";
    public static final String HEADER = "<?xml version='1.0' encoding='utf-8'?>";
    public static final String EXPERIMENT = "<experiment>";
    public static final String EEXPERIMENT = "</experiment>";
    public static final int SERIES = 0;
    public static final int DATE = 1;
    public static final int PERSON = 2;
    public static final int STRAIN = 3;
    public static final int TREATMENTS = 4;
    public static final int REDSIGNAL = 5;
    public static final int IMAGELOC = 6;
    public static final int TIMEPOINTS = 7;
    public static final int ANNOTS = 8;
    public static final int ATCONFIG = 9;
    public static final int EDITEDBY = 10;
    public static final int EDITEDTP = 11;
    public static final int EDITEDCELLS = 12;
    public static final int CHECKED = 13;
    public static final int COMMENTS = 14;
    public static final int STATUS = 15;
    public static String[] elem = new String[]{"series", "date", "person", "strain", "treatments", "redsig", "imageloc", "timepts", "annots", "acetree", "editedby", "editedtimepts", "editedcells", "checkedby", "comments", "status"};
    public static String[] att = new String[]{"name", "date", "name", "name", "desc", "value", "loc", "num", "loc", "config", "name", "num", "num", "name", "text", "case"};
    public static String[] statuses = new String[]{"new", "archived", "deleted", "arc1", "arc2", "arc3", "del1"};
    public static final int NEWSTATUS = 0;
    public static final int ARCHIVEDSTATUS = 1;
    public static final int DELETEDSTATUS = 2;
    public static final int ARC1STATUS = 3;
    public static final int ARC2STATUS = 4;
    public static final int ARC3STATUS = 5;
    public static final int DEL1STATUS = 6;
    private static final String CS = ", ";

    public EmbryoXML() {
        int i = 0;
        while (i < elem.length) {
            this.iTags.put(elem[i], new Integer(i));
            this.iRecord[i] = "n/a";
            ++i;
        }
        this.iRecord[EmbryoXML.elem.length - 1] = statuses[0];
    }

    public EmbryoXML(String embryoName) throws FileNotFoundException {
        this(embryoName, DBAccess.cDBLocation);
    }

    public EmbryoXML(String embryoName, String dbPath) throws FileNotFoundException {
        this();
        if (DBAccess.cDBLocation == null) {
            ManifestX.reportAndUpdateManifest();
            DBAccess.cDBLocation = ManifestX.getManifestValue("DBLocation");
        }
        System.out.println("BDAccess.cBDLocation: " + DBAccess.cDBLocation);
        if (dbPath == null) {
            dbPath = DBAccess.cDBLocation;
        }
        if (!dbPath.endsWith("/")) {
            dbPath = String.valueOf(dbPath) + "/";
        }
        String path = embryoName;
        boolean OK = true;
        try {
            FileReader fr = new FileReader(path);
            QDParser.parse(this, fr);
        }
        catch (Exception e) {
            EmbryoXML.println("EmbryoXML: exception: " + e);
            OK = false;
        }
        if (!OK) {
            throw new FileNotFoundException(path);
        }
    }

    public EmbryoXML(String path, int x) {
        this();
        try {
            FileReader fr = new FileReader(path);
            QDParser.parse(this, fr);
        }
        catch (FileNotFoundException fnfe) {
            EmbryoXML.println("EmbryoXML: filenotfoundexception: " + fnfe);
            fnfe.printStackTrace();
        }
        catch (Exception e) {
            EmbryoXML.println("EmbryoXML: exception: " + e);
            e.printStackTrace();
        }
    }

    public static void writeXML(String filePath, String[] data) {
        int k = filePath.lastIndexOf("/");
        String s = "";
        s = k == filePath.length() - 1 ? String.valueOf(filePath) + data[0] : String.valueOf(filePath) + "/" + data[0];
        try {
            FileOutputStream fos = new FileOutputStream(String.valueOf(s) + XML);
            PrintWriter pw = new PrintWriter(fos);
            pw.println(HEADER);
            pw.println();
            pw.println(EXPERIMENT);
            int i = 0;
            while (i < elem.length) {
                if (data[i] != null && data[i].length() != 0) {
                    s = S + elem[i] + SP + att[i] + EQ + data[i] + E;
                    pw.println(s);
                }
                ++i;
            }
            pw.println(EEXPERIMENT);
            pw.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            System.exit(1);
        }
    }

    @Override
    public void startElement(String tag, Hashtable<?, ?> h) throws Exception {
        System.out.println("Looking in EmbryoXML for startElement for tag: " + tag);
        if (!tag.equals("experiment")) {
            try {
                int m = this.iTags.get(tag);
                System.out.println("EmbryoXML got integer: " + m + " from tag: " + tag);
                this.iRecord[m] = (String)h.get(att[m]);
            }
            catch (Exception e) {
                System.out.println("Cannot retrieve Integer value for tag: " + tag);
                e.printStackTrace();
                EmbryoXML.println("startElement: " + tag + CS + h);
                System.exit(1);
            }
        }
    }

    @Override
    public void endElement(String tag) throws Exception {
    }

    @Override
    public void startDocument() throws Exception {
    }

    @Override
    public void endDocument() throws Exception {
    }

    @Override
    public void text(String str) throws Exception {
    }

    public static void updateRecord(String[] data) {
        data[8] = data[6];
        data[9] = String.valueOf(data[0]) + ".dat";
    }

    public static void updateDatabase(String newLoc) {
        File dir = new File(DBAccess.cDBLocation);
        String[] list = dir.list();
        int i = 0;
        while (i < list.length) {
            if (i >= 2) {
                if (i > 4) break;
                String s = list[i];
                if (s.endsWith(XML)) {
                    int k = s.indexOf(XML);
                    s = s.substring(0, k);
                    EmbryoXML.println("updateDatabase, " + i + CS + s);
                    try {
                        EmbryoXML exml = new EmbryoXML(s);
                        EmbryoXML.updateRecord(exml.iRecord);
                        EmbryoXML.writeXML(newLoc, exml.iRecord);
                    }
                    catch (FileNotFoundException fnfe) {
                        fnfe.printStackTrace();
                    }
                }
            }
            ++i;
        }
    }

    public static void main(String[] args) {
        String dbloc = "/nfs/waterston/embryoDBnew/";
        String series = "081505";
        String series1 = "20071004cyd1";
        String series2 = "20071004cyd1";
        String seriex = null;
        seriex = "20080125_ceh-43_1";
        seriex = "20080125_ceh-43_1";
        series = "20080125_ceh-43_1";
        boolean bx = series1.equals(series2);
        boolean bxx = series.equals(seriex);
        EmbryoXML.println(bx + CS + bxx);
        String testFile = String.valueOf(dbloc) + series + XML;
        try {
            FileInputStream fileInputStream = new FileInputStream(testFile);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        try {
            EmbryoXML ioe = new EmbryoXML(series, null);
        }
        catch (FileNotFoundException fnfe) {
            fnfe.printStackTrace();
        }
        EmbryoXML.println("A-OK");
    }

    private static void println(String s) {
        System.out.println(s);
    }
}

