/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.help;

import java.awt.Dimension;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextArea;

public class FileError
extends JFrame {
    private static final String IMAGE_ERROR_TITLE = "Image File Not Found";
    private static final String ZIP_ERROR_TITLE = "Zip File Not Found";
    private static final String TITLE = "File Not Found";
    private static final int IMAGE_TYPE = 1;
    private static final int ZIP_TYPE = 2;
    private static final String IMAGE_STRING = " image ";
    private static final String ZIP_STRING = " zip ";
    private boolean image_type;
    private boolean zip_type;

    public FileError(String filepath, int type) {
        super(TITLE);
        this.image_type = type == 1;
        boolean bl = this.zip_type = type == 2;
        if (this.image_type) {
            this.setTitle(IMAGE_ERROR_TITLE);
        } else if (this.zip_type) {
            this.setTitle(ZIP_ERROR_TITLE);
        }
        JPanel contentPanel = new JPanel();
        contentPanel.setLayout(new BoxLayout(contentPanel, 1));
        JTextArea txtBox = new JTextArea("\n\nFailed to open", 11, 200);
        if (this.image_type) {
            txtBox.append(IMAGE_STRING);
        } else if (this.zip_type) {
            txtBox.append(ZIP_STRING);
        }
        txtBox.append("file\n\n");
        txtBox.append(String.valueOf(filepath) + "\n\n");
        txtBox.setLineWrap(true);
        txtBox.setEditable(false);
        contentPanel.add(txtBox);
        this.add(contentPanel);
        this.setPreferredSize(new Dimension(350, 200));
        this.pack();
        this.setVisible(true);
        this.setDefaultCloseOperation(2);
        System.out.println("Cannot open image file " + filepath);
    }
}

