/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.image;

import ij.ImagePlus;
import ij.gui.ImageCanvas;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.DecimalFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.event.MouseInputAdapter;
import org.rhwlab.acetree.AceTree;
import org.rhwlab.acetree.AnnotInfo;
import org.rhwlab.snight.NucleiMgr;
import org.rhwlab.snight.Nucleus;
import org.rhwlab.utils.EUtils;

public class AuxImageWindowYZ
extends JFrame {
    AceTree iAceTree;
    ImageCanvas iImgCanvas;
    ImagePlus iImgPlus;
    String iTitle;
    MouseHandler iMouseHandler;
    Hashtable iAnnotsShown;
    JToolBar iToolBar;
    JLabel iMouseData;
    NucleiMgr iNucleiMgr;
    double iZPixRes;
    int iXLoc;
    int iTime;
    ImageProcessor iDataProc;
    boolean iShowCentroids;
    boolean iShowAnnotations;
    private static final Color NUCCOLOR = new Color(140, 70, 255);
    public static final int[] WIDTHS = new int[]{1, 2, 3};
    private static final String CS = ", ";
    private static final String POSITION = "yz = ";
    private static DecimalFormat DF1 = new DecimalFormat("###.#");

    public AuxImageWindowYZ(String title, ImageProcessor dataProc, AceTree aceTree, int x) {
        super(title);
        ImageCanvas ic;
        this.iTitle = title;
        this.iAceTree = aceTree;
        this.iXLoc = x;
        this.iNucleiMgr = this.iAceTree.getNucleiMgr();
        this.iZPixRes = this.iNucleiMgr.getZPixRes();
        String s = this.iTitle.split(" @")[0];
        int k = s.lastIndexOf("-t");
        s = s.substring(k + 2);
        this.iTime = Integer.parseInt(s);
        this.iDataProc = dataProc;
        this.iImgPlus = new ImagePlus();
        this.iShowCentroids = false;
        this.iShowAnnotations = false;
        this.iAnnotsShown = new Hashtable();
        this.updateImagePlus();
        this.iImgCanvas = ic = new ImageCanvas(this.iImgPlus);
        this.iToolBar = new JToolBar();
        this.iToolBar.add(new JLabel("Mouse at: "));
        this.iMouseData = new JLabel("");
        this.iToolBar.add(this.iMouseData);
        Container c = this.getContentPane();
        JPanel jp = new JPanel();
        jp.setLayout(new BorderLayout());
        jp.add((Component)this.iToolBar, "North");
        jp.add((Component)this.iImgCanvas, "Center");
        c.add(jp);
        this.pack();
        this.setVisible(true);
        this.setDefaultCloseOperation(0);
        WinEventMgr wem = new WinEventMgr();
        this.addWindowFocusListener(wem);
        this.addWindowListener(wem);
        this.iMouseHandler = new MouseHandler(this);
        this.iImgCanvas.addMouseMotionListener((MouseMotionListener)this.iMouseHandler);
        this.iImgCanvas.addMouseListener((MouseListener)this.iMouseHandler);
    }

    private void updateImagePlus() {
        byte[] bpix = (byte[])this.iDataProc.getPixels();
        byte[] R = new byte[bpix.length];
        byte[] G = new byte[bpix.length];
        byte[] B = new byte[bpix.length];
        ColorProcessor iproc3 = new ColorProcessor(this.iDataProc.getWidth(), this.iDataProc.getHeight());
        iproc3.getRGB(R, G, B);
        G = bpix;
        iproc3.setRGB(R, G, B);
        if (this.iShowCentroids) {
            this.showCentroids(this.iTime, this.iXLoc, (ImageProcessor)iproc3);
        }
        if (this.iShowAnnotations) {
            this.showAnnotations((ImageProcessor)iproc3);
        }
        this.iImgPlus.setProcessor(this.iTitle, (ImageProcessor)iproc3);
        if (this.iImgCanvas != null) {
            this.iImgCanvas.repaint();
        }
        this.repaint();
    }

    protected void showCentroids(int time, int x, ImageProcessor iproc) {
        double zPixRes = 11.0;
        Vector v = (Vector)this.iNucleiMgr.getNucleiRecord().elementAt(time - 1);
        iproc.setColor(NUCCOLOR);
        iproc.setLineWidth(WIDTHS[1]);
        Enumeration e = v.elements();
        this.iAceTree.getCurrentCell().getName();
        while (e.hasMoreElements()) {
            double u;
            Nucleus n = (Nucleus)e.nextElement();
            if (n.status < 0 || !((u = this.nucDiameter(n, x)) > 0.0)) continue;
            int xx = (int)((double)n.z * zPixRes);
            iproc.setColor(NUCCOLOR);
            iproc.drawPolygon(EUtils.pCircle(xx, n.y, (int)(u / 2.0)));
        }
    }

    private void showAnnotations(ImageProcessor iproc) {
        iproc.setColor(Color.white);
        Enumeration e = this.iAnnotsShown.elements();
        while (e.hasMoreElements()) {
            AnnotInfo ai = (AnnotInfo)e.nextElement();
            iproc.drawString(ai.iName, ai.iX, ai.iY);
        }
    }

    public double nucDiameter(Nucleus n, double x) {
        if (n == null) {
            return -1.0;
        }
        double r = -0.5;
        double cellPlane = n.x;
        double R = (double)n.size / 2.0;
        double y = (cellPlane - x) / R;
        double r2 = 1.0 - y * y;
        if (r2 >= 0.0) {
            r = Math.sqrt(r2) * R;
        }
        return 2.0 * r;
    }

    private static void println(String s) {
        System.out.println(s);
    }

    public static void main(String[] args) {
    }

    class MouseHandler
    extends MouseInputAdapter {
        public MouseHandler(AuxImageWindowYZ iw) {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            String s = AuxImageWindowYZ.POSITION + e.getY() + AuxImageWindowYZ.CS + DF1.format((double)e.getX() / AuxImageWindowYZ.this.iZPixRes);
            AuxImageWindowYZ.this.iMouseData.setText(s);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            int plane = (int)Math.round((double)e.getX() / AuxImageWindowYZ.this.iZPixRes);
            Nucleus n = AuxImageWindowYZ.this.iNucleiMgr.findClosestNucleus(AuxImageWindowYZ.this.iXLoc, e.getY(), plane, AuxImageWindowYZ.this.iTime);
            if (n == null) {
                return;
            }
            int x = (int)Math.round((double)n.z * AuxImageWindowYZ.this.iZPixRes);
            AnnotInfo ai = new AnnotInfo(n.identity, x, n.y);
            if (AuxImageWindowYZ.this.iAnnotsShown.get(ai.iName) != null) {
                AuxImageWindowYZ.this.iAnnotsShown.remove(ai.iName);
            } else {
                AuxImageWindowYZ.this.iAnnotsShown.put(ai.iName, ai);
            }
            AuxImageWindowYZ.this.updateImagePlus();
        }
    }

    private class WinEventMgr
    extends WindowAdapter {
        private WinEventMgr() {
        }

        @Override
        public void windowGainedFocus(WindowEvent e) {
        }

        @Override
        public void windowClosing(WindowEvent e) {
            AuxImageWindowYZ.this.dispose();
        }
    }
}

