/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.image;

import ij.ImagePlus;
import ij.gui.ImageCanvas;
import ij.process.ImageProcessor;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JPanel;
import org.rhwlab.acetree.AceTree;
import org.rhwlab.image.ImageWindow;
import org.rhwlab.snight.Nucleus;
import org.rhwlab.utils.EUtils;

public class CellMovementImage
extends ImageWindow {
    public CellMovementImage(String title, ImagePlus imgPlus) {
        ImageCanvas ic;
        this.iIsMainImgWindow = true;
        this.iTitle = title;
        this.setTitle(title);
        iImgPlus = imgPlus;
        this.iImgCanvas = ic = new ImageCanvas(imgPlus);
        Dimension d = ic.getSize();
        d.getHeight();
        JPanel p = new JPanel();
        p.setLayout(new BorderLayout());
        p.add((Component)ic, "Center");
        this.setDefaultCloseOperation(2);
        this.setImageTimeAndPlaneFromTitle();
        this.iAceTree = AceTree.getAceTree(null);
        this.updateCurrentInfo(true);
        this.getContentPane().add(p);
        this.pack();
        this.setVisible(true);
        this.setResizable(false);
        WinEventMgr wem = new WinEventMgr();
        this.addWindowListener(wem);
        this.addWindowFocusListener(wem);
        this.refreshDisplay(null);
    }

    @Override
    public ImagePlus refreshDisplay(String imageName) {
        if (imageName == null) {
            imageName = this.iTitle;
        } else {
            if (imageName.indexOf(cTifPrefix) == -1) {
                imageName = String.valueOf(cTifPrefix) + imageName;
            }
            this.iTitle = imageName;
            this.setTitle(this.iTitle);
        }
        this.updateCurrentInfo(true);
        ImagePlus ip = null;
        ip = CellMovementImage.makeImage(imageName);
        switch (this.iAceTree.getColor()) {
            case 1: {
                ip = CellMovementImage.makeGreenImagePlus(ip);
                break;
            }
            case 2: {
                ip = CellMovementImage.makeRedImagePlus(ip);
                break;
            }
            case 3: {
                ip = CellMovementImage.makePlainImagePlus(ip);
            }
        }
        if (ip != null) {
            iImgPlus.setProcessor(imageName, ip.getProcessor());
        }
        this.showCentroids(0);
        this.showCentroids(1);
        this.iImgCanvas.repaint();
        return iImgPlus;
    }

    protected void showCentroids(int increment) {
        int t = this.iImageTime + this.iTimeInc - 1 - increment;
        if (t < 0) {
            return;
        }
        Vector v = (Vector)cNucleiMgr.getNucleiRecord().elementAt(t);
        ImageProcessor iproc = this.getImagePlus().getProcessor();
        if (increment == 0) {
            iproc.setColor(Color.red);
        } else {
            iproc.setColor(Color.yellow);
        }
        iproc.setLineWidth(cLineWidth);
        Enumeration e = v.elements();
        this.iAceTree.getCurrentCell().getName();
        while (e.hasMoreElements()) {
            double x;
            Nucleus n = (Nucleus)e.nextElement();
            if (n.status < 0 || !((x = cNucleiMgr.nucDiameter(n, this.iImagePlane + this.iPlaneInc)) > 0.0)) continue;
            iproc.drawPolygon(EUtils.pCircle(n.x, n.y, (int)(x / 2.0)));
        }
    }

    private void updateCurrentInfo(boolean detectChange) {
        this.iImageTime = this.iAceTree.getImageTime();
        this.iImagePlane = this.iAceTree.getImagePlane();
        this.iTimeInc = this.iAceTree.getTimeInc();
        this.iPlaneInc = this.iAceTree.getPlaneInc();
    }

    public static void main(String[] args) {
    }

    private class WinEventMgr
    extends WindowAdapter {
        private WinEventMgr() {
        }

        @Override
        public void windowGainedFocus(WindowEvent e) {
            CellMovementImage.this.refreshDisplay(null);
        }

        @Override
        public void windowClosing(WindowEvent e) {
            CellMovementImage.this.dispose();
            CellMovementImage.this.iAceTree.setEditImageNull(4);
        }
    }
}

