/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.image;

import ij.ImagePlus;
import ij.process.ByteProcessor;
import ij.process.ImageProcessor;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.Border;
import org.rhwlab.acetree.AceTree;
import org.rhwlab.image.AuxImageWindowXZ;
import org.rhwlab.image.AuxImageWindowYZ;
import org.rhwlab.image.ImageWindow;
import org.rhwlab.image.ZipImage;
import org.rhwlab.snight.NucleiMgr;

public class DepthViews
extends JPanel
implements ActionListener {
    JFrame iFrame;
    JSpinner iTime;
    JSpinner iXYLocation;
    JButton iXZView;
    JButton iYZView;
    AceTree iAceTree;
    NucleiMgr iNucleiMgr;
    String iImageName;
    private static final String CS = ", ";

    public DepthViews(String s) {
        this.setPreferredSize(new Dimension(200, 200));
        this.setLayout(new BoxLayout(this, 1));
        this.iFrame = new JFrame();
        this.iAceTree = AceTree.getAceTree(null);
        this.iNucleiMgr = this.iAceTree.getNucleiMgr();
        this.makeUI();
        this.showMe();
    }

    private void makeUI() {
        this.setLayout(new GridLayout(0, 1));
        Border blackline = BorderFactory.createLineBorder(Color.black);
        JPanel p = new JPanel();
        p.add(new JLabel("time:"));
        SpinnerNumberModel model = new SpinnerNumberModel(100, 1, this.iNucleiMgr.getEndingIndex(), 1);
        this.iTime = new JSpinner(model);
        p.add(this.iTime);
        p.setBorder(blackline);
        this.add(p);
        p = new JPanel();
        p.add(new JLabel("x or y loc:"));
        model = new SpinnerNumberModel(250, 10, ImageWindow.cImageWidth, 10);
        this.iXYLocation = new JSpinner(model);
        p.add(this.iXYLocation);
        p.setBorder(blackline);
        this.add(p);
        this.iYZView = new JButton("YZ View");
        this.iYZView.addActionListener(this);
        this.add(this.iYZView);
        this.iXZView = new JButton("XZ View");
        this.iXZView.addActionListener(this);
        this.add(this.iXZView);
    }

    private void yzView(int time, int x) {
        ImagePlus iplus = this.getOneYZ(time, x);
        DepthViews.println("yzView, " + iplus.getWidth() + CS + iplus.getHeight() + CS + ImageWindow.cImageHeight + CS + this.iNucleiMgr.getPlaneEnd());
        ImageProcessor iproc = iplus.getProcessor();
        String s2 = String.valueOf(this.iImageName) + " @ x = " + x;
        new AuxImageWindowYZ(s2, iproc, this.iAceTree, x);
    }

    private void xzView(int time, int y) {
        ImagePlus iplus = this.getOneXZ(time, y);
        ImageProcessor iproc = iplus.getProcessor();
        String s2 = String.valueOf(this.iImageName) + " @ y=" + y;
        new AuxImageWindowXZ(s2, iproc, this.iAceTree, y);
    }

    private ImagePlus getOneYZ(int time, int x) {
        int factor = (int)Math.round(this.iAceTree.getiZPixRes());
        int planeEnd = this.iNucleiMgr.getPlaneEnd();
        ByteProcessor bp = new ByteProcessor(factor * planeEnd - 1, ImageWindow.cImageHeight);
        int m = 1;
        while (m <= planeEnd) {
            ImageProcessor ip = this.getImage(time, m);
            if (ip == null) break;
            int i = 0;
            while (i < ip.getHeight()) {
                int p = ip.getPixel(x, i);
                int k = 0;
                while (k < factor) {
                    bp.putPixel(k + m * factor, i, p);
                    ++k;
                }
                ++i;
            }
            ++m;
        }
        String s = String.valueOf(time) + "_" + x;
        ImagePlus iplus = new ImagePlus(s, (ImageProcessor)bp);
        return iplus;
    }

    private ImagePlus getOneXZ(int time, int y) {
        int factor = (int)Math.round(this.iAceTree.getiZPixRes());
        int planeEnd = this.iNucleiMgr.getPlaneEnd();
        ByteProcessor bp = new ByteProcessor(ImageWindow.cImageWidth, factor * planeEnd - 1);
        int m = 1;
        while (m <= planeEnd) {
            ImageProcessor ip = this.getImage(time, m);
            if (ip == null) break;
            DepthViews.println("test2: " + ip + CS + time + CS + m + CS + planeEnd);
            int i = 0;
            while (i < ip.getWidth()) {
                int p = ip.getPixel(i, y);
                int k = 0;
                while (k < factor) {
                    bp.putPixel(i, k + m * factor, p);
                    ++k;
                }
                ++i;
            }
            ++m;
        }
        String s = String.valueOf(time) + "_" + y;
        ImagePlus iplus = new ImagePlus(s, (ImageProcessor)bp);
        return iplus;
    }

    private ImageProcessor getImage(int time, int plane) {
        String imageFile = ImageWindow.cZipTifFilePath;
        imageFile = String.valueOf(imageFile) + "/" + ImageWindow.cTifPrefix;
        imageFile = String.valueOf(imageFile) + this.iAceTree.makeImageName(time, plane);
        int k = imageFile.lastIndexOf("/");
        String s = imageFile.substring(k + 1);
        k = s.lastIndexOf("-");
        this.iImageName = s = s.substring(0, k);
        ImageProcessor ip = this.getRedData(imageFile);
        return ip;
    }

    private ImageProcessor getRedData(String greenName) {
        if (ImageWindow.cUseZip == 2) {
            return this.getRedZipData(greenName);
        }
        ImagePlus ip = null;
        try {
            FileInputStream fis = new FileInputStream(greenName);
            byte[] ba = ImageWindow.readByteArray(fis);
            ip = ImageWindow.openTiff(new ByteArrayInputStream(ba), false);
            fis.close();
            if (ImageWindow.imagewindowUseStack == 1) {
                int markerChannel = 1;
                ip = ImageWindow.splitImage(ip, markerChannel);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (ip != null) {
            return ip.getProcessor();
        }
        return null;
    }

    private ImageProcessor getRedZipData(String redName) {
        ZipImage zipImage = new ZipImage(redName);
        int k1 = redName.lastIndexOf("/") + 1;
        String ss = redName.substring(k1);
        int k2 = ss.indexOf(".");
        ss = ss.substring(0, k2);
        ZipEntry ze = null;
        if (zipImage != null) {
            ze = zipImage.getZipEntry(String.valueOf(ss) + ".tif");
        }
        ImagePlus ip = null;
        ip = zipImage.readData(ze, true);
        if (ip != null) {
            return ip.getProcessor();
        }
        return null;
    }

    public void showMe() {
        this.iFrame.setTitle("DepthViews");
        this.iFrame.setDefaultCloseOperation(2);
        this.iFrame.setContentPane(this);
        this.iFrame.pack();
        this.iFrame.setLocationRelativeTo(this.iAceTree);
        this.iFrame.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int time = (Integer)this.iTime.getValue();
        int xy = (Integer)this.iXYLocation.getValue();
        DepthViews.println("actionPerformed: " + time + CS + xy);
        Object o = e.getSource();
        if (o == this.iYZView) {
            this.yzView(time, xy);
        } else if (o == this.iXZView) {
            this.xzView(time, xy);
        }
    }

    public static void main(String[] args) {
    }

    private static void println(String s) {
        System.out.println(s);
    }
}

