/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.image;

import com.sun.j3d.utils.geometry.Sphere;
import java.awt.Color;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.media.j3d.Appearance;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.LineArray;
import javax.media.j3d.LineAttributes;
import javax.media.j3d.Material;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.TransparencyAttributes;
import javax.vecmath.Color3f;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;
import org.rhwlab.acetree.AceTree;
import org.rhwlab.acetree.PartsList;
import org.rhwlab.image.ColorConstants;
import org.rhwlab.image.Image3D;
import org.rhwlab.image.Image3DViewConfig;
import org.rhwlab.image.ImageWindow;
import org.rhwlab.image.NamedSphere;
import org.rhwlab.snight.NucleiMgr;
import org.rhwlab.snight.Nucleus;
import org.rhwlab.tree.Cell;

public class Image3DGeometryManager {
    private AceTree iAceTree;
    private NucleiMgr iNucleiMgr;
    private Image3DViewConfig viewConfig;
    private BranchGroup nucBG;
    private Vector iSisterList;
    private Hashtable iNucleiHash;
    private boolean iTransparent;
    private boolean iShowIt;
    private boolean iEmptyNuclei3D;
    private Shape3D overlay;
    private boolean overlayReady;
    private boolean iShowSameSizeSpheres;
    private double iSphereScale;
    public int iXA;
    public int iYA;
    public float iZA;
    private static String CS = ",";
    private final String[] SISTERS = new String[]{"E", "MS", "AB", "P1", "EMS", "P2", "C", "P3", "D", "P4"};
    private final float SETSPHERESIZE = 0.075f;

    public Image3DGeometryManager(Image3D parent) {
        this.viewConfig = Image3DViewConfig.getInstance();
        this.iAceTree = parent.getAceTree();
        this.iNucleiMgr = this.iAceTree.getNucleiMgr();
        this.overlay = null;
        this.iShowSameSizeSpheres = false;
        this.iSphereScale = 1.0;
    }

    public void setShowSameSizeSpheres(boolean show) {
        this.iShowSameSizeSpheres = show;
    }

    public BranchGroup createNuclearBranchGroup(int iXA, int iYA, float iZA) {
        this.nucBG = new BranchGroup();
        this.nucBG.setCapability(17);
        this.iXA = iXA;
        this.iYA = iYA;
        this.iZA = iZA;
        if (this.viewConfig.areSistersVisible()) {
            this.iSisterList = this.prepareSortedList();
            this.addNucleiViaSisterList();
        } else {
            this.addNuclei();
        }
        if (this.viewConfig.isShowingTails()) {
            this.addTracks();
        }
        if (this.viewConfig.isShowingOverlay() && this.overlayReady && this.overlay != null) {
            System.out.println("Calling addOverlay()...");
            this.addOverlay();
        }
        return this.nucBG;
    }

    private int inSISTERS(String name) {
        int i = 0;
        while (i < this.SISTERS.length) {
            if (name.equals(this.SISTERS[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private String getSister(String name) {
        String sister = "";
        int i = 0;
        while (i < this.SISTERS.length) {
            if (name.equals(this.SISTERS[i])) {
                if (i % 2 == 0) {
                    sister = this.SISTERS[i + 1];
                    break;
                }
                sister = this.SISTERS[i - 1];
                break;
            }
            ++i;
        }
        return sister;
    }

    private void showSisters() {
        Vector sorted;
        this.iSisterList = sorted = this.prepareSortedList();
        int i = 0;
        while (i < sorted.size()) {
            String second;
            if (i == sorted.size() - 1) break;
            String first = (String)sorted.get(i);
            if (this.areSisters(first, second = (String)sorted.get(i + 1))) {
                this.println("sisters, " + first + CS + second);
                ++i;
            }
            ++i;
        }
    }

    private Vector prepareSortedList() {
        this.iNucleiHash = new Hashtable();
        Vector<String> sortedList = new Vector<String>();
        Vector<String> catsAndDogs = new Vector<String>();
        NucleiMgr nucleiMgr = this.iAceTree.getNucleiMgr();
        int time = this.iAceTree.getImageTime() + this.iAceTree.getTimeInc();
        Vector nuclei = (Vector)nucleiMgr.getNucleiRecord().elementAt(time - 1);
        int i = 0;
        while (i < nuclei.size()) {
            Nucleus n = (Nucleus)nuclei.get(i);
            if (n.status != -1) {
                this.iNucleiHash.put(n.identity, n);
                if (this.inSISTERS(n.identity) >= 0) {
                    catsAndDogs.add(n.identity);
                } else {
                    sortedList.add(n.identity);
                }
            }
            ++i;
        }
        Collections.sort(sortedList);
        this.addCatsAndDogs(sortedList, catsAndDogs);
        return sortedList;
    }

    private void addCatsAndDogs(Vector sortedList, Vector catsAndDogs) {
        while (catsAndDogs.size() > 0) {
            String name = (String)catsAndDogs.remove(0);
            sortedList.add(name);
            String sister = this.getSister(name);
            if (sister.length() <= 0 || !catsAndDogs.contains(sister)) continue;
            sortedList.add(sister);
            catsAndDogs.remove(sister);
        }
    }

    private boolean areSisters(String first, String second) {
        boolean[] ans = new boolean[2];
        ans[1] = false;
        ans[0] = false;
        this.specialCaseSisters(first, second, ans);
        if (ans[0]) {
            return ans[1];
        }
        String s = "";
        s = first.substring(0, first.length() - 1);
        int k = second.indexOf(s);
        return k == 0 && first.length() == second.length();
    }

    private void specialCaseSisters(String first, String second, boolean[] ans) {
        int firstLoc = this.inSISTERS(first);
        int secondLoc = this.inSISTERS(second);
        boolean bl = ans[0] = firstLoc >= 0 || secondLoc >= 0;
        ans[1] = firstLoc % 2 == 0 ? secondLoc == firstLoc + 1 : secondLoc == firstLoc - 1;
    }

    private void addNucleiViaSisterList() {
        this.iShowIt = true;
        this.iTransparent = false;
        NucleiMgr nucleiMgr = this.iAceTree.getNucleiMgr();
        int time = this.iAceTree.getImageTime() + this.iAceTree.getTimeInc();
        Vector nuclei = (Vector)nucleiMgr.getNucleiRecord().elementAt(time - 1);
        nuclei = this.copyNuclei(nuclei);
        this.getCenter(nuclei);
        while (this.iSisterList.size() > 0) {
            String name = (String)this.iSisterList.remove(0);
            if (this.iSisterList.size() == 0) {
                this.addOne(name, false);
                break;
            }
            String next = (String)this.iSisterList.get(0);
            if (this.areSisters(name, next)) {
                this.iSisterList.remove(0);
                this.addSisters(name, next, time);
                continue;
            }
            this.addOne(name, false);
        }
    }

    private void addSisters(String first, String second, int time) {
        Nucleus n1 = this.addOne(first, true);
        boolean showing = this.iShowIt;
        Nucleus n2 = this.addOne(second, true);
        boolean bl = this.iShowIt = this.iShowIt && showing;
        if (this.iShowIt && !this.iTransparent) {
            this.addConnector(n1, n2, this.viewConfig.getSisterColor());
        }
    }

    private void addConnector(Nucleus n1, Nucleus n2, Color color) {
        if (!this.iShowIt) {
            return;
        }
        LineArray connector = new LineArray(2, 5);
        int width = ImageWindow.cImageWidth;
        float scale = width / 2;
        float xoff = this.iXA;
        float yoff = this.iYA;
        float zoff = this.iZA;
        Nucleus n = n1;
        float xf = ((float)n.x - xoff) / scale;
        float yf = ((float)n.y - yoff) / scale;
        yf = -yf;
        this.iNucleiMgr.getZPixRes();
        float z = (float)this.iNucleiMgr.getZPixRes() * (n.z - zoff) / scale;
        z = -z;
        connector.setCoordinate(0, new Point3f(xf, yf, z));
        n = n2;
        xf = ((float)n.x - xoff) / scale;
        yf = ((float)n.y - yoff) / scale;
        yf = -yf;
        z = (float)this.iNucleiMgr.getZPixRes() * (n.z - zoff) / scale;
        z = -z;
        connector.setCoordinate(1, new Point3f(xf, yf, z));
        LineAttributes la = new LineAttributes();
        la.setLineWidth(5.0f);
        Color3f c = new Color3f(color);
        connector.setColor(0, c);
        connector.setColor(1, c);
        Appearance app = new Appearance();
        app.setLineAttributes(la);
        System.out.println("Getting lineage number in addConnector()...");
        int k = this.getLineageNumber(n1.identity);
        if (k >= this.viewConfig.getNumDispProps() - 2) {
            connector.setColor(0, ColorConstants.white);
            connector.setColor(1, ColorConstants.white);
        }
        this.nucBG.addChild(new Shape3D(connector, app));
    }

    private Nucleus addOne(String name, boolean sister) {
        Nucleus n = (Nucleus)this.iNucleiHash.get(name);
        System.out.println("Nucleus identity: " + n.identity);
        if (n == null) {
            this.println("addOne, " + name + CS + sister);
        }
        int width = ImageWindow.cImageWidth;
        float scale = width / 2;
        float xoff = this.iXA;
        float yoff = this.iYA;
        float zoff = this.iZA;
        float xf = ((float)n.x - xoff) / scale;
        float yf = ((float)n.y - yoff) / scale;
        yf = -yf;
        float z = (float)this.iNucleiMgr.getZPixRes() * (n.z - zoff) / scale;
        z = -z;
        float rf = (float)(n.size / 2) / scale;
        Appearance app = new Appearance();
        new TransparencyAttributes(2, 1.0f);
        new TransparencyAttributes(2, 0.5f);
        int k = this.getLineageNumber(n.identity);
        System.out.println("Lineage number returned in addOne: " + k);
        this.iShowIt = true;
        this.iTransparent = false;
        if (k < this.viewConfig.getNumDispProps() - 2) {
            app = this.getLineageColor(k);
        } else {
            int m = this.viewConfig.getDispProp(this.viewConfig.getNumDispProps() - 2).getLineageNum();
            switch (m) {
                case 0: {
                    this.iShowIt = false;
                    break;
                }
                case 1: {
                    app = this.getLineageColor(11);
                    break;
                }
                default: {
                    app = this.getLineageColor(10);
                }
            }
        }
        boolean bl = this.iShowIt = app != null;
        if (this.iShowIt && app != null) {
            if (sister) {
                rf = (float)Math.min(n.size / 2, 10) / scale;
            }
            if (this.iShowSameSizeSpheres) {
                rf = 0.075f * (float)this.iSphereScale;
            }
            this.nucBG.addChild(this.makeNamedSphere(n.identity, xf, yf, z, rf, app));
        }
        return n;
    }

    public void setSphereScale(double s) {
        this.iSphereScale = s;
    }

    public boolean empty() {
        return this.iEmptyNuclei3D;
    }

    private Appearance setColor(Color3f color) {
        Color3f eColor = new Color3f(0.0f, 0.0f, 0.0f);
        Color3f sColor = color;
        Material m = new Material(eColor, eColor, sColor, sColor, 100.0f);
        m.setLightingEnable(true);
        Appearance app = new Appearance();
        app.setMaterial(m);
        return app;
    }

    private Appearance getLineageColor(int k) {
        Appearance app = null;
        switch (k) {
            case 0: {
                app = this.setColor(ColorConstants.red);
                break;
            }
            case 1: {
                app = this.setColor(ColorConstants.blue);
                break;
            }
            case 2: {
                app = this.setColor(ColorConstants.green);
                break;
            }
            case 3: {
                app = this.setColor(ColorConstants.yellow);
                break;
            }
            case 4: {
                app = this.setColor(ColorConstants.cyan);
                break;
            }
            case 5: {
                app = this.setColor(ColorConstants.magenta);
                break;
            }
            case 6: {
                app = this.setColor(ColorConstants.pink);
                break;
            }
            case 7: {
                app = this.setColor(ColorConstants.gray);
                break;
            }
            case 8: {
                app = this.setColor(ColorConstants.lightgray);
                break;
            }
            case 9: {
                app = this.setColor(ColorConstants.darkgray);
                break;
            }
            case 10: {
                app = this.setColor(ColorConstants.white);
                break;
            }
            case 11: {
                app = this.setColor(ColorConstants.lightgray);
                TransparencyAttributes tran = new TransparencyAttributes(2, 0.75f);
                app.setTransparencyAttributes(tran);
                break;
            }
            default: {
                app = null;
            }
        }
        return app;
    }

    private Appearance getExpressionColor(Nucleus n) {
        Cell.setMinRed(this.viewConfig.getMinRed());
        Cell.setMaxRed(this.viewConfig.getMaxRed());
        int k = Cell.getDiscrete(n.rweight);
        Color color = Cell.getTheColor(k);
        color = this.getColor(n);
        Color3f c3f = new Color3f(color);
        Appearance app = this.setColor(c3f);
        return app;
    }

    private Color getColor(Nucleus n) {
        float iHue;
        int rweight;
        int red = rweight = n.rweight;
        float frac = ((float)red - (float)Cell.cMin) / ((float)Cell.cMax - (float)Cell.cMin);
        frac = Math.min(frac, 1.0f);
        frac = Math.max(frac, 0.0f);
        float hue = iHue = 0.0f;
        float sat = 1.0f;
        int col = Color.HSBtoRGB(hue, sat, frac);
        return new Color(col);
    }

    private Vector copyNuclei(Vector nuclei) {
        Vector<Nucleus> newNuclei = new Vector<Nucleus>();
        Enumeration e = nuclei.elements();
        Nucleus n = null;
        while (e.hasMoreElements()) {
            n = (Nucleus)e.nextElement();
            newNuclei.add(n.copy());
        }
        Collections.sort(newNuclei, n);
        return newNuclei;
    }

    private void addTracks() {
        int goBack = 1;
        Nucleus oldNuc = null;
        Nucleus newNuc = null;
        Vector oldNuclei = null;
        Vector newNuclei = null;
        NucleiMgr nucleiMgr = this.iAceTree.getNucleiMgr();
        int time = this.iAceTree.getImageTime() + this.iAceTree.getTimeInc();
        newNuclei = (Vector)nucleiMgr.getNucleiRecord().elementAt(time - goBack);
        this.getCenter(newNuclei);
        while (goBack < this.viewConfig.getTailTimePoints()) {
            ++goBack;
            try {
                oldNuclei = (Vector)nucleiMgr.getNucleiRecord().elementAt(time - goBack);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                return;
            }
            if (oldNuclei.size() == 0) {
                return;
            }
            int i = 0;
            while (i < newNuclei.size()) {
                newNuc = (Nucleus)newNuclei.elementAt(i);
                if (newNuc.status >= 0) {
                    int j = 0;
                    while (j < oldNuclei.size()) {
                        oldNuc = (Nucleus)oldNuclei.elementAt(j);
                        if (oldNuc.status >= 0 && oldNuc.index == newNuc.predecessor) {
                            this.addConnector(newNuc, oldNuc, this.viewConfig.getCustomTailColor());
                        }
                        ++j;
                    }
                }
                ++i;
            }
            newNuclei = oldNuclei;
        }
    }

    private void addNuclei() {
        int time;
        NucleiMgr nucleiMgr = this.iAceTree.getNucleiMgr();
        Vector nuclei = nucleiMgr.getElementAt((time = this.iAceTree.getImageTime() + this.iAceTree.getTimeInc()) - 1);
        boolean bl = this.iEmptyNuclei3D = nuclei.size() == 0;
        if (this.iEmptyNuclei3D) {
            return;
        }
        nuclei = this.copyNuclei(nuclei);
        this.getCenter(nuclei);
        Nucleus n = null;
        int width = ImageWindow.cImageWidth;
        int height = ImageWindow.cImageHeight;
        if (width == 0) {
            width = 800;
        }
        if (height == 0) {
            height = 512;
        }
        float scale = width / 2;
        float xoff = this.iXA;
        float yoff = this.iYA;
        float zoff = this.iZA;
        int j = 0;
        while (j < nuclei.size()) {
            n = (Nucleus)nuclei.elementAt(j);
            if (n.status >= 0) {
                float xf = ((float)n.x - xoff) / scale;
                float yf = ((float)n.y - yoff) / scale;
                yf = -yf;
                float z = (float)this.iNucleiMgr.getZPixRes() * (n.z - zoff) / scale;
                z = -z;
                float rf = (float)(n.size / 2) / scale;
                Appearance app = new Appearance();
                TransparencyAttributes tran = new TransparencyAttributes(2, 1.0f);
                tran.setTransparency(0.8f);
                int rule = this.getLineageRule(n.identity);
                int k = this.getLineageNumber(rule);
                this.iShowIt = true;
                if (rule < this.viewConfig.getNumDispProps() - 2) {
                    app = this.getLineageColor(k);
                } else {
                    int m = this.viewConfig.getDispProp(this.viewConfig.getNumDispProps() - 2).getLineageNum();
                    switch (m) {
                        case 0: {
                            this.iShowIt = false;
                            break;
                        }
                        case 1: {
                            app = this.getLineageColor(11);
                            break;
                        }
                        default: {
                            app = this.getLineageColor(10);
                        }
                    }
                }
                if (this.viewConfig.isUsingExpression()) {
                    if (this.viewConfig.isUsingExpressionColors()) {
                        app = this.getExpressionColor(n);
                    }
                    if (n.rweight < this.viewConfig.getMinRed()) {
                        app = this.setColor(ColorConstants.white);
                        app.setTransparencyAttributes(tran);
                        this.iShowIt = this.viewConfig.isShowingNonExpressing();
                    }
                } else if (this.viewConfig.getDispProp(this.viewConfig.getNumDispProps() - 3).getName().equals("Special")) {
                    app = this.special(n);
                }
                if (this.iShowIt && app != null) {
                    if (this.iShowSameSizeSpheres) {
                        rf = 0.075f * (float)this.iSphereScale;
                    }
                    this.nucBG.addChild(this.makeNamedSphere(n.identity, xf, yf, z, rf, app));
                    app.getTransparencyAttributes();
                }
            }
            ++j;
        }
    }

    private boolean inSCAList(Nucleus n) {
        String[] theList = new String[]{"ABaraaappaa", "ABalpaappa", "ABaraaappap", "ABaraaapaaa", "ABaraaappp", "MSaaaaaa", "ABalpaapppa", "ABprpapppp", "ABalpaapppp"};
        int i = 0;
        while (i < theList.length) {
            if (n.identity.equals(theList[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private Appearance special(Nucleus n) {
        Appearance appRest;
        TransparencyAttributes faint = new TransparencyAttributes(2, 0.8f);
        new TransparencyAttributes(2, 1.0f);
        TransparencyAttributes solid = new TransparencyAttributes(2, 0.0f);
        Appearance app = null;
        String name = n.identity;
        app = appRest = null;
        this.iShowIt = true;
        name = name.toLowerCase();
        if (name.indexOf("e") == 0) {
            app = this.setColor(ColorConstants.yellow);
            app.setTransparencyAttributes(solid);
        }
        if (name.indexOf("msaa") == 0) {
            app = this.setColor(ColorConstants.magenta);
            app.setTransparencyAttributes(solid);
            if (name.indexOf("msaaaaaa") == 0 || name.indexOf("msaappp") == 0) {
                app = appRest;
            }
        }
        if (name.indexOf("mspa") == 0) {
            app = this.setColor(ColorConstants.cyan);
            app.setTransparencyAttributes(solid);
            if (name.indexOf("mspapp") == 0) {
                app = appRest;
            }
        }
        if (name.indexOf("abalpaaa") == 0 || name.indexOf("abalpaapa") == 0 || name.indexOf("abalpapp") == 0) {
            app = this.setColor(ColorConstants.pink);
            app.setTransparencyAttributes(solid);
        }
        if (name.indexOf("abaraaaa") == 0 || name.indexOf("abaraaapa") == 0) {
            app = this.setColor(ColorConstants.blue);
            app.setTransparencyAttributes(solid);
            if (name.indexOf("abaraaapaaa") == 0) {
                app = appRest;
            }
        }
        if (name.indexOf("abaraap") == 0) {
            app = this.setColor(ColorConstants.blue);
            app.setTransparencyAttributes(solid);
        }
        if (name.indexOf("abarapa") == 0) {
            app = this.setColor(ColorConstants.blue);
            app.setTransparencyAttributes(solid);
            if (name.indexOf("abarapapapa") == 0) {
                app = appRest;
            }
        }
        if (app == appRest) {
            this.iShowIt = true;
            app = this.setColor(ColorConstants.white);
            app.setTransparencyAttributes(faint);
        }
        return app;
    }

    private Appearance special(Nucleus n, boolean bogus) {
        Appearance appRest;
        TransparencyAttributes faint = new TransparencyAttributes(2, 0.8f);
        new TransparencyAttributes(2, 1.0f);
        TransparencyAttributes solid = new TransparencyAttributes(2, 0.0f);
        Appearance app = null;
        String name = n.identity;
        app = appRest = null;
        this.iShowIt = true;
        name = name.toLowerCase();
        if (name.indexOf("e") == 0) {
            app = this.setColor(ColorConstants.green);
            app.setTransparencyAttributes(solid);
        }
        if (name.indexOf("msaa") == 0) {
            app = this.setColor(ColorConstants.magenta);
            app.setTransparencyAttributes(solid);
            if (name.indexOf("msaaaaaa") == 0 || name.indexOf("msaappp") == 0) {
                app = appRest;
            }
        }
        if (name.indexOf("mspa") == 0) {
            app = this.setColor(ColorConstants.cyan);
            app.setTransparencyAttributes(solid);
            if (name.indexOf("mspapp") == 0) {
                app = appRest;
            }
        }
        if (name.indexOf("abalpaaa") == 0 || name.indexOf("abalpaapa") == 0 || name.indexOf("abalpapp") == 0) {
            app = this.setColor(ColorConstants.red);
            app.setTransparencyAttributes(solid);
        }
        if (name.indexOf("abaraaaa") == 0 || name.indexOf("abaraaapa") == 0) {
            app = this.setColor(ColorConstants.blue);
            app.setTransparencyAttributes(solid);
            if (name.indexOf("abaraaapaaa") == 0) {
                app = appRest;
            }
        }
        if (name.indexOf("abaraap") == 0) {
            app = this.setColor(ColorConstants.blue);
            app.setTransparencyAttributes(solid);
        }
        if (name.indexOf("abarapa") == 0) {
            app = this.setColor(ColorConstants.blue);
            app.setTransparencyAttributes(solid);
            if (name.indexOf("abarapapapa") == 0) {
                app = appRest;
            }
        }
        if (app == appRest) {
            this.iShowIt = true;
            app = this.setColor(ColorConstants.white);
            app.setTransparencyAttributes(faint);
        }
        return app;
    }

    private void getCenter(Vector nuclei) {
        this.iXA = 0;
        this.iYA = 0;
        this.iZA = 0.0f;
        int count = 0;
        Enumeration e = nuclei.elements();
        while (e.hasMoreElements()) {
            Nucleus n = (Nucleus)e.nextElement();
            if (n.status == -1) continue;
            this.iXA += n.x;
            this.iYA += n.y;
            this.iZA += n.z;
            ++count;
        }
        this.iXA /= count;
        this.iYA /= count;
        this.iZA /= (float)count;
    }

    private TransformGroup makeNamedSphere(String name, float x, float y, float z, float r, Appearance a) {
        Transform3D translate = new Transform3D();
        translate.set(new Vector3f(x, y, z));
        NamedSphere sph = new NamedSphere(name, r, a);
        TransformGroup tg = new TransformGroup(translate);
        tg.addChild(sph);
        return tg;
    }

    private TransformGroup makeSphere(float x, float y, float z, float r, Appearance a) {
        Transform3D translate = new Transform3D();
        translate.set(new Vector3f(x, y, z));
        Sphere sph = new Sphere(r, a);
        TransformGroup tg = new TransformGroup(translate);
        tg.addChild(sph);
        return tg;
    }

    private void println(String s) {
        System.out.println(s);
    }

    private int getLineageNumber(String name) {
        if (name.indexOf("Z") >= 0) {
            name = "P";
        }
        int num = this.viewConfig.getNumDispProps();
        String propername = PartsList.lookupSulston(name);
        int i = 0;
        while (i < this.viewConfig.getNumDispProps()) {
            boolean matchpropername;
            boolean bl = matchpropername = propername != null && propername.equals(this.viewConfig.getDispProp(i).getName());
            if (matchpropername || name.indexOf(this.viewConfig.getDispProp(i).getName()) >= 0) {
                num = this.viewConfig.getDispProp(i).getLineageNum();
                break;
            }
            ++i;
        }
        return num;
    }

    private int getLineageNumber(int index) {
        if (index >= 0 && index < this.viewConfig.getNumDispProps()) {
            return this.viewConfig.getDispProp(index).getLineageNum();
        }
        return 0;
    }

    private int getLineageRule(String name) {
        if (name.indexOf("Z") >= 0) {
            name = "P";
        }
        int numDispProps = this.viewConfig.getNumDispProps();
        Integer propernamei = null;
        Integer namei = null;
        String propername = PartsList.lookupSulston(name);
        String target = "";
        name = name.toLowerCase();
        int i = 0;
        while (i < numDispProps) {
            target = this.viewConfig.getDispProp(i).getName();
            if (!(target = target.toLowerCase()).equals("")) {
                if (propername != null && propername.startsWith(target)) {
                    propernamei = i;
                } else if (name.startsWith(target)) {
                    namei = i;
                }
            }
            ++i;
        }
        if (propernamei != null) {
            return propernamei;
        }
        if (namei != null) {
            return namei;
        }
        int otherIndex = this.viewConfig.getOtherIndex();
        if (otherIndex != -1) {
            return otherIndex;
        }
        return numDispProps - 2;
    }

    public void addOverlay() {
        if (this.overlay != null) {
            Shape3D duplicateOverlay = new Shape3D();
            duplicateOverlay.duplicateNode(this.overlay, true);
            this.nucBG.addChild(duplicateOverlay);
            System.out.println("Finished adding to scene graph.");
            return;
        }
        System.out.println("No overlay to add to scene graph.");
    }

    public synchronized void setOverlay(Shape3D overlay) {
        this.overlay = overlay;
    }

    public synchronized void setOverlayReady(boolean ready) {
        this.overlayReady = ready;
    }
}

