/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.image;

import ij.ImagePlus;
import java.awt.Color;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.util.Vector;
import javax.media.j3d.Appearance;
import javax.media.j3d.PointArray;
import javax.media.j3d.PointAttributes;
import javax.media.j3d.Shape3D;
import javax.vecmath.Color4f;
import org.rhwlab.acetree.AceTree;
import org.rhwlab.image.Image3D;
import org.rhwlab.image.Image3DGeometryManager;
import org.rhwlab.image.Image3DViewConfig;
import org.rhwlab.image.ImageWindow;
import org.rhwlab.snight.NucleiMgr;
import org.rhwlab.tree.Cell;

public class Image3DOverlayGenerator
extends Thread {
    private AceTree aceTree;
    private Image3DViewConfig viewConfig;
    private ImageWindow imageWindow;
    private Image3DGeometryManager geoMgr;
    private NucleiMgr nucleiMgr;
    private boolean needReload;
    private Image3D parent;
    private Vector<BufferedImage> images;
    private Vector<double[]> coordinates;
    private Vector<Float> alphas;
    private Vector<Color> colors;
    private Shape3D overlay;
    private int time;
    private Cell overlayROICell;
    private int sliceCount;
    private int iUseStack;

    public Image3DOverlayGenerator(Image3D p) {
        this.parent = p;
        this.geoMgr = this.parent.getGeoManager();
        this.viewConfig = this.parent.getViewConfig();
        this.aceTree = this.parent.getAceTree();
        this.nucleiMgr = this.aceTree.getNucleiMgr();
        this.imageWindow = this.aceTree.iImgWin;
        this.sliceCount = this.nucleiMgr.getPlaneEnd();
        this.overlay = null;
        this.iUseStack = this.aceTree.getUseStack();
    }

    /*
     * Exception decompiling
     */
    @Override
    public void run() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 10[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void loadImages() throws InterruptedException {
        this.images = new Vector();
        ImagePlus ip = null;
        String title = this.viewConfig.getTitle();
        if (this.iUseStack == 1) {
            title = this.aceTree.getTifPathWithPrefix();
        }
        System.out.println("Image3DOverlayGenerator.loadImages() title: " + title);
        String imageName = null;
        this.time = this.aceTree.getImageTime() + this.aceTree.getTimeInc();
        int i = 0;
        while (i < this.getSliceCount() && !Thread.currentThread().isInterrupted()) {
            if (this.iUseStack == 0) {
                imageName = "tif/" + title + "-p";
                if (i + 1 < 10) {
                    imageName = String.valueOf(imageName) + "0";
                }
                imageName = String.valueOf(imageName) + (i + 1) + ".tif";
                ip = ImageWindow.makeImage(imageName);
            } else if (this.iUseStack == 1) {
                imageName = title;
                ip = ImageWindow.makeImage2(imageName, i, this.iUseStack);
            }
            BufferedImage bf = ip.getBufferedImage();
            AffineTransform tx = AffineTransform.getScaleInstance(1.0, -1.0);
            tx.translate(0.0, -bf.getHeight(null));
            AffineTransformOp op = new AffineTransformOp(tx, 1);
            bf = op.filter(bf, null);
            this.images.add(bf);
            ++i;
        }
        Thread.currentThread();
        if (Thread.interrupted()) {
            System.out.println("Thread interrupted.");
            throw new InterruptedException();
        }
        System.out.println("generator finished loading images.");
    }

    public Shape3D generateOverlay(float pointSize) throws InterruptedException {
        if (this.coordinates.size() > 0) {
            PointArray p = new PointArray(this.coordinates.size(), 13);
            Shape3D points = new Shape3D(p);
            points.setAppearance(new Appearance());
            points.getAppearance().setPointAttributes(new PointAttributes(pointSize, true));
            int i = 0;
            while (i < this.coordinates.size()) {
                p.setCoordinate(i, this.coordinates.get(i));
                float[] col = this.colors.get(i).getColorComponents(null);
                if (Thread.currentThread().isInterrupted()) {
                    Thread.currentThread();
                    if (Thread.interrupted()) {
                        throw new InterruptedException();
                    }
                }
                if (!this.viewConfig.useOverlayRedChannel()) {
                    col[0] = 0.0f;
                }
                if (!this.viewConfig.useOverlayGreenChannel()) {
                    col[1] = 0.0f;
                }
                if (!this.viewConfig.useOverlayBlueChannel()) {
                    col[2] = 0.0f;
                }
                float alpha = (float)(1.0 - Math.pow(Math.sqrt(col[0] * col[0] + col[1] * col[1] + col[2] * col[2]) / Math.sqrt(3.0), 2.5));
                p.setColor(i, new Color4f(col[0], col[1], col[2], 1.0f - alpha));
                ++i;
            }
            System.out.println("Finished converting to Shape3D in generateOverlay().");
            return points;
        }
        return null;
    }

    public void generateOverlayInfo(double dx, double dy, double dz, int subSample, double colorScale) throws InterruptedException {
        this.coordinates = new Vector();
        this.colors = new Vector();
        this.alphas = new Vector();
        BufferedImage img = null;
        int width = ImageWindow.cImageWidth;
        if (width == 0) {
            width = 800;
        }
        float scale = width / 2;
        this.viewConfig.setOverlayMaxZ(this.nucleiMgr.getPlaneEnd());
        int z = 0;
        while (z < this.images.size()) {
            if (z > this.viewConfig.getOverlayMinZ() && z < this.viewConfig.getOverlayMaxZ()) {
                img = this.images.get(z);
                int x = 0;
                while (x < img.getWidth()) {
                    if (x > this.viewConfig.getOverlayMinX() && x < this.viewConfig.getOverlayMaxX()) {
                        int y = 0;
                        while (y < img.getHeight()) {
                            if (y > this.viewConfig.getOverlayMinY() && y < this.viewConfig.getOverlayMaxY() && x % subSample == 0 && y % subSample == 0) {
                                if (Thread.currentThread().isInterrupted()) {
                                    Thread.currentThread();
                                    if (Thread.interrupted()) {
                                        throw new InterruptedException();
                                    }
                                }
                                int colorAsInt = img.getRGB(x, img.getHeight() - y - 1);
                                this.colors.add(new Color(colorAsInt, true));
                                float[] col = new Color(colorAsInt).getColorComponents(null);
                                double alpha = 1.0 - Math.pow(Math.sqrt(col[0] * col[0] + col[1] * col[1] + col[2] * col[2]) / Math.sqrt(3.0), colorScale);
                                this.alphas.add(new Float((float)alpha));
                                float xf = (float)(x - this.geoMgr.iXA) / scale;
                                float yf = (float)(y - this.geoMgr.iYA) / scale;
                                float zf = (float)dz * ((float)z - this.geoMgr.iZA) / scale;
                                yf = -yf;
                                zf = -zf;
                                this.coordinates.add(new double[]{(double)xf * dx, (double)yf * dy, zf});
                            }
                            ++y;
                        }
                    }
                    ++x;
                }
            }
            ++z;
        }
        System.out.println("Finished generateOverlayInfo().");
    }

    public void addOverlayAutoROI() {
        Cell c = this.aceTree.getCurrentCell();
        if (c != this.overlayROICell) {
            this.overlayROICell = c;
            c = null;
        }
        int x = this.overlayROICell.getX();
        int y = this.overlayROICell.getY();
        double diameter = this.aceTree.getCurrentCell().getDiam();
        this.viewConfig.setOverlayMinX((int)((double)x - 2.0 * diameter));
        this.viewConfig.setOverlayMaxX((int)((double)x + 2.0 * diameter));
        this.viewConfig.setOverlayMinY((int)((double)y - 2.0 * diameter));
        this.viewConfig.setOverlayMaxY((int)((double)y + 2.0 * diameter));
        if (c != this.overlayROICell) {
            this.viewConfig.setOverlayXYZChanged(true);
        }
    }

    public void createOverlay() throws InterruptedException {
        if (this.viewConfig.useOverlayAutoROI()) {
            this.addOverlayAutoROI();
        }
        if (this.overlay == null || this.time != this.aceTree.getImageTime() + this.aceTree.getTimeInc()) {
            this.loadImages();
            this.viewConfig.setOverlayXYZChanged(true);
        }
        if (this.viewConfig.isOverlayXYZChanged()) {
            this.viewConfig.setOverlayXYZChanged(false);
            this.viewConfig.setChangeOverlayChannel(false);
            this.generateOverlayInfo(1.0, 1.0, this.nucleiMgr.getZPixRes(), this.viewConfig.getOverlaySubsample(), 2.5);
            this.overlay = this.generateOverlay(this.calculateOverlayPointSize());
        } else if (this.viewConfig.changeOverlayChannel()) {
            this.viewConfig.setChangeOverlayChannel(false);
            this.overlay = this.generateOverlay(this.calculateOverlayPointSize());
        }
        if (this.overlay != null) {
            this.geoMgr.setOverlay(this.overlay);
            return;
        }
    }

    public int getSliceCount() {
        return this.sliceCount;
    }

    public float calculateOverlayPointSize() {
        return (float)this.viewConfig.getOverlaySubsample() * 5.0f;
    }
}

