/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.image;

import java.awt.Color;
import org.rhwlab.image.SublineageDisplayProperty;

public class Image3DViewConfig {
    public static final String[] LINEAGE_COLORS = new String[]{"red", "blue", "green", "yellow", "cyan", "magenta", "pink", "gray", "light gray", "dark gray", "white", "transparent", "omit"};
    public static final String[] TRANSPROPS = new String[]{"omit", "transparent", "white"};
    public static final String[] GRAYDEPTH = new String[]{"white", "light gray", "dark gray"};
    public final SublineageDisplayProperty[] DISP_PROPS = new SublineageDisplayProperty[]{new SublineageDisplayProperty("ABa", 0), new SublineageDisplayProperty("ABp", 1), new SublineageDisplayProperty("C", 5), new SublineageDisplayProperty("D", 6), new SublineageDisplayProperty("E", 2), new SublineageDisplayProperty("MS", 4), new SublineageDisplayProperty("P", 3), new SublineageDisplayProperty("polar", 7), new SublineageDisplayProperty("", 2), new SublineageDisplayProperty("", 2), new SublineageDisplayProperty("", 2), new SublineageDisplayProperty("", 2), new SublineageDisplayProperty("", 2), new SublineageDisplayProperty("", 2), new SublineageDisplayProperty("", 2), new SublineageDisplayProperty("", 2), new SublineageDisplayProperty("", 2), new SublineageDisplayProperty("", 2), new SublineageDisplayProperty("", 2), new SublineageDisplayProperty("", 2), new SublineageDisplayProperty("", 2), new SublineageDisplayProperty("", 2), new SublineageDisplayProperty("", 2), new SublineageDisplayProperty("", 2), new SublineageDisplayProperty("other", 2), new SublineageDisplayProperty("background", 1)};
    public static final SublineageDisplayProperty[] DEFAULT_DISP_PROPS = new SublineageDisplayProperty[]{new SublineageDisplayProperty("ABa", 0), new SublineageDisplayProperty("ABp", 1), new SublineageDisplayProperty("C", 5), new SublineageDisplayProperty("D", 6), new SublineageDisplayProperty("E", 2), new SublineageDisplayProperty("MS", 4), new SublineageDisplayProperty("P", 3), new SublineageDisplayProperty("polar", 7), new SublineageDisplayProperty("", 2), new SublineageDisplayProperty("", 2), new SublineageDisplayProperty("", 2), new SublineageDisplayProperty("", 2), new SublineageDisplayProperty("", 2), new SublineageDisplayProperty("", 2), new SublineageDisplayProperty("", 2), new SublineageDisplayProperty("", 2), new SublineageDisplayProperty("", 2), new SublineageDisplayProperty("", 2), new SublineageDisplayProperty("", 2), new SublineageDisplayProperty("", 2), new SublineageDisplayProperty("", 2), new SublineageDisplayProperty("", 2), new SublineageDisplayProperty("", 2), new SublineageDisplayProperty("", 2), new SublineageDisplayProperty("other", 2), new SublineageDisplayProperty("background", 1)};
    public static final int MIN_RED = 25000;
    public static final int MAX_RED = 100000;
    public static final int SPECIAL = 1;
    public static final int MAX_TAIL_TIME_PTS = 20;
    public static final int MIN_TAIL_TIME_PTS = 0;
    public static final int INIT_TAIL_TIME_PTS = 10;
    public static final int DEFAULT_TAIL_OPACITY = 50;
    public static final int DEFAULT_OVERLAY_MAX_X = 512;
    public static final int DEFAULT_OVERLAY_MIN_X = 0;
    public static final int DEFAULT_OVERLAY_MAX_Y = 512;
    public static final int DEFAULT_OVERLAY_MIN_Y = 0;
    public static final int DEFAULT_OVERLAY_MAX_Z = 30;
    public static final int DEFAULT_OVERLAY_MIN_Z = 0;
    public static final int DEFAULT_OVERLAY_SUBSAMPLE = 2;
    public static final Color DEFAULT_CUSTOM_TAIL_COLOR = Color.MAGENTA;
    private static Image3DViewConfig instance = null;
    private SublineageDisplayProperty[] dispProps;
    private boolean useExpression;
    private boolean showNonExpressing;
    private boolean useExpressionColors;
    private int minRed;
    private int maxRed;
    private boolean showTails;
    private Color customTailColor;
    private int tailOpacity;
    private int tailTimePts;
    private boolean sistersVisible;
    private String currentRotDir;
    private int lineageCount;
    private String title;
    private int overlayMaxX;
    private int overlayMinX;
    private int overlayMaxY;
    private int overlayMinY;
    private int overlayMaxZ;
    private int overlayMinZ;
    private int overlaySubsample;
    private boolean overlayXYZChanged;
    private boolean showOverlay;
    private boolean useOverlayAutoROI;
    private boolean useOverlayRedChannel;
    private boolean useOverlayGreenChannel;
    private boolean useOverlayBlueChannel;
    private boolean changeOverlayChannel;

    public static int getColorIndex(String color) {
        int i = 0;
        while (i < LINEAGE_COLORS.length) {
            if (color.equals(LINEAGE_COLORS[i])) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    public Image3DViewConfig() {
        this.propertiesReset();
    }

    public static Image3DViewConfig getInstance() {
        if (instance == null) {
            instance = new Image3DViewConfig();
        }
        return instance;
    }

    public void propertiesReset() {
        this.dispProps = this.DISP_PROPS;
        this.useExpression = false;
        this.showNonExpressing = false;
        this.showTails = false;
        this.minRed = 25000;
        this.maxRed = 100000;
        this.tailTimePts = 10;
        this.tailOpacity = 50;
        this.customTailColor = DEFAULT_CUSTOM_TAIL_COLOR;
        this.currentRotDir = ".";
        this.resetOverlayDefaults();
        this.showOverlay = false;
    }

    public static SublineageDisplayProperty[] getDefaultDispProp() {
        return DEFAULT_DISP_PROPS;
    }

    public void resetOverlayDefaults() {
        this.overlayMaxX = 512;
        this.overlayMinX = 0;
        this.overlayMaxY = 512;
        this.overlayMinY = 0;
        this.overlayMaxZ = 30;
        this.overlayMinZ = 0;
        this.overlayXYZChanged = true;
        this.overlaySubsample = 2;
        this.useOverlayAutoROI = false;
        this.showOverlay = true;
        this.useOverlayRedChannel = true;
        this.useOverlayGreenChannel = true;
        this.useOverlayBlueChannel = true;
        this.changeOverlayChannel = false;
    }

    public int getNumDispProps() {
        return this.dispProps.length;
    }

    public SublineageDisplayProperty getDispProp(int i) {
        return this.dispProps[i];
    }

    public int getOtherIndex() {
        int i = 0;
        while (i < this.getNumDispProps()) {
            String name = this.dispProps[i].getName();
            if ((name = name.toLowerCase()).equals("other")) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public SublineageDisplayProperty[] getDispProps() {
        return this.dispProps;
    }

    public int getMinRed() {
        return this.minRed;
    }

    public int getMaxRed() {
        return this.maxRed;
    }

    public boolean isUsingExpression() {
        return this.useExpression;
    }

    public boolean isUsingExpressionColors() {
        return this.useExpressionColors;
    }

    public boolean isShowingNonExpressing() {
        return this.showNonExpressing;
    }

    public boolean areSistersVisible() {
        return this.sistersVisible;
    }

    public int getLineageCount() {
        return this.lineageCount;
    }

    public String getCurrentRotDir() {
        return this.currentRotDir;
    }

    public boolean isShowingTails() {
        return this.showTails;
    }

    public Color getCustomTailColor() {
        return this.customTailColor;
    }

    public int getTailOpacity() {
        return this.tailOpacity;
    }

    public int getTailTimePoints() {
        return this.tailTimePts;
    }

    public Color getSisterColor() {
        return Color.MAGENTA;
    }

    public String getTitle() {
        return this.title;
    }

    public int getOverlayMaxX() {
        return this.overlayMaxX;
    }

    public int getOverlayMinX() {
        return this.overlayMinX;
    }

    public int getOverlayMaxY() {
        return this.overlayMaxY;
    }

    public int getOverlayMinY() {
        return this.overlayMinY;
    }

    public int getOverlayMaxZ() {
        return this.overlayMaxZ;
    }

    public int getOverlayMinZ() {
        return this.overlayMinZ;
    }

    public int getOverlaySubsample() {
        return this.overlaySubsample;
    }

    public boolean isOverlayXYZChanged() {
        return this.overlayXYZChanged;
    }

    public boolean isShowingOverlay() {
        return this.showOverlay;
    }

    public boolean useOverlayAutoROI() {
        return this.useOverlayAutoROI;
    }

    public boolean useOverlayRedChannel() {
        return this.useOverlayRedChannel;
    }

    public boolean useOverlayGreenChannel() {
        return this.useOverlayGreenChannel;
    }

    public boolean useOverlayBlueChannel() {
        return this.useOverlayBlueChannel;
    }

    public boolean changeOverlayChannel() {
        return this.changeOverlayChannel;
    }

    public void setMinRed(int newMin) {
        this.minRed = newMin;
    }

    public void setMaxRed(int newMax) {
        this.maxRed = newMax;
    }

    public void setUseExpression(boolean useExpr) {
        this.useExpression = useExpr;
    }

    public void setUseExpressionColors(boolean useExprCol) {
        this.useExpressionColors = useExprCol;
    }

    public void setShowNonExpressing(boolean showNonExpr) {
        this.showNonExpressing = showNonExpr;
    }

    public void setSistersVisible(boolean sisterVisible) {
        this.sistersVisible = sisterVisible;
    }

    private void reportDispProps() {
        int i = 0;
        while (i < this.getNumDispProps()) {
            System.out.println("dispProp: " + i + "," + this.getDispProp(i).getName() + "," + this.getDispProp(i).getLineageNum());
            ++i;
        }
    }

    public void setLineageCount(int count) {
        this.lineageCount = count;
    }

    public void setCurrentRotDir(String dir) {
        this.currentRotDir = dir;
    }

    public void setShowingTails(boolean show) {
        this.showTails = show;
    }

    public void setCustomTailColor(Color c) {
        if (c != null) {
            this.customTailColor = c;
        }
    }

    public void setTailOpacity(int op) {
        this.tailOpacity = op;
    }

    public void setTailTimePoints(int tp) {
        this.tailTimePts = tp;
    }

    public void setTitle(String t) {
        this.title = t;
    }

    public void setOverlayMaxX(int o) {
        this.overlayMaxX = o;
    }

    public void setOverlayMaxY(int o) {
        this.overlayMaxY = o;
    }

    public void setOverlayMaxZ(int o) {
        this.overlayMaxZ = o;
    }

    public void setOverlayMinX(int o) {
        this.overlayMinX = o;
    }

    public void setOverlayMinY(int o) {
        this.overlayMinY = o;
    }

    public void setOverlayMinZ(int o) {
        this.overlayMinZ = o;
    }

    public void setOverlaySubsample(int s) {
        this.overlaySubsample = s;
    }

    public void setOverlayXYZChanged(boolean c) {
        this.overlayXYZChanged = c;
    }

    public void setShowingOverlay(boolean show) {
        this.showOverlay = show;
    }

    public void setUseOverlayAutoROI(boolean use) {
        this.useOverlayAutoROI = use;
    }

    public void setUseOverlayRedChannel(boolean use) {
        this.useOverlayRedChannel = use;
    }

    public void setUseOverlayGreenChannel(boolean use) {
        this.useOverlayGreenChannel = use;
    }

    public void setUseOverlayBlueChannel(boolean use) {
        this.useOverlayBlueChannel = use;
    }

    public void setChangeOverlayChannel(boolean use) {
        this.changeOverlayChannel = use;
    }
}

