/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.image;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class ImageContrastTool
extends JDialog
implements ActionListener,
ChangeListener {
    private JSlider iSlider1min;
    private JSlider iSlider1max;
    private JSlider iSlider2min;
    private JSlider iSlider2max;
    private JTextField iText1min;
    private JTextField iText1max;
    private JTextField iText2min;
    private JTextField iText2max;
    private double min1;
    private double max1;
    private double min2;
    private double max2;
    private JButton iReset;
    private JButton iCancel;
    private int iUseStack;
    private static final int MAX8BIT = 255;
    private static final int MAX16BIT = 65535;

    public ImageContrastTool(JFrame parent, int useStack) {
        super(parent, "Adjust Contrast", false);
        this.iUseStack = useStack;
        if (this.iUseStack == 1) {
            this.setTitle(String.valueOf(this.getTitle()) + " 16-bit stack mode");
        } else {
            this.setTitle(String.valueOf(this.getTitle()) + " 8-bit non-stack mode");
        }
        this.addDialogComponents();
        this.setDefaultCloseOperation(1);
        this.pack();
        this.setVisible(true);
        this.min2 = 0.0;
        this.min1 = 0.0;
        if (this.iUseStack == 1) {
            this.max2 = 65535.0;
            this.max1 = 65535.0;
        } else {
            this.max2 = 255.0;
            this.max1 = 255.0;
        }
    }

    public void addDialogComponents() {
        DocumentListener docListener = new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.readText(e);
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.readText(e);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.readText(e);
            }

            private void readText(DocumentEvent e) {
                Object source = e.getDocument().getProperty("owner");
                if (source instanceof JTextField) {
                    try {
                        boolean valid;
                        double val = Double.parseDouble(((JTextField)source).getText());
                        int sliderVal = (int)val;
                        int validMax = 255;
                        if (ImageContrastTool.this.iUseStack == 1) {
                            validMax = 65535;
                        }
                        boolean bl = valid = val >= 0.0 && val <= (double)validMax;
                        if (valid) {
                            if (ImageContrastTool.this.iText1min == source) {
                                ImageContrastTool.this.iSlider1min.setValue(sliderVal);
                            } else if (ImageContrastTool.this.iText1max == source) {
                                ImageContrastTool.this.iSlider1max.setValue(sliderVal);
                            } else if (ImageContrastTool.this.iText2min == source) {
                                ImageContrastTool.this.iSlider2min.setValue(sliderVal);
                            } else if (ImageContrastTool.this.iText2max == source) {
                                ImageContrastTool.this.iSlider2max.setValue(sliderVal);
                            }
                        }
                    }
                    catch (Exception e2) {
                        return;
                    }
                }
            }
        };
        JPanel jpWhole = new JPanel();
        jpWhole.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        int sliderMaxVal = 255;
        if (this.iUseStack == 1) {
            sliderMaxVal = 65535;
        }
        JLabel jl = new JLabel("Red Channel Min");
        this.iSlider1min = new JSlider(0, sliderMaxVal);
        this.iSlider1min.setValue(0);
        this.setTicks(this.iSlider1min);
        this.iSlider1min.addChangeListener(this);
        this.iText1min = new JTextField("0", 7);
        this.iText1min.getDocument().addDocumentListener(docListener);
        this.setOwner(this.iText1min);
        c.ipady = 20;
        c.gridx = 0;
        c.gridy = 0;
        jpWhole.add((Component)jl, c);
        c.gridx = 1;
        c.gridwidth = 3;
        jpWhole.add((Component)this.iSlider1min, c);
        c.gridx = 4;
        c.gridwidth = 1;
        jpWhole.add((Component)this.iText1min, c);
        jl = new JLabel("Red Channel Max");
        this.iSlider1max = new JSlider(0, sliderMaxVal);
        this.iSlider1max.setValue(sliderMaxVal);
        this.setTicks(this.iSlider1max);
        this.iSlider1max.addChangeListener(this);
        this.iText1max = new JTextField("" + sliderMaxVal, 7);
        this.iText1max.getDocument().addDocumentListener(docListener);
        this.setOwner(this.iText1max);
        c.gridx = 0;
        c.gridy = 1;
        jpWhole.add((Component)jl, c);
        c.gridx = 1;
        c.gridwidth = 3;
        jpWhole.add((Component)this.iSlider1max, c);
        c.gridx = 4;
        c.gridwidth = 1;
        jpWhole.add((Component)this.iText1max, c);
        jl = new JLabel("Green Channel Min");
        this.iSlider2min = new JSlider(0, sliderMaxVal);
        this.iSlider2min.setValue(0);
        this.setTicks(this.iSlider2min);
        this.iSlider2min.addChangeListener(this);
        this.iText2min = new JTextField("0", 7);
        this.iText2min.getDocument().addDocumentListener(docListener);
        this.setOwner(this.iText2min);
        c.gridx = 0;
        c.gridy = 2;
        jpWhole.add((Component)jl, c);
        c.gridx = 1;
        c.gridwidth = 3;
        jpWhole.add((Component)this.iSlider2min, c);
        c.gridx = 4;
        c.gridwidth = 1;
        jpWhole.add((Component)this.iText2min, c);
        jl = new JLabel("Green Channel Max");
        this.iSlider2max = new JSlider(0, sliderMaxVal);
        this.iSlider2max.setValue(65535);
        this.setTicks(this.iSlider2max);
        this.iSlider2max.addChangeListener(this);
        this.iText2max = new JTextField("" + sliderMaxVal, 7);
        this.iText2max.getDocument().addDocumentListener(docListener);
        this.setOwner(this.iText2max);
        c.gridx = 0;
        c.gridy = 3;
        jpWhole.add((Component)jl, c);
        c.gridx = 1;
        c.gridwidth = 3;
        jpWhole.add((Component)this.iSlider2max, c);
        c.gridx = 4;
        c.gridwidth = 1;
        jpWhole.add((Component)this.iText2max, c);
        this.iReset = new JButton("Reset");
        this.iReset.addActionListener(this);
        this.iCancel = new JButton("Cancel");
        this.iCancel.addActionListener(this);
        c.gridy = 4;
        c.gridx = 1;
        jpWhole.add((Component)this.iReset, c);
        c.gridx = 2;
        jpWhole.add((Component)this.iCancel, c);
        this.add(jpWhole);
    }

    public void setOwner(JTextField jtf) {
        jtf.getDocument().putProperty("owner", jtf);
    }

    public void setTicks(JSlider js) {
        Dimension d = js.getPreferredSize();
        js.setPreferredSize(new Dimension(d.width + 120, d.height));
        if (this.iUseStack == 1) {
            js.setMinorTickSpacing(4096);
            js.setMajorTickSpacing(8192);
        } else {
            js.setMinorTickSpacing(16);
            js.setMajorTickSpacing(32);
        }
        js.setPaintTicks(true);
        js.setSnapToTicks(false);
        Hashtable<Integer, JLabel> table = new Hashtable<Integer, JLabel>();
        table.put(new Integer(0), new JLabel("0"));
        if (this.iUseStack == 1) {
            table.put(new Integer(16384), new JLabel("16383"));
            table.put(new Integer(32768), new JLabel("32767"));
            table.put(new Integer(49152), new JLabel("49151"));
            table.put(new Integer(65535), new JLabel("65535"));
        } else {
            table.put(new Integer(64), new JLabel("63"));
            table.put(new Integer(128), new JLabel("127"));
            table.put(new Integer(192), new JLabel("191"));
            table.put(new Integer(255), new JLabel("255"));
        }
        js.setLabelTable(table);
        js.setPaintLabels(true);
    }

    public void setSlider1min(int val) {
        this.iSlider1min.setValue(val);
    }

    public void setSlider1max(int val) {
        this.iSlider1max.setValue(val);
    }

    public void setSlider2min(int val) {
        this.iSlider2min.setValue(val);
    }

    public void setSlider2max(int val) {
        this.iSlider2max.setValue(val);
    }

    public JSlider getSlider1min() {
        return this.iSlider1min;
    }

    public JSlider getSlider1max() {
        return this.iSlider1max;
    }

    public JSlider getSlider2min() {
        return this.iSlider2min;
    }

    public JSlider getSlider2max() {
        return this.iSlider2max;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (this.iCancel == source) {
            this.setVisible(false);
        } else if (this.iReset == source) {
            this.resetSliders();
        }
    }

    public void resetSliders() {
        this.iSlider1min.setValue(0);
        this.iSlider2min.setValue(0);
        if (this.iUseStack == 1) {
            this.iSlider1max.setValue(65535);
            this.iSlider2max.setValue(65535);
        } else {
            this.iSlider1max.setValue(255);
            this.iSlider2max.setValue(255);
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        JSlider source = (JSlider)e.getSource();
        if (!source.getValueIsAdjusting()) {
            int val = source.getValue();
            String txt = "" + val;
            if (this.iSlider1min == source) {
                this.min1 = val;
                this.iText1min.setText(txt);
            } else if (this.iSlider1max == source) {
                this.max1 = val;
                this.iText1max.setText(txt);
            } else if (this.iSlider2min == source) {
                this.min2 = val;
                this.iText2min.setText(txt);
            } else if (this.iSlider2max == source) {
                this.max2 = val;
                this.iText2max.setText(txt);
            }
        }
    }
}

