/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.image;

import ij.IJ;
import ij.ImagePlus;
import ij.gui.ImageCanvas;
import ij.gui.OvalRoi;
import ij.io.FileInfo;
import ij.io.FileOpener;
import ij.io.Opener;
import ij.io.TiffDecoder;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.ImageConverter;
import ij.process.ImageProcessor;
import java.awt.AWTException;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import java.util.zip.ZipEntry;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.FileImageOutputStream;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.ListModel;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MouseInputAdapter;
import net.sf.ij.jaiio.BufferedImageCreator;
import org.rhwlab.acetree.AceTree;
import org.rhwlab.acetree.AnnotInfo;
import org.rhwlab.acetree.PartsList;
import org.rhwlab.acetree.PlayerControl;
import org.rhwlab.image.ImageContrastTool;
import org.rhwlab.image.ImageParamsDialog;
import org.rhwlab.image.ImageZoomerFrame;
import org.rhwlab.image.ImageZoomerPanel;
import org.rhwlab.image.ZipImage;
import org.rhwlab.nucedit.AddOneDialog;
import org.rhwlab.nucedit.UnifiedNucRelinkDialog;
import org.rhwlab.snight.NucleiMgr;
import org.rhwlab.snight.Nucleus;
import org.rhwlab.tree.Cell;
import org.rhwlab.utils.EUtils;

public class ImageWindow
extends JFrame
implements KeyListener,
Runnable {
    public ImageCanvas iImgCanvas;
    static ImagePlus iImgPlus;
    String iTitle;
    static Object[] iSpecialEffect;
    AceTree iAceTree;
    Vector iAnnotsShown;
    MouseHandler iMouseHandler;
    WinEventMgr wem;
    boolean iMouseEventHandled;
    int iImageTime;
    int iTimeInc;
    int iImagePlane;
    int iPlaneInc;
    boolean iIsMainImgWindow;
    boolean iIsRightMouseButton;
    boolean iSaveImage;
    boolean iSaveInProcess;
    String iSaveImageDirectory;
    boolean iUseRobot;
    boolean iNewConstruction;
    PartsList iPartsList;
    public static ColorSchemeDisplayProperty[] iDispProps;
    private JPanel iControlPanel;
    protected JToolBar iToolBar;
    protected JButton iHelp;
    protected JButton iProperties;
    ImageZoomerFrame iImageZoomerFrame;
    ImageZoomerPanel iImageZoomerPanel;
    static boolean cAcbTree;
    public static int contrastmin1;
    public static int contrastmax1;
    public static int contrastmin2;
    public static int contrastmax2;
    static byte[] iRpix;
    static byte[] iGpix;
    static byte[] iBpix;
    public static int imagewindowPlaneNumber;
    public static int imagewindowUseStack;
    public static String cZipTifFilePath;
    public static String cTifPrefix;
    public static String cTifPrefixR;
    public static int cUseZip;
    static ZipImage cZipImage;
    public static NucleiMgr cNucleiMgr;
    public static int cImageWidth;
    public static int cImageHeight;
    public static int cLineWidth;
    public static String cCurrentImageFile;
    public static String cCurrentImagePart;
    public static int cSplitChannelImage;
    ImagePlus currentImage;
    protected DefaultListModel iBookmarkListModel;
    protected ImageContrastTool ict;
    protected JButton ictApplyButton;
    protected JSlider iSlider1min;
    protected JSlider iSlider1max;
    protected JSlider iSlider2min;
    protected JSlider iSlider2max;
    protected static boolean setOriginalContrastValues;
    public static final int[] WIDTHS;
    protected static final String RANDOMF = ".zip0";
    protected static final String RANDOMT = ".tif0";
    protected static final String DASHT = "-t";
    protected static final String DASHP = "-p";
    private static final int GREENCHANNEL = 2;
    private static final int REDCHANNEL = 4;
    private static final int CHANNELMAX = 255;
    private static final int CHANNELMIN = 0;
    public static final Integer ANTERIOR;
    public static final Integer POSTERIOR;
    public static final Integer NONE;
    private static final String CS = ", ";
    private static final int DATA_BLOCK_SIZE = 2048;
    public static final int NCENTROID = 0;
    public static final int SCENTROID = 1;
    public static final int ANNOTATIONS = 2;
    public static final int UPPERSIS = 3;
    public static final int LOWERSIS = 4;
    public static final int LINEWIDTH = 5;
    public static final int BMCENTROID = 7;
    public static final Color[] COLOR;
    public JDialog iDialog;
    public JDialog iDialog2;
    private static final int MAX8BIT = 255;
    private static final int MAX16BIT = 65535;

    static {
        cAcbTree = false;
        WIDTHS = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10};
        ANTERIOR = new Integer(1);
        POSTERIOR = new Integer(2);
        NONE = new Integer(0);
        COLOR = new Color[]{Color.RED, new Color(140, 70, 255), Color.GREEN, Color.YELLOW, Color.CYAN, Color.MAGENTA, Color.PINK, Color.LIGHT_GRAY, Color.WHITE};
    }

    public ImageWindow(String title, ImagePlus imgPlus, PlayerControl playercontrol) {
        super(title.substring(4, title.length()));
        ImageCanvas ic;
        setOriginalContrastValues = true;
        this.iPartsList = new PartsList();
        this.iTitle = title;
        iImgPlus = imgPlus;
        this.iImgCanvas = ic = new ImageCanvas(imgPlus);
        iDispProps = this.getDisplayProps();
        URL imageURL = ImageWindow.class.getResource("/images/icon2.gif");
        ImageIcon test = new ImageIcon(imageURL, "x");
        this.setIconImage(test.getImage());
        Container c = this.getContentPane();
        JPanel jp = new JPanel();
        jp.setLayout(new BorderLayout());
        BufferedImage image = BufferedImageCreator.create((ColorProcessor)((ColorProcessor)iImgPlus.getProcessor()));
        this.iImageZoomerPanel = new ImageZoomerPanel(this, image, 10.0, title, playercontrol);
        jp.add(this.iImageZoomerPanel);
        c.add(jp);
        this.pack();
        this.setVisible(true);
        this.setDefaultCloseOperation(1);
        this.wem = new WinEventMgr();
        this.addWindowFocusListener(this.wem);
        this.addWindowListener(this.wem);
        this.iMouseHandler = new MouseHandler(this);
        this.iImageZoomerPanel.getImage().addMouseMotionListener(this.iMouseHandler);
        this.iImageZoomerPanel.getImage().addMouseListener(this.iMouseHandler);
        this.setImageTimeAndPlaneFromTitle();
        this.iAnnotsShown = new Vector();
        this.iIsRightMouseButton = false;
        this.iSaveImage = false;
        this.iSaveImageDirectory = null;
        this.iUseRobot = false;
        this.iImgCanvas.addKeyListener((KeyListener)this);
        this.iBookmarkListModel = null;
        this.ict = null;
        this.ictApplyButton = null;
        this.iSlider2max = null;
        this.iSlider2min = null;
        this.iSlider1max = null;
        this.iSlider1min = null;
        contrastmin2 = 0;
        contrastmin1 = 0;
        if (imagewindowUseStack == 1) {
            contrastmax2 = 65535;
            contrastmax1 = 65535;
        } else {
            contrastmax2 = 255;
            contrastmax1 = 255;
        }
    }

    public void removeHandlers() {
        this.iImageZoomerPanel.getImage().removeMouseListener(this.iMouseHandler);
        this.iImageZoomerPanel.getImage().removeMouseListener(this.iMouseHandler);
        this.iMouseHandler = null;
        this.removeWindowFocusListener(this.wem);
        this.removeWindowListener(this.wem);
        this.wem = null;
    }

    public void setBookmarkList(ListModel list) {
        this.iBookmarkListModel = (DefaultListModel)list;
    }

    public MouseHandler getMouseHandler() {
        return this.iMouseHandler;
    }

    public static void setStaticParameters(String zipTifFilePath, String tifPrefix, int useZip, int splitChannelImage) {
        cZipTifFilePath = zipTifFilePath;
        cTifPrefix = tifPrefix;
        cUseZip = useZip;
        if (cUseZip == 1) {
            cZipImage = new ZipImage(cZipTifFilePath);
        }
        cLineWidth = 1;
        String[] sa = cTifPrefix.split("/");
        if (sa.length > 1) {
            cTifPrefixR = String.valueOf(sa[0]) + "R" + "/" + sa[1];
        }
        cSplitChannelImage = splitChannelImage;
    }

    public static void setNucleiMgr(NucleiMgr nucleiMgr) {
        cNucleiMgr = nucleiMgr;
    }

    public static ImagePlus makeImage(String s) {
        cCurrentImageFile = s;
        ImagePlus ip = null;
        switch (cUseZip) {
            case 0: 
            case 3: {
                ip = ImageWindow.doMakeImageFromTif(s);
                break;
            }
            case 1: {
                ip = ImageWindow.doMakeImageFromZip(s);
                break;
            }
            default: {
                ip = ImageWindow.doMakeImageFromZip2(s);
            }
        }
        if (ip != null) {
            cImageWidth = ip.getWidth();
            cImageHeight = ip.getHeight();
        }
        if (ip == null) {
            return iImgPlus;
        }
        return ip;
    }

    public String getCurrentImageName() {
        return String.valueOf(cZipTifFilePath) + "/" + cTifPrefix + this.iAceTree.makeImageName();
    }

    public static ImagePlus makeImage2(String s, int iplane, int ustack) {
        cCurrentImageFile = s;
        ImagePlus ip = null;
        imagewindowPlaneNumber = iplane;
        imagewindowUseStack = ustack;
        switch (cUseZip) {
            case 0: 
            case 3: {
                ip = ImageWindow.doMakeImageFromTif(s);
                break;
            }
            case 1: {
                ip = ImageWindow.doMakeImageFromZip(s);
                break;
            }
            default: {
                ip = ImageWindow.doMakeImageFromZip2(s);
            }
        }
        if (ip != null) {
            cImageWidth = ip.getWidth();
            cImageHeight = ip.getHeight();
        }
        if (ip == null) {
            return iImgPlus;
        }
        return ip;
    }

    public static ImagePlus doMakeImageFromZip(String s) {
        ImagePlus ip;
        ZipEntry ze;
        if (cZipImage == null) {
            cZipImage = new ZipImage(cZipTifFilePath);
        }
        if ((ze = cZipImage.getZipEntry(s)) == null) {
            ip = new ImagePlus();
            ColorProcessor iproc = new ColorProcessor(cImageWidth, cImageHeight);
            ip.setProcessor(s, (ImageProcessor)iproc);
        } else {
            ip = cZipImage.readData(ze);
        }
        return ip;
    }

    public static ImagePlus doMakeImageFromZip2(String s) {
        ImagePlus ip;
        cZipImage = new ZipImage(String.valueOf(cZipTifFilePath) + "/" + s);
        int k1 = s.indexOf("/") + 1;
        String ss = s.substring(k1);
        int k2 = ss.indexOf(".");
        ss = ss.substring(0, k2);
        ZipEntry ze = null;
        if (cZipImage != null) {
            ze = cZipImage.getZipEntry(String.valueOf(ss) + ".tif");
        }
        if (ze == null) {
            ip = new ImagePlus();
            ColorProcessor iproc = new ColorProcessor(cImageWidth, cImageHeight);
            ip.setProcessor(s, (ImageProcessor)iproc);
        } else {
            ip = cZipImage.readData(ze);
        }
        ColorProcessor iprocColor = (ColorProcessor)ip.getProcessor();
        int[] all = (int[])iprocColor.getPixels();
        byte[] R = new byte[all.length];
        byte[] G = new byte[all.length];
        byte[] B = new byte[all.length];
        iprocColor.getRGB(R, G, B);
        iRpix = R;
        iGpix = G;
        iBpix = B;
        return ip;
    }

    private static void showError(String fileName) {
        new Throwable().printStackTrace();
        String message = "Exiting: cannot find image\n";
        message = String.valueOf(message) + fileName;
        JOptionPane pane = new JOptionPane(message);
        JDialog dialog = pane.createDialog(null, "Error");
        dialog.setVisible(true);
    }

    public static ImagePlus doMakeImageFromTif(String s) {
        if (cUseZip == 3) {
            s = s.replaceAll("tif", "jpg");
        }
        cCurrentImagePart = s;
        ImagePlus ip = null;
        String ss = String.valueOf(cZipTifFilePath) + "/" + s;
        if (imagewindowUseStack == 1) {
            try {
                ip = new Opener().openImage(ss, imagewindowPlaneNumber);
            }
            catch (IllegalArgumentException iae) {
                System.out.println("Exception in ImageWindow.doMakeImageFromTif(String)");
                System.out.println("TIFF file required.");
            }
        } else {
            ip = new Opener().openImage(ss);
        }
        if (ip != null) {
            cImageWidth = ip.getWidth();
            cImageHeight = ip.getHeight();
            ip = ImageWindow.convertToRGB(ip);
        } else {
            ip = new ImagePlus();
            ColorProcessor iproc = new ColorProcessor(cImageWidth, cImageHeight);
            ip.setProcessor(s, (ImageProcessor)iproc);
        }
        return ip;
    }

    public static ImagePlus readData(FileInputStream fis, boolean bogus) {
        if (fis == null) {
            return null;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buf = new byte[4096];
        try {
            int byteCount;
            FileInputStream is = fis;
            byte[] data = new byte[2048];
            while ((byteCount = ((InputStream)is).read(data, 0, 2048)) != -1) {
                out.write(data, 0, byteCount);
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return ImageWindow.openTiff(new ByteArrayInputStream(out.toByteArray()), true);
    }

    public static ImagePlus readData(FileInputStream fis) {
        if (fis == null) {
            return null;
        }
        byte[] ba = ImageWindow.readByteArray(fis);
        return ImageWindow.openTiff(new ByteArrayInputStream(ba), true);
    }

    public static byte[] readByteArray(FileInputStream fis) {
        if (fis == null) {
            return null;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buf = new byte[4096];
        try {
            int byteCount;
            FileInputStream is = fis;
            byte[] data = new byte[2048];
            while ((byteCount = ((InputStream)is).read(data, 0, 2048)) != -1) {
                out.write(data, 0, byteCount);
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return out.toByteArray();
    }

    public static ImagePlus openTiff(InputStream in, boolean convertToRGB) {
        if (in == null) {
            return null;
        }
        FileInfo[] info = null;
        try {
            TiffDecoder td = new TiffDecoder(in, null);
            info = td.getTiffInfo();
        }
        catch (FileNotFoundException e) {
            IJ.error((String)"TiffDecoder", (String)("File not found: " + e.getMessage()));
            return null;
        }
        catch (Exception e) {
            IJ.error((String)"TiffDecoder", (String)("" + e));
            return null;
        }
        ImagePlus imp = null;
        if (IJ.debugMode) {
            IJ.log((String)info[0].info);
        }
        FileOpener fo = new FileOpener(info[0]);
        imp = fo.open(false);
        return imp;
    }

    public static ImagePlus splitImage(ImagePlus ip, int channel) {
        ImageProcessor iproc = ip.getProcessor();
        iproc.flipHorizontal();
        if (channel == 2) {
            iproc.setRoi(new Rectangle(ip.getWidth() / 2, 0, ip.getWidth() / 2, ip.getHeight()));
        } else {
            iproc.setRoi(new Rectangle(0, 0, ip.getWidth() / 2, ip.getHeight()));
        }
        ImageProcessor cropped = iproc.crop();
        ip.setProcessor(cropped);
        return ip;
    }

    private static ImagePlus convertToRGB(ImagePlus ip) {
        if (imagewindowUseStack == 1) {
            FileInfo fi = new FileInfo();
            fi = ip.getFileInfo();
            ImageProcessor iproc = ip.getProcessor();
            iproc.flipHorizontal();
            int pixelCount = iproc.getPixelCount();
            int ipwidth = iproc.getWidth();
            int ipheight = iproc.getHeight();
            if (cSplitChannelImage == 1) {
                pixelCount /= 2;
                ipwidth /= 2;
            }
            byte[] G = new byte[pixelCount];
            byte[] R = new byte[pixelCount];
            byte[] B = new byte[pixelCount];
            ColorProcessor iproc3 = new ColorProcessor(ipwidth, ipheight);
            if (cSplitChannelImage == 1) {
                iproc.setRoi(new Rectangle(ip.getWidth() / 2, 0, ip.getWidth() / 2, ip.getHeight()));
                ImageProcessor croppedR = iproc.crop();
                ImagePlus croppedIPR = new ImagePlus(ip.getTitle(), croppedR);
                iproc.setRoi(new Rectangle(0, 0, ip.getWidth() / 2, ip.getHeight()));
                ImageProcessor croppedG = iproc.crop();
                ImagePlus croppedIPG = new ImagePlus(ip.getTitle(), croppedG);
                if (setOriginalContrastValues) {
                    int ipminred = (int)croppedIPR.getDisplayRangeMin();
                    int ipmaxred = (int)croppedIPR.getDisplayRangeMax();
                    System.out.println("ImageWindow set Red min, max from image: " + ipminred + CS + ipmaxred);
                    contrastmin1 = ipminred;
                    contrastmax1 = ipmaxred;
                    int ipmingre = (int)croppedIPG.getDisplayRangeMin();
                    int ipmaxgre = (int)croppedIPG.getDisplayRangeMax();
                    System.out.println("ImageWindow set Green min, max from image: " + ipmingre + CS + ipmaxgre);
                    contrastmin2 = ipmingre;
                    contrastmax2 = ipmaxgre;
                    setOriginalContrastValues = false;
                }
                croppedIPR.setDisplayRange((double)contrastmin1, (double)contrastmax1);
                croppedIPG.setDisplayRange((double)contrastmin2, (double)contrastmax2);
                ImageConverter ic1 = new ImageConverter(croppedIPR);
                ImageConverter ic2 = new ImageConverter(croppedIPG);
                ic1.convertToGray8();
                ic2.convertToGray8();
                ImageProcessor convertedR = croppedIPR.getProcessor();
                ImageProcessor convertedG = croppedIPG.getProcessor();
                R = (byte[])convertedR.getPixels();
                G = (byte[])convertedG.getPixels();
            } else {
                if (setOriginalContrastValues) {
                    int ipmingre = (int)ip.getDisplayRangeMin();
                    int ipmaxgre = (int)ip.getDisplayRangeMax();
                    System.out.println("ImageWindow set Green min, max from image: " + ipmingre + CS + ipmaxgre);
                    contrastmin2 = ipmingre;
                    contrastmax2 = ipmaxgre;
                    setOriginalContrastValues = false;
                }
                ip.setDisplayRange((double)contrastmin2, (double)contrastmax2);
                ImageConverter ic = new ImageConverter(ip);
                ic.convertToGray8();
                ImageProcessor converted = ip.getProcessor();
                G = (byte[])converted.getPixels();
            }
            iRpix = R;
            iGpix = G;
            iBpix = B;
            iproc3.setRGB(iRpix, iGpix, iBpix);
            ip.setProcessor("test", (ImageProcessor)iproc3);
            return ip;
        }
        FileInfo fi = new FileInfo();
        fi = ip.getFileInfo();
        if (fi.getBytesPerPixel() != 8) {
            ImageConverter ic = new ImageConverter(ip);
            ic.convertToGray8();
        }
        ImageProcessor iproc = ip.getProcessor();
        byte[] bpix = (byte[])iproc.getPixels();
        byte[] R = new byte[bpix.length];
        byte[] G = new byte[bpix.length];
        byte[] B = new byte[bpix.length];
        ColorProcessor iproc3 = new ColorProcessor(iproc.getWidth(), iproc.getHeight());
        iproc3.getRGB(R, G, B);
        G = bpix;
        R = ImageWindow.getRedChannel(R);
        iRpix = R;
        iGpix = G;
        iBpix = B;
        return ImageWindow.buildImagePlus(ip);
    }

    private static ImagePlus buildImagePlus(ImagePlus ip) {
        ImageProcessor iproc = ip.getProcessor();
        ColorProcessor iproc3 = new ColorProcessor(iproc.getWidth(), iproc.getHeight());
        iproc3.setRGB(iRpix, iGpix, iBpix);
        ip.setProcessor("test", (ImageProcessor)iproc3);
        return ip;
    }

    protected static ImagePlus makeRedImagePlus(ImagePlus ip) {
        ImageProcessor iproc = ip.getProcessor();
        ColorProcessor iproc3 = new ColorProcessor(iproc.getWidth(), iproc.getHeight());
        iproc3.setRGB(iRpix, new byte[iRpix.length], new byte[iRpix.length]);
        ip.setProcessor("test", (ImageProcessor)iproc3);
        return ip;
    }

    protected static ImagePlus makeGreenImagePlus(ImagePlus ip) {
        ImageProcessor iproc = ip.getProcessor();
        ColorProcessor iproc3 = new ColorProcessor(iproc.getWidth(), iproc.getHeight());
        iproc3.setRGB(new byte[iRpix.length], iGpix, new byte[iRpix.length]);
        ip.setProcessor("test", (ImageProcessor)iproc3);
        return ip;
    }

    protected static ImagePlus makePlainImagePlus(ImagePlus ip) {
        ImageProcessor iproc = ip.getProcessor();
        ColorProcessor iproc3 = new ColorProcessor(iproc.getWidth(), iproc.getHeight());
        if (cAcbTree) {
            iproc3.setRGB(iRpix, iRpix, iRpix);
        } else {
            iproc3.setRGB(new byte[iRpix.length], new byte[iRpix.length], new byte[iRpix.length]);
        }
        ip.setProcessor("test", (ImageProcessor)iproc3);
        return ip;
    }

    private static byte[] getRedChannel(byte[] R) {
        String fileName = ImageWindow.makeRedChannelName();
        File f = new File(fileName);
        if (f.exists()) {
            ImagePlus ip = null;
            ip = imagewindowUseStack == 1 ? new Opener().openImage(fileName, imagewindowPlaneNumber) : new Opener().openImage(fileName);
            FileInfo fi = new FileInfo();
            fi = ip.getFileInfo();
            if (fi.getBytesPerPixel() != 8) {
                ImageConverter ic = new ImageConverter(ip);
                ic.convertToGray8();
            }
            if (ip != null) {
                ByteProcessor bproc = (ByteProcessor)ip.getProcessor();
                R = (byte[])bproc.getPixels();
            } else {
                System.out.println("getRedChannel, Opener returned null ip");
            }
        }
        return R;
    }

    private static String makeRedChannelName() {
        String s = cCurrentImageFile;
        String ss = cCurrentImagePart;
        ss = ss.substring(3);
        s = String.valueOf(cZipTifFilePath) + "/" + "/tifR/" + ss;
        if (cUseZip == 3) {
            s = String.valueOf(cZipTifFilePath) + "/" + "/jpgR/" + ss;
        }
        return s;
    }

    public ImageWindow() {
    }

    public ImageWindow(String title, ImagePlus imgPlus, boolean test) {
        super(title);
        ImageCanvas ic;
        this.iTitle = title;
        iImgPlus = imgPlus;
        this.iImgCanvas = ic = new ImageCanvas(imgPlus);
        this.getContentPane().add((Component)ic);
        this.pack();
        this.setVisible(true);
        this.setDefaultCloseOperation(3);
    }

    public ColorSchemeDisplayProperty[] getDisplayProps() {
        ColorSchemeDisplayProperty[] dispProps = new ColorSchemeDisplayProperty[]{new ColorSchemeDisplayProperty("normal centroid", 1), new ColorSchemeDisplayProperty("selected centroid", 8), new ColorSchemeDisplayProperty("annotations", 8), new ColorSchemeDisplayProperty("upper sister", 4), new ColorSchemeDisplayProperty("lower sister", 5), new ColorSchemeDisplayProperty("line size", 0), new ColorSchemeDisplayProperty("nucleus marker", 0), new ColorSchemeDisplayProperty("bookmarked centroid", 1)};
        return dispProps;
    }

    private int getLineageNumber(String name) {
        int num = iDispProps.length;
        int i = 0;
        while (i < iDispProps.length) {
            if (name.indexOf(ImageWindow.iDispProps[i].iName) >= 0) {
                num = ImageWindow.iDispProps[i].iLineageNum;
                break;
            }
            ++i;
        }
        return num;
    }

    protected JMenuBar createMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        JMenu menu = null;
        JMenuItem test = null;
        menu = new JMenu("dummy");
        menuBar.add(menu);
        test = new JMenuItem("dummy");
        menu.add(test);
        return menuBar;
    }

    public void setAceTree(AceTree aceTree) {
        this.iAceTree = aceTree;
    }

    public AceTree getAceTree() {
        return this.iAceTree;
    }

    public ImagePlus refreshDisplay(String imageName) {
        BufferedImage image;
        int k;
        if (imageName == null) {
            imageName = this.iTitle;
        } else {
            if (imageName.indexOf(cTifPrefix) == -1) {
                imageName = String.valueOf(cTifPrefix) + imageName;
            }
            this.iTitle = imageName;
            this.setTitle(imageName.substring(4, imageName.length()));
        }
        if (this.iIsMainImgWindow) {
            this.iTimeInc = this.iAceTree.getTimeInc();
            this.iPlaneInc = this.iAceTree.getPlaneInc();
            this.iImageTime = this.iAceTree.getImageTime();
            this.iImagePlane = this.iAceTree.getImagePlane();
            imagewindowPlaneNumber = this.iAceTree.getImagePlane() + this.iPlaneInc;
        } else {
            this.iTimeInc = 0;
            this.iPlaneInc = 0;
            this.setImageTimeAndPlaneFromTitle();
        }
        imagewindowUseStack = this.iAceTree.getUseStack();
        if (imagewindowUseStack == 1) {
            this.setTitle(String.valueOf(imageName.substring(4, imageName.length())) + " (plane " + imagewindowPlaneNumber + ")");
        }
        String random = RANDOMT;
        if (cUseZip > 0) {
            random = RANDOMF;
        }
        if ((k = imageName.indexOf(random)) > -1) {
            imageName = imageName.substring(0, k + random.length() - 1);
        }
        ImagePlus ip = null;
        this.currentImage = ip = ImageWindow.makeImage(imageName);
        if (ip == null) {
            this.iAceTree.pausePlayerControl();
            System.out.println("no ImagePlus for: " + this.iTitle);
        }
        if (this.iAceTree == null) {
            return null;
        }
        switch (this.iAceTree.getColor()) {
            case 1: {
                ip = ImageWindow.makeGreenImagePlus(ip);
                break;
            }
            case 2: {
                ip = ImageWindow.makeRedImagePlus(ip);
                break;
            }
            case 3: {
                ip = ImageWindow.makePlainImagePlus(ip);
            }
        }
        if (ip != null && imagewindowUseStack != 1) {
            ip.setDisplayRange((double)contrastmin1, (double)contrastmax1, 4);
            ip.setDisplayRange((double)contrastmin2, (double)contrastmax2, 2);
        }
        if (ip != null) {
            iImgPlus.setProcessor(imageName, ip.getProcessor());
        }
        if (this.iIsMainImgWindow && this.iAceTree.isTracking()) {
            this.iAceTree.addMainAnnotation();
        }
        if (this.iAceTree.getShowCentroids()) {
            this.showCentroids();
        }
        if (this.iAceTree.getShowAnnotations()) {
            this.showAnnotations();
        }
        if (iSpecialEffect != null) {
            this.showSpecialEffect();
        }
        this.iImgCanvas.repaint();
        if (this.iImageZoomerPanel != null) {
            image = BufferedImageCreator.create((ColorProcessor)((ColorProcessor)iImgPlus.getProcessor()));
            this.iImageZoomerPanel.updateImage(image);
        }
        if (this.iImageZoomerFrame != null) {
            image = BufferedImageCreator.create((ColorProcessor)((ColorProcessor)iImgPlus.getProcessor()));
            this.iImageZoomerFrame.updateImage(image);
        }
        return iImgPlus;
    }

    @Override
    public void keyPressed(KeyEvent e) {
        boolean ctrl;
        int code = e.getKeyCode();
        int mods = e.getModifiers();
        boolean shift = (mods & 1) == 1;
        boolean bl = ctrl = (mods & 2) == 2;
        if (shift || ctrl) {
            this.sendToEIDialog2(code, shift, ctrl);
        } else {
            switch (code) {
                case 38: {
                    this.iAceTree.actionPerformed(new ActionEvent(this, 0, "Up Z"));
                    break;
                }
                case 40: {
                    this.iAceTree.actionPerformed(new ActionEvent(this, 0, "Down Z"));
                    break;
                }
                case 37: {
                    this.iAceTree.actionPerformed(new ActionEvent(this, 0, "Prev"));
                    break;
                }
                case 39: {
                    this.iAceTree.actionPerformed(new ActionEvent(this, 0, "Next"));
                    break;
                }
                case 113: {
                    this.iAceTree.actionPerformed(new ActionEvent(this, 0, "F2"));
                    break;
                }
                default: {
                    return;
                }
            }
        }
    }

    private void sendToEIDialog2(int keycode, boolean alt, boolean ctrl) {
        ImageWindow.println("sendToEIDialog2, ");
        Object a = null;
        switch (keycode) {
            case 38: {
                this.iAceTree.actionPerformed(new ActionEvent(this, 0, "Up Z"));
                break;
            }
            case 40: {
                this.iAceTree.actionPerformed(new ActionEvent(this, 0, "Down Z"));
                break;
            }
            case 37: {
                AddOneDialog addOne = this.iAceTree.iAddOneDialog;
                if (addOne == null) break;
                addOne.actionPerformed(new ActionEvent(this, 0, "LEFT"));
                break;
            }
            case 39: {
                this.iAceTree.actionPerformed(new ActionEvent(this, 0, "Next"));
                break;
            }
            case 113: {
                this.iAceTree.actionPerformed(new ActionEvent(this, 0, "F2"));
                break;
            }
            default: {
                return;
            }
        }
    }

    public void quickRefresh() {
        this.iImgCanvas.repaint();
    }

    public void setSpecialEffect(Object[] specialEffect) {
        iSpecialEffect = specialEffect;
    }

    protected void showSpecialEffect() {
        if (!this.iAceTree.isTracking()) {
            return;
        }
        int x1 = (Integer)iSpecialEffect[0];
        int y1 = (Integer)iSpecialEffect[1];
        int z1 = (Integer)iSpecialEffect[2];
        int x2 = (Integer)iSpecialEffect[3];
        int y2 = (Integer)iSpecialEffect[4];
        int r2 = (Integer)iSpecialEffect[5];
        int z2 = (Integer)iSpecialEffect[6];
        String s = (String)iSpecialEffect[7];
        int offset = r2 + 4;
        if (y2 < y1) {
            offset = -offset;
        }
        ImageProcessor iproc = this.getImagePlus().getProcessor();
        iproc.setColor(COLOR[ImageWindow.iDispProps[4].iLineageNum]);
        if (z2 <= z1) {
            iproc.setColor(COLOR[ImageWindow.iDispProps[3].iLineageNum]);
        }
        iproc.setLineWidth(cLineWidth);
        iproc.drawLine(x1, y1, x2, y2);
        iproc.drawPolygon(EUtils.pCircle(x2, y2, r2));
        iproc.drawString("    " + s + "(" + z2 + ")", x2, y2 + offset);
    }

    private void redrawMe() {
        this.iImgCanvas.repaint();
    }

    protected void setImageTimeAndPlaneFromTitle() {
        int k = this.iTitle.lastIndexOf(DASHT) + DASHT.length();
        if (k <= 1) {
            this.iImageTime = 1;
            this.iImagePlane = 15;
            this.iTimeInc = 0;
            this.iPlaneInc = 0;
            String random = RANDOMT;
            if (cUseZip > 0) {
                random = RANDOMF;
            }
            this.iIsMainImgWindow = this.iTitle.indexOf(random) == -1;
            return;
        }
        System.out.println("setImage..: " + k);
        String time = this.iTitle.substring(k, k + 3);
        this.iImageTime = Integer.parseInt(time);
        String s = this.iTitle.substring(k);
        k = s.indexOf(DASHP) + DASHP.length();
        String plane = s.substring(k, k + 2);
        this.iImagePlane = Integer.parseInt(plane);
        this.iTimeInc = 0;
        this.iPlaneInc = 0;
        String random = RANDOMT;
        if (cUseZip > 0) {
            random = RANDOMF;
        }
        this.iIsMainImgWindow = this.iTitle.indexOf(random) == -1;
    }

    public ImageCanvas getCanvas() {
        return this.iImgCanvas;
    }

    public ImagePlus getImagePlus() {
        return iImgPlus;
    }

    public void addAnnotation(int mx, int my, boolean dontRemove) {
        if (this.iIsMainImgWindow) {
            this.iTimeInc = this.iAceTree.getTimeInc();
            this.iImageTime = this.iAceTree.getImageTime();
            this.iPlaneInc = this.iAceTree.getPlaneInc();
        } else {
            this.iTimeInc = 0;
            this.iPlaneInc = 0;
        }
        Nucleus n = cNucleiMgr.findClosestNucleus(mx, my, this.iImagePlane + this.iPlaneInc, this.iImageTime + this.iTimeInc);
        if (cNucleiMgr.hasCircle(n, this.iImagePlane + this.iPlaneInc)) {
            String propername = PartsList.lookupSulston(n.identity);
            String label = n.identity;
            if (propername != null) {
                label = String.valueOf(label) + " " + propername;
            }
            AnnotInfo ai = new AnnotInfo(label, n.x, n.y);
            boolean itemRemoved = false;
            boolean itemAlreadyPresent = false;
            String test = label;
            AnnotInfo aiTest = null;
            int k = 0;
            while (k < this.iAnnotsShown.size()) {
                aiTest = (AnnotInfo)this.iAnnotsShown.elementAt(k);
                if (aiTest.iName.equals(test)) {
                    itemAlreadyPresent = true;
                    if (dontRemove) break;
                    this.iAnnotsShown.remove(k);
                    itemRemoved = true;
                    break;
                }
                ++k;
            }
            if (!itemRemoved && !itemAlreadyPresent) {
                this.iAnnotsShown.add(ai);
            }
            if (this.iIsRightMouseButton && this.iIsMainImgWindow) {
                this.iIsRightMouseButton = false;
            }
        }
    }

    protected void showCentroids() {
        int time = this.iImageTime + this.iTimeInc;
        if (time < 0) {
            this.iImageTime = 1;
            this.iTimeInc = 0;
        }
        Vector v = cNucleiMgr.getElementAt(this.iImageTime + this.iTimeInc - 1);
        ImageProcessor iproc = this.getImagePlus().getProcessor();
        iproc.setColor(COLOR[ImageWindow.iDispProps[0].iLineageNum]);
        iproc.setLineWidth(WIDTHS[ImageWindow.iDispProps[5].iLineageNum]);
        Object p = null;
        Enumeration e = v.elements();
        Cell currentCell = this.iAceTree.getCurrentCell();
        while (e.hasMoreElements()) {
            String name;
            double x;
            Nucleus n = (Nucleus)e.nextElement();
            if (n.status < 0 || !((x = cNucleiMgr.nucDiameter(n, this.iImagePlane + this.iPlaneInc)) > 0.0)) continue;
            if (this.iBookmarkListModel != null && !this.iBookmarkListModel.isEmpty() && this.iBookmarkListModel.contains(name = n.identity)) {
                iproc.setColor(COLOR[ImageWindow.iDispProps[7].iLineageNum]);
            }
            if (currentCell != null && n.hashKey != null && n.hashKey.equals(currentCell.getHashKey()) && this.iAceTree.isTracking()) {
                iproc.setColor(COLOR[ImageWindow.iDispProps[1].iLineageNum]);
            }
            int TOGGLE_OPTION = 6;
            if (ImageWindow.iDispProps[TOGGLE_OPTION].iLineageNum == 0) {
                iproc.drawPolygon(EUtils.pCircle(n.x, n.y, (int)(x / 2.0)));
            } else {
                iproc.drawDot(n.x, n.y);
            }
            iproc.setColor(COLOR[ImageWindow.iDispProps[0].iLineageNum]);
        }
    }

    private void drawRoi(int plane, Nucleus c, ImageProcessor iproc) {
        double d = cNucleiMgr.nucDiameter(c, plane);
        float fxx = c.x;
        float fyy = c.y;
        fxx = (float)((double)fxx - d / 2.0);
        fyy = (float)((double)fyy - d / 2.0);
        int xx = (int)((double)fxx + 0.5);
        int yy = (int)((double)fyy + 0.5);
        int dd = (int)(d + 0.5);
        OvalRoi oRoi = new OvalRoi(xx, yy, dd, dd);
        iproc.setColor(new Color(0, 0, 255));
        oRoi.drawPixels(iproc);
        Rectangle r = oRoi.getBounds();
        int width = iproc.getWidth();
        int y = r.y;
        while (y < r.y + r.height) {
            int offset = y * width;
            int x = r.x;
            while (x <= r.x + r.width) {
                int i = offset + x;
                if (oRoi.contains(x, y)) {
                    int k = iproc.getPixel(x, y);
                    int n = k & 0xFF00FF00;
                }
                ++x;
            }
            ++y;
        }
    }

    protected void showAnnotations() {
        Vector v = (Vector)cNucleiMgr.getNucleiRecord().elementAt(this.iImageTime + this.iTimeInc - 1);
        int size = v.size();
        int[] x = new int[size];
        int[] y = new int[size];
        Vector<AnnotInfo> annots = new Vector<AnnotInfo>();
        Enumeration e = v.elements();
        while (e.hasMoreElements()) {
            AnnotInfo ai = null;
            Nucleus n = (Nucleus)e.nextElement();
            String propername = PartsList.lookupSulston(n.identity);
            String label = n.identity;
            if (propername != null) {
                label = String.valueOf(label) + " " + propername;
            }
            if (n.status < 0 || this.isInList(label) == null) continue;
            ai = new AnnotInfo(label, n.x, n.y);
            if (!cNucleiMgr.hasCircle(n, this.iImagePlane + this.iPlaneInc)) continue;
            annots.add(ai);
        }
        this.drawStrings(annots, this);
    }

    private void drawStrings(Vector annots, ImageWindow imgWin) {
        ImagePlus imgPlus = imgWin.getImagePlus();
        ImageProcessor imgProc = imgPlus.getProcessor();
        ImageCanvas imgCan = imgWin.getCanvas();
        imgProc.setColor(COLOR[ImageWindow.iDispProps[2].iLineageNum]);
        imgProc.setFont(new Font("SansSerif", 1, 13));
        Enumeration e = annots.elements();
        while (e.hasMoreElements()) {
            AnnotInfo ai = (AnnotInfo)e.nextElement();
            imgProc.moveTo(imgCan.offScreenX(ai.iX), imgCan.offScreenY(ai.iY));
            String name = ai.iName;
            int i = name.indexOf(" ");
            if (i > 0) {
                name = name.substring(i + 1, name.length());
            }
            imgProc.drawString(name);
        }
        imgPlus.updateAndDraw();
    }

    private void showWhichAnnotations() {
        int i = 0;
        while (i < this.iAnnotsShown.size()) {
            System.out.println((AnnotInfo)this.iAnnotsShown.elementAt(i));
            ++i;
        }
    }

    public void updateCurrentCellAnnotation(Cell newCell, Cell old, int time) {
        AnnotInfo ai = null;
        if (old != null) {
            ai = this.isInList(old.getName());
        }
        if (ai != null) {
            this.iAnnotsShown.remove(ai);
        }
        if (time == -1) {
            time = newCell.getTime();
        }
        String s = newCell.getHashKey();
        Nucleus n = null;
        if (s != null) {
            n = cNucleiMgr.getNucleusFromHashkey(newCell.getHashKey(), time);
        }
        if (n != null && this.isInList(newCell.getName()) == null) {
            ai = new AnnotInfo(newCell.getName(), n.x, n.y);
            this.iAnnotsShown.add(ai);
        }
    }

    public void clearAnnotations() {
        this.iAnnotsShown.clear();
    }

    public void addAnnotation(String name, int x, int y) {
        AnnotInfo ai = new AnnotInfo(name, x, y);
        this.iAnnotsShown.add(ai);
    }

    protected AnnotInfo isInList(String name) {
        AnnotInfo aiFound = null;
        Enumeration e = this.iAnnotsShown.elements();
        while (e.hasMoreElements()) {
            AnnotInfo ai = (AnnotInfo)e.nextElement();
            boolean is = ai.iName.equals(name);
            if (!is) continue;
            aiFound = ai;
            break;
        }
        return aiFound;
    }

    public void saveImageIfEnabled() {
        if (this.iSaveImage) {
            while (this.iSaveInProcess) {
            }
            new Thread(this).start();
        }
    }

    @Override
    public void run() {
        this.iSaveInProcess = true;
        int k = 1000;
        if (this.iNewConstruction) {
            k = 5000;
            this.iNewConstruction = false;
        }
        try {
            Thread.sleep(k);
        }
        catch (InterruptedException ie) {
            ie.printStackTrace();
        }
        this.saveImage();
    }

    void saveJpeg(BufferedImage bi, String outFileName, int quality) {
        Iterator<ImageWriter> iter = ImageIO.getImageWritersByFormatName("jpeg");
        ImageWriter writer = iter.next();
        ImageWriteParam iwp = writer.getDefaultWriteParam();
        iwp.setCompressionMode(2);
        iwp.setCompressionQuality(1.0f);
        File file = new File(outFileName);
        if (file.exists()) {
            file.delete();
        }
        file = new File(outFileName);
        try {
            FileImageOutputStream output = new FileImageOutputStream(file);
            writer.setOutput(output);
            IIOImage image = new IIOImage(bi, null, null);
            writer.write(null, image, iwp);
            writer.dispose();
            output.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void zoomView() {
        String title = "zoom";
        BufferedImage image = BufferedImageCreator.create((ColorProcessor)((ColorProcessor)iImgPlus.getProcessor()));
        ImageZoomerFrame izf = new ImageZoomerFrame(this, image, 10.0, title);
        izf.addKeyListener(this);
        this.iImageZoomerFrame = izf;
    }

    public void saveImage() {
        String title = this.makeTitle();
        if (title == null) {
            this.cancelSaveOperations();
            return;
        }
        Rectangle screenRect = this.getBounds();
        int topAdjust = 23;
        int y = screenRect.y;
        screenRect.y += topAdjust;
        int height = screenRect.height;
        screenRect.height -= topAdjust;
        Robot robot = null;
        BufferedImage image = null;
        if (this.iUseRobot) {
            try {
                robot = new Robot();
            }
            catch (AWTException e) {
                ImageWindow.println("EXCEPTION -- NO ROBOT -- NOT SAVING");
                this.iSaveInProcess = false;
                this.iSaveImage = false;
                this.iAceTree.iAceMenuBar.resetSaveState();
                return;
            }
            image = robot.createScreenCapture(screenRect);
        } else {
            image = BufferedImageCreator.create((ColorProcessor)((ColorProcessor)iImgPlus.getProcessor()));
        }
        this.saveJpeg(image, title, 20);
        System.out.println("file: " + title + " written");
        this.iSaveInProcess = false;
    }

    public void cancelSaveOperations() {
        ImageWindow.println("WARNING: NO IMAGE SAVE PATH -- NOT SAVING!");
        this.iSaveInProcess = false;
        this.iSaveImage = false;
        this.iAceTree.iAceMenuBar.resetSaveState();
    }

    public String getSaveImageDirectory() {
        if (this.iSaveImageDirectory != null) {
            return this.iSaveImageDirectory;
        }
        try {
            Class.forName("net.sf.ij.jaiio.BufferedImageCreator");
        }
        catch (ClassNotFoundException e) {
            this.iUseRobot = true;
            ImageWindow.println("USING ROBOT FOR IMAGE2D SAVING");
        }
        try {
            JFileChooser fc = new JFileChooser("");
            fc.setDialogTitle("Save images to: ");
            fc.setFileSelectionMode(1);
            int returnVal = fc.showOpenDialog(null);
            String path = null;
            if (returnVal == 0) {
                this.iSaveImageDirectory = path = fc.getSelectedFile().getPath();
                System.out.println("Saving images to: " + path);
                return path;
            }
            System.out.println("Save cancelled by user.");
            return null;
        }
        catch (Exception e) {
            System.out.println("Failed to get save image directory.");
            e.printStackTrace();
            return null;
        }
    }

    private String makeTitle() {
        if (this.iSaveImageDirectory == null) {
            String dir;
            this.iSaveImageDirectory = dir = this.getSaveImageDirectory();
            if (dir == null) {
                return null;
            }
        }
        String s = this.iTitle;
        int j = s.lastIndexOf("/") + 1;
        int k = s.lastIndexOf(".");
        s = String.valueOf(s.substring(j, k)) + ".jpeg";
        s = String.valueOf(this.iSaveImageDirectory) + "/" + s;
        return s;
    }

    public void setSaveImageState(boolean saveIt) {
        this.iSaveImage = saveIt;
    }

    public Object[] getSpecialEffect() {
        return iSpecialEffect;
    }

    private String getClickedCellName(int x, int y) {
        int timeInc = 0;
        int planeInc = 0;
        if (this.iIsMainImgWindow) {
            timeInc = this.iAceTree.getTimeInc();
            planeInc = this.iAceTree.getPlaneInc();
        }
        String name = "";
        Nucleus n = cNucleiMgr.findClosestNucleus(x, y, this.iImageTime + this.iTimeInc);
        if (cNucleiMgr.hasCircle(n, this.iImagePlane + this.iPlaneInc)) {
            name = n.identity;
        }
        return name;
    }

    private static void println(String s) {
        System.out.println(s);
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    public void launchImageParamsDialog() {
        new ImageParamsDialog(this);
    }

    public void launchContrastTool() {
        if (this.ict == null) {
            this.ict = new ImageContrastTool(this, imagewindowUseStack);
            this.iSlider1min = this.ict.getSlider1min();
            this.iSlider1max = this.ict.getSlider1max();
            this.iSlider2min = this.ict.getSlider2min();
            this.iSlider2max = this.ict.getSlider2max();
            this.ict.setSlider1min(contrastmin1);
            this.ict.setSlider1max(contrastmax1);
            this.ict.setSlider2min(contrastmin2);
            this.ict.setSlider2max(contrastmax2);
            SliderListener sl = new SliderListener();
            this.iSlider1min.addChangeListener(sl);
            this.iSlider1max.addChangeListener(sl);
            this.iSlider2min.addChangeListener(sl);
            this.iSlider2max.addChangeListener(sl);
        } else {
            this.ict.setSlider1min(contrastmin1);
            this.ict.setSlider1max(contrastmax1);
            this.ict.setSlider2min(contrastmin2);
            this.ict.setSlider2max(contrastmax2);
            this.ict.setVisible(true);
        }
    }

    public void updateCellAnnotation(Cell newCell, String oldName, int time) {
        AnnotInfo ai = this.isInList(oldName);
        if (ai != null) {
            this.iAnnotsShown.remove(ai);
            Nucleus n = cNucleiMgr.getNucleusFromHashkey(newCell.getHashKey(), time);
            String name = newCell.getName();
            if (this.isInList(name) == null) {
                int space = name.indexOf(" ");
                if (space >= 0) {
                    name = name.substring(space + 1, name.length());
                }
                ai = new AnnotInfo(name, n.x, n.y);
                this.iAnnotsShown.add(ai);
            }
        }
    }

    public void processEditMouseEvent(MouseEvent e) {
        if (this.iDialog == null & this.iDialog2 == null) {
            return;
        }
        if (this.iDialog2 != null) {
            UnifiedNucRelinkDialog relink = (UnifiedNucRelinkDialog)this.iDialog2;
            relink.processMouseEvent(e);
        }
        if (this.iDialog != null) {
            AddOneDialog addOne = (AddOneDialog)this.iDialog;
            addOne.processMouseEvent(e);
        }
    }

    public static void setUseStack(int x) {
        imagewindowUseStack = x;
    }

    public class ColorSchemeDisplayProperty {
        public String iName;
        public int iLineageNum;

        public ColorSchemeDisplayProperty(String name, int lineageNum) {
            this.iName = name;
            this.iLineageNum = lineageNum;
        }
    }

    public class ColorSchemeUI {
        public JPanel iPanel;
        public JTextField iTF;
        public JComboBox iCB;
        public JLabel iLabel;
        private String[] COLORS = new String[]{"red", "blue", "green", "yellow", "cyan", "magenta", "pink", "gray", "white"};
        private String[] SHAPES = new String[]{"circle", "dot"};
        private String[] SIZES = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10"};

        public ColorSchemeUI(int i) {
            this.iPanel = new JPanel();
            this.iPanel.setLayout(new GridLayout(1, 2));
            this.iTF = new JTextField(ImageWindow.iDispProps[i].iName, 1);
            this.iLabel = new JLabel(ImageWindow.iDispProps[i].iName);
            String[] list = this.COLORS;
            if (i == 5) {
                list = this.SIZES;
            }
            if (i == 6) {
                list = this.SHAPES;
            }
            this.iCB = new JComboBox<String>(list);
            this.iCB.setSelectedIndex(ImageWindow.iDispProps[i].iLineageNum);
            this.iPanel.add(this.iLabel);
            this.iPanel.add(this.iCB);
            this.iPanel.setMaximumSize(new Dimension(200, 10));
        }
    }

    class MouseHandler
    extends MouseInputAdapter {
        ImageWindow iw;

        public MouseHandler(ImageWindow iw) {
            this.iw = iw;
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            int x = e.getX();
            int y = e.getY();
            int x2 = ImageWindow.this.iImageZoomerPanel.transform(x);
            int y2 = ImageWindow.this.iImageZoomerPanel.transform(y);
            MouseEvent e2 = new MouseEvent(this.iw, 0, 0L, 0, x2, y2, 0, false, e.getButton());
            try {
                ImageWindow.this.iAceTree.mouseMoved(e2);
            }
            catch (NullPointerException npe) {
                return;
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            int x = e.getX();
            int y = e.getY();
            int x2 = ImageWindow.this.iImageZoomerPanel.transform(x);
            int y2 = ImageWindow.this.iImageZoomerPanel.transform(y);
            int button = e.getButton();
            ImageWindow.this.iIsRightMouseButton = button == 3 | e.isControlDown();
            if (button == 3 | e.isControlDown()) {
                Nucleus n = cNucleiMgr.findClosestNucleus(x2, y2, ImageWindow.this.iImagePlane + ImageWindow.this.iPlaneInc, ImageWindow.this.iImageTime + ImageWindow.this.iTimeInc);
                if (n == null) {
                    return;
                }
                Cell c = ImageWindow.this.iAceTree.getCellByName(n.identity);
                if (c != null) {
                    ImageWindow.this.iAceTree.setCurrentCell(c, ImageWindow.this.iImageTime + ImageWindow.this.iTimeInc, 3);
                }
            } else if (button == 1) {
                ImageWindow.this.addAnnotation(x2, y2, false);
                ImageWindow.this.refreshDisplay(null);
            }
            ImageWindow.this.iAceTree.cellAnnotated(ImageWindow.this.getClickedCellName(x2, y2));
            ImageWindow.this.iAceTree.updateDisplay();
            MouseEvent e2 = new MouseEvent(this.iw, 0, 0L, 0, x2, y2, 0, false, e.getButton());
            ImageWindow.this.processEditMouseEvent(e2);
        }
    }

    public class PropertiesTab
    implements ActionListener {
        JPanel iPanel;
        ColorSchemeUI[] iCSUI;
        private String[] COLORS = new String[]{"red", "blue", "green", "yellow", "cyan", "magenta", "pink", "gray", "white"};
        private String[] SIZES = new String[]{"1", "2", "3"};
        private static final int WIDTH = 15;

        public PropertiesTab() {
            Border blackline = BorderFactory.createLineBorder(Color.black);
            iDispProps = ImageWindow.this.getDisplayProps();
            this.iCSUI = new ColorSchemeUI[iDispProps.length];
            this.iPanel = new JPanel();
            this.iPanel.setLayout(new BorderLayout());
            this.iPanel.setBorder(blackline);
            JPanel lineagePanel = new JPanel();
            JPanel dummyPanel = new JPanel();
            JPanel topPart = new JPanel();
            topPart.setLayout(new GridLayout(1, 2));
            lineagePanel.setLayout(new GridLayout(0, 1));
            lineagePanel.setBorder(blackline);
            topPart.add(lineagePanel);
            topPart.add(dummyPanel);
            JPanel[] testPanel = new JPanel[iDispProps.length];
            JPanel labelPanel = new JPanel();
            JLabel sublineage = new JLabel("item");
            JLabel color = new JLabel("color");
            labelPanel.setLayout(new GridLayout(1, 2));
            labelPanel.add(sublineage);
            labelPanel.add(color);
            lineagePanel.add(labelPanel);
            int i = 0;
            while (i < iDispProps.length) {
                this.iCSUI[i] = new ColorSchemeUI(i);
                lineagePanel.add(this.iCSUI[i].iPanel);
                ++i;
            }
            lineagePanel.setMaximumSize(new Dimension(200, 200));
            this.iPanel.add((Component)topPart, "North");
            JPanel buttonPanel = new JPanel();
            buttonPanel.setLayout(new GridLayout(1, 3));
            JButton reset = new JButton("Reset");
            JButton apply = new JButton("Apply");
            JButton cancel = new JButton("Cancel");
            buttonPanel.add(apply);
            reset.addActionListener(this);
            apply.addActionListener(this);
            cancel.addActionListener(this);
            buttonPanel.add(reset);
            buttonPanel.add(apply);
            buttonPanel.add(cancel);
            JPanel botPart = new JPanel();
            botPart.setLayout(new GridLayout(5, 1));
            botPart.add(new JPanel());
            botPart.add(buttonPanel);
            botPart.add(new JPanel());
            botPart.add(new JPanel());
            botPart.add(new JPanel());
            this.iPanel.add((Component)botPart, "Center");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            block4: {
                String command;
                block3: {
                    command = e.getActionCommand();
                    if (!command.equals("Reset")) break block3;
                    iDispProps = ImageWindow.this.getDisplayProps();
                    int i = 0;
                    while (i < iDispProps.length) {
                        this.iCSUI[i].iLabel.setText(ImageWindow.iDispProps[i].iName);
                        this.iCSUI[i].iCB.setSelectedIndex(ImageWindow.iDispProps[i].iLineageNum);
                        ++i;
                    }
                    break block4;
                }
                if (!command.equals("Apply")) break block4;
                int i = 0;
                while (i < iDispProps.length) {
                    String name = this.iCSUI[i].iTF.getText();
                    if (name.length() == 0) {
                        name = "-";
                    }
                    int num = this.iCSUI[i].iCB.getSelectedIndex();
                    ImageWindow.iDispProps[i].iName = name;
                    ImageWindow.iDispProps[i].iLineageNum = num;
                    ++i;
                }
            }
        }

        public JPanel getPanel() {
            return this.iPanel;
        }
    }

    public class SliderListener
    implements ChangeListener {
        @Override
        public void stateChanged(ChangeEvent e) {
            JSlider source = (JSlider)e.getSource();
            if (!source.getValueIsAdjusting()) {
                int max2;
                int min2;
                int max1;
                int min1 = ImageWindow.this.iSlider1min.getValue();
                if (min1 <= (max1 = ImageWindow.this.iSlider1max.getValue())) {
                    contrastmin1 = min1;
                    contrastmax1 = max1;
                }
                if ((min2 = ImageWindow.this.iSlider2min.getValue()) <= (max2 = ImageWindow.this.iSlider2max.getValue())) {
                    contrastmin2 = min2;
                    contrastmax2 = max2;
                }
                ImageWindow.this.refreshDisplay(null);
            }
        }
    }

    private class WinEventMgr
    extends WindowAdapter {
        private WinEventMgr() {
        }

        @Override
        public void windowGainedFocus(WindowEvent e) {
            ImageWindow.this.iAceTree.requestFocus();
        }

        @Override
        public void windowClosing(WindowEvent e) {
            if (ImageWindow.this.iIsMainImgWindow) {
                ImageWindow.this.dispose();
            }
        }
    }
}

