/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.image;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.text.DecimalFormat;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.rhwlab.acetree.PlayerControl;
import org.rhwlab.image.ImageWindow;

public class ImageZoomerPanel
extends JPanel
implements ActionListener {
    private ImagePanel m_imagePanel;
    private JScrollPane m_srollPane;
    private JPanel m_imageContainer;
    private JLabel m_zoomedInfo;
    private JButton m_zoomInButton;
    private JButton m_zoomOutButton;
    private JButton m_originalButton;
    private Cursor m_zoomCursor;
    ImageWindow iImgWin;
    private static final String CS = ", ";
    private static final String C = ",";
    private static final String TAB = "\t";
    private static final DecimalFormat DF0 = new DecimalFormat("####");
    private static final DecimalFormat DF1 = new DecimalFormat("####.#");
    private static final DecimalFormat DF4 = new DecimalFormat("####.####");

    public ImageZoomerPanel(ImageWindow imgWin, Image image, double zoomPercentage, String imageName, PlayerControl playercontrol) {
        this.iImgWin = imgWin;
        if (image == null) {
            this.add(new JLabel("Image " + imageName + " not Found"));
        } else {
            JPanel topPanel = new JPanel(new FlowLayout(1));
            this.m_zoomInButton = playercontrol.getiZoomPlus();
            this.m_zoomInButton.addActionListener(this);
            this.m_zoomOutButton = playercontrol.getiZoomMinus();
            this.m_zoomOutButton.addActionListener(this);
            this.m_originalButton = playercontrol.getiZoomEqual();
            this.m_originalButton.addActionListener(this);
            this.m_zoomedInfo = playercontrol.getiZoomLabel();
            this.m_imagePanel = new ImagePanel(image, zoomPercentage);
            this.m_imagePanel.addKeyListener(this.iImgWin);
            this.m_imageContainer = new JPanel(new FlowLayout(1));
            this.m_imageContainer.setBackground(Color.BLACK);
            this.m_imageContainer.add(this.m_imagePanel);
            this.m_srollPane = new JScrollPane(this.m_imageContainer);
            this.m_srollPane.setAutoscrolls(true);
            this.setLayout(new BorderLayout());
            this.add("South", topPanel);
            this.add("Center", this.m_srollPane);
            this.m_imagePanel.repaint();
        }
        this.setVisible(true);
    }

    public void updateImage(Image img) {
        this.m_imagePanel.updateImage(img);
        this.m_imagePanel.repaint();
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        if (ae.getSource().equals(this.m_zoomInButton)) {
            this.m_imagePanel.zoomIn();
            this.adjustLayout();
        } else if (ae.getSource().equals(this.m_zoomOutButton)) {
            this.m_imagePanel.zoomOut();
            this.adjustLayout();
        } else if (ae.getSource().equals(this.m_originalButton)) {
            this.m_imagePanel.originalSize();
            this.adjustLayout();
        }
    }

    public void setZoomCursorImage(Image zoomcursorImage) {
        this.m_zoomCursor = Toolkit.getDefaultToolkit().createCustomCursor(zoomcursorImage, new Point(0, 0), "ZoomCursor");
    }

    public int transform(int position) {
        return (int)Math.round((double)position * 100.0 / this.m_imagePanel.getZoomedTo());
    }

    private void adjustLayout() {
        this.m_imageContainer.doLayout();
        this.m_srollPane.doLayout();
        this.m_zoomedInfo.setText(String.valueOf((int)this.m_imagePanel.getZoomedTo()) + "%");
    }

    void getPositionData(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        int x2 = (int)Math.round((double)x * 100.0 / this.m_imagePanel.getZoomedTo());
        int y2 = (int)Math.round((double)y * 100.0 / this.m_imagePanel.getZoomedTo());
        MouseEvent e2 = new MouseEvent(this.iImgWin, 0, 0L, 0, x2, y2, 0, false, e.getButton());
        this.iImgWin.getMouseHandler().mouseClicked(e2);
    }

    public JPanel getImage() {
        return this.m_imagePanel;
    }

    private static void println(String s) {
        System.out.println(s);
    }

    private static void print(String s) {
        System.out.print(s);
    }

    private static String fmt4(double d) {
        return DF4.format(d);
    }

    private static String fmt1(double d) {
        return DF1.format(d);
    }

    private static String fmt0(double d) {
        return DF0.format(d);
    }

    public class ImagePanel
    extends JPanel {
        private double m_zoom = 1.0;
        private double m_zoomPercentage;
        private Image m_image;

        public ImagePanel(Image image, double zoomPercentage) {
            this.m_image = image;
            this.m_zoomPercentage = zoomPercentage / 100.0;
        }

        public void updateImage(Image img) {
            this.m_image = img;
        }

        @Override
        public void paintComponent(Graphics grp) {
            Graphics2D g2D = (Graphics2D)grp;
            g2D.setColor(Color.WHITE);
            g2D.fillRect(0, 0, this.getWidth(), this.getHeight());
            g2D.scale(this.m_zoom, this.m_zoom);
            g2D.drawImage(this.m_image, 0, 0, this);
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension((int)((double)this.m_image.getWidth(this) + (double)this.m_image.getWidth(this) * (this.m_zoom - 1.0)), (int)((double)this.m_image.getHeight(this) + (double)this.m_image.getHeight(this) * (this.m_zoom - 1.0)));
        }

        public void setZoomPercentage(int zoomPercentage) {
            this.m_zoomPercentage = (double)zoomPercentage / 100.0;
        }

        public void originalSize() {
            this.m_zoom = 1.0;
        }

        public void zoomIn() {
            this.m_zoom += this.m_zoomPercentage;
        }

        public void zoomOut() {
            this.m_zoom -= this.m_zoomPercentage;
            if (this.m_zoom < this.m_zoomPercentage) {
                if (this.m_zoomPercentage > 1.0) {
                    this.m_zoom = 1.0;
                } else {
                    this.zoomIn();
                }
            }
        }

        public double getZoomedTo() {
            return this.m_zoom * 100.0;
        }
    }
}

