/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.image;

import ij.ImagePlus;
import ij.gui.ImageCanvas;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;
import java.awt.Component;
import java.awt.Container;
import java.awt.Rectangle;
import java.text.DecimalFormat;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class VistaTest2
extends JFrame {
    static byte[] iRpix;
    static byte[] iGpix;
    static byte[] iBpix;
    String iTitle;
    ImagePlus iImgPlus;
    ImageCanvas iImgCanvas;
    private static final String CS = ", ";
    private static final DecimalFormat DF0;
    private static final DecimalFormat DF1;
    private static final DecimalFormat DF4;

    static {
        DF0 = new DecimalFormat("####");
        DF1 = new DecimalFormat("####.#");
        DF4 = new DecimalFormat("####.####");
    }

    public VistaTest2(String title, ImagePlus iplus) {
        super(title);
        ImageCanvas ic;
        this.iTitle = title;
        this.iImgPlus = iplus;
        this.iImgCanvas = ic = new ImageCanvas(iplus);
        Container c = this.getContentPane();
        JPanel jp = new JPanel();
        jp.add((Component)ic);
        c.add(jp);
        this.pack();
        this.setVisible(true);
        this.setDefaultCloseOperation(3);
    }

    public static ImagePlus makeImage(String s) {
        ImagePlus ip = null;
        ip = VistaTest2.doMakeImageFromTif(s);
        return ip;
    }

    public static ImagePlus doMakeImageFromTif(String s) {
        ImagePlus ip = VistaTest2.readData();
        ip = VistaTest2.convertToRGB(ip);
        return ip;
    }

    private static ImagePlus convertToRGB(ImagePlus ip) {
        ImageProcessor iproc = ip.getProcessor();
        byte[] bpix = (byte[])iproc.getPixels();
        byte[] R = new byte[bpix.length];
        byte[] G = new byte[bpix.length];
        byte[] B = new byte[bpix.length];
        ColorProcessor iproc3 = new ColorProcessor(iproc.getWidth(), iproc.getHeight());
        iproc3.getRGB(R, G, B);
        G = bpix;
        R = VistaTest2.getRedChannel(R);
        iRpix = R;
        iGpix = G;
        iBpix = B;
        return VistaTest2.buildImagePlus(ip);
    }

    private static ImagePlus buildImagePlus(ImagePlus ip) {
        ImageProcessor iproc = ip.getProcessor();
        ColorProcessor iproc3 = new ColorProcessor(iproc.getWidth(), iproc.getHeight());
        iproc3.setRGB(iRpix, iGpix, iBpix);
        ip.setProcessor("test", (ImageProcessor)iproc3);
        return ip;
    }

    private static ImagePlus readData() {
        return VistaTest2.openTiff();
    }

    private static ImagePlus openTiff() {
        ByteProcessor iprocG = new ByteProcessor(200, 200);
        Rectangle rectG = new Rectangle(50, 70, 50, 50);
        iprocG.setRoi(rectG);
        iprocG.setValue(128.0);
        iprocG.fill();
        ImagePlus iplus = new ImagePlus("vistaTest", (ImageProcessor)iprocG);
        return iplus;
    }

    private static byte[] getRedChannel(byte[] R) {
        ByteProcessor iprocR = new ByteProcessor(200, 200);
        Rectangle rectR = new Rectangle(70, 90, 50, 50);
        iprocR.setRoi(rectR);
        iprocR.setValue(128.0);
        iprocR.fill();
        R = (byte[])iprocR.getPixels();
        return R;
    }

    public static void main(String[] args) {
        VistaTest2.println("VistaTest2.main, ");
        ImagePlus ip = VistaTest2.makeImage("");
        new VistaTest2("vistaTest2, ", ip);
    }

    private static void println(String s) {
        System.out.println(s);
    }

    private static void print(String s) {
        System.out.print(s);
    }

    private static String fmt1(double d) {
        return DF1.format(d);
    }

    private static String fmt0(double d) {
        return DF1.format(d);
    }
}

