/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.nucedit;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.tree.TreeNode;
import org.rhwlab.acetree.AceTree;
import org.rhwlab.acetree.NucUtils;
import org.rhwlab.image.ImageWindow;
import org.rhwlab.snight.NucleiMgr;
import org.rhwlab.snight.Nucleus;
import org.rhwlab.tree.AncesTree;
import org.rhwlab.tree.Cell;
import org.rhwlab.tree.CellData;

public class DeathsAdjacencies
extends JDialog
implements ActionListener,
ListSelectionListener,
Comparator {
    AceTree iAceTree;
    AncesTree iAncesTree;
    NucleiMgr iNucleiMgr;
    Vector nuclei_record;
    Cell iRoot;
    Hashtable iCellsByName;
    private JFrame iFrame;
    protected JToolBar iToolBar;
    protected JMenuBar iMenuBar;
    private String iTitle = "Deaths and Adjacencies";
    private JTextField iTextField;
    private JList iCellList;
    private DefaultListModel iListModel;
    private boolean iNamesAvailable;
    private JScrollPane iScrollPane;
    private JComboBox iCombo;
    private int iTime;
    private Font iFont;
    private String iCellName;
    private int iTest;
    private static final double TOL = 0.7;
    private static final double FACTOR = 0.5;
    String[] shelp = new String[]{"# maxTime field accepts forms like 200:ABalaa", "# if the colon and cell are there then output will be filtered to that", "# and its decendents", "# Deaths: makes a queryable list of cell deaths", "# Adjacent backward: makes two queryable lists showing nearby cells at this ane previous time.", "#A djacent forward: makes a queryable list of cells near current cell at next time"};
    private static final String CLEAR = "Clear";
    private static final String LINE = "                                        ";
    private static final String ANGLE = "Angle";
    private static final String TEST1 = "Deaths";
    private static final String TEST2 = "Adj back";
    private static final String TEST3 = "Adj forward";
    private static final String TEST4 = "Jumps";
    private static final String TEST5 = "Test5";
    private static final String HELP = "Help";
    private static final String CS = ", ";
    private static final DecimalFormat DF2 = new DecimalFormat("###.##");

    public DeathsAdjacencies() {
        this.setTitle(this.iTitle);
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 3));
        this.setContentPane(p);
        this.iToolBar = new JToolBar("");
        this.iToolBar.setLayout(new GridLayout(1, 0));
        p.add(this.iToolBar);
        this.buildOutToolBar();
        this.buildList();
        this.iCellList.setVisibleRowCount(10);
        p.add(this.iScrollPane);
        this.initialize();
        this.setVisible(true);
        this.pack();
        this.help();
    }

    private void test1() {
        this.iNamesAvailable = false;
        this.iTest = 1;
        int t1 = this.iNucleiMgr.getConfig().iStartingIndex;
        int t2 = this.iNucleiMgr.getConfig().iEndingIndex;
        String[] sa = this.iTextField.getText().split(":");
        int maxTime = Integer.parseInt(sa[0]);
        String filter = "";
        if (sa.length > 1) {
            filter = sa[1];
        }
        t2 = maxTime;
        ImageWindow imgWin = this.iAceTree.getImageWindow();
        this.iListModel.clear();
        this.iListModel.addElement("#list shows cells that died and the time");
        int i = t1;
        while (i < t2) {
            Vector nuclei = (Vector)this.nuclei_record.get(i - 1);
            int j = 0;
            while (j < nuclei.size()) {
                Nucleus n = (Nucleus)nuclei.get(j);
                if (n.status >= 1 && n.successor1 < 0 && n.successor2 < 0) {
                    StringBuffer sb = new StringBuffer();
                    sb.append(n.identity);
                    sb.append(CS + i);
                    if (sb.toString().indexOf(filter) == 0) {
                        this.iListModel.addElement(sb.toString());
                    }
                }
                ++j;
            }
            ++i;
        }
        this.iNamesAvailable = true;
    }

    private void test3() {
        this.iNamesAvailable = false;
        this.iTest = 3;
        this.iCellName = this.iAceTree.getCurrentCell().getName();
        this.iTime = this.iAceTree.getImageTime() + this.iAceTree.getTimeInc();
        Vector nuclei = (Vector)this.nuclei_record.get(this.iTime - 1);
        Vector nuclei2 = (Vector)this.nuclei_record.get(this.iTime);
        Nucleus nn = NucUtils.getCurrentCellData(nuclei, this.iCellName);
        double zPixRes = this.iNucleiMgr.getZPixRes();
        int x = nn.x;
        int y = nn.y;
        int z = (int)(zPixRes * (double)nn.z);
        Vector<D> v = new Vector<D>();
        int k = 0;
        int i = 0;
        while (i < nuclei2.size()) {
            Nucleus n = (Nucleus)nuclei2.get(i);
            if (n.identity.length() > 0) {
                ++k;
                int zz = (int)(zPixRes * (double)n.z);
                int dx = n.x - x;
                int dy = n.y - y;
                int dz = zz - z;
                int d2 = dx * dx + dy * dy + dz * dz;
                d2 = (int)Math.round(Math.sqrt(d2));
                D u = new D(n.identity, d2, n.x, n.y, n.z, n, k, this.iTime + 1);
                v.add(u);
            }
            ++i;
        }
        Collections.sort(v, new D());
        ImageWindow imgWin = this.iAceTree.getImageWindow();
        imgWin.clearAnnotations();
        this.iListModel.clear();
        this.iListModel.addElement("#list shows cells at time " + (this.iTime + 1) + " near " + this.iCellName + " at time " + this.iTime);
        int u = Math.min(v.size(), 10);
        int i2 = 0;
        while (i2 < u) {
            D dd = (D)v.get(i2);
            imgWin.addAnnotation(dd.id, dd.x, dd.y);
            StringBuffer sb = new StringBuffer();
            sb.append(dd.id);
            sb.append(CS + dd.d);
            sb.append(CS + (this.iTime + 1));
            this.iListModel.addElement(sb.toString());
            ++i2;
        }
        imgWin.refreshDisplay(null);
        this.iNamesAvailable = true;
    }

    private void test2() {
        int d2;
        int dz;
        int dy;
        int dx;
        int zz;
        Nucleus n;
        this.iTest = 2;
        this.iNamesAvailable = false;
        this.iCellName = this.iAceTree.getCurrentCell().getName();
        this.iTime = this.iAceTree.getImageTime() + this.iAceTree.getTimeInc();
        Vector nuclei = (Vector)this.nuclei_record.get(this.iTime - 1);
        Vector nuclei2 = null;
        if (this.iTime > 1) {
            nuclei2 = (Vector)this.nuclei_record.get(this.iTime - 2);
        }
        double zPixRes = this.iNucleiMgr.getZPixRes();
        Nucleus nn = NucUtils.getCurrentCellData(nuclei, this.iCellName);
        int x1 = nn.x;
        int y1 = nn.y;
        int z1 = (int)(zPixRes * (double)nn.z);
        Vector<D> v = new Vector<D>();
        Vector<D> v2 = new Vector<D>();
        int k = 0;
        D u = null;
        int i = 0;
        while (i < nuclei.size()) {
            n = (Nucleus)nuclei.get(i);
            if (n.identity.length() > 0) {
                ++k;
                zz = (int)(zPixRes * (double)n.z);
                dx = n.x - x1;
                dy = n.y - y1;
                dz = zz - z1;
                d2 = dx * dx + dy * dy + dz * dz;
                d2 = (int)Math.round(Math.sqrt(d2));
                u = new D(n.identity, d2, n.x, n.y, n.z, n, k, this.iTime);
                v.add(u);
            }
            ++i;
        }
        if (nuclei2 != null) {
            i = 0;
            while (i < nuclei2.size()) {
                n = (Nucleus)nuclei2.get(i);
                if (n.identity.length() > 0) {
                    ++k;
                    zz = (int)(zPixRes * (double)n.z);
                    dx = n.x - x1;
                    dy = n.y - y1;
                    dz = zz - z1;
                    d2 = dx * dx + dy * dy + dz * dz;
                    d2 = (int)Math.round(Math.sqrt(d2));
                    u = new D(n.identity, d2, n.x, n.y, n.z, n, k, this.iTime - 1);
                    v2.add(u);
                }
                ++i;
            }
        }
        Collections.sort(v, new D());
        if (nuclei2 != null) {
            Collections.sort(v2, new D());
        }
        ImageWindow imgWin = this.iAceTree.getImageWindow();
        imgWin.clearAnnotations();
        this.iListModel.clear();
        this.iListModel.addElement("#list shows: index, name, distance, time, plane");
        this.iListModel.addElement("#nuclei at time " + this.iTime + " near " + this.iCellName + " at time " + this.iTime);
        this.addItems(v, imgWin);
        if (nuclei2 != null) {
            this.iListModel.addElement("#nuclei at time " + (this.iTime - 1) + " near " + this.iCellName + " at time " + this.iTime);
            this.addItems(v2, imgWin);
            imgWin.refreshDisplay(null);
        }
        this.iNamesAvailable = true;
    }

    private void test4() {
        this.iNamesAvailable = false;
        this.iTest = 1;
        this.iListModel.clear();
        this.iListModel.addElement("#list shows cells and jump as fraction of nuc diameter");
        this.iListModel.addElement("#list sorted in decreasing order of jump fraction");
        Vector<String> bigJumps = new Vector<String>();
        String[] sa = this.iTextField.getText().split(":");
        int maxTime = Integer.parseInt(sa[0]);
        String filter = "";
        if (sa.length > 1) {
            filter = sa[1];
        }
        int checkCount = 0;
        Cell P = (Cell)this.iCellsByName.get("P");
        Enumeration<TreeNode> e = P.children();
        while (e.hasMoreElements()) {
            Cell c = (Cell)e.nextElement();
            Enumeration<TreeNode> poe = c.preorderEnumeration();
            block1: while (poe.hasMoreElements()) {
                Cell cc = (Cell)poe.nextElement();
                int baseTime = cc.getTime();
                Vector v = cc.getCellData();
                int size = v.size();
                if (size <= 1) continue;
                Vector<Integer> jumps = new Vector<Integer>();
                int sizeSum = 0;
                String name = cc.getName();
                CellData cd0 = (CellData)v.get(0);
                sizeSum += cd0.iNucleus.size;
                int i = 1;
                while (i < size) {
                    CellData cd1 = (CellData)v.get(i);
                    jumps.add(new Integer(this.jump(cd0, cd1)));
                    sizeSum += cd1.iNucleus.size;
                    cd0 = cd1;
                    ++i;
                }
                int stdSize = sizeSum / size;
                int i2 = 0;
                while (i2 < jumps.size()) {
                    String s;
                    int time = baseTime + i2;
                    if (time > maxTime) continue block1;
                    double x = ((Integer)jumps.get(i2)).intValue();
                    double xf = x / (double)stdSize;
                    if (xf > 0.7 && !bigJumps.contains(s = String.valueOf(name) + CS + time + CS + DF2.format(xf))) {
                        bigJumps.add(s);
                        ++checkCount;
                    }
                    ++i2;
                }
            }
        }
        Collections.sort(bigJumps, this);
        int i = 0;
        while (i < bigJumps.size()) {
            String s = (String)bigJumps.get(i);
            if (s.indexOf(filter) == 0) {
                this.iListModel.addElement(s);
            }
            ++i;
        }
        this.iNamesAvailable = true;
    }

    private int jump(CellData cd0, CellData cd1) {
        double zPixRes = this.iNucleiMgr.getZPixRes();
        Nucleus n0 = cd0.iNucleus;
        Nucleus n1 = cd1.iNucleus;
        int x = n0.x;
        int y = n0.y;
        int z = (int)(zPixRes * (double)n0.z);
        int zz = (int)(zPixRes * (double)n1.z);
        int dx = n1.x - x;
        int dy = n1.y - y;
        int dz = zz - z;
        int d2 = dx * dx + dy * dy + dz * dz;
        d2 = (int)Math.round(Math.sqrt(d2));
        return d2;
    }

    public int compare(Object arg0, Object arg1) {
        double d1;
        int rtn = 1;
        String[] sa = ((String)arg0).split(CS);
        double d0 = Double.parseDouble(sa[2]);
        if (d0 > (d1 = Double.parseDouble((sa = ((String)arg1).split(CS))[2]))) {
            rtn = -1;
        }
        return rtn;
    }

    private void test4X() {
        DeathsAdjacencies.println("test4 clicked");
        this.iNamesAvailable = false;
        this.iTest = 4;
        this.iTime = this.iAceTree.getImageTime() + this.iAceTree.getTimeInc();
        double zPixRes = this.iNucleiMgr.getZPixRes();
        Vector nuclei = (Vector)this.nuclei_record.get(this.iTime - 1);
        int i = 0;
        while (i < nuclei.size()) {
            Nucleus n1 = (Nucleus)nuclei.get(i);
            if (n1.status > 0) {
                int margin = (int)Math.round((double)n1.size * 0.5);
                int j = 0;
                while (j < nuclei.size()) {
                    if (j != i) {
                        int zd;
                        int yd;
                        int xd;
                        Nucleus n2 = (Nucleus)nuclei.get(j);
                        if (n2.status > 0 && (xd = Math.abs(n1.x - n2.x)) <= margin && (yd = Math.abs(n1.y - n2.y)) <= margin && (zd = (int)Math.round(zPixRes * (double)Math.abs(n1.z - n2.z))) <= margin) {
                            int d = (int)Math.round(Math.sqrt(xd * xd + yd * yd + zd * zd));
                            StringBuffer sb = new StringBuffer();
                            sb.append(d);
                            sb.append(CS + n1.identity);
                            sb.append(CS + n2.identity);
                            sb.append(CS + n1.x + CS + n1.y + CS + n1.z);
                            sb.append(CS + n2.x + CS + n2.y + CS + n2.z);
                            this.iListModel.addElement(sb.toString());
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        this.iNamesAvailable = true;
    }

    private void addItems(Vector vv, ImageWindow imgWin) {
        int last = Math.min(vv.size(), 10);
        int i = 0;
        while (i < last) {
            D dd = (D)vv.get(i);
            imgWin.addAnnotation(dd.id, dd.x, dd.y);
            StringBuffer sb = new StringBuffer();
            sb.append(i);
            sb.append(CS + dd.id);
            sb.append(CS + dd.d);
            sb.append(CS + dd.time);
            sb.append(CS + dd.n.z);
            this.iListModel.addElement(sb.toString());
            ++i;
        }
    }

    private void help() {
        int i = 0;
        while (i < this.shelp.length) {
            this.iListModel.addElement(this.shelp[i]);
            ++i;
        }
    }

    private String getConfigFileInfo(String longName) {
        String s = longName.substring(longName.lastIndexOf(47) + 1);
        s = s.substring(0, s.indexOf(46));
        return s;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String s = e.getActionCommand();
        if (e.getSource() == this.iCombo) {
            String newSelection = (String)this.iCombo.getSelectedItem();
            this.iAceTree.restoreTree(newSelection);
        } else if (s.equals(TEST1)) {
            this.test1();
        } else if (s.equals(TEST2)) {
            this.test2();
        } else if (s.equals(TEST3)) {
            this.test3();
        } else if (s.equals(TEST4)) {
            this.test4();
        } else if (s.equals(HELP)) {
            this.help();
        } else if (s.equals(CLEAR)) {
            this.iNamesAvailable = false;
            this.iListModel.clear();
            this.help();
        }
    }

    private void buildOutToolBar() {
        this.iToolBar.setMaximumSize(new Dimension(700, 20));
        this.iToolBar.add(new JLabel("maxTime:"));
        this.iTextField = new JTextField();
        this.iTextField.setColumns(5);
        this.iTextField.setText("200");
        this.iToolBar.add(this.iTextField);
        JButton jb = null;
        jb = new JButton(CLEAR);
        this.addToolBarButton(jb);
        jb = new JButton(TEST1);
        this.addToolBarButton(jb);
        jb = new JButton(TEST4);
        this.addToolBarButton(jb);
        jb = new JButton(TEST2);
        this.addToolBarButton(jb);
        jb = new JButton(TEST3);
        this.addToolBarButton(jb);
    }

    protected void addToolBarButton(AbstractButton ab) {
        ab.addActionListener(this);
        this.iToolBar.add(ab);
    }

    protected void addComboBox(JComboBox jcb) {
        jcb.addActionListener(this);
        this.iToolBar.add(jcb);
    }

    private void buildList() {
        this.iListModel = new DefaultListModel();
        this.iCellList = new JList(this.iListModel);
        this.iCellList.setFont(new Font("courier", 0, 16));
        this.iCellList.setSelectionMode(0);
        this.iCellList.setSelectedIndex(0);
        this.iCellList.addListSelectionListener(this);
        this.iScrollPane = new JScrollPane(this.iCellList);
    }

    public void showMe() {
        this.iFrame.setTitle("Deaths and Adjacencies Dialog");
        this.iFrame.setDefaultCloseOperation(2);
        this.iFrame.setContentPane(this);
        this.iFrame.pack();
        this.iFrame.setVisible(true);
    }

    public void initialize() {
        this.iAceTree = AceTree.getAceTree(null);
        Hashtable h = this.iAceTree.iCellsByName;
        Cell P = (Cell)h.get("P");
        int k = P.getChildCount();
        DeathsAdjacencies.println("DeathsAndAdjacencies.initialize, " + k + CS + P.getName());
        this.iNucleiMgr = this.iAceTree.getNucleiMgr();
        this.nuclei_record = this.iNucleiMgr.getNucleiRecord();
        this.iAncesTree = this.iNucleiMgr.getAncesTree();
        this.iCellsByName = this.iAncesTree.getCellsByName();
        Cell PP = (Cell)this.iCellsByName.get("P");
        int kk = PP.getChildCount();
        DeathsAdjacencies.println("DeathsAndAdjacencies.initialize, " + kk + CS + PP.getName());
        this.iRoot = this.iAncesTree.getRoot();
        this.iRoot = this.iAceTree.getRoot();
    }

    private static void println(String s) {
        System.out.println(s);
    }

    public static void main(String[] args) {
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (!this.iNamesAvailable) {
            return;
        }
        if (!e.getValueIsAdjusting()) {
            int index = this.iCellList.getSelectedIndex();
            int k = Math.max(index, 1);
            String s = (String)this.iListModel.elementAt(k);
            if (s == null) {
                return;
            }
            if (s.charAt(0) == '#') {
                return;
            }
            String[] sa = s.split(CS);
            String name = "";
            if (this.iTest == 2) {
                name = sa[1];
                this.iTime = Integer.parseInt(sa[3]);
            } else if (this.iTest == 1) {
                name = sa[0];
                this.iTime = Integer.parseInt(sa[1]);
            } else if (this.iTest == 3) {
                name = sa[0];
                this.iTime = Integer.parseInt(sa[2]);
            } else if (this.iTest == 4) {
                name = sa[1];
            }
            this.bringUpImageWindow(name);
        }
    }

    private void bringUpImageWindow(String name) {
        Vector<String> v = new Vector<String>();
        v.add("InputCtrl1");
        v.add(String.valueOf(this.iTime));
        v.add(name);
        this.iAceTree.forceTrackingOn();
        this.iAceTree.controlCallback(v);
        this.iAceTree.setFocusHome();
    }

    class CellRenderer
    extends JLabel
    implements ListCellRenderer {
        CellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            String s = (String)value;
            this.setText(s);
            this.setFont(DeathsAdjacencies.this.iFont);
            if (DeathsAdjacencies.this.iCellName != null && s.indexOf(DeathsAdjacencies.this.iCellName) >= 0) {
                this.setFont(DeathsAdjacencies.this.iFont.deriveFont(1));
            }
            return this;
        }
    }

    private class D
    implements Comparator {
        String id;
        int d;
        int x;
        int y;
        float z;
        Nucleus n;
        int k;
        int time;

        public D() {
        }

        public D(String s, int dd, int xx, int yy, float zz, Nucleus nn, int kk, int t) {
            this.id = s;
            this.d = dd;
            this.x = xx;
            this.y = yy;
            this.z = zz;
            this.n = nn;
            this.k = kk;
            this.time = t;
        }

        public int compare(Object o1, Object o2) {
            D d1 = (D)o1;
            D d2 = (D)o2;
            int rtn = 0;
            if (d1.d < d2.d) {
                rtn = -1;
            } else if (d1.d > d2.d) {
                rtn = 1;
            }
            return rtn;
        }
    }
}

