/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.nucedit;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.tree.TreeNode;
import org.rhwlab.acetree.AceTree;
import org.rhwlab.snight.NucleiMgr;
import org.rhwlab.snight.Nucleus;
import org.rhwlab.tree.AncesTree;
import org.rhwlab.tree.Cell;

public class Juvenesence
extends JDialog
implements ActionListener,
ListSelectionListener {
    private JFrame iFrame;
    protected JToolBar iToolBar;
    private JTextField iTextField;
    AceTree iAceTree;
    AncesTree iAncesTree;
    NucleiMgr iNucleiMgr;
    Vector nuclei_record;
    Cell iRoot;
    Hashtable iCellsByName;
    Vector iSortedCellNames;
    int iLastTime;
    private JList iCellList;
    private DefaultListModel iListModel;
    private boolean iNamesAvailable;
    private JScrollPane iScrollPane;
    int iTime;
    String iTitle = "Juvenesence";
    private static double MINRATIO = 0.8;
    private static double MAXRATIO = 2.5;
    private static final String CS = ", ";
    private static final DecimalFormat DF2 = new DecimalFormat("###.##");
    private static final DecimalFormat DF000 = new DecimalFormat("000");

    public Juvenesence() {
        this.setTitle(this.iTitle);
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 3));
        this.setContentPane(p);
        this.iToolBar = new JToolBar("");
        this.iToolBar.setLayout(new GridLayout(1, 0));
        p.add(this.iToolBar);
        this.buildOutToolBar();
        this.buildList();
        this.iCellList.setVisibleRowCount(10);
        p.add(this.iScrollPane);
        this.initialize();
        this.setVisible(true);
        this.pack();
    }

    public void initialize() {
        this.iAceTree = AceTree.getAceTree(null);
        this.iNucleiMgr = this.iAceTree.getNucleiMgr();
        this.nuclei_record = this.iNucleiMgr.getNucleiRecord();
        this.iAncesTree = this.iNucleiMgr.getAncesTree();
        this.iCellsByName = this.iAncesTree.getCellsByName();
        this.iRoot = this.iAceTree.getRoot();
        this.makeSortedCellNames();
        this.iLastTime = this.estimate350CellStage();
    }

    public void lifetimesTest(double tolL, double tolH) {
        Cell c;
        String name;
        Juvenesence.println("lifetimesTest, " + tolL + CS + tolH);
        this.iLastTime = Integer.parseInt(this.iTextField.getText());
        Vector v = this.findQualifyingCellNames();
        AncesTree ances = this.iAncesTree;
        Enumeration<TreeNode> e = this.iRoot.breadthFirstEnumeration();
        Vector<String> base = new Vector<String>();
        while (e.hasMoreElements()) {
            Cell c2 = (Cell)e.nextElement();
            String name2 = c2.getName();
            if (!v.contains(name2)) continue;
            base.add(name2);
        }
        Hashtable<String, Double> lifetimesHash = new Hashtable<String, Double>();
        int i = base.size() - 1;
        while (i >= 0) {
            name = (String)base.get(i);
            if (name.equals("Cpppa")) {
                boolean bl = false;
            }
            if ((c = (Cell)this.iCellsByName.get(name)).getEndTime() < this.iLastTime) {
                double lifetime = c.getEndTime() - c.getTime() + 1;
                lifetimesHash.put(name, new Double(lifetime));
            }
            --i;
        }
        i = base.size() - 1;
        while (i >= 0) {
            String pname;
            Object obj;
            name = (String)base.get(i);
            c = (Cell)this.iCellsByName.get(name);
            Cell p = (Cell)c.getParent();
            if (p != null && (obj = lifetimesHash.get(pname = p.getName())) != null) {
                double lifetime;
                double ratio;
                double pLifetime = (Double)obj;
                obj = lifetimesHash.get(name);
                if (obj != null && ((ratio = (lifetime = ((Double)lifetimesHash.get(name)).doubleValue()) / pLifetime) < tolL || ratio > tolH)) {
                    String s = String.valueOf(name) + CS + c.getEndTime() + CS + Juvenesence.fmt4(ratio) + CS + Juvenesence.fmt4(lifetime) + CS + Juvenesence.fmt4(pLifetime);
                    Juvenesence.println(s);
                    this.iListModel.addElement(s);
                }
            }
            --i;
        }
        Juvenesence.println("lifetimesTest, exiting");
    }

    private Vector findQualifyingCellNames() {
        Vector<String> ans = new Vector<String>();
        int i = 0;
        while (i < this.iSortedCellNames.size()) {
            Cell c;
            String name = (String)this.iSortedCellNames.get(i);
            if (name.length() != 0 && (c = (Cell)this.iCellsByName.get(name)).getFateInt() == 1) {
                int endT;
                Cell cp = (Cell)c.getParent();
                if (cp == null) {
                    Juvenesence.println("$$$$$$$$$$$");
                    Juvenesence.println("##### findComparableCellNames, missing parent, " + name);
                    Juvenesence.println("***********");
                }
                if (cp.getFateInt() == 1 && (endT = c.getEndTime()) <= this.iLastTime) {
                    ans.add(name);
                }
            }
            ++i;
        }
        return ans;
    }

    private void makeSortedCellNames() {
        this.iSortedCellNames = new Vector();
        Enumeration e = this.iCellsByName.keys();
        boolean i = false;
        while (e.hasMoreElements()) {
            this.iSortedCellNames.add((String)e.nextElement());
        }
        Collections.sort(this.iSortedCellNames);
    }

    private int estimate350CellStage() {
        int stage = 355;
        boolean r = false;
        int size = 0;
        int time = 0;
        int i = 0;
        while (i < this.nuclei_record.size()) {
            Vector nuclei = (Vector)this.nuclei_record.get(i);
            int t = nuclei.size();
            if (t > size) {
                size = t;
                time = i;
            }
            int count = 0;
            if (size > stage) {
                count = 0;
                int j = 0;
                while (j < nuclei.size()) {
                    Nucleus n = (Nucleus)nuclei.get(j);
                    if (n.status > 0 && !n.identity.startsWith("N")) {
                        ++count;
                    }
                    ++j;
                }
            }
            if (count > stage) break;
            ++i;
        }
        return time + 1;
    }

    private void buildList() {
        this.iListModel = new DefaultListModel();
        this.iCellList = new JList(this.iListModel);
        this.iCellList.setFont(new Font("courier", 0, 16));
        this.iCellList.setSelectionMode(2);
        this.iCellList.setSelectedIndex(0);
        this.iCellList.addListSelectionListener(this);
        this.iCellList.setVisibleRowCount(5);
        this.iScrollPane = new JScrollPane(this.iCellList);
        this.iListModel.addElement(this.help());
    }

    private void buildOutToolBar() {
        this.iToolBar.setMaximumSize(new Dimension(700, 20));
        this.iToolBar.add(new JLabel("end"));
        this.iTextField = new JTextField();
        this.iTextField.setColumns(5);
        this.iTextField.setText(String.valueOf(this.iLastTime));
        this.iToolBar.add(this.iTextField);
        JButton jb = null;
        jb = new JButton("Clear");
        this.addToolBarButton(jb);
        jb = new JButton("Report");
        this.addToolBarButton(jb);
        jb = new JButton("SetParms");
        this.addToolBarButton(jb);
    }

    protected void addToolBarButton(AbstractButton ab) {
        ab.addActionListener(this);
        this.iToolBar.add(ab);
    }

    public void showMe() {
        this.iFrame.setDefaultCloseOperation(2);
        this.iFrame.setContentPane(this);
        this.iFrame.pack();
        this.iFrame.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String s = e.getActionCommand();
        if (s.equals("SetParms")) {
            this.setParms();
        } else if (s.equals("Report")) {
            this.iNamesAvailable = false;
            this.lifetimesTest(MINRATIO, MAXRATIO);
            this.iNamesAvailable = true;
        } else if (s.equals("Clear")) {
            this.iNamesAvailable = false;
            this.iListModel.clear();
            this.iListModel.addElement(this.help());
        }
    }

    private String help() {
        return "### dividing cell, time, ratio, lifetime, parent lifetime";
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (!this.iNamesAvailable) {
            return;
        }
        if (!e.getValueIsAdjusting()) {
            int index = this.iCellList.getSelectedIndex();
            int k = Math.max(index, 1);
            String s = (String)this.iListModel.elementAt(k);
            if (s == null) {
                return;
            }
            if (s.charAt(0) == '#') {
                return;
            }
            String[] sa = s.split(CS);
            String name = sa[0];
            this.iTime = Integer.parseInt(sa[1]);
            this.bringUpImageWindow(name);
        }
    }

    private void bringUpImageWindow(String name) {
        Vector<String> v = new Vector<String>();
        v.add("InputCtrl1");
        v.add(String.valueOf(this.iTime));
        v.add(name);
        this.iAceTree.forceTrackingOn();
        this.iAceTree.controlCallback(v);
        this.iAceTree.setFocusHome();
    }

    private void setParms() {
        Parms myDialog = new Parms(this.iFrame, true);
    }

    public static void main(String[] args) {
    }

    private static void println(String s) {
        System.out.println(s);
    }

    private static String fmt4(double d) {
        return new DecimalFormat("####.####").format(d);
    }

    private class Parms
    extends JDialog
    implements ActionListener {
        private JPanel iPanel;
        private JButton iOKButton;
        private JButton iCancelButton;
        private JTextField iMaxRatio;
        private JTextField iMinRatio;

        public Parms(JFrame frame, boolean modal) {
            super((Frame)frame, modal);
            this.iPanel = null;
            this.iOKButton = null;
            this.iCancelButton = null;
            this.iPanel = new JPanel();
            this.getContentPane().add(this.iPanel);
            this.iPanel.setLayout(new GridLayout(0, 1));
            this.iMinRatio = new JTextField(String.valueOf(MINRATIO));
            this.iMaxRatio = new JTextField(String.valueOf(MAXRATIO));
            this.iPanel.add(new JLabel("min ratio"));
            this.iPanel.add(this.iMinRatio);
            this.iPanel.add(new JLabel("max ratio"));
            this.iPanel.add(this.iMaxRatio);
            this.iOKButton = new JButton("OK");
            this.iOKButton.addActionListener(this);
            this.iPanel.add(this.iOKButton);
            this.iCancelButton = new JButton("Cancel");
            this.iCancelButton.addActionListener(this);
            this.iPanel.add(this.iCancelButton);
            this.pack();
            this.setLocationRelativeTo(frame);
            this.setVisible(true);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.iOKButton == e.getSource()) {
                MINRATIO = Double.parseDouble(this.iMinRatio.getText());
                MAXRATIO = Double.parseDouble(this.iMaxRatio.getText());
            }
            this.setVisible(false);
        }
    }
}

