/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.nucedit;

import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.text.DecimalFormat;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.rhwlab.acetree.AceTree;
import org.rhwlab.nucedit.EditLog;
import org.rhwlab.nucedit.GenericDialog;
import org.rhwlab.snight.Nucleus;
import org.rhwlab.tree.AncesTree;
import org.rhwlab.tree.Cell;

public class KillCellsDialog
extends GenericDialog {
    JTextField iCellToKill;
    JTextField iKillTime;
    JRadioButton iOneCell;
    JRadioButton iSeveralCells;
    JLabel iCellCount;
    JTextField iCellsToKill;
    Vector iCandidateCells;
    int iTime;
    String iCellName;
    EditLog iEditLog;
    int iNumCellsToEnd;
    JButton iUseAll;
    private static final int WIDTH = 200;
    private static final int HEIGHT = 225;
    private static final int MAX_KILLS = 999;
    public static final String TITLE = "Kill Cell";
    public static final String ONECELL = "one cell";
    public static final String SEVERAL = "several cells";
    public static final String KILLABLE = " are killable";
    public static final String CELLTOKILL = "Cell";
    public static final String KILLTIME = "Start Time";
    public static final String NUMBER = "End Time";
    public static final String SPACER = "     ";
    private static final String CS = ", ";
    private static final String TAB = "\t";
    private static final DecimalFormat DF0 = new DecimalFormat("####");
    private static final DecimalFormat DF1 = new DecimalFormat("####.#");
    private static final DecimalFormat DF4 = new DecimalFormat("####.####");

    public KillCellsDialog(AceTree aceTree, Frame owner, boolean modal, Cell cell, int time, EditLog editLog) {
        super(aceTree, owner, modal);
        int nmax;
        this.iCellName = cell != null ? cell.getName() : "";
        this.iEditLog = this.iNucleiMgr.getEditLog();
        this.iCandidateCells = new Vector();
        this.iTime = time;
        this.setTitle(TITLE);
        this.iContentPanel.setLayout(new BoxLayout(this.iContentPanel, 3));
        JPanel p = new JPanel();
        p.setLayout(new GridLayout(1, 0));
        JLabel test = new JLabel(CELLTOKILL);
        p.add(test);
        this.iCellToKill = new JTextField();
        this.iCellToKill.setColumns(12);
        this.iCellToKill.setText(this.iCellName);
        p.add(this.iCellToKill);
        this.iContentPanel.add(p);
        p = new JPanel();
        p.setLayout(new GridLayout(1, 0));
        test = new JLabel(KILLTIME);
        this.iKillTime = new JTextField();
        this.iKillTime.setColumns(12);
        this.iKillTime.setText(String.valueOf(time));
        p.add(test);
        p.add(this.iKillTime);
        this.iContentPanel.add(p);
        JPanel choices = new JPanel();
        choices.setLayout(new GridLayout(1, 0));
        Vector nuclei = (Vector)this.iNucleiMgr.getNucleiRecord().elementAt(this.iTime - 1);
        this.iCandidateCells = new Vector();
        this.iCandidateCells.add(nuclei);
        if (cell != null) {
            this.collectCandidateCells();
            nmax = this.iCandidateCells.size();
        } else {
            nmax = 0;
        }
        this.iNumCellsToEnd = nmax;
        this.iCellCount = new JLabel(NUMBER);
        choices.add(this.iCellCount);
        this.iCellsToKill = new JTextField();
        this.iCellsToKill.setColumns(12);
        this.iCellsToKill.setText(String.valueOf(time));
        choices.add(this.iCellsToKill);
        this.iUseAll = new JButton("Use All");
        this.iUseAll.setAlignmentX(0.5f);
        this.iUseAll.addActionListener(this);
        this.iContentPanel.add(choices);
        this.iContentPanel.add(this.iUseAll);
        this.pack();
        this.setVisible(true);
    }

    private void collectCandidateCells() {
        int k = this.iTime;
        int count = 1;
        boolean found = true;
        String name = this.iCellToKill.getText();
        Nucleus n = null;
        Vector nuclei = null;
        Vector nuclei_record = this.iNucleiMgr.getNucleiRecord();
        while (found && count < 999 && k < nuclei_record.size()) {
            nuclei = (Vector)nuclei_record.elementAt(k++);
            found = false;
            int j = 0;
            while (j < nuclei.size()) {
                n = (Nucleus)nuclei.elementAt(j);
                if (n.identity.equals(name)) {
                    if (n.status <= 0) break;
                    this.iCandidateCells.add(nuclei);
                    found = true;
                }
                ++j;
            }
            ++count;
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Hashtable h;
        this.iCellName = this.iCellToKill.getText();
        this.iTime = Integer.parseInt(this.iKillTime.getText());
        Vector nuclei = (Vector)this.iNucleiMgr.getNucleiRecord().elementAt(this.iTime - 1);
        this.iCandidateCells = new Vector();
        this.iCandidateCells.add(nuclei);
        this.collectCandidateCells();
        this.iNumCellsToEnd = this.iCandidateCells.size();
        System.out.println("Parsed successors for " + this.iCellName + "at time " + this.iTime + " found " + this.iNumCellsToEnd);
        if (this.iNucleiMgr.getCurrentCellData(this.iCellName, this.iTime) == null) {
            System.out.println("Attempt to delete nonexistent cell quitting");
            return;
        }
        Object o = e.getSource();
        if (o == this.iUseAll) {
            Integer xx2 = Integer.valueOf(this.iKillTime.getText());
            this.iCellsToKill.setText(String.valueOf(xx2 + this.iNumCellsToEnd - 1));
            return;
        }
        Integer xx = Integer.valueOf(this.iCellsToKill.getText());
        Integer xx2 = Integer.valueOf(this.iKillTime.getText());
        int k = xx - xx2 + 1;
        if (k == 0 || k > this.iNumCellsToEnd) {
            System.out.println("Out of range values provided for cell deletion");
            return;
        }
        String indexString = this.iNucleiMgr.getIndex(this.iCellName, this.iTime);
        this.iEditLog.appendx("KILLING " + this.iCellName + indexString + " at time " + this.iTime);
        if (k == 1) {
            this.iEditLog.append(".");
        } else {
            this.iEditLog.appendx(" and following ");
            if (k == 2) {
                this.iEditLog.append("time." + this.iNucleiMgr.getIndex(this.iCellName, this.iTime + 1));
            } else {
                int km = k - 1;
                String s = String.valueOf(km) + " times ";
                int i = 0;
                while (i < km) {
                    s = String.valueOf(s) + this.iNucleiMgr.getIndex(this.iCellName, this.iTime + i + 1);
                    ++i;
                }
                this.iEditLog.append(s);
            }
        }
        this.iNucleiMgr.makeBackupNucleiRecord();
        Nucleus predecessorNuc = null;
        if (this.iTime > 1) {
            Nucleus nc = this.iNucleiMgr.getCurrentCellData(this.iCellName, this.iTime);
            Vector predNuclei = (Vector)this.iNucleiMgr.getNucleiRecord().elementAt(this.iTime - 2);
            if (nc.predecessor > 0) {
                predecessorNuc = (Nucleus)predNuclei.elementAt(nc.predecessor - 1);
            }
        }
        int namingMethod = AceTree.getAceTree(null).getNucleiMgr().getIdentity().getNamingMethod();
        int i = 0;
        while (i < k) {
            nuclei = (Vector)this.iCandidateCells.elementAt(i);
            Nucleus n = null;
            int j = 0;
            while (j < nuclei.size()) {
                n = (Nucleus)nuclei.elementAt(j);
                if (n.identity.equals(this.iCellName)) {
                    n.status = -1;
                    n.identity = "";
                    n.assignedID = "";
                }
                ++j;
            }
            ++i;
        }
        Cell c = null;
        int strTime = this.iTime - 1;
        if (predecessorNuc != null) {
            AncesTree ances = this.iAceTree.getAncesTree();
            h = ances.getCellsByName();
            c = (Cell)h.get(predecessorNuc.identity);
        }
        if (o == this.iApplyAndRebuild) {
            this.iAceTree.clearTree();
            this.iAceTree.buildTree(true);
            this.iEditLog.setModified(true);
            AncesTree ances = this.iAceTree.getAncesTree();
            h = ances.getCellsByName();
            if (c != null) {
                c = (Cell)h.get(c.getName());
            }
            System.out.println("killCellsDialog.actionPerformed: " + c + CS + strTime);
            if (c == null) {
                Vector newtime = this.iNucleiMgr.getNuclei(strTime - 1);
                Nucleus newnuc = (Nucleus)newtime.get(0);
                c = (Cell)this.iAceTree.getAncesTree().getCells().get(newnuc.hashKey);
            }
            this.iAceTree.setStartingCell(c, strTime);
            this.dispose();
        } else {
            super.actionPerformed(e);
        }
    }

    public static void main(String[] args) {
    }

    private static void println(String s) {
        System.out.println(s);
    }

    private static void print(String s) {
        System.out.print(s);
    }

    private static String fmt4(double d) {
        return DF4.format(d);
    }

    private static String fmt1(double d) {
        return DF1.format(d);
    }

    private static String fmt0(double d) {
        return DF0.format(d);
    }
}

