/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.nucedit;

import java.awt.Color;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.border.Border;
import org.rhwlab.acetree.AceTree;
import org.rhwlab.nucedit.KillSublineage;
import org.rhwlab.snight.NucleiMgr;
import org.rhwlab.snight.Nucleus;

public class KillDeepNucsDialog
extends JDialog
implements ActionListener {
    AceTree iAceTree;
    NucleiMgr iNucleiMgr;
    int iZLim;
    int iCount;
    JLabel iEstimatedCount;
    JLabel iZLimLabel;
    JRadioButton iFlippedImages;
    private static final String CS = ", ";
    private static final String TAB = "\t";
    private static final DecimalFormat DF0 = new DecimalFormat("####");
    private static final DecimalFormat DF1 = new DecimalFormat("####.#");
    private static final DecimalFormat DF4 = new DecimalFormat("####.####");

    public KillDeepNucsDialog(AceTree aceTree, Frame owner, boolean modal) {
        super(owner, modal);
        this.iAceTree = aceTree;
        this.iNucleiMgr = this.iAceTree.getNucleiMgr();
        this.setTitle("Kill Group");
        KillDeepNucsDialog dialog = this;
        this.iZLim = 27;
        JPanel bothTools = new JPanel();
        bothTools.setLayout(new BoxLayout(bothTools, 3));
        JPanel pWhole = new JPanel();
        JLabel l = new JLabel("Kill Based On Z");
        l.setAlignmentX(0.5f);
        pWhole.add(l);
        pWhole.add(new JLabel(" "));
        pWhole.setLayout(new BoxLayout(pWhole, 3));
        Border blackline = BorderFactory.createLineBorder(Color.black);
        Border topBorder = BorderFactory.createEmptyBorder(10, 0, 0, 0);
        Border botBorder = BorderFactory.createEmptyBorder(0, 0, 10, 0);
        JPanel p = new JPanel();
        p.setLayout(new GridLayout(1, 0));
        p.add(new JLabel("Z Limit:"));
        this.iZLimLabel = new JLabel(String.valueOf(this.iZLim));
        p.add(this.iZLimLabel);
        JButton plus = new JButton("+");
        JButton minus = new JButton("-");
        plus.addActionListener(this);
        minus.addActionListener(this);
        p.add(plus);
        p.add(minus);
        pWhole.add(p);
        p = new JPanel();
        ButtonGroup zDir = new ButtonGroup();
        JRadioButton zhigh = new JRadioButton("Above", true);
        this.iFlippedImages = new JRadioButton("Below");
        zDir.add(zhigh);
        zDir.add(this.iFlippedImages);
        p.setLayout(new GridLayout(1, 0));
        p.add(new JLabel("Kill Cells:"));
        p.add(zhigh);
        p.add(this.iFlippedImages);
        pWhole.add(p);
        this.estimateNucs(false);
        this.iEstimatedCount = new JLabel(String.valueOf(this.iCount));
        p = new JPanel();
        p.setLayout(new GridLayout(1, 0));
        JButton estimate = new JButton("Estimate");
        p.add(estimate);
        estimate.addActionListener(this);
        pWhole.add(p);
        p = new JPanel();
        p.setLayout(new GridLayout(1, 0));
        p.add(new JLabel("Estimated count: "));
        p.add(this.iEstimatedCount);
        pWhole.add(p);
        p = new JPanel();
        p.setLayout(new GridLayout(1, 0));
        JButton killem = new JButton("Kill Cells");
        killem.addActionListener(this);
        p.add(killem);
        pWhole.add(p);
        bothTools.setOpaque(true);
        JPanel group = new JPanel();
        group.setLayout(new BoxLayout(group, 2));
        group.add(pWhole);
        group.add(Box.createHorizontalGlue());
        group.add(new JSeparator(1));
        group.add(new JSeparator(1));
        group.add(Box.createHorizontalGlue());
        group.add(new KillSublineage(aceTree));
        bothTools.add(group);
        bothTools.add(new JSeparator(0));
        bothTools.add(new JLabel(" "));
        l = new JLabel("Warning: Kill Group tools are only for cleanup.");
        l.setAlignmentX(0.5f);
        bothTools.add(l);
        l = new JLabel("Not recommended for editing.");
        l.setAlignmentX(0.5f);
        bothTools.add(l);
        dialog.setContentPane(bothTools);
        dialog.setLocationRelativeTo(owner);
        dialog.pack();
        dialog.setVisible(true);
    }

    private void estimateNucs(boolean implement) {
        KillDeepNucsDialog.println("estimateNucs, " + this.iZLim + CS + this.iCount + CS + implement);
        this.iCount = 0;
        Vector nucRec = this.iNucleiMgr.getNucleiRecord();
        int i = 0;
        while (i < nucRec.size()) {
            Vector nuclei = (Vector)nucRec.get(i);
            int j = 0;
            while (j < nuclei.size()) {
                Nucleus n = (Nucleus)nuclei.get(j);
                if (!(n.status == -1 || n.z < (float)this.iZLim && !this.iFlippedImages.isSelected() || n.z > (float)this.iZLim && this.iFlippedImages.isSelected())) {
                    if (implement) {
                        n.status = -1;
                    } else {
                        ++this.iCount;
                    }
                }
                ++j;
            }
            ++i;
        }
        if (implement) {
            this.iAceTree.clearTree();
            this.iAceTree.buildTree(true);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String c = e.getActionCommand();
        if (c.equals("+")) {
            ++this.iZLim;
        } else if (c.equals("-")) {
            --this.iZLim;
        } else if (c.equals("Estimate")) {
            this.estimateNucs(false);
            this.iEstimatedCount.setText(String.valueOf(this.iCount));
        } else if (c.equals("Kill Cells")) {
            this.estimateNucs(true);
            this.iEstimatedCount.setText(String.valueOf(this.iCount));
        }
        this.iZLimLabel.setText(String.valueOf(this.iZLim));
    }

    public static void main(String[] args) {
    }

    private static void println(String s) {
        System.out.println(s);
    }

    private static void print(String s) {
        System.out.print(s);
    }

    private static String fmt4(double d) {
        return DF4.format(d);
    }

    private static String fmt1(double d) {
        return DF1.format(d);
    }

    private static String fmt0(double d) {
        return DF0.format(d);
    }
}

